/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.preloader;

import java.awt.Robot;
import javafx.application.Preloader;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.silentsoft.actlist.util.ConfigUtil;
import org.silentsoft.core.util.SystemUtil;

public class App
extends Preloader {
    private Stage stage;
    @FXML
    private Label statusLabel;
    @FXML
    private ProgressBar statusProgressBar;

    public void start(Stage stage) throws Exception {
        App.checkSingleInstance();
        this.stage = stage;
        stage.initStyle(StageStyle.TRANSPARENT);
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName().concat(".fxml")));
        fxmlLoader.setController((Object)this);
        stage.setScene(new Scene((Parent)fxmlLoader.load(), (Paint)Color.TRANSPARENT));
        stage.setWidth(400.0);
        stage.setHeight(360.0);
        stage.show();
    }

    private static void checkSingleInstance() {
        String imageName = "Actlist";
        if (SystemUtil.isWindows()) {
            imageName = imageName + ".exe";
        }
        if (SystemUtil.findProcessByImageName((String)imageName, (String)SystemUtil.getCurrentProcessId())) {
            try {
                Robot robot = new Robot();
                int keyCode = ConfigUtil.getShowHideActlistHotKeyCode();
                int modifier = ConfigUtil.getShowHideActlistHotKeyModifier();
                if ((modifier & 0x80) == 128) {
                    robot.keyPress(17);
                }
                if ((modifier & 0x200) == 512) {
                    robot.keyPress(18);
                }
                if ((modifier & 0x40) == 64) {
                    robot.keyPress(16);
                }
                if ((modifier & 0x100) == 256) {
                    robot.keyPress(524);
                }
                robot.keyPress(keyCode);
                if ((modifier & 0x80) == 128) {
                    robot.keyRelease(17);
                }
                if ((modifier & 0x200) == 512) {
                    robot.keyRelease(18);
                }
                if ((modifier & 0x40) == 64) {
                    robot.keyRelease(16);
                }
                if ((modifier & 0x100) == 256) {
                    robot.keyRelease(524);
                }
                robot.keyRelease(keyCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public void handleApplicationNotification(Preloader.PreloaderNotification preloaderNotification) {
        if (preloaderNotification instanceof Preloader.ProgressNotification) {
            double progress = ((Preloader.ProgressNotification)preloaderNotification).getProgress();
            this.statusProgressBar.setProgress(progress);
            if (Double.compare(progress, 0.3) == 0) {
                this.statusLabel.setText("Preparing engine");
            } else if (Double.compare(progress, 0.5) == 0) {
                this.statusLabel.setText("Preparing plugins");
            } else if (Double.compare(progress, 1.0) >= 0) {
                this.statusLabel.setText("Enjoy your own Actlist !");
            }
        } else if (preloaderNotification instanceof Preloader.StateChangeNotification && ((Preloader.StateChangeNotification)preloaderNotification).getType() == Preloader.StateChangeNotification.Type.BEFORE_START) {
            this.stage.hide();
        }
    }
}

