/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin.about;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.silentsoft.actlist.plugin.ActlistPlugin;
import org.silentsoft.core.util.ObjectUtil;
import org.silentsoft.ui.viewer.AbstractViewerController;

public class PluginAboutController
extends AbstractViewerController {
    @FXML
    private VBox rootVBox;
    @FXML
    private ImageView iconImage;
    @FXML
    private Label name;
    @FXML
    private HBox versionAndAuthorBox;
    @FXML
    private Label version;
    @FXML
    private Label authorText;
    @FXML
    private Hyperlink authorLink;
    @FXML
    private HBox newVersionBox;
    @FXML
    private Hyperlink newVersionLink;

    public void initialize(Parent viewer, Object ... parameters) {
        Object _plugin;
        if (parameters != null && parameters.length > 0 && (_plugin = parameters[0]) instanceof ActlistPlugin) {
            ActlistPlugin plugin = (ActlistPlugin)_plugin;
            if (plugin.existsIcon()) {
                try {
                    this.iconImage.setImage(plugin.getIcon().getImage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (ObjectUtil.isNotEmpty((Object)plugin.getPluginName())) {
                this.name.setText(plugin.getPluginName());
            }
            if (ObjectUtil.isNotEmpty((Object)plugin.getPluginVersion())) {
                this.version.setText(plugin.getPluginVersion());
            }
            if (ObjectUtil.isNotEmpty((Object)plugin.getPluginAuthor())) {
                if (ObjectUtil.isNotEmpty((Object)plugin.getPluginAuthorURI())) {
                    this.authorLink.setText(plugin.getPluginAuthor());
                    this.authorLink.setOnAction(actionEvent -> {
                        this.authorLink.setVisited(false);
                        try {
                            Desktop.getDesktop().browse(plugin.getPluginAuthorURI());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                } else {
                    this.authorText.setText(" by ".concat(plugin.getPluginAuthor()));
                }
            }
            Object _isAvailableNewPlugin = parameters[1];
            Object _newPluginURI = parameters[2];
            if (_isAvailableNewPlugin instanceof Boolean) {
                boolean isAvailableNewPlugin = (Boolean)_isAvailableNewPlugin;
                if (isAvailableNewPlugin && _newPluginURI != null && _newPluginURI instanceof URI) {
                    this.newVersionBox.setVisible(true);
                    URI newPluginURI = (URI)_newPluginURI;
                    this.newVersionLink.setOnAction(actionEvent -> {
                        this.newVersionLink.setVisited(false);
                        try {
                            Desktop.getDesktop().browse(newPluginURI);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                } else {
                    this.newVersionBox.setVisible(false);
                    VBox parent = (VBox)this.newVersionBox.getParent();
                    parent.getChildren().remove((Object)this.newVersionBox);
                }
            }
            if (this.haveContentToShow(plugin)) {
                TabPane tabPane = this.createContentTabPane();
                this.makeTabIfContentExists(tabPane, "Description", plugin.getPluginDescriptionURI(), plugin.getPluginDescription());
                this.makeTabIfContentExists(tabPane, "Change Log", plugin.getPluginChangeLogURI(), plugin.getPluginChangeLog());
                this.makeTabIfContentExists(tabPane, "License", plugin.getPluginLicenseURI(), plugin.getPluginLicense());
                viewer.getScene().getWindow().sizeToScene();
            }
        }
    }

    private boolean haveContentToShow(ActlistPlugin plugin) {
        boolean result = false;
        if (ObjectUtil.isNotEmpty((Object)plugin.getPluginDescriptionURI()) || ObjectUtil.isNotEmpty((Object)plugin.getPluginDescription())) {
            result = true;
        } else if (ObjectUtil.isNotEmpty((Object)plugin.getPluginChangeLogURI()) || ObjectUtil.isNotEmpty((Object)plugin.getPluginChangeLog())) {
            result = true;
        } else if (ObjectUtil.isNotEmpty((Object)plugin.getPluginLicenseURI()) || ObjectUtil.isNotEmpty((Object)plugin.getPluginLicense())) {
            result = true;
        }
        return result;
    }

    private TabPane createContentTabPane() {
        TabPane tabPane = new TabPane();
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        ScrollPane scrollPane = new ScrollPane((Node)tabPane);
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        scrollPane.setPrefWidth(330.0);
        scrollPane.setPrefHeight(310.0);
        VBox.setVgrow((Node)scrollPane, (Priority)Priority.ALWAYS);
        this.rootVBox.getChildren().add((Object)scrollPane);
        return tabPane;
    }

    private void makeTabIfContentExists(TabPane tabPane, String title, URI uri, String text) {
        boolean existsContent;
        boolean bl = existsContent = ObjectUtil.isNotEmpty((Object)uri) || ObjectUtil.isNotEmpty((Object)text);
        if (existsContent) {
            WebView webView = new WebView();
            Consumer<String> loadContent = raw -> {
                String content = HtmlRenderer.builder().build().render(Parser.builder().build().parse(raw));
                webView.getEngine().setUserStyleSheetLocation(((Object)((Object)this)).getClass().getResource("/github-markdown.css").toExternalForm());
                webView.getEngine().loadContent(String.format("<article class='markdown-body'>%s</article>", content));
            };
            if (ObjectUtil.isNotEmpty((Object)uri)) {
                if ("jar".equals(uri.getScheme())) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(uri.toURL().openStream(), StandardCharsets.UTF_8));){
                        StringBuffer buffer = new StringBuffer();
                        String value = null;
                        while ((value = reader.readLine()) != null) {
                            buffer.append(value.concat("\r\n"));
                        }
                        loadContent.accept(buffer.toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    webView.getEngine().load(uri.toString());
                }
            } else if (ObjectUtil.isNotEmpty((Object)text)) {
                loadContent.accept(text);
            }
            tabPane.getTabs().add((Object)new Tab(title, (Node)webView));
        }
    }
}

