/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin;

import com.github.plushaze.traynotification.animations.Animations;
import com.jfoenix.controls.JFXHamburger;
import com.jfoenix.controls.JFXSpinner;
import com.jfoenix.controls.JFXToggleButton;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.control.PopOver;
import org.silentsoft.actlist.application.App;
import org.silentsoft.actlist.comparator.VersionComparator;
import org.silentsoft.actlist.plugin.ActlistPlugin;
import org.silentsoft.actlist.plugin.PluginConfig;
import org.silentsoft.actlist.plugin.PluginManager;
import org.silentsoft.actlist.plugin.about.PluginAbout;
import org.silentsoft.actlist.plugin.messagebox.MessageBox;
import org.silentsoft.actlist.plugin.tray.TrayNotification;
import org.silentsoft.actlist.rest.RESTfulAPI;
import org.silentsoft.actlist.util.ConfigUtil;
import org.silentsoft.core.util.DateUtil;
import org.silentsoft.core.util.FileUtil;
import org.silentsoft.core.util.JSONUtil;
import org.silentsoft.core.util.ObjectUtil;
import org.silentsoft.core.util.SystemUtil;
import org.silentsoft.io.event.EventListener;
import org.silentsoft.io.memory.SharedMemory;
import org.silentsoft.ui.model.Delta;

public class PluginComponent
implements EventListener {
    @FXML
    private AnchorPane root;
    @FXML
    private JFXHamburger hand;
    @FXML
    private HBox pluginLoadingBox;
    @FXML
    private Label lblPluginName;
    @FXML
    private Label warningLabel;
    @FXML
    private Label updateAlarmLabel;
    @FXML
    private JFXToggleButton togActivator;
    @FXML
    private VBox contentLoadingBox;
    @FXML
    private VBox contentBox;
    private String pluginFileName;
    private ActlistPlugin plugin;
    private PopOver popOver;
    private ObservableList<Node> functions;
    private HashMap<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> trayNotifications = new HashMap();
    private boolean isAvailableNewPlugin = false;
    private URI newPluginURI;
    private Stage aboutStage;
    private volatile Runnable checkForUpdates = () -> {
        block25: {
            try {
                boolean hasEndOfService;
                boolean hasTurnedOnKillSwitch;
                URI pluginUpdateCheckURI = this.plugin.getPluginUpdateCheckURI();
                if (pluginUpdateCheckURI == null) break block25;
                Map result = null;
                ArrayList<BasicNameValuePair> param = new ArrayList<BasicNameValuePair>();
                param.add(new BasicNameValuePair("version", this.plugin.getPluginVersion()));
                String uri = pluginUpdateCheckURI.toString();
                if (uri.matches("(?i).*\\.js")) {
                    StringBuffer script = new StringBuffer();
                    script.append(String.format("var version = '%s';", this.plugin.getPluginVersion())).append("\r\n");
                    script.append(RESTfulAPI.doGet(pluginUpdateCheckURI.toString(), param, String.class, this.plugin.getBeforeRequest()));
                    ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("nashorn");
                    Object _result = scriptEngine.eval(script.toString());
                    if (_result instanceof Map) {
                        result = (Map)_result;
                    }
                } else {
                    result = RESTfulAPI.doGet(pluginUpdateCheckURI.toString(), param, Map.class, this.plugin.getBeforeRequest());
                }
                if (result == null) {
                    return;
                }
                if (result.containsKey("available")) {
                    this.isAvailableNewPlugin = Boolean.parseBoolean(String.valueOf(result.get("available")));
                    if (this.isAvailableNewPlugin) {
                        AtomicReference<Object> updateAction = new AtomicReference<Object>(null);
                        URI pluginArchivesURI = this.plugin.getPluginArchivesURI();
                        if (pluginArchivesURI != null) {
                            this.newPluginURI = pluginArchivesURI;
                        }
                        if (result.containsKey("url")) {
                            try {
                                this.newPluginURI = new URI(String.valueOf(result.get("url")));
                                this.plugin.setPluginArchivesURI(this.newPluginURI);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (this.newPluginURI != null) {
                            updateAction.set(((Runnable)() -> {
                                this.showAboutStage();
                                this.updateAlarmLabel.setVisible(false);
                            }));
                        }
                        if (result.containsKey("jar")) {
                            String jar = String.valueOf(result.get("jar")).trim();
                            AtomicReference<Object> requiredActlist = new AtomicReference<Object>(null);
                            if (result.containsKey("requiredActlist")) {
                                requiredActlist.set(String.valueOf(result.get("requiredActlist")).trim());
                            }
                            updateAction.set(((Runnable)() -> {
                                boolean shouldSkipAutoUpdate = false;
                                try {
                                    if (requiredActlist.get() != null && !((String)requiredActlist.get()).isEmpty() && VersionComparator.getInstance().compare("2.2.0", (String)requiredActlist.get()) < 0) {
                                        ButtonType cancelButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
                                        ButtonType updateAnywayButton = new ButtonType("Update anyway", ButtonBar.ButtonData.OK_DONE);
                                        Alert alert = new Alert(Alert.AlertType.NONE);
                                        alert.setTitle("Warning");
                                        alert.getDialogPane().getStyleClass().add((Object)"warning");
                                        alert.setHeaderText(String.join((CharSequence)"", "This update requires at least Actlist ", (CharSequence)requiredActlist.get()));
                                        alert.setContentText("This update may cause the plugin to crash. Do you want to update anyway ?");
                                        alert.getButtonTypes().addAll((Object[])new ButtonType[]{cancelButton, updateAnywayButton});
                                        Optional alertResponse = alert.showAndWait();
                                        if (alertResponse.isPresent() && alertResponse.get() != updateAnywayButton) {
                                            shouldSkipAutoUpdate = true;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                if (shouldSkipAutoUpdate) {
                                    this.updateAlarmLabel.setVisible(false);
                                    return;
                                }
                                AtomicBoolean succeedToAutoUpdate = new AtomicBoolean(false);
                                this.pluginLoadingBox.setVisible(true);
                                this.displayLoadingBar(true);
                                new Thread(() -> {
                                    AtomicBoolean networkUnavailable = new AtomicBoolean(false);
                                    AtomicReference exception = new AtomicReference();
                                    try {
                                        RESTfulAPI.doGet(jar, this.plugin.getBeforeRequest(), afterResponse -> {
                                            block14: {
                                                try {
                                                    Path newPluginFilePath;
                                                    HttpEntity entity = afterResponse.getEntity();
                                                    if (entity == null) break block14;
                                                    InputStream content = entity.getContent();
                                                    String uuid = UUID.randomUUID().toString().replaceAll("-", "");
                                                    Path partialFilePath = Paths.get(System.getProperty("java.io.tmpdir"), uuid.concat(".partial"));
                                                    if (Files.notExists(partialFilePath.getParent(), new LinkOption[0])) {
                                                        Files.createDirectories(partialFilePath.getParent(), new FileAttribute[0]);
                                                    }
                                                    Files.createFile(partialFilePath, new FileAttribute[0]);
                                                    FileOutputStream fileStream = new FileOutputStream(partialFilePath.toString());
                                                    IOUtils.copy((InputStream)content, (OutputStream)fileStream);
                                                    ((OutputStream)fileStream).close();
                                                    new JarFile(partialFilePath.toString()).close();
                                                    String _newPluginFileName = "";
                                                    try {
                                                        Header contentDispositionHeader = afterResponse.getFirstHeader("Content-Disposition");
                                                        if (contentDispositionHeader != null && contentDispositionHeader.getValue() != null) {
                                                            _newPluginFileName = URLDecoder.decode(StringUtils.substringAfterLast((String)contentDispositionHeader.getValue().toLowerCase().replaceAll("\"", ""), (String)"filename="), "UTF-8").trim();
                                                        }
                                                    }
                                                    catch (Exception contentDispositionHeader) {
                                                    }
                                                    finally {
                                                        if (ObjectUtil.isEmpty((Object)_newPluginFileName)) {
                                                            _newPluginFileName = String.valueOf(Paths.get(URI.create(jar).getPath(), new String[0]).getFileName());
                                                        }
                                                        if (ObjectUtil.isEmpty((Object)_newPluginFileName)) {
                                                            _newPluginFileName = UUID.randomUUID().toString().replaceAll("-", "");
                                                        }
                                                    }
                                                    if (!_newPluginFileName.toLowerCase().endsWith(".jar")) {
                                                        _newPluginFileName = _newPluginFileName.concat(".jar");
                                                    }
                                                    if (Files.exists(newPluginFilePath = Paths.get(System.getProperty("user.dir"), "plugins", _newPluginFileName), new LinkOption[0])) {
                                                        newPluginFilePath = Paths.get(System.getProperty("user.dir"), "plugins", uuid.concat(".jar"));
                                                    }
                                                    String newPluginFileName = String.valueOf(newPluginFilePath.getFileName());
                                                    Files.move(partialFilePath, newPluginFilePath, new CopyOption[0]);
                                                    Path currentConfigFile = Paths.get(System.getProperty("user.dir"), "plugins", "config", this.pluginFileName.concat(".config"));
                                                    if (Files.exists(currentConfigFile, new LinkOption[0])) {
                                                        Path newConfigFile = Paths.get(System.getProperty("user.dir"), "plugins", "config", newPluginFileName.concat(".config"));
                                                        Files.copy(currentConfigFile, newConfigFile, StandardCopyOption.REPLACE_EXISTING);
                                                    }
                                                    CountDownLatch latch = new CountDownLatch(1);
                                                    Platform.runLater(() -> {
                                                        try {
                                                            VBox componentBox;
                                                            VBox vBox = componentBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
                                                            synchronized (vBox) {
                                                                int indexOfThisPlugin = componentBox.getChildren().indexOf((Object)this.root);
                                                                if (!this.isActivated()) {
                                                                    List deactivatedPlugins = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
                                                                    deactivatedPlugins.add(newPluginFileName);
                                                                    org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_SAVE_DEACTIVATED_PLUGINS");
                                                                }
                                                                PluginManager.delete(this.pluginFileName);
                                                                PluginManager.load(newPluginFileName, this.isActivated(), indexOfThisPlugin);
                                                                org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_SAVE_PRIORITY_OF_PLUGINS");
                                                            }
                                                        }
                                                        catch (Error | Exception e) {
                                                            e.printStackTrace();
                                                        }
                                                        finally {
                                                            latch.countDown();
                                                        }
                                                    });
                                                    latch.await();
                                                    succeedToAutoUpdate.set(true);
                                                }
                                                catch (Exception e) {
                                                    e.printStackTrace();
                                                    exception.set(e);
                                                }
                                            }
                                        });
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        networkUnavailable.set(true);
                                    }
                                    if (!succeedToAutoUpdate.get()) {
                                        Platform.runLater(() -> {
                                            this.pluginLoadingBox.setVisible(false);
                                            this.displayLoadingBar(false);
                                            this.updateAlarmLabel.setVisible(false);
                                        });
                                        if (networkUnavailable.get()) {
                                            if (Desktop.isDesktopSupported()) {
                                                try {
                                                    Desktop.getDesktop().browse(URI.create(jar));
                                                }
                                                catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                        } else {
                                            MessageBox.showException((Object)App.getStage(), (String)"Failed to update", (Throwable)((Throwable)exception.get()));
                                        }
                                    }
                                }).start();
                            }));
                        }
                        if (updateAction.get() != null) {
                            this.updateAlarmLabel.setOnMouseClicked(event -> ((Runnable)updateAction.get()).run());
                            this.updateAlarmLabel.setVisible(true);
                            this.playFadeTransition((Node)this.updateAlarmLabel);
                        } else {
                            this.updateAlarmLabel.setVisible(false);
                        }
                        try {
                            this.plugin.pluginUpdateFound();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (result.containsKey("killSwitch") && (hasTurnedOnKillSwitch = "on".equalsIgnoreCase(String.valueOf(result.get("killSwitch")).trim()))) {
                    String message = "The plugin's kill switch has turned on by the author.";
                    this.makeDisable(new Exception(message), false);
                    this.warningLabel.setOnMouseClicked(event -> MessageBox.showInformation((Object)App.getStage(), (String)message));
                    this.warningLabel.setVisible(true);
                    this.playFadeTransition((Node)this.warningLabel);
                }
                if (result.containsKey("endOfService") && (hasEndOfService = Boolean.parseBoolean(String.valueOf(result.get("endOfService"))))) {
                    this.warningLabel.setOnMouseClicked(event -> MessageBox.showInformation((Object)App.getStage(), (String)"This plugin has reached end of service by the author."));
                    this.warningLabel.setVisible(true);
                    this.playFadeTransition((Node)this.warningLabel);
                }
            }
            catch (Error | Exception e) {
                e.printStackTrace();
            }
            finally {
                new Thread(() -> {
                    try {
                        ArrayList<BasicNameValuePair> param = new ArrayList<BasicNameValuePair>();
                        param.add(new BasicNameValuePair("uuid", ObjectUtil.toString((Object)this.plugin.getPluginStatisticsUUID())));
                        param.add(new BasicNameValuePair("name", ObjectUtil.toString((Object)this.plugin.getPluginName())));
                        param.add(new BasicNameValuePair("version", ObjectUtil.toString((Object)this.plugin.getPluginVersion())));
                        RESTfulAPI.doPost("http://actlist.silentsoft.org/api/plugin/statistics", param);
                    }
                    catch (Error | Exception throwable) {
                        // empty catch block
                    }
                }).start();
            }
        }
    };

    public String getPluginFileName() {
        return this.pluginFileName;
    }

    public void initialize() {
    }

    public void initialize(String pluginFileName, Class<? extends ActlistPlugin> pluginClass, boolean activated) {
        this.pluginFileName = pluginFileName;
        new Thread(() -> {
            AtomicBoolean shouldTraceException = new AtomicBoolean(true);
            try {
                String configContent;
                PluginConfig pluginConfig;
                this.makeConsumable();
                this.makeDraggable();
                this.applyDarkMode();
                this.popOver = new PopOver((Node)new VBox());
                ((VBox)this.popOver.getContentNode()).setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
                this.popOver.setArrowLocation(PopOver.ArrowLocation.TOP_LEFT);
                this.plugin = (ActlistPlugin)pluginClass.newInstance();
                ActlistPlugin.SupportedPlatform currentPlatform = null;
                if (SystemUtil.isWindows()) {
                    currentPlatform = ActlistPlugin.SupportedPlatform.WINDOWS;
                } else if (SystemUtil.isMac()) {
                    currentPlatform = ActlistPlugin.SupportedPlatform.MACOSX;
                }
                this.plugin.currentPlatformObject().set((Object)currentPlatform);
                ActlistPlugin.SupportedPlatform[] supportedPlatforms = this.plugin.getSupportedPlatforms();
                if (supportedPlatforms != null && supportedPlatforms.length > 0 && !Arrays.asList(supportedPlatforms).contains(currentPlatform)) {
                    shouldTraceException.set(false);
                    List listOfSupportedPlatform = Arrays.stream(supportedPlatforms).map(Enum::name).collect(Collectors.toList());
                    String errorMessage = String.join((CharSequence)"", "This plugin only supports ", String.join((CharSequence)", ", listOfSupportedPlatform));
                    Runnable errorDialog = () -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Error");
                        alert.setHeaderText("Unsupported platform");
                        alert.setContentText(errorMessage);
                        alert.showAndWait();
                    };
                    this.lblPluginName.setOnMouseClicked(mouseEvent -> {
                        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                            errorDialog.run();
                        }
                    });
                    this.warningLabel.setOnMouseClicked(mouseEvent -> errorDialog.run());
                    this.warningLabel.setVisible(true);
                    this.playFadeTransition((Node)this.warningLabel);
                    throw new Exception(errorMessage);
                }
                String minimumCompatibleVersion = this.plugin.getMinimumCompatibleVersion();
                if (minimumCompatibleVersion != null && VersionComparator.getInstance().compare("2.2.0", minimumCompatibleVersion) < 0) {
                    shouldTraceException.set(false);
                    String errorMessage = String.join((CharSequence)"", "This plugin requires at least Actlist ", minimumCompatibleVersion);
                    Runnable confirmDialog = () -> {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("Confirmation");
                        alert.setHeaderText(errorMessage);
                        alert.setContentText("Would you like to check latest Actlist now ?");
                        Optional result = alert.showAndWait();
                        if (result.isPresent() && result.get() == ButtonType.OK) {
                            try {
                                Desktop.getDesktop().browse(new URI("http://actlist.silentsoft.org/archives/"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    this.lblPluginName.setOnMouseClicked(mouseEvent -> {
                        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                            confirmDialog.run();
                        }
                    });
                    this.warningLabel.setOnMouseClicked(mouseEvent -> confirmDialog.run());
                    this.warningLabel.setVisible(true);
                    this.playFadeTransition((Node)this.warningLabel);
                    throw new Exception(errorMessage);
                }
                HashMap pluginMap = (HashMap)SharedMemory.getDataMap().get((Object)"KEY_PLUGIN_MAP");
                this.plugin.classLoaderObject().set(pluginMap.get(pluginFileName));
                this.plugin.proxyHostObject().set((Object)RESTfulAPI.getProxyHost());
                this.plugin.darkModeProperty().set(ConfigUtil.isDarkMode());
                this.plugin.setPluginConfig(new PluginConfig(pluginFileName));
                File configFile = Paths.get(System.getProperty("user.dir"), "plugins", "config", pluginFileName.concat(".config")).toFile();
                if (configFile.exists() && (pluginConfig = (PluginConfig)JSONUtil.JSONToObject((String)(configContent = FileUtil.readFile((File)configFile)), PluginConfig.class)) != null) {
                    if (!pluginFileName.equals(pluginConfig.getPlugin())) {
                        pluginConfig.setPlugin(pluginFileName);
                        pluginConfig.commit();
                    }
                    this.plugin.setPluginConfig(pluginConfig);
                }
                Platform.runLater(() -> {
                    try {
                        String warningText;
                        String pluginName = this.plugin.getPluginName();
                        String pluginDescription = this.plugin.getPluginDescription();
                        this.lblPluginName.setText(pluginName == null || pluginName.trim().isEmpty() ? pluginFileName : pluginName);
                        if (ObjectUtil.isNotEmpty((Object)pluginDescription)) {
                            this.lblPluginName.setTooltip(new Tooltip(pluginDescription));
                        }
                        if (ObjectUtil.isNotEmpty((Object)(warningText = this.plugin.getWarningText()))) {
                            this.warningLabel.setVisible(true);
                            this.playFadeTransition((Node)this.warningLabel);
                        } else {
                            this.warningLabel.setVisible(false);
                        }
                        if (this.plugin.isOneTimePlugin()) {
                            this.togActivator.setSelected(false);
                        } else {
                            this.togActivator.setSelected(activated);
                        }
                        this.plugin.shouldShowLoadingBar().addListener((observable, oldValue, newValue) -> {
                            if (oldValue == newValue) {
                                return;
                            }
                            this.displayLoadingBar((boolean)newValue);
                        });
                        this.plugin.exceptionObject().addListener((observable, oldValue, newValue) -> {
                            if (newValue != null) {
                                this.makeDisable((Throwable)newValue, true);
                                this.plugin.exceptionObject().set(null);
                            }
                        });
                        this.plugin.showTrayNotificationObject().addListener((observable, oldValue, newValue) -> {
                            if (newValue != null) {
                                com.github.plushaze.traynotification.notification.TrayNotification trayNotification = new com.github.plushaze.traynotification.notification.TrayNotification();
                                HashMap<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> hashMap = this.trayNotifications;
                                synchronized (hashMap) {
                                    this.trayNotifications.put((TrayNotification)newValue, trayNotification);
                                }
                                trayNotification.setRectangleFill(Paint.valueOf((String)"#222222"));
                                trayNotification.setImage(App.getIcons().get(4));
                                trayNotification.setAnimation(Animations.POPUP);
                                String titleValue = this.plugin.getPluginName() == null || this.plugin.getPluginName().trim().isEmpty() ? pluginFileName : this.plugin.getPluginName();
                                String titlePrefix = String.format("[%s] ", titleValue);
                                if (newValue.getTitle() == null || newValue.getTitle().trim().isEmpty()) {
                                    trayNotification.setTitle(titlePrefix.concat(""));
                                } else {
                                    trayNotification.setTitle(titlePrefix.concat(newValue.getTitle()));
                                }
                                if (newValue.getMessage() == null || newValue.getMessage().trim().isEmpty()) {
                                    trayNotification.setMessage("(empty message)");
                                } else {
                                    trayNotification.setMessage(newValue.getMessage());
                                }
                                trayNotification.setOnDismiss((EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
                                    HashMap<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> hashMap = this.trayNotifications;
                                    synchronized (hashMap) {
                                        this.trayNotifications.remove(newValue);
                                    }
                                    if (newValue.getDuration() == null) {
                                        org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_BRING_TO_FRONT");
                                    }
                                }));
                                if (newValue.getDuration() == null) {
                                    trayNotification.showAndWait();
                                } else {
                                    trayNotification.showAndDismiss(newValue.getDuration());
                                }
                                this.plugin.showTrayNotificationObject().set(null);
                            }
                        });
                        Consumer<com.github.plushaze.traynotification.notification.TrayNotification> dismiss = trayNotification -> new Thread(() -> {
                            while (!trayNotification.isTrayShowing()) {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (Exception exception) {}
                            }
                            Platform.runLater(() -> trayNotification.dismiss());
                        }).start();
                        this.plugin.dismissTrayNotificationObject().addListener((observable, oldValue, newValue) -> {
                            if (newValue != null) {
                                HashMap<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> hashMap = this.trayNotifications;
                                synchronized (hashMap) {
                                    if (this.trayNotifications.containsKey(newValue)) {
                                        com.github.plushaze.traynotification.notification.TrayNotification trayNotification = this.trayNotifications.get(newValue);
                                        dismiss.accept(trayNotification);
                                    }
                                }
                                this.plugin.dismissTrayNotificationObject().set(null);
                            }
                        });
                        this.plugin.shouldDismissTrayNotifications().addListener((observable, oldValue, newValue) -> {
                            if (newValue.booleanValue()) {
                                HashMap<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> hashMap = this.trayNotifications;
                                synchronized (hashMap) {
                                    for (Map.Entry<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> entrySet : this.trayNotifications.entrySet()) {
                                        com.github.plushaze.traynotification.notification.TrayNotification trayNotification = entrySet.getValue();
                                        dismiss.accept(trayNotification);
                                    }
                                    this.plugin.shouldDismissTrayNotifications().set(false);
                                }
                            }
                        });
                        this.plugin.shouldBrowseActlistArchives().addListener((observable, oldValue, newValue) -> {
                            if (newValue.booleanValue()) {
                                try {
                                    Desktop.getDesktop().browse(new URI("http://actlist.silentsoft.org/archives/"));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                this.plugin.shouldBrowseActlistArchives().set(false);
                            }
                        });
                        this.plugin.shouldRequestShowActlist().addListener((observable, oldValue, newValue) -> {
                            if (newValue.booleanValue()) {
                                if (App.isHidden()) {
                                    org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_SHOW_HIDE", (boolean)false);
                                }
                            } else if (App.isShown()) {
                                org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_SHOW_HIDE", (boolean)false);
                            }
                        });
                        this.plugin.shouldRequestDeactivate().addListener((observable, oldValue, newValue) -> {
                            if (newValue.booleanValue()) {
                                if (this.isActivated()) {
                                    this.togActivator.setSelected(false);
                                    this.deactivated();
                                }
                                this.plugin.shouldRequestDeactivate().set(false);
                            }
                        });
                        if (this.plugin.existsGraphic()) {
                            this.plugin.getGraphic();
                        }
                        this.plugin.initialize();
                        this.functions = FXCollections.observableArrayList();
                        for (ActlistPlugin.Function function : this.plugin.getFunctionMap().values()) {
                            this.addFunction(function);
                        }
                        if (activated && !this.plugin.isOneTimePlugin()) {
                            this.activated();
                        }
                        org.silentsoft.io.event.EventHandler.addListener((EventListener)this);
                    }
                    catch (Throwable e) {
                        this.lblPluginName.setText(pluginFileName);
                        this.makeDisable(e, shouldTraceException.get());
                    }
                    finally {
                        this.pluginLoadingBox.setVisible(false);
                        new Thread(() -> {
                            boolean shouldCheck = true;
                            Date latestCheckDate = null;
                            while (this.plugin != null) {
                                if (shouldCheck) {
                                    this.checkForUpdates.run();
                                    latestCheckDate = Calendar.getInstance().getTime();
                                }
                                try {
                                    Thread.sleep((long)Duration.minutes((double)10.0).toMillis());
                                }
                                catch (InterruptedException interruptedException) {
                                    shouldCheck = DateUtil.getDifferenceHoursFromNow(latestCheckDate) >= 24;
                                    continue;
                                }
                                catch (Throwable throwable) {
                                    shouldCheck = DateUtil.getDifferenceHoursFromNow(latestCheckDate) >= 24;
                                    throw throwable;
                                }
                                shouldCheck = DateUtil.getDifferenceHoursFromNow((Date)latestCheckDate) >= 24;
                            }
                        }).start();
                    }
                });
            }
            catch (Throwable e) {
                Platform.runLater(() -> {
                    this.lblPluginName.setText(pluginFileName);
                    this.makeDisable(e, shouldTraceException.get());
                    this.pluginLoadingBox.setVisible(false);
                });
            }
        }).start();
    }

    private boolean isInitialized() {
        return this.plugin != null;
    }

    void clear() {
        if (this.isActivated()) {
            try {
                this.clearPluginGraphicAndDeactivate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isInitialized()) {
            this.plugin.classLoaderObject().set(null);
            this.plugin = null;
        }
    }

    private void playFadeTransition(Node node) {
        Runnable action = () -> {
            if (node.isVisible()) {
                FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)400.0), node);
                fadeTransition.setFromValue(1.0);
                fadeTransition.setToValue(0.3);
                fadeTransition.setCycleCount(6);
                fadeTransition.setAutoReverse(true);
                fadeTransition.play();
            }
        };
        if (Platform.isFxApplicationThread()) {
            action.run();
        } else {
            Platform.runLater(() -> action.run());
        }
    }

    private void makeDisable(Throwable throwable, boolean shouldTraceException) {
        if (shouldTraceException) {
            throwable.printStackTrace();
        }
        new Thread(() -> {
            if (this.togActivator.selectedProperty().get()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Platform.runLater(() -> {
                this.lblPluginName.setCursor(Cursor.HAND);
                if (shouldTraceException) {
                    Runnable exceptionDialog = () -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Exception Dialog");
                        alert.setHeaderText(this.pluginFileName);
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        throwable.printStackTrace(pw);
                        String exceptionText = sw.toString();
                        TextArea textArea = new TextArea(exceptionText);
                        textArea.setEditable(false);
                        textArea.setWrapText(true);
                        textArea.setMaxWidth(Double.MAX_VALUE);
                        textArea.setMaxHeight(Double.MAX_VALUE);
                        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
                        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
                        GridPane content = new GridPane();
                        content.setMaxWidth(Double.MAX_VALUE);
                        content.add((Node)textArea, 0, 0);
                        alert.getDialogPane().setContent((Node)content);
                        alert.showAndWait();
                    };
                    this.lblPluginName.setTooltip(new Tooltip("Click to show the exception log."));
                    this.lblPluginName.setOnMouseClicked(mouseEvent -> {
                        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                            exceptionDialog.run();
                        }
                    });
                    this.warningLabel.setOnMouseClicked(mouseEvent -> exceptionDialog.run());
                    this.warningLabel.setVisible(true);
                    this.playFadeTransition((Node)this.warningLabel);
                } else {
                    this.lblPluginName.setTooltip(new Tooltip(throwable.getMessage()));
                }
                this.togActivator.setUnToggleLineColor(Paint.valueOf((String)"#da4242"));
                this.togActivator.setDisable(true);
                this.togActivator.setOpacity(1.0);
                this.togActivator.setSelected(false);
                this.clearPluginGraphic();
                org.silentsoft.io.event.EventHandler.removeListener((EventListener)this);
            });
        }).start();
    }

    private void makeConsumable() {
        this.root.addEventHandler(MouseEvent.MOUSE_RELEASED, mouseEvent -> mouseEvent.consume());
    }

    private void makeDraggable() {
        this.hand.setOnDragDetected(mouseEvent -> {
            this.createSnapshot((MouseEvent)mouseEvent);
            this.root.startFullDrag();
        });
        this.root.addEventFilter(MouseDragEvent.MOUSE_DRAG_ENTERED, mouseDragEvent -> {
            VBox componentBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
            if (componentBox.getUserData() != null) {
                if (ConfigUtil.isDarkMode()) {
                    this.root.setStyle("-fx-background-color: #2d2d2d;");
                } else {
                    this.root.setStyle("-fx-background-color: #f2f2f2;");
                }
            }
        });
        this.root.addEventFilter(MouseDragEvent.MOUSE_DRAG_RELEASED, mouseDragEvent -> {
            VBox componentBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
            if (componentBox.getUserData() != null) {
                HashMap map = (HashMap)componentBox.getUserData();
                int indexOfDraggingNode = componentBox.getChildren().indexOf(map.get("dragging"));
                int indexOfDropTarget = componentBox.getChildren().indexOf((Object)this.root);
                if (indexOfDraggingNode >= 0 && indexOfDropTarget >= 0) {
                    Node node = (Node)componentBox.getChildren().remove(indexOfDraggingNode);
                    componentBox.getChildren().add(indexOfDropTarget, (Object)node);
                }
                this.deleteSnapshot();
                org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_SAVE_PRIORITY_OF_PLUGINS");
            }
        });
        this.root.addEventFilter(MouseDragEvent.MOUSE_DRAG_EXITED, mouseDragEvent -> {
            if (ConfigUtil.isDarkMode()) {
                this.root.setStyle("-fx-background-color: rgb(40, 40, 40);");
            } else {
                this.root.setStyle("-fx-background-color: #ffffff;");
            }
        });
        this.hand.setOnMouseReleased(mouseEvent -> this.deleteSnapshot());
    }

    private void applyDarkMode() {
        this.hand.setOpacity(ConfigUtil.isDarkMode() ? 1.0 : 0.2);
        String backgroundColorStyle = ConfigUtil.isDarkMode() ? "-fx-background-color: rgb(40, 40, 40);" : "-fx-background-color: #ffffff;";
        this.root.setStyle(backgroundColorStyle);
        this.pluginLoadingBox.setStyle(backgroundColorStyle);
        this.contentLoadingBox.setStyle(backgroundColorStyle);
    }

    private void createSnapshot(MouseEvent mouseEvent) {
        ImageView snapshot = new ImageView((Image)this.root.snapshot(null, null));
        snapshot.setManaged(false);
        snapshot.setMouseTransparent(true);
        snapshot.setEffect((Effect)new DropShadow(3.0, 0.0, 1.5, Color.valueOf((String)"#333333")));
        snapshot.setVisible(false);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("snapshot", snapshot);
        map.put("dragging", this.root);
        VBox componentBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
        componentBox.getChildren().add((Object)snapshot);
        componentBox.setUserData(map);
        componentBox.setOnMouseDragged(event -> {
            snapshot.setVisible(true);
            snapshot.relocate(event.getX() - mouseEvent.getX(), event.getY() - mouseEvent.getY());
        });
    }

    private void deleteSnapshot() {
        VBox componentBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
        componentBox.setOnMouseDragged(null);
        if (componentBox.getUserData() != null) {
            HashMap map = (HashMap)componentBox.getUserData();
            componentBox.getChildren().remove(map.get("snapshot"));
        }
        componentBox.setUserData(null);
    }

    private void addFunction(ActlistPlugin.Function function) {
        this.functions.add((Object)this.createFunctionBox(function.graphic, (EventHandler<? super MouseEvent>)((EventHandler)mouseEvent -> {
            try {
                if (function.action != null) {
                    function.action.run();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        })));
    }

    private HBox createFunctionBox(Node node, EventHandler<? super MouseEvent> action) {
        HBox hBox = new HBox(new Node[]{node});
        hBox.setAlignment(Pos.CENTER);
        hBox.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        hBox.setStyle("-fx-background-color: #fbfbfb;");
        hBox.setOnMouseEntered(mouseEvent -> hBox.setStyle("-fx-background-color: lightgray;"));
        hBox.setOnMouseExited(mouseEvent -> hBox.setStyle("-fx-background-color: #fbfbfb;"));
        hBox.addEventFilter(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
            try {
                this.popOver.hide();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new Thread(() -> Platform.runLater(() -> {
                try {
                    if (action != null) {
                        action.handle(mouseEvent);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            })).start();
        });
        return hBox;
    }

    private HBox createAboutFunction() {
        return this.createFunctionBox((Node)new Label("About"), (EventHandler<? super MouseEvent>)((EventHandler)mouseEvent -> this.showAboutStage()));
    }

    @FXML
    private void showAboutStage() {
        if (this.aboutStage != null) {
            this.aboutStage.close();
            this.aboutStage = null;
        }
        this.aboutStage = new Stage();
        this.aboutStage.initOwner((Window)App.getStage());
        this.aboutStage.initStyle(StageStyle.UTILITY);
        BorderPane scene = new BorderPane();
        scene.setCenter((Node)new PluginAbout(this.plugin, this.isAvailableNewPlugin, this.newPluginURI).getViewer());
        this.aboutStage.setScene(new Scene((Parent)scene));
        this.aboutStage.show();
    }

    @FXML
    private void showWarningText() {
        this.warningLabel.setVisible(false);
        try {
            String warningText = this.plugin.getWarningText();
            if (ObjectUtil.isNotEmpty((Object)warningText)) {
                MessageBox.showWarning((Object)App.getStage(), (String)warningText);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HBox createCheckForUpdatesFunction() {
        return this.createFunctionBox((Node)new Label("Check for updates"), (EventHandler<? super MouseEvent>)((EventHandler)mouseEvent -> {
            this.pluginLoadingBox.setVisible(true);
            this.displayLoadingBar(true);
            new Thread(() -> {
                this.checkForUpdates.run();
                this.pluginLoadingBox.setVisible(false);
                this.displayLoadingBar(false);
            }).start();
        }));
    }

    private HBox createDeleteFunction() {
        Label label = new Label("Delete");
        label.setTextFill(Paint.valueOf((String)"#db0018"));
        return this.createFunctionBox((Node)label, (EventHandler<? super MouseEvent>)((EventHandler)mouseEvent -> {
            Optional result = MessageBox.showConfirm((Object)App.getStage(), (String)"Are you sure you want to delete this plugin? You may need to restart the application for the best effect.");
            if (result.isPresent() && result.get() == ButtonType.OK) {
                try {
                    PluginManager.delete(this.pluginFileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MessageBox.showError((Object)App.getStage(), (String)e.getMessage());
                }
            }
        }));
    }

    private void displayLoadingBar(final boolean shouldShowLoadingBar) {
        if (this.isActivated() && this.plugin.existsGraphic()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PluginComponent.this.contentLoadingBox.getChildren().clear();
                    if (shouldShowLoadingBar) {
                        JFXSpinner spinner = new JFXSpinner();
                        spinner.setPrefSize(28.0, 28.0);
                        PluginComponent.this.contentLoadingBox.getChildren().add((Object)spinner);
                    }
                    PluginComponent.this.contentBox.setVisible(!shouldShowLoadingBar);
                    PluginComponent.this.contentLoadingBox.setVisible(shouldShowLoadingBar);
                }
            };
            if (Platform.isFxApplicationThread()) {
                runnable.run();
            } else {
                Platform.runLater(() -> runnable.run());
            }
        }
    }

    @FXML
    private void mouseClicked(MouseEvent e) {
        if (e.getButton() == MouseButton.SECONDARY) {
            ((VBox)this.popOver.getContentNode()).getChildren().clear();
            if (this.isInitialized()) {
                ((VBox)this.popOver.getContentNode()).getChildren().add((Object)this.createAboutFunction());
                if (this.isActivated()) {
                    if (this.plugin.getFunctionMap().size() > 0) {
                        ((VBox)this.popOver.getContentNode()).getChildren().add((Object)this.createCustomSeparator());
                    }
                    ((VBox)this.popOver.getContentNode()).getChildren().addAll(this.functions);
                }
                ((VBox)this.popOver.getContentNode()).getChildren().add((Object)this.createCustomSeparator());
                ((VBox)this.popOver.getContentNode()).getChildren().add((Object)this.createCheckForUpdatesFunction());
            }
            ((VBox)this.popOver.getContentNode()).getChildren().add((Object)this.createDeleteFunction());
            this.popOver.show((Window)App.getStage(), e.getScreenX() - 40.0, e.getScreenY() - 10.0);
        }
    }

    private Separator createCustomSeparator() {
        Separator separator = new Separator(Orientation.HORIZONTAL);
        separator.setStyle("-fx-padding: 0.083333em 0.0em 0.0em 0.0em;");
        return separator;
    }

    @FXML
    private void toggleOnAction() {
        if (this.isActivated()) {
            this.activated();
        } else {
            this.deactivated();
        }
    }

    private void loadPluginGraphic() {
        try {
            Node pluginContent;
            if (this.plugin.existsGraphic() && (pluginContent = this.plugin.getGraphic()) != null) {
                BorderPane pluginPane = new BorderPane(pluginContent);
                BorderPane.setAlignment((Node)pluginContent, (Pos)Pos.TOP_CENTER);
                this.contentBox.getChildren().add((Object)pluginPane);
                Separator contentLine = new Separator();
                contentLine.setPrefWidth(215.0);
                contentLine.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
                contentLine.setCursor(Cursor.V_RESIZE);
                AtomicReference<Object> initialHeight = new AtomicReference<Object>(null);
                Delta dragDelta = new Delta();
                contentLine.setOnMousePressed(mouseEvent -> {
                    if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                        if (initialHeight.get() == null) {
                            initialHeight.set(pluginPane.getHeight());
                        }
                        dragDelta.setHeight(pluginPane.getHeight());
                        dragDelta.setY(mouseEvent.getScreenY());
                        if (mouseEvent.getClickCount() >= 2) {
                            pluginPane.setMinHeight(((Double)initialHeight.get()).doubleValue());
                            pluginPane.setMaxHeight(((Double)initialHeight.get()).doubleValue());
                            contentLine.setCursor(Cursor.V_RESIZE);
                        }
                    }
                });
                contentLine.setOnMouseDragged(mouseEvent -> {
                    if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                        double height = dragDelta.getHeight() + (mouseEvent.getScreenY() - dragDelta.getY());
                        if (height >= (Double)initialHeight.get()) {
                            pluginPane.setMinHeight(height);
                            pluginPane.setMaxHeight(height);
                            contentLine.setCursor(Cursor.V_RESIZE);
                        } else {
                            contentLine.setCursor(Cursor.CLOSED_HAND);
                        }
                    }
                });
                this.contentBox.getChildren().add((Object)contentLine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void clearPluginGraphic() {
        this.contentBox.getChildren().clear();
        this.contentLoadingBox.getChildren().clear();
        if (this.popOver != null) {
            this.popOver.hide();
        }
    }

    boolean isActivated() {
        return this.togActivator.selectedProperty().get();
    }

    void clearPluginGraphicAndDeactivate() throws Exception {
        this.clearPluginGraphic();
        this.plugin.pluginDeactivated();
    }

    private void activated() {
        this.displayLoadingBar(true);
        new Thread(() -> Platform.runLater(() -> {
            try {
                this.plugin.pluginActivated();
                this.loadPluginGraphic();
                if (!this.plugin.isOneTimePlugin()) {
                    List deactivatedPlugins = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
                    deactivatedPlugins.remove(this.pluginFileName);
                    org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_SAVE_DEACTIVATED_PLUGINS");
                }
            }
            catch (Throwable e) {
                this.makeDisable(e, true);
            }
            finally {
                this.displayLoadingBar(false);
            }
        })).start();
    }

    private void deactivated() {
        new Thread(() -> Platform.runLater(() -> {
            try {
                if (!this.plugin.isOneTimePlugin()) {
                    List deactivatedPlugins = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
                    deactivatedPlugins.add(this.pluginFileName);
                    org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_SAVE_DEACTIVATED_PLUGINS");
                }
                this.clearPluginGraphicAndDeactivate();
            }
            catch (Throwable e) {
                this.makeDisable(e, true);
            }
        })).start();
    }

    public void onEvent(String event) {
        if (this.isActivated()) {
            try {
                switch (event) {
                    case "EVENT_APPLICATION_ACTIVATED": {
                        this.plugin.applicationActivated();
                        break;
                    }
                    case "EVENT_APPLICATION_DEACTIVATED": {
                        this.plugin.applicationDeactivated();
                        break;
                    }
                    case "EVENT_APPLICATION_CLOSE_REQUESTED": {
                        this.plugin.applicationCloseRequested();
                        break;
                    }
                    case "EVENT_UPDATE_PROXY_HOST": {
                        this.plugin.proxyHostObject().set((Object)RESTfulAPI.getProxyHost());
                        this.plugin.applicationConfigChanged();
                        break;
                    }
                    case "EVENT_APPLY_DARK_MODE": {
                        this.plugin.darkModeProperty().set(ConfigUtil.isDarkMode());
                        this.plugin.applicationConfigChanged();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            switch (event) {
                case "EVENT_APPLY_DARK_MODE": {
                    this.applyDarkMode();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

