/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.view.about;

import java.awt.Desktop;
import java.net.URI;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.silentsoft.io.memory.SharedMemory;
import org.silentsoft.ui.viewer.AbstractViewerController;

public class AboutController
extends AbstractViewerController {
    @FXML
    private Label version;
    @FXML
    private Label runtime;
    @FXML
    private HBox newVersionBox;
    @FXML
    private Hyperlink archivesLink;
    @FXML
    private Hyperlink sourceCodeLink;
    @FXML
    private Hyperlink licenseLink;
    @FXML
    private Hyperlink changeLogLink;
    @FXML
    private Hyperlink homepageLink;

    public void initialize(Parent viewer, Object ... parameters) {
        this.version.setText("2.2.0");
        this.runtime.setText(String.format("%s, %s", System.getProperty("java.vm.name"), System.getProperty("java.runtime.version")));
        boolean isAvailableNewActlist = (Boolean)SharedMemory.getDataMap().getOrDefault((Object)"KEY_IS_AVAILABLE_NEW_ACTLIST", (Object)false);
        if (isAvailableNewActlist) {
            this.newVersionBox.setVisible(true);
        } else {
            this.newVersionBox.setVisible(false);
        }
    }

    @FXML
    private void browseHomepage() {
        this.browse(this.homepageLink, "http://actlist.silentsoft.org");
    }

    @FXML
    private void browseArchives() {
        this.browse(this.archivesLink, "http://actlist.silentsoft.org/archives/");
    }

    @FXML
    private void browseSourceCode() {
        this.browse(this.sourceCodeLink, "https://github.com/silentsoft/actlist");
    }

    @FXML
    private void browseLicense() {
        this.browse(this.licenseLink, "https://github.com/silentsoft/actlist/blob/master/NOTICE.md");
    }

    @FXML
    private void browseChangeLog() {
        this.browse(this.changeLogLink, "https://github.com/silentsoft/actlist/blob/master/CHANGELOG.md");
    }

    private void browse(Hyperlink hyperlink, String uri) {
        hyperlink.setVisited(false);
        try {
            Desktop.getDesktop().browse(URI.create(uri));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

