/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.util;

import org.silentsoft.actlist.ActlistConfig;
import org.silentsoft.core.util.SystemUtil;
import org.silentsoft.io.memory.SharedMemory;

public class ConfigUtil {
    public static ActlistConfig getActlistConfig() {
        return (ActlistConfig)SharedMemory.getDataMap().get((Object)"KEY_ACTLIST_CONFIG");
    }

    public static double getRootWidth() {
        Object rootWidth = ConfigUtil.getActlistConfig().get("rootWidth");
        if (rootWidth instanceof Integer) {
            return (double)((Integer)rootWidth).intValue() + 0.0;
        }
        return (Double)rootWidth;
    }

    public static void setRootWidth(double width) throws Exception {
        ConfigUtil.getActlistConfig().put("rootWidth", width);
    }

    public static double getRootHeight() {
        Object rootHeight = ConfigUtil.getActlistConfig().get("rootHeight");
        if (rootHeight instanceof Integer) {
            return (double)((Integer)rootHeight).intValue() + 0.0;
        }
        return (Double)rootHeight;
    }

    public static void setRootHeight(double height) throws Exception {
        ConfigUtil.getActlistConfig().put("rootHeight", height);
    }

    public static double getStageWidth() {
        Object stageWidth = ConfigUtil.getActlistConfig().get("stageWidth");
        if (stageWidth instanceof Integer) {
            return (double)((Integer)stageWidth).intValue() + 0.0;
        }
        return (Double)stageWidth;
    }

    public static void setStageWidth(double width) throws Exception {
        ConfigUtil.getActlistConfig().put("stageWidth", width);
    }

    public static double getStageHeight() {
        Object stageHeight = ConfigUtil.getActlistConfig().get("stageHeight");
        if (stageHeight instanceof Integer) {
            return (double)((Integer)stageHeight).intValue() + 0.0;
        }
        return (Double)stageHeight;
    }

    public static void setStageHeight(double height) throws Exception {
        ConfigUtil.getActlistConfig().put("stageHeight", height);
    }

    public static double getStageOpacity() {
        Object stageOpacity = ConfigUtil.getActlistConfig().get("stageOpacity");
        if (stageOpacity instanceof Integer) {
            return (double)((Integer)stageOpacity).intValue() + 0.0;
        }
        return (Double)stageOpacity;
    }

    public static void setStageOpacity(double opacity) throws Exception {
        ConfigUtil.getActlistConfig().put("stageOpacity", opacity);
    }

    public static boolean isAlwaysOnTop() {
        return (Boolean)ConfigUtil.getActlistConfig().get("alwaysOnTop");
    }

    public static void setAlwaysOnTop(boolean value) throws Exception {
        ConfigUtil.getActlistConfig().put("alwaysOnTop", value);
    }

    public static String getLoggingLevel() {
        return (String)ConfigUtil.getActlistConfig().get("loggingLevel");
    }

    public static void setLoggingLevel(String value) throws Exception {
        ConfigUtil.getActlistConfig().put("loggingLevel", value);
    }

    public static int getShowHideActlistHotKeyModifier() {
        return (Integer)ConfigUtil.getActlistConfig().get("showHideActlistHotKeyModifier");
    }

    public static void setShowHideActlistHotKeyModifier(int modifier) throws Exception {
        ConfigUtil.getActlistConfig().put("showHideActlistHotKeyModifier", modifier);
    }

    public static int getShowHideActlistHotKeyCode() {
        return (Integer)ConfigUtil.getActlistConfig().get("showHideActlistHotKeyCode");
    }

    public static void setShowHideActlistHotKeyCode(int code) throws Exception {
        ConfigUtil.getActlistConfig().put("showHideActlistHotKeyCode", code);
    }

    public static String getShowHideActlistHotKeyText() {
        String hotKeyText = "";
        int modifier = ConfigUtil.getShowHideActlistHotKeyModifier();
        if ((modifier & 0x80) == 128) {
            hotKeyText = hotKeyText.concat("Ctrl + ");
        }
        if ((modifier & 0x200) == 512) {
            hotKeyText = hotKeyText.concat("Alt + ");
        }
        if ((modifier & 0x40) == 64) {
            hotKeyText = hotKeyText.concat("Shift + ");
        }
        if ((modifier & 0x100) == 256) {
            hotKeyText = SystemUtil.isWindows() ? hotKeyText.concat("Win + ") : (SystemUtil.isMac() ? hotKeyText.concat("Cmd + ") : hotKeyText.concat("Meta + "));
        }
        return hotKeyText.concat(String.valueOf((char)ConfigUtil.getShowHideActlistHotKeyCode()));
    }

    public static String getTheme() {
        Object theme = ConfigUtil.getActlistConfig().get("theme");
        if (theme == null) {
            try {
                theme = SystemUtil.isMac() ? "MAC" : "WIN";
                ConfigUtil.setTheme((String)theme);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (String)theme;
    }

    public static void setTheme(String theme) throws Exception {
        ConfigUtil.getActlistConfig().put("theme", theme);
    }

    public static boolean isMacTheme() {
        return "MAC".equalsIgnoreCase(ConfigUtil.getTheme());
    }

    public static boolean isWinTheme() {
        return "WIN".equalsIgnoreCase(ConfigUtil.getTheme());
    }

    public static boolean isDarkMode() {
        return (Boolean)ConfigUtil.getActlistConfig().get("darkMode");
    }

    public static void setDarkMode(boolean value) throws Exception {
        ConfigUtil.getActlistConfig().put("darkMode", value);
    }

    public static String getProxyMode() {
        return (String)ConfigUtil.getActlistConfig().get("proxyMode");
    }

    public static void setProxyMode(String proxyMode) throws Exception {
        ConfigUtil.getActlistConfig().put("proxyMode", proxyMode);
    }

    public static String getProxyHost() {
        return (String)ConfigUtil.getActlistConfig().get("proxyHost");
    }

    public static void setProxyHost(String proxyHost) throws Exception {
        ConfigUtil.getActlistConfig().put("proxyHost", proxyHost);
    }

    public class ProxyMode {
        public static final String NONE = "NONE";
        public static final String AUTOMATIC = "AUTOMATIC";
        public static final String MANUAL = "MANUAL";
    }

    public class Theme {
        public static final String MAC = "MAC";
        public static final String WIN = "WIN";
    }
}

