/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.application;

import com.jfoenix.controls.JFXButton;
import de.codecentric.centerdevice.glass.AdapterContext;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.SVGPath;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.control.PopOver;
import org.silentsoft.actlist.application.App;
import org.silentsoft.actlist.plugin.PluginComponent;
import org.silentsoft.actlist.plugin.PluginManager;
import org.silentsoft.actlist.plugin.messagebox.MessageBox;
import org.silentsoft.actlist.rest.RESTfulAPI;
import org.silentsoft.actlist.util.ConfigUtil;
import org.silentsoft.actlist.view.about.About;
import org.silentsoft.actlist.view.configuration.Configuration;
import org.silentsoft.actlist.view.explore.Explore;
import org.silentsoft.core.util.DateUtil;
import org.silentsoft.core.util.FileUtil;
import org.silentsoft.core.util.SystemUtil;
import org.silentsoft.io.event.EventHandler;
import org.silentsoft.io.event.EventListener;
import org.silentsoft.io.memory.SharedMemory;
import org.silentsoft.ui.model.Delta;
import org.silentsoft.ui.model.MaximizeProperty;
import org.silentsoft.ui.util.StageDragResizer;

public class AppController
implements EventListener {
    @FXML
    private AnchorPane root;
    @FXML
    private BorderPane head;
    @FXML
    private Label headMinimizeButton;
    @FXML
    private Label headMaximizeButton;
    @FXML
    private Label headCloseButton;
    @FXML
    private BorderPane body;
    @FXML
    private Pane handPaneMac;
    @FXML
    private VBox sideArea;
    @FXML
    private HBox sideControls;
    @FXML
    private Label sideMinimizeButton;
    @FXML
    private Label sideMaximizeButton;
    @FXML
    private Label sideCloseButton;
    @FXML
    private VBox sideNav;
    @FXML
    private Region navPluginsMac;
    @FXML
    private Region navExploreMac;
    @FXML
    private Region navConsoleMac;
    @FXML
    private Region navAboutMac;
    @FXML
    private Region navConfigurationMac;
    @FXML
    private Region navPluginsWin;
    @FXML
    private Region navExploreWin;
    @FXML
    private Region navConsoleWin;
    @FXML
    private Region navAboutWin;
    @FXML
    private Region navConfigurationWin;
    @FXML
    private Label newPluginsAlarmLabelMac;
    @FXML
    private Label newPluginsAlarmLabelWin;
    @FXML
    private Label appUpdateAlarmLabelMac;
    @FXML
    private Label appUpdateAlarmLabelWin;
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private BorderPane contentPane;
    @FXML
    private VBox componentBox;
    private TextArea consoleTextArea;
    private PopOver updatePopOver;
    private MaximizeProperty maximizeProperty;
    private HashMap<String, URLClassLoader> pluginMap;

    protected void initialize() {
        EventHandler.addListener((EventListener)this);
        this.initConsole();
        this.root.setPrefWidth(ConfigUtil.getRootWidth());
        this.root.setPrefHeight(ConfigUtil.getRootHeight());
        this.maximizeProperty = new MaximizeProperty(App.getStage());
        this.pluginMap = new HashMap();
        this.makeDraggable(App.getStage(), (Node)this.head);
        this.makeNormalizable(App.getStage(), (Node)this.head);
        this.makeMinimizable(App.getStage(), (Node)this.headMinimizeButton);
        this.makeMaximizable(App.getStage(), (Node)this.headMaximizeButton);
        this.makeClosable(App.getStage(), (Node)this.headCloseButton);
        this.makeDraggable(App.getStage(), (Node)this.sideNav);
        this.makeNormalizable(App.getStage(), (Node)this.sideNav);
        this.makeMinimizable(App.getStage(), (Node)this.sideMinimizeButton);
        this.makeMaximizable(App.getStage(), (Node)this.sideMaximizeButton);
        this.makeClosable(App.getStage(), (Node)this.sideCloseButton);
        this.makeDraggable(App.getStage(), (Node)this.handPaneMac);
        this.makeNormalizable(App.getStage(), (Node)this.handPaneMac);
        this.applyTheme();
        this.applyDarkMode();
        this.makeResizable(App.getStage(), (Region)this.root);
        this.initUpdatePopOver();
        this.checkUpdate();
        SharedMemory.getDataMap().put((Object)"KEY_PLUGIN_MAP", this.pluginMap);
        SharedMemory.getDataMap().put((Object)"KEY_COMPONENT_BOX", (Object)this.componentBox);
        this.loadPlugins();
        this.enableContextMenu();
        this.enableDragAndDrop();
    }

    public void notifyFocusState(boolean isFocused) {
        if (ConfigUtil.isMacTheme()) {
            if (isFocused) {
                this.sideCloseButton.setStyle("-fx-background-color: red; -fx-background-radius: 5em;");
                this.sideMinimizeButton.setStyle("-fx-background-color: orange; -fx-background-radius: 5em;");
                this.sideMaximizeButton.setStyle("-fx-background-color: #59bf53; -fx-background-radius: 5em;");
            } else {
                this.sideCloseButton.setStyle("-fx-background-color: #808080; -fx-background-radius: 5em;");
                this.sideMinimizeButton.setStyle("-fx-background-color: #808080; -fx-background-radius: 5em;");
                this.sideMaximizeButton.setStyle("-fx-background-color: #808080; -fx-background-radius: 5em;");
            }
        }
    }

    private void initConsole() {
        this.consoleTextArea = new TextArea();
        MenuItem clearMenuItem = new MenuItem("Clear");
        clearMenuItem.setOnAction(event -> EventHandler.callEvent(this.getClass(), (String)"EVENT_CLEAR_CONSOLE_LOG"));
        this.consoleTextArea.setContextMenu(new ContextMenu(new MenuItem[]{clearMenuItem}));
        this.consoleTextArea.setEditable(false);
        this.consoleTextArea.setFont(Font.font((String)"Consolas", (double)13.0));
        StringBuffer style = new StringBuffer();
        style.append("-fx-control-inner-background: rgb(40, 40, 40); ");
        style.append("-fx-background-color: -fx-control-inner-background; ");
        style.append("-fx-background-radius: 0; ");
        style.append("-fx-faint-focus-color: transparent;");
        this.consoleTextArea.setStyle(style.toString());
        SharedMemory.getDataMap().put((Object)"KEY_CONSOLE_TEXT_AREA", (Object)this.consoleTextArea);
    }

    private void makeDraggable(Stage stage, Node byNode) {
        Delta dragDelta = new Delta();
        byNode.setOnMousePressed(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                dragDelta.setX(stage.getX() - mouseEvent.getScreenX());
                dragDelta.setY(stage.getY() - mouseEvent.getScreenY());
                byNode.setOpacity(0.98);
            }
        });
        byNode.setOnMouseDragged(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                if (this.maximizeProperty.isMaximized()) {
                    double x = mouseEvent.getScreenX() - stage.getX();
                    double y = mouseEvent.getScreenY() - stage.getY();
                    this.changeMaximizeProperty(stage);
                    dragDelta.setX(-1.0 * (stage.getWidth() / 2.0));
                    dragDelta.setY(-1.0 * mouseEvent.getSceneY());
                } else {
                    stage.setX(mouseEvent.getScreenX() + dragDelta.getX());
                    stage.setY(mouseEvent.getScreenY() + dragDelta.getY());
                }
            }
        });
        byNode.setOnMouseReleased(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                byNode.setOpacity(1.0);
            }
        });
    }

    private void makeNormalizable(Stage stage, Node byNode) {
        byNode.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getClickCount() >= 2) {
                this.changeMaximizeProperty(stage);
            }
        });
    }

    private void makeMinimizable(Stage stage, Node byNode) {
        byNode.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                stage.setIconified(true);
            }
        });
    }

    private void makeMaximizable(Stage stage, Node byNode) {
        byNode.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                this.changeMaximizeProperty(stage);
            }
        });
    }

    private void makeClosable(Stage stage, Node byNode) {
        byNode.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                if (SystemUtil.isMac()) {
                    AdapterContext.getContext().getApplicationAdapter().hide();
                } else {
                    stage.hide();
                }
            }
        });
    }

    private void makeResizable(Stage stage, Region region) {
        StageDragResizer.makeResizable((Stage)stage, (Region)region, (int)7, (int)10, () -> {
            try {
                ConfigUtil.setRootWidth(region.getWidth());
                ConfigUtil.setRootHeight(region.getHeight());
                ConfigUtil.setStageWidth(App.getStage().getWidth());
                ConfigUtil.setStageHeight(App.getStage().getHeight());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void changeMaximizeProperty(Stage stage) {
        this.maximizeProperty.setMaximized(stage, !this.maximizeProperty.isMaximized());
        if (this.maximizeProperty.isMaximized()) {
            AnchorPane.setLeftAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setTopAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)this.body, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.body, (Double)0.0);
            AnchorPane.setTopAnchor((Node)this.body, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)this.body, (Double)0.0);
        } else {
            AnchorPane.setLeftAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setRightAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setTopAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setBottomAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setLeftAnchor((Node)this.body, (Double)2.0);
            AnchorPane.setRightAnchor((Node)this.body, (Double)2.0);
            AnchorPane.setTopAnchor((Node)this.body, (Double)2.0);
            AnchorPane.setBottomAnchor((Node)this.body, (Double)2.0);
        }
        stage.getScene().getRoot().requestLayout();
    }

    private void applyTheme() {
        if (this.isWinTheme()) {
            this.body.setTop((Node)this.head);
            this.body.setLeft(null);
            this.handPaneMac.setVisible(false);
        } else if (this.isMacTheme()) {
            this.body.setTop(null);
            this.body.setLeft((Node)this.sideArea);
            this.handPaneMac.setVisible(true);
        }
    }

    private void applyDarkMode() {
        String css = this.getClass().getResource("App-darkmode.css").toExternalForm();
        if (ConfigUtil.isDarkMode()) {
            if (!this.root.getStylesheets().contains((Object)css)) {
                this.root.getStylesheets().add((Object)css);
            }
        } else {
            this.root.getStylesheets().remove((Object)css);
        }
    }

    private void playNewPluginsAlarm() {
        Platform.runLater(() -> {
            this.newPluginsAlarmLabelWin.setVisible(true);
            this.newPluginsAlarmLabelMac.setVisible(true);
            FadeTransition fadeTransition = null;
            if (this.isWinTheme()) {
                fadeTransition = new FadeTransition(Duration.millis((double)400.0), (Node)this.newPluginsAlarmLabelWin);
            } else if (this.isMacTheme()) {
                fadeTransition = new FadeTransition(Duration.millis((double)400.0), (Node)this.newPluginsAlarmLabelMac);
            }
            if (fadeTransition != null) {
                fadeTransition.setFromValue(1.0);
                fadeTransition.setToValue(0.3);
                fadeTransition.setCycleCount(6);
                fadeTransition.setAutoReverse(true);
                fadeTransition.play();
            }
        });
    }

    @FXML
    private void showPluginsView() {
        this.toggleNav(this.navPluginsWin, this.navPluginsMac);
        this.newPluginsAlarmLabelWin.setVisible(false);
        this.newPluginsAlarmLabelMac.setVisible(false);
        this.contentPane.setCenter((Node)this.componentBox);
    }

    @FXML
    private void showExploreView() {
        this.toggleNav(this.navExploreWin, this.navExploreMac);
        this.contentPane.setCenter((Node)new Explore().getViewer());
    }

    @FXML
    private void showConsoleView() {
        this.toggleNav(this.navConsoleWin, this.navConsoleMac);
        this.contentPane.setCenter((Node)this.consoleTextArea);
    }

    @FXML
    private void showAboutView() {
        this.toggleNav(this.navAboutWin, this.navAboutMac);
        this.contentPane.setCenter((Node)new About().getViewer());
    }

    @FXML
    private void showConfigurationView() {
        this.toggleNav(this.navConfigurationWin, this.navConfigurationMac);
        this.contentPane.setCenter((Node)new Configuration().getViewer());
    }

    @FXML
    private void eventNavMouseEntered(MouseEvent mouseEvent) {
        Region region;
        if (mouseEvent.getSource() instanceof Region && (region = (Region)mouseEvent.getSource()).getOpacity() != 1.0) {
            region.setOpacity(0.9);
        }
    }

    @FXML
    private void eventNavMouseExited(MouseEvent mouseEvent) {
        Region region;
        if (mouseEvent.getSource() instanceof Region && (region = (Region)mouseEvent.getSource()).getOpacity() != 1.0) {
            region.setOpacity(0.75);
        }
    }

    private void toggleNav(Region targetWin, Region targetMac) {
        Arrays.asList(this.navPluginsWin, this.navExploreWin, this.navConsoleWin, this.navAboutWin, this.navConfigurationWin, this.navPluginsMac, this.navExploreMac, this.navConsoleMac, this.navAboutMac, this.navConfigurationMac).forEach(region -> {
            if (region == targetWin || region == targetMac) {
                region.setOpacity(1.0);
            } else {
                region.setOpacity(0.75);
            }
        });
    }

    private boolean isWinTheme() {
        return "WIN".equals(ConfigUtil.getTheme());
    }

    private boolean isMacTheme() {
        return "MAC".equals(ConfigUtil.getTheme());
    }

    private void initUpdatePopOver() {
        this.updatePopOver = new PopOver();
        Label title = new Label("Actlist Update Alarm");
        title.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)12.0));
        title.setTextFill(Paint.valueOf((String)"#000000"));
        title.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        Label message = new Label("New Actlist is available. Would you like to browse now ?");
        message.setWrapText(true);
        message.setFont(Font.font((String)"Verdana", (double)12.0));
        message.setTextFill(Paint.valueOf((String)"#000000"));
        message.setTextAlignment(TextAlignment.CENTER);
        message.setPrefWidth(194.0);
        message.setPrefHeight(40.0);
        JFXButton notNowButton = new JFXButton("Not Now");
        notNowButton.setCursor(Cursor.HAND);
        notNowButton.setPrefWidth(97.0);
        notNowButton.setButtonType(JFXButton.ButtonType.RAISED);
        notNowButton.setRipplerFill(Paint.valueOf((String)"#eeeeee"));
        notNowButton.setFont(Font.font((String)"Verdana", (double)12.0));
        notNowButton.setTextFill(Paint.valueOf((String)"#0b7aea"));
        notNowButton.setOnMouseClicked(mouseEvent -> this.hideUpdatePopOver());
        JFXButton browseButton = new JFXButton("Browse");
        browseButton.setCursor(Cursor.HAND);
        browseButton.setPrefWidth(97.0);
        browseButton.setButtonType(JFXButton.ButtonType.RAISED);
        browseButton.setRipplerFill(Paint.valueOf((String)"#eeeeee"));
        browseButton.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)12.0));
        browseButton.setTextFill(Paint.valueOf((String)"#1c81f9"));
        browseButton.setOnMouseClicked(mouseEvent -> {
            try {
                Desktop.getDesktop().browse(new URI("http://actlist.silentsoft.org/archives/"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hideUpdatePopOver();
        });
        HBox hBox = new HBox(new Node[]{notNowButton, browseButton});
        hBox.setAlignment(Pos.CENTER);
        hBox.setStyle("-fx-border-color: lightgray; -fx-border-width: 1 0 0 0;");
        VBox vBox = new VBox(new Node[]{title, message, hBox});
        vBox.setAlignment(Pos.CENTER);
        vBox.setStyle("-fx-background-color: white;");
        vBox.setSpacing(5.0);
        vBox.setPrefWidth(214.0);
        vBox.setPrefHeight(103.0);
        this.updatePopOver.setContentNode((Node)vBox);
    }

    private void checkUpdate() {
        new Thread(() -> {
            Runnable checkUpdate = () -> {
                try {
                    boolean isAvailableNewActlist = false;
                    ArrayList<BasicNameValuePair> param = new ArrayList<BasicNameValuePair>();
                    param.add(new BasicNameValuePair("version", "2.2.0"));
                    param.add(new BasicNameValuePair("os", SystemUtil.getOSName()));
                    param.add(new BasicNameValuePair("architecture", SystemUtil.getPlatformArchitecture()));
                    Map result = RESTfulAPI.doGet("http://actlist.silentsoft.org/api/update/check", param, Map.class);
                    if (result == null) {
                        return;
                    }
                    if (result.containsKey("available")) {
                        isAvailableNewActlist = Boolean.parseBoolean(String.valueOf(result.get("available")));
                    }
                    SharedMemory.getDataMap().put((Object)"KEY_IS_AVAILABLE_NEW_ACTLIST", (Object)isAvailableNewActlist);
                    if (isAvailableNewActlist) {
                        Platform.runLater(() -> {
                            this.appUpdateAlarmLabelWin.setVisible(true);
                            this.appUpdateAlarmLabelMac.setVisible(true);
                            FadeTransition fadeTransition = null;
                            if (this.isWinTheme()) {
                                fadeTransition = new FadeTransition(Duration.millis((double)400.0), (Node)this.appUpdateAlarmLabelWin);
                            } else if (this.isMacTheme()) {
                                fadeTransition = new FadeTransition(Duration.millis((double)400.0), (Node)this.appUpdateAlarmLabelMac);
                            }
                            if (fadeTransition != null) {
                                fadeTransition.setFromValue(1.0);
                                fadeTransition.setToValue(0.3);
                                fadeTransition.setCycleCount(6);
                                fadeTransition.setAutoReverse(true);
                                fadeTransition.play();
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            };
            boolean shouldCheck = true;
            Date latestCheckDate = null;
            while (true) {
                if (shouldCheck) {
                    checkUpdate.run();
                    latestCheckDate = Calendar.getInstance().getTime();
                }
                try {
                    Thread.sleep((long)Duration.minutes((double)10.0).toMillis());
                }
                catch (InterruptedException interruptedException) {
                    shouldCheck = DateUtil.getDifferenceHoursFromNow((Date)latestCheckDate) >= 24;
                    continue;
                    catch (Throwable throwable) {
                        shouldCheck = DateUtil.getDifferenceHoursFromNow((Date)latestCheckDate) >= 24;
                        throw throwable;
                    }
                }
                shouldCheck = DateUtil.getDifferenceHoursFromNow((Date)latestCheckDate) >= 24;
                continue;
                break;
            }
        }).start();
    }

    @FXML
    private void showControls() {
        ((SVGPath)this.sideCloseButton.getGraphic()).setFill(Paint.valueOf((String)"rgb(35, 35, 35)"));
        ((SVGPath)this.sideMinimizeButton.getGraphic()).setFill(Paint.valueOf((String)"rgb(35, 35, 35)"));
        ((SVGPath)this.sideMaximizeButton.getGraphic()).setFill(Paint.valueOf((String)"rgb(35, 35, 35)"));
    }

    @FXML
    private void hideControls() {
        ((SVGPath)this.sideCloseButton.getGraphic()).setFill(Paint.valueOf((String)"transparent"));
        ((SVGPath)this.sideMinimizeButton.getGraphic()).setFill(Paint.valueOf((String)"transparent"));
        ((SVGPath)this.sideMaximizeButton.getGraphic()).setFill(Paint.valueOf((String)"transparent"));
    }

    @FXML
    private void showUpdatePopOver() {
        if (!this.updatePopOver.isShowing()) {
            if (this.isWinTheme()) {
                this.updatePopOver.setArrowLocation(PopOver.ArrowLocation.TOP_RIGHT);
                this.updatePopOver.show((Node)this.appUpdateAlarmLabelWin);
            } else if (this.isMacTheme()) {
                this.updatePopOver.setArrowLocation(PopOver.ArrowLocation.BOTTOM_LEFT);
                this.updatePopOver.show((Node)this.appUpdateAlarmLabelMac);
            }
        }
    }

    private void hideUpdatePopOver() {
        this.updatePopOver.hide();
        this.appUpdateAlarmLabelWin.setVisible(false);
        this.appUpdateAlarmLabelMac.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPlugins() {
        this.componentBox.getChildren().clear();
        try {
            File pluginsDirectory = Paths.get(System.getProperty("user.dir"), "plugins").toFile();
            if (!pluginsDirectory.exists()) {
                pluginsDirectory.mkdirs();
            }
            List<String> purgeTargetPlugins = this.readPurgeTargetPlugins();
            SharedMemory.getDataMap().put((Object)"KEY_PURGE_TARGET_PLUGINS", purgeTargetPlugins);
            List<String> deactivatedPlugins = this.readDeactivatedPlugins();
            SharedMemory.getDataMap().put((Object)"KEY_DEACTIVATED_PLUGINS", deactivatedPlugins);
            List<String> priorityOfPlugins = this.readPriorityOfPlugins();
            SharedMemory.getDataMap().put((Object)"KEY_PRIORITY_OF_PLUGINS", priorityOfPlugins);
            for (int i = purgeTargetPlugins.size() - 1; i >= 0; --i) {
                Path path2 = Paths.get(System.getProperty("user.dir"), "plugins", purgeTargetPlugins.get(i));
                if (Files.exists(path2, new LinkOption[0])) {
                    try {
                        Files.delete(path2);
                        purgeTargetPlugins.remove(i);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                purgeTargetPlugins.remove(i);
            }
            this.savePurgeTargetPlugins();
            ArrayList<String> plugins = new ArrayList<String>();
            Stream<Path> pathStream = Files.walk(Paths.get(System.getProperty("user.dir"), "plugins"), 1, new FileVisitOption[0]);
            pathStream.forEach(path -> {
                if (this.isAssignableFromJarFile((Path)path)) {
                    plugins.add(path.getFileName().toString());
                }
            });
            pathStream.close();
            for (int i = deactivatedPlugins.size() - 1; i >= 0; --i) {
                String plugin = deactivatedPlugins.get(i);
                if (plugins.contains(plugin)) continue;
                deactivatedPlugins.remove(i);
            }
            this.saveDeactivatedPlugins();
            Path configDirectory = Paths.get(System.getProperty("user.dir"), "plugins", "config");
            if (Files.exists(configDirectory, new LinkOption[0]) && Files.isDirectory(configDirectory, new LinkOption[0])) {
                Stream<Path> pathStream2 = Files.walk(configDirectory, 1, new FileVisitOption[0]);
                pathStream2.forEach(path -> {
                    String fileName = path.getFileName().toString();
                    if (fileName.toLowerCase().endsWith(".config") && !plugins.contains(fileName = fileName.substring(0, fileName.length() - ".config".length()))) {
                        try {
                            Files.delete(path);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                pathStream2.close();
            }
            for (int i = priorityOfPlugins.size() - 1; i >= 0; --i) {
                String plugin = priorityOfPlugins.get(i);
                if (plugins.contains(plugin)) {
                    plugins.remove(plugin);
                    plugins.add(0, plugin);
                    continue;
                }
                priorityOfPlugins.remove(i);
            }
            priorityOfPlugins.clear();
            priorityOfPlugins.addAll(plugins);
            this.savePriorityOfPlugins();
            SharedMemory.getDataMap().put((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS", (Object)plugins.size());
            EventHandler.callEvent(this.getClass(), (String)"EVENT_NOTIFY_PRELOADER_PREPARING_PLUGINS");
            for (String plugin : plugins) {
                try {
                    Path path3 = Paths.get(System.getProperty("user.dir"), "plugins", plugin);
                    if (!this.isAssignableFromJarFile(path3)) continue;
                    this.loadPlugin(path3);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    EventHandler.callEvent(this.getClass(), (String)"EVENT_NOTIFY_PRELOADER_COUNT_DOWN_PLUGIN");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (SharedMemory.getDataMap().get((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS") == null) {
                SharedMemory.getDataMap().put((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS", (Object)0);
                EventHandler.callEvent(this.getClass(), (String)"EVENT_NOTIFY_PRELOADER_PREPARING_PLUGINS");
            }
            this.createPromptComponent();
        }
        App.getStage().showingProperty().addListener((observable, oldValue, newValue) -> {
            if (!oldValue.booleanValue() && newValue.booleanValue()) {
                EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_ACTIVATED");
            } else if (oldValue.booleanValue() && !newValue.booleanValue()) {
                EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_DEACTIVATED");
            }
        });
        App.getStage().iconifiedProperty().addListener((observable, oldValue, newValue) -> {
            if (!oldValue.booleanValue() && newValue.booleanValue()) {
                EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_DEACTIVATED");
            } else if (oldValue.booleanValue() && !newValue.booleanValue()) {
                EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_ACTIVATED");
            }
        });
        App.getStage().setOnCloseRequest(windowEvent -> EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_EXIT"));
    }

    private void enableContextMenu() {
        MenuItem menuItem = new MenuItem("Add a new plugin");
        menuItem.setOnAction(actionEvent -> {
            FileChooser.ExtensionFilter jarFilter = new FileChooser.ExtensionFilter("Actlist Plugin File", new String[]{"*.jar"});
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Select a new Actlist plugin file");
            fileChooser.setInitialDirectory(Paths.get(System.getProperty("user.dir"), "plugins").toFile());
            fileChooser.getExtensionFilters().add((Object)jarFilter);
            fileChooser.setSelectedExtensionFilter(jarFilter);
            File file = fileChooser.showOpenDialog((Window)App.getStage());
            if (file == null) {
                return;
            }
            this.installAndLoadThePlugin(file, true);
        });
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{menuItem});
        this.scrollPane.setOnMouseReleased(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                contextMenu.show((Window)App.getStage(), mouseEvent.getScreenX(), mouseEvent.getScreenY());
            }
        });
    }

    private void enableDragAndDrop() {
        Predicate<Dragboard> containsJarFileOnly = dragboard -> {
            if (dragboard.hasFiles()) {
                List files = dragboard.getFiles();
                for (File file : files) {
                    if (file.isFile() && file.getName().toLowerCase().endsWith(".jar")) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        };
        this.scrollPane.setOnDragOver(dragEvent -> {
            if (containsJarFileOnly.test(dragEvent.getDragboard())) {
                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            } else {
                dragEvent.consume();
            }
        });
        this.scrollPane.setOnDragDropped(dragEvent -> {
            dragEvent.setDropCompleted(false);
            if (containsJarFileOnly.test(dragEvent.getDragboard())) {
                HashMap pluginMap = (HashMap)SharedMemory.getDataMap().get((Object)"KEY_PLUGIN_MAP");
                int numberOfPluginsBeforeInstall = pluginMap.size();
                for (File file : dragEvent.getDragboard().getFiles()) {
                    this.installAndLoadThePlugin(file, false);
                    dragEvent.setDropCompleted(true);
                }
                int numberOfPluginsAfterInstall = pluginMap.size();
                if (numberOfPluginsBeforeInstall != numberOfPluginsAfterInstall) {
                    this.showPluginsView();
                }
            }
            dragEvent.consume();
        });
    }

    private void installAndLoadThePlugin(File file, boolean strict) {
        try {
            Path path = PluginManager.install(file, strict);
            if (path != null) {
                PluginManager.load(String.valueOf(path.getFileName()), true);
                this.savePriorityOfPlugins();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageBox.showError((Object)App.getStage(), (String)"Oops... something is weird !");
        }
    }

    private boolean isAssignableFromJarFile(Path path) {
        String extension;
        String fileName;
        File file = path.toFile();
        return file.isFile() && (fileName = file.getName()).contains(".") && ".jar".equalsIgnoreCase(extension = fileName.substring(fileName.lastIndexOf("."), fileName.length()));
    }

    private List<String> readPurgeTargetPlugins() {
        return FileUtil.readFileByLine((Path)Paths.get(System.getProperty("user.dir"), "plugins", "purge.ini"), (boolean)true).stream().distinct().collect(Collectors.toList());
    }

    private void savePurgeTargetPlugins() {
        try {
            List purgeTargetPlugins = (List)SharedMemory.getDataMap().get((Object)"KEY_PURGE_TARGET_PLUGINS");
            purgeTargetPlugins = purgeTargetPlugins.stream().distinct().collect(Collectors.toList());
            SharedMemory.getDataMap().put((Object)"KEY_PURGE_TARGET_PLUGINS", purgeTargetPlugins);
            StringBuffer buffer = new StringBuffer();
            for (String purgeTargetPlugin : purgeTargetPlugins) {
                buffer.append(purgeTargetPlugin);
                buffer.append("\r\n");
            }
            FileUtil.saveFile((Path)Paths.get(System.getProperty("user.dir"), "plugins", "purge.ini"), (String)buffer.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<String> readDeactivatedPlugins() {
        return FileUtil.readFileByLine((Path)Paths.get(System.getProperty("user.dir"), "plugins", "deactivated.ini"), (boolean)true).stream().distinct().collect(Collectors.toList());
    }

    private void saveDeactivatedPlugins() {
        try {
            List deactivatedPlugins = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
            deactivatedPlugins = deactivatedPlugins.stream().distinct().collect(Collectors.toList());
            SharedMemory.getDataMap().put((Object)"KEY_DEACTIVATED_PLUGINS", deactivatedPlugins);
            StringBuffer buffer = new StringBuffer();
            for (String deactivatedPlugin : deactivatedPlugins) {
                buffer.append(deactivatedPlugin);
                buffer.append("\r\n");
            }
            FileUtil.saveFile((Path)Paths.get(System.getProperty("user.dir"), "plugins", "deactivated.ini"), (String)buffer.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<String> readPriorityOfPlugins() {
        return FileUtil.readFileByLine((Path)Paths.get(System.getProperty("user.dir"), "plugins", "priority.ini"), (boolean)true).stream().distinct().collect(Collectors.toList());
    }

    private void savePriorityOfPlugins() {
        try {
            List<String> priorityOfPlugins;
            StringBuffer buffer = new StringBuffer();
            if (this.componentBox.getChildren().isEmpty()) {
                priorityOfPlugins = (List)SharedMemory.getDataMap().get((Object)"KEY_PRIORITY_OF_PLUGINS");
            } else {
                priorityOfPlugins = new ArrayList();
                for (Node node : this.componentBox.getChildrenUnmodifiable()) {
                    priorityOfPlugins.add(((PluginComponent)node.getUserData()).getPluginFileName());
                }
            }
            for (String priorityOfPlugin : priorityOfPlugins) {
                buffer.append(priorityOfPlugin);
                buffer.append("\r\n");
            }
            FileUtil.saveFile((Path)Paths.get(System.getProperty("user.dir"), "plugins", "priority.ini"), (String)buffer.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadPlugin(Path path) throws Exception {
        String fileName = path.getFileName().toString();
        List deactivatedPlugins = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
        PluginManager.load(fileName, !deactivatedPlugins.contains(fileName));
    }

    private void createPromptComponent() {
        Runnable action = () -> {
            VBox vBox = this.componentBox;
            synchronized (vBox) {
                if (this.componentBox.getChildren().isEmpty()) {
                    Label firstLine = new Label();
                    firstLine.setText("No plugins available.");
                    Hyperlink explore = new Hyperlink();
                    explore.setText("Explore");
                    explore.setOnMouseReleased(mouseEvent -> {
                        explore.setVisited(false);
                        this.showExploreView();
                    });
                    Label dragAndDrop = new Label();
                    dragAndDrop.setText("or drag and drop.");
                    HBox secondLine = new HBox(new Node[]{explore, dragAndDrop});
                    secondLine.setAlignment(Pos.CENTER);
                    VBox vBox2 = new VBox(new Node[]{firstLine, secondLine});
                    vBox2.setAlignment(Pos.CENTER);
                    vBox2.setSpacing(15.0);
                    AnchorPane.setTopAnchor((Node)vBox2, (Double)0.0);
                    AnchorPane.setRightAnchor((Node)vBox2, (Double)0.0);
                    AnchorPane.setBottomAnchor((Node)vBox2, (Double)0.0);
                    AnchorPane.setLeftAnchor((Node)vBox2, (Double)0.0);
                    AnchorPane pane = new AnchorPane(new Node[]{vBox2});
                    pane.setPrefWidth(310.0);
                    pane.setPrefHeight(310.0);
                    this.componentBox.getChildren().add((Object)pane);
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            action.run();
        } else {
            Platform.runLater((Runnable)action);
        }
    }

    public void onEvent(String event) {
        switch (event) {
            case "EVENT_APPLY_THEME": {
                this.applyTheme();
                break;
            }
            case "EVENT_APPLY_DARK_MODE": {
                this.applyDarkMode();
                break;
            }
            case "EVENT_PLAY_NEW_PLUGINS_ALARM": {
                this.playNewPluginsAlarm();
                break;
            }
            case "EVENT_SHOW_PLUGINS_VIEW": {
                this.showPluginsView();
                break;
            }
            case "EVENT_SHOW_EXPLORE_VIEW": {
                this.showExploreView();
                break;
            }
            case "EVENT_SHOW_ABOUT_VIEW": {
                this.showAboutView();
                break;
            }
            case "EVENT_SHOW_CONFIGURATION_VIEW": {
                this.showConfigurationView();
                break;
            }
            case "EVENT_SAVE_PURGE_TARGET_PLUGINS": {
                this.savePurgeTargetPlugins();
                break;
            }
            case "EVENT_SAVE_DEACTIVATED_PLUGINS": {
                this.saveDeactivatedPlugins();
                break;
            }
            case "EVENT_SAVE_PRIORITY_OF_PLUGINS": {
                this.savePriorityOfPlugins();
                break;
            }
            case "EVENT_CREATE_PROMPT_COMPONENT": {
                this.createPromptComponent();
            }
        }
    }
}

