/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin.messagebox;

import com.sun.javafx.stage.StageHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.silentsoft.actlist.plugin.CompatibleVersion;

@CompatibleVersion(value="1.0.0")
public final class MessageBox {
    private static List<Image> getActlistIcons() {
        return new Function<int[], List<Image>>(){

            @Override
            public List<Image> apply(int[] values) {
                ArrayList<Image> images = new ArrayList<Image>();
                for (int size : values) {
                    images.add(new Image(String.join((CharSequence)"", "/images/icon/actlist_", String.valueOf(size), ".png")));
                }
                return images;
            }
        }.apply(new int[]{24, 32, 48, 64, 128, 256});
    }

    @CompatibleVersion(value="1.0.0")
    public static void showAbout(String message) {
        MessageBox.showAbout(null, null, message);
    }

    @CompatibleVersion(value="1.0.0")
    public static void showAbout(Object owner, String message) {
        MessageBox.showAbout(owner, null, message);
    }

    @CompatibleVersion(value="1.0.0")
    public static void showAbout(String masthead, String message) {
        MessageBox.showAbout(null, masthead, message);
    }

    @CompatibleVersion(value="1.0.0")
    public static void showAbout(Object owner, String masthead, String message) {
        MessageBox.showMessage(Alert.AlertType.INFORMATION, "About", owner, masthead, message);
    }

    @CompatibleVersion(value="1.2.6")
    public static void showInformation(String message) {
        MessageBox.showInformation(null, null, message);
    }

    @CompatibleVersion(value="1.2.6")
    public static void showInformation(Object owner, String message) {
        MessageBox.showInformation(owner, null, message);
    }

    @CompatibleVersion(value="1.2.6")
    public static void showInformation(String masthead, String message) {
        MessageBox.showInformation(null, masthead, message);
    }

    @CompatibleVersion(value="1.0.0")
    public static void showInformation(Object owner, String masthead, String message) {
        MessageBox.showMessage(Alert.AlertType.INFORMATION, "Information", owner, masthead, message);
    }

    @CompatibleVersion(value="1.2.6")
    public static void showWarning(String message) {
        MessageBox.showWarning(null, null, message);
    }

    @CompatibleVersion(value="1.2.6")
    public static void showWarning(Object owner, String message) {
        MessageBox.showWarning(owner, null, message);
    }

    @CompatibleVersion(value="1.2.6")
    public static void showWarning(String masthead, String message) {
        MessageBox.showWarning(null, masthead, message);
    }

    @CompatibleVersion(value="1.2.6")
    public static void showWarning(Object owner, String masthead, String message) {
        MessageBox.showMessage(Alert.AlertType.WARNING, "Warning", owner, masthead, message);
    }

    @CompatibleVersion(value="1.0.0")
    public static void showError(String message) {
        MessageBox.showError(null, null, message);
    }

    @CompatibleVersion(value="1.0.0")
    public static void showError(Object owner, String message) {
        MessageBox.showError(owner, null, message);
    }

    @CompatibleVersion(value="1.0.0")
    public static void showError(String masthead, String message) {
        MessageBox.showError(null, masthead, message);
    }

    @CompatibleVersion(value="1.0.0")
    public static void showError(Object owner, String masthead, String message) {
        MessageBox.showMessage(Alert.AlertType.ERROR, "Error", owner, masthead, message);
    }

    private static void showMessage(Alert.AlertType alertType, String title, Object owner, String masthead, String message) {
        Alert alert = new Alert(alertType);
        ((Stage)alert.getDialogPane().getScene().getWindow()).getIcons().addAll(MessageBox.getActlistIcons());
        alert.setTitle(title);
        alert.setHeaderText(masthead);
        alert.setContentText(message);
        if (owner == null) {
            ObservableList stages = StageHelper.getStages();
            if (!stages.isEmpty()) {
                alert.initOwner((Window)stages.get(0));
            }
        } else {
            alert.initOwner((Window)owner);
        }
        alert.showAndWait();
    }

    @CompatibleVersion(value="1.0.0")
    public static Optional<ButtonType> showConfirm(String message) {
        return MessageBox.showConfirm(null, null, message);
    }

    @CompatibleVersion(value="1.0.0")
    public static Optional<ButtonType> showConfirm(Object owner, String message) {
        return MessageBox.showConfirm(owner, null, message);
    }

    @CompatibleVersion(value="1.0.0")
    public static Optional<ButtonType> showConfirm(String masthead, String message) {
        return MessageBox.showConfirm(null, masthead, message);
    }

    @CompatibleVersion(value="1.0.0")
    public static Optional<ButtonType> showConfirm(Object owner, String masthead, String message) {
        String title = "Confirm";
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        ((Stage)alert.getDialogPane().getScene().getWindow()).getIcons().addAll(MessageBox.getActlistIcons());
        alert.setTitle(title);
        alert.setHeaderText(masthead);
        alert.setContentText(message);
        if (owner == null) {
            ObservableList stages = StageHelper.getStages();
            if (!stages.isEmpty()) {
                alert.initOwner((Window)stages.get(0));
            }
        } else {
            alert.initOwner((Window)owner);
        }
        return alert.showAndWait();
    }

    @CompatibleVersion(value="1.0.0")
    public static void showException(Throwable exception) {
        MessageBox.showException(null, null, null, exception);
    }

    @CompatibleVersion(value="1.0.0")
    public static void showException(Object owner, Throwable exception) {
        MessageBox.showException(owner, null, null, exception);
    }

    @CompatibleVersion(value="1.0.0")
    public static void showException(String message, Throwable exception) {
        MessageBox.showException(null, null, message, exception);
    }

    @CompatibleVersion(value="1.0.0")
    public static void showException(Object owner, String message, Throwable exception) {
        MessageBox.showException(owner, null, message, exception);
    }

    @CompatibleVersion(value="1.0.0")
    public static void showException(String masthead, String message, Throwable exception) {
        MessageBox.showException(null, masthead, message, exception);
    }

    @CompatibleVersion(value="1.0.0")
    public static void showException(Object owner, String masthead, String message, Throwable exception) {
        Platform.runLater(() -> {
            String title = "Exception";
            Alert alert = new Alert(Alert.AlertType.ERROR);
            ((Stage)alert.getDialogPane().getScene().getWindow()).getIcons().addAll(MessageBox.getActlistIcons());
            alert.setTitle(title);
            alert.setHeaderText(masthead);
            alert.setContentText(message);
            if (owner == null) {
                ObservableList stages = StageHelper.getStages();
                if (!stages.isEmpty()) {
                    alert.initOwner((Window)stages.get(0));
                }
            } else {
                alert.initOwner((Window)owner);
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            String exceptionText = sw.toString();
            Label label = new Label("The exception stacktrace was:");
            TextArea textArea = new TextArea(exceptionText);
            textArea.setEditable(false);
            textArea.setWrapText(true);
            textArea.setMaxWidth(Double.MAX_VALUE);
            textArea.setMaxHeight(Double.MAX_VALUE);
            GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
            GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
            GridPane expContent = new GridPane();
            expContent.setMaxWidth(Double.MAX_VALUE);
            expContent.add((Node)label, 0, 0);
            expContent.add((Node)textArea, 0, 1);
            alert.getDialogPane().setExpandableContent((Node)expContent);
            alert.showAndWait();
        });
    }
}

