/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.view.configuration;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXSlider;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import com.tulskiy.keymaster.common.HotKey;
import com.tulskiy.keymaster.common.HotKeyListener;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.AnchorPane;
import javax.swing.KeyStroke;
import org.apache.http.conn.util.InetAddressUtils;
import org.silentsoft.actlist.application.App;
import org.silentsoft.actlist.util.ConfigUtil;
import org.silentsoft.core.util.SystemUtil;
import org.silentsoft.io.event.EventHandler;
import org.silentsoft.ui.viewer.AbstractViewerController;
import org.slf4j.LoggerFactory;

public class ConfigurationController
extends AbstractViewerController {
    @FXML
    private AnchorPane root;
    @FXML
    private JFXSlider stageOpacity;
    @FXML
    private JFXCheckBox alwaysOnTop;
    @FXML
    private JFXRadioButton winTheme;
    @FXML
    private JFXRadioButton macTheme;
    @FXML
    private JFXRadioButton enableDarkMode;
    @FXML
    private JFXRadioButton disableDarkMode;
    @FXML
    private JFXComboBox<String> loggingLevel;
    @FXML
    private JFXTextField showHideActlistHotKey;
    private AtomicBoolean hotKeyMakingMode;
    @FXML
    private JFXRadioButton noneProxy;
    @FXML
    private JFXRadioButton automaticProxy;
    @FXML
    private JFXRadioButton manualProxy;
    @FXML
    private JFXComboBox<String> proxyScheme;
    @FXML
    private JFXTextField proxyAddress;
    @FXML
    private JFXTextField proxyPort;
    @FXML
    private JFXCheckBox manualProxyValidator;
    private AtomicBoolean isValidAddress;
    private AtomicBoolean isValidPort;

    public void initialize() {
        this.applyDarkMode();
    }

    public void initialize(Parent viewer, Object ... parameters) {
        String proxyMode;
        String theme;
        this.stageOpacity.setValue(ConfigUtil.getStageOpacity() * 100.0);
        this.loggingLevel.setItems(FXCollections.observableArrayList((Object[])new String[]{"All", "Trace", "Debug", "Info", "Warn", "Error", "Off"}));
        this.loggingLevel.getSelectionModel().select((Object)ConfigUtil.getLoggingLevel());
        this.showHideActlistHotKey.setText(ConfigUtil.getShowHideActlistHotKeyText());
        this.alwaysOnTop.setSelected(ConfigUtil.isAlwaysOnTop());
        this.hotKeyMakingMode = new AtomicBoolean(false);
        switch (theme = ConfigUtil.getTheme()) {
            case "WIN": {
                this.winTheme.setSelected(true);
                break;
            }
            case "MAC": {
                this.macTheme.setSelected(true);
            }
        }
        if (ConfigUtil.isDarkMode()) {
            this.enableDarkMode.setSelected(true);
        } else {
            this.disableDarkMode.setSelected(true);
        }
        this.stageOpacity.valueProperty().addListener((observable, oldValue, newValue) -> App.getStage().setOpacity(newValue.doubleValue() / 100.0));
        this.stageOpacity.setOnMouseReleased(mouseEvent -> {
            try {
                ConfigUtil.setStageOpacity(this.stageOpacity.getValue() / 100.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.stageOpacity.setOnKeyReleased(keyEvent -> {
            try {
                ConfigUtil.setStageOpacity(this.stageOpacity.getValue() / 100.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.loggingLevel.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue != null) {
                    ((Logger)LoggerFactory.getLogger((String)"ROOT")).setLevel(Level.toLevel((String)newValue));
                    ConfigUtil.setLoggingLevel(newValue);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.showHideActlistHotKey.setOnKeyPressed(keyEvent -> this.hotKeyMakingMode.set(true));
        this.showHideActlistHotKey.setOnKeyReleased(keyEvent -> {
            try {
                if (this.hotKeyMakingMode.get() && (keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isShiftDown()) && keyEvent.getCode().getName().length() == 1) {
                    int modifier = 0;
                    String hotKeyText = "";
                    if (keyEvent.isControlDown()) {
                        modifier += 128;
                        hotKeyText = hotKeyText.concat("Ctrl + ");
                    }
                    if (keyEvent.isAltDown()) {
                        modifier += 512;
                        hotKeyText = hotKeyText.concat("Alt + ");
                    }
                    if (keyEvent.isShiftDown()) {
                        modifier += 64;
                        hotKeyText = hotKeyText.concat("Shift + ");
                    }
                    if (keyEvent.isMetaDown()) {
                        modifier += 256;
                        hotKeyText = SystemUtil.isWindows() ? hotKeyText.concat("Win + ") : (SystemUtil.isMac() ? hotKeyText.concat("Cmd + ") : hotKeyText.concat("Meta + "));
                    }
                    hotKeyText = hotKeyText.concat(keyEvent.getCode().getName());
                    ConfigUtil.setShowHideActlistHotKeyModifier(modifier);
                    ConfigUtil.setShowHideActlistHotKeyCode(keyEvent.getCode().getName().charAt(0));
                    App.getProvider().reset();
                    App.getProvider().register(KeyStroke.getKeyStroke((int)keyEvent.getCode().getName().charAt(0), modifier), new HotKeyListener(){

                        public void onHotKey(HotKey arg0) {
                            EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_SHOW_HIDE");
                        }
                    });
                    this.showHideActlistHotKey.setText(hotKeyText);
                    this.hotKeyMakingMode.set(false);
                    EventHandler.callEvent(((Object)((Object)this)).getClass(), (String)"EVENT_REGISTER_TRAY_ICON");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.proxyScheme.setItems(FXCollections.observableArrayList((Object[])new String[]{"http", "https"}));
        this.proxyScheme.getSelectionModel().select((Object)"http");
        this.proxyScheme.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue != null && this.proxyAddress.validate() && this.proxyPort.validate()) {
                    this.saveProxy();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.isValidAddress = new AtomicBoolean(false);
        this.proxyAddress.getValidators().add((Object)new ValidatorBase(){
            {
                this.setMessage("Invalid IPv4");
            }

            protected void eval() {
                this.hasErrors.set(true);
                try {
                    String text = ((TextInputControl)this.srcControl.get()).getText();
                    this.hasErrors.set(!InetAddressUtils.isIPv4Address((String)text));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.proxyAddress.focusedProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (!newValue.booleanValue()) {
                    this.isValidAddress.set(this.proxyAddress.validate());
                    if (!this.proxyPort.getText().isEmpty()) {
                        this.isValidPort.set(this.proxyPort.validate());
                    }
                    if (this.isValidAddress.get() && this.isValidPort.get()) {
                        this.saveProxy();
                        this.manualProxyValidator.setSelected(true);
                    } else {
                        this.manualProxyValidator.setSelected(false);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.isValidPort = new AtomicBoolean(false);
        this.proxyPort.getValidators().add((Object)new ValidatorBase(){
            {
                this.setMessage("Invalid");
            }

            protected void eval() {
                this.hasErrors.set(true);
                try {
                    String text = ((TextInputControl)this.srcControl.get()).getText();
                    int port = Integer.parseInt(text);
                    if (port >= 0 && port <= 65535) {
                        this.hasErrors.set(false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.proxyPort.focusedProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (!newValue.booleanValue()) {
                    this.isValidPort.set(this.proxyPort.validate());
                    if (!this.proxyAddress.getText().isEmpty()) {
                        this.isValidAddress.set(this.proxyAddress.validate());
                    }
                    if (this.isValidAddress.get() && this.isValidPort.get()) {
                        this.saveProxy();
                        this.manualProxyValidator.setSelected(true);
                    } else {
                        this.manualProxyValidator.setSelected(false);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.manualProxyValidator.setSelected(false);
        switch (proxyMode = ConfigUtil.getProxyMode()) {
            case "NONE": {
                this.noneProxy.setSelected(true);
                break;
            }
            case "AUTOMATIC": {
                this.automaticProxy.setSelected(true);
                break;
            }
            case "MANUAL": {
                this.manualProxy.setSelected(true);
                URI uri = URI.create(ConfigUtil.getProxyHost());
                this.proxyScheme.getSelectionModel().select((Object)uri.getScheme());
                this.proxyAddress.setText(uri.getHost());
                this.proxyPort.setText(String.valueOf(uri.getPort()));
            }
        }
        this.proxyScheme.setDisable(!"MANUAL".equals(proxyMode));
        this.proxyAddress.setDisable(!"MANUAL".equals(proxyMode));
        this.proxyPort.setDisable(!"MANUAL".equals(proxyMode));
    }

    @FXML
    private void alwaysOnTop() throws Exception {
        ConfigUtil.setAlwaysOnTop(this.alwaysOnTop.selectedProperty().get());
        App.getStage().setAlwaysOnTop(this.alwaysOnTop.selectedProperty().get());
    }

    @FXML
    private void theme() throws Exception {
        if (this.winTheme.selectedProperty().get()) {
            ConfigUtil.setTheme("WIN");
        } else if (this.macTheme.selectedProperty().get()) {
            ConfigUtil.setTheme("MAC");
        }
        EventHandler.callEvent(((Object)((Object)this)).getClass(), (String)"EVENT_APPLY_THEME", (boolean)false);
    }

    @FXML
    private void darkMode() throws Exception {
        ConfigUtil.setDarkMode(this.enableDarkMode.selectedProperty().get());
        this.applyDarkMode();
        EventHandler.callEvent(((Object)((Object)this)).getClass(), (String)"EVENT_APPLY_DARK_MODE", (boolean)false);
    }

    private void applyDarkMode() {
        String css = ((Object)((Object)this)).getClass().getResource("Configuration-darkmode.css").toExternalForm();
        if (ConfigUtil.isDarkMode()) {
            if (!this.root.getStylesheets().contains((Object)css)) {
                this.root.getStylesheets().add((Object)css);
            }
        } else {
            this.root.getStylesheets().remove((Object)css);
        }
    }

    @FXML
    private void proxy() throws Exception {
        boolean isSelectedManualProxy = this.manualProxy.selectedProperty().get();
        if (!isSelectedManualProxy) {
            this.proxyAddress.setText("");
            this.proxyPort.setText("");
            this.isValidAddress.set(false);
            this.isValidPort.set(false);
            this.manualProxyValidator.setSelected(false);
        }
        this.proxyScheme.setDisable(!isSelectedManualProxy);
        this.proxyAddress.setDisable(!isSelectedManualProxy);
        this.proxyPort.setDisable(!isSelectedManualProxy);
        if (this.noneProxy.selectedProperty().get() || this.automaticProxy.selectedProperty().get()) {
            this.saveProxy();
        }
    }

    private void saveProxy() throws Exception {
        if (this.noneProxy.selectedProperty().get()) {
            ConfigUtil.setProxyMode("NONE");
            ConfigUtil.setProxyHost("");
        } else if (this.automaticProxy.selectedProperty().get()) {
            ConfigUtil.setProxyMode("AUTOMATIC");
            ConfigUtil.setProxyHost("");
        } else if (this.manualProxy.selectedProperty().get()) {
            ConfigUtil.setProxyMode("MANUAL");
            ConfigUtil.setProxyHost(String.join((CharSequence)"", (CharSequence)this.proxyScheme.getSelectionModel().getSelectedItem(), "://", this.proxyAddress.getText(), ":", this.proxyPort.getText()));
        }
        EventHandler.callEvent(((Object)((Object)this)).getClass(), (String)"EVENT_UPDATE_PROXY_HOST");
    }
}

