/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import org.silentsoft.actlist.application.App;
import org.silentsoft.actlist.plugin.ActlistPlugin;
import org.silentsoft.actlist.plugin.PluginClassLoader;
import org.silentsoft.actlist.plugin.PluginComponent;
import org.silentsoft.actlist.plugin.messagebox.MessageBox;
import org.silentsoft.core.util.ObjectUtil;
import org.silentsoft.io.event.EventHandler;
import org.silentsoft.io.memory.SharedMemory;

public class PluginManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path install(File file, boolean strict) throws Exception {
        if (file == null) {
            return null;
        }
        boolean shouldCopy = true;
        if (file.getPath().equals(Paths.get(System.getProperty("user.dir"), "plugins", file.getName()).toString())) {
            HashMap pluginMap = (HashMap)SharedMemory.getDataMap().get((Object)"KEY_PLUGIN_MAP");
            if (pluginMap.containsKey(file.getName())) {
                if (strict) {
                    MessageBox.showError((Object)App.getStage(), (String)"You can not select an already loaded plugin !");
                }
                return null;
            }
            shouldCopy = false;
        }
        Path sourcePath = Paths.get(file.toURI());
        Path targetPath = Paths.get(System.getProperty("user.dir"), "plugins", file.getName());
        if (shouldCopy) {
            if (Files.exists(targetPath, new LinkOption[0])) {
                String uuid = UUID.randomUUID().toString().replaceAll("-", "");
                targetPath = Paths.get(System.getProperty("user.dir"), "plugins", uuid.concat(".jar"));
            }
            Files.copy(sourcePath, targetPath, new CopyOption[0]);
        }
        boolean isErrorOccur = false;
        try (URLClassLoader classLoader = null;){
            Class<?> pluginClass = null;
            InputStream inputStream = null;
            classLoader = new PluginClassLoader(new URL[]{targetPath.toUri().toURL()});
            try {
                URL manifestURL = classLoader.findResource("META-INF/MANIFEST.MF");
                inputStream = manifestURL.openStream();
                Manifest manifest = new Manifest(inputStream);
                String mainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS).trim();
                if (ObjectUtil.isNotEmpty((Object)mainClass)) {
                    pluginClass = classLoader.loadClass(mainClass);
                }
            }
            catch (Error | Exception e) {
                e.printStackTrace();
            }
            finally {
                if (pluginClass == null) {
                    pluginClass = classLoader.loadClass("Plugin");
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            if (!ActlistPlugin.class.isAssignableFrom(pluginClass)) {
                isErrorOccur = true;
            }
        }
        if (isErrorOccur) {
            if (shouldCopy) {
                Files.delete(targetPath);
            }
            if (strict) {
                MessageBox.showError((Object)App.getStage(), (String)"This file is not kind of Actlist plugin !");
            }
            return null;
        }
        return targetPath;
    }

    public static void delete(String pluginFileName) throws Exception {
        PluginManager.unload(pluginFileName);
        try {
            Files.delete(Paths.get(System.getProperty("user.dir"), "plugins", pluginFileName));
        }
        catch (Exception e) {
            List purgeTargetPlugins = (List)SharedMemory.getDataMap().get((Object)"KEY_PURGE_TARGET_PLUGINS");
            purgeTargetPlugins.add(pluginFileName);
            EventHandler.callEvent(PluginManager.class, (String)"EVENT_SAVE_PURGE_TARGET_PLUGINS");
        }
        try {
            Files.deleteIfExists(Paths.get(System.getProperty("user.dir"), "plugins", "config", pluginFileName.concat(".config")));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            List deactivatedPlugins = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
            deactivatedPlugins.remove(pluginFileName);
            EventHandler.callEvent(PluginManager.class, (String)"EVENT_SAVE_DEACTIVATED_PLUGINS");
        }
        catch (Exception deactivatedPlugins) {
            // empty catch block
        }
        try {
            List priorityOfPlugins = (List)SharedMemory.getDataMap().get((Object)"KEY_PRIORITY_OF_PLUGINS");
            priorityOfPlugins.remove(pluginFileName);
            EventHandler.callEvent(PluginManager.class, (String)"EVENT_SAVE_PRIORITY_OF_PLUGINS");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void load(String pluginFileName, boolean activated) throws Exception {
        PluginManager.load(pluginFileName, activated, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(String pluginFileName, boolean activated, Integer index) throws Exception {
        PluginClassLoader classLoader = new PluginClassLoader(new URL[]{Paths.get(System.getProperty("user.dir"), "plugins", pluginFileName).toUri().toURL()});
        Class<?> pluginClass = null;
        InputStream inputStream = null;
        try {
            URL manifestURL = classLoader.findResource("META-INF/MANIFEST.MF");
            inputStream = manifestURL.openStream();
            Manifest manifest = new Manifest(inputStream);
            String mainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS).trim();
            if (ObjectUtil.isNotEmpty((Object)mainClass)) {
                pluginClass = classLoader.loadClass(mainClass);
            }
        }
        catch (Error | Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pluginClass == null) {
                pluginClass = classLoader.loadClass("Plugin");
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (ActlistPlugin.class.isAssignableFrom(pluginClass)) {
            HashMap pluginMap = (HashMap)SharedMemory.getDataMap().get((Object)"KEY_PLUGIN_MAP");
            boolean shouldClearPromptLabel = pluginMap.size() == 0;
            pluginMap.put(pluginFileName, classLoader);
            FXMLLoader fxmlLoader = new FXMLLoader(PluginComponent.class.getResource(PluginComponent.class.getSimpleName().concat(".fxml")));
            Node component = (Node)fxmlLoader.load();
            PluginComponent pluginComponent = (PluginComponent)fxmlLoader.getController();
            pluginComponent.initialize(pluginFileName, pluginClass, activated);
            component.setUserData((Object)pluginComponent);
            VBox componentBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
            if (shouldClearPromptLabel) {
                componentBox.getChildren().clear();
            }
            if (index == null) {
                componentBox.getChildren().add((Object)component);
            } else {
                componentBox.getChildren().add(index.intValue(), (Object)component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unload(String pluginFileName) throws Exception {
        VBox componentBox;
        VBox vBox = componentBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
        synchronized (vBox) {
            int j = componentBox.getChildren().size();
            for (int i = 0; i < j; ++i) {
                PluginComponent pluginComponent = (PluginComponent)((Node)componentBox.getChildren().get(i)).getUserData();
                if (!pluginComponent.getPluginFileName().equals(pluginFileName)) continue;
                pluginComponent.clear();
                componentBox.getChildren().remove(i);
                HashMap pluginMap = (HashMap)SharedMemory.getDataMap().get((Object)"KEY_PLUGIN_MAP");
                ((URLClassLoader)pluginMap.get(pluginFileName)).close();
                pluginMap.remove(pluginFileName);
                break;
            }
            EventHandler.callEvent(PluginManager.class, (String)"EVENT_CREATE_PROMPT_COMPONENT");
        }
    }
}

