/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.console;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.shape.SVGPath;
import javafx.stage.Stage;
import org.silentsoft.actlist.util.ConfigUtil;
import org.silentsoft.io.event.EventHandler;
import org.silentsoft.io.event.EventListener;
import org.silentsoft.io.memory.SharedMemory;
import org.silentsoft.ui.model.Delta;
import org.silentsoft.ui.model.MaximizeProperty;
import org.silentsoft.ui.util.StageDragResizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console
implements EventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Console.class);
    @FXML
    private AnchorPane root;
    @FXML
    private BorderPane head;
    @FXML
    private AnchorPane body;
    @FXML
    private HBox leftBox;
    @FXML
    private Label leftMinimizeButton;
    @FXML
    private Label leftMaximizeButton;
    @FXML
    private Label leftCloseButton;
    @FXML
    private Label icon;
    @FXML
    private Label title;
    @FXML
    private HBox rightBox;
    @FXML
    private Label rightMinimizeButton;
    @FXML
    private Label rightMaximizeButton;
    @FXML
    private Label rightCloseButton;
    @FXML
    private TextArea console;
    static PrintStream consoleStream;
    static PrintStream advancedStream;
    private PrintStream printStream;
    private MaximizeProperty maximizeProperty;

    public void initialize(Stage stage) {
        EventHandler.addListener((EventListener)this);
        this.setContextMenu();
        consoleStream = new PrintStream(new ByteArrayOutputStream(){

            @Override
            public synchronized void write(byte[] b, int off, int len) {
                super.write(b, off, len);
                try {
                    String log = this.toString("UTF-8");
                    this.reset();
                    Platform.runLater(() -> {
                        Object appConsole = SharedMemory.getDataMap().get((Object)"KEY_CONSOLE_TEXT_AREA");
                        if (appConsole instanceof TextArea) {
                            ((TextArea)appConsole).appendText(log);
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, true);
        advancedStream = new PrintStream(new ByteArrayOutputStream(){

            @Override
            public synchronized void write(byte[] b, int off, int len) {
                super.write(b, off, len);
                try {
                    String log = this.toString("UTF-8");
                    this.reset();
                    Platform.runLater(() -> Console.this.console.appendText(log));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, true);
        this.printStream = new PrintStream(new ByteArrayOutputStream(){

            @Override
            public synchronized void write(byte[] b, int off, int len) {
                super.write(b, off, len);
                try {
                    String log = this.toString("UTF-8");
                    this.reset();
                    if (!log.trim().isEmpty()) {
                        if (log.equals(String.valueOf(SharedMemory.getDataMap().get((Object)"KEY_INFO_TEXT")))) {
                            consoleStream.println(log);
                            advancedStream.println(log);
                        } else {
                            LOGGER.info(log);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, true);
        this.maximizeProperty = new MaximizeProperty(stage);
        this.makeDraggable(stage, (Node)this.head);
        this.makeNormalizable(stage, (Node)this.head);
        this.makeMinimizable(stage, (Node)this.leftMinimizeButton);
        this.makeMaximizable(stage, (Node)this.leftMaximizeButton);
        this.makeClosable(stage, (Node)this.leftCloseButton);
        this.makeMinimizable(stage, (Node)this.rightMinimizeButton);
        this.makeMaximizable(stage, (Node)this.rightMaximizeButton);
        this.makeClosable(stage, (Node)this.rightCloseButton);
        this.applyTheme();
        this.makeResizable(stage, (Region)this.root);
    }

    public void notifyFocusState(boolean isFocused) {
        if (ConfigUtil.isMacTheme()) {
            if (isFocused) {
                this.leftCloseButton.setStyle("-fx-background-color: red; -fx-background-radius: 5em;");
                this.leftMinimizeButton.setStyle("-fx-background-color: orange; -fx-background-radius: 5em;");
                this.leftMaximizeButton.setStyle("-fx-background-color: #59bf53; -fx-background-radius: 5em;");
            } else {
                this.leftCloseButton.setStyle("-fx-background-color: #808080; -fx-background-radius: 5em;");
                this.leftMinimizeButton.setStyle("-fx-background-color: #808080; -fx-background-radius: 5em;");
                this.leftMaximizeButton.setStyle("-fx-background-color: #808080; -fx-background-radius: 5em;");
            }
        }
    }

    private void setContextMenu() {
        MenuItem clearMenuItem = new MenuItem("Clear");
        clearMenuItem.setOnAction(event -> this.clearConsoleLog());
        this.console.setContextMenu(new ContextMenu(new MenuItem[]{clearMenuItem}));
    }

    private void makeDraggable(Stage stage, Node byNode) {
        Delta dragDelta = new Delta();
        byNode.setOnMousePressed(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                dragDelta.setX(stage.getX() - mouseEvent.getScreenX());
                dragDelta.setY(stage.getY() - mouseEvent.getScreenY());
                byNode.setOpacity(0.8);
            }
        });
        byNode.setOnMouseDragged(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                if (this.maximizeProperty.isMaximized()) {
                    double x = mouseEvent.getScreenX() - stage.getX();
                    double y = mouseEvent.getScreenY() - stage.getY();
                    this.changeMaximizeProperty(stage);
                    dragDelta.setX(-1.0 * (stage.getWidth() / 2.0));
                    dragDelta.setY(-1.0 * mouseEvent.getSceneY());
                } else {
                    stage.setX(mouseEvent.getScreenX() + dragDelta.getX());
                    stage.setY(mouseEvent.getScreenY() + dragDelta.getY());
                }
            }
        });
        byNode.setOnMouseReleased(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                byNode.setOpacity(1.0);
            }
        });
    }

    private void makeNormalizable(Stage stage, Node byNode) {
        byNode.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getClickCount() >= 2) {
                this.changeMaximizeProperty(stage);
            }
        });
    }

    private void makeMinimizable(Stage stage, Node byNode) {
        byNode.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                stage.setIconified(true);
            }
        });
    }

    private void makeMaximizable(Stage stage, Node byNode) {
        byNode.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                this.changeMaximizeProperty(stage);
            }
        });
    }

    private void makeClosable(Stage stage, Node byNode) {
        byNode.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                stage.close();
            }
        });
    }

    private void makeResizable(Stage stage, Region region) {
        StageDragResizer.makeResizable((Stage)stage, (Region)region, (int)7, (int)10);
    }

    private void changeMaximizeProperty(Stage stage) {
        this.maximizeProperty.setMaximized(stage, !this.maximizeProperty.isMaximized());
        if (this.maximizeProperty.isMaximized()) {
            AnchorPane.setLeftAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setTopAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)this.head, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.head, (Double)0.0);
            AnchorPane.setTopAnchor((Node)this.head, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)this.body, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.body, (Double)0.0);
            AnchorPane.setTopAnchor((Node)this.body, (Double)25.0);
            AnchorPane.setBottomAnchor((Node)this.body, (Double)0.0);
        } else {
            AnchorPane.setLeftAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setRightAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setTopAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setBottomAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setLeftAnchor((Node)this.head, (Double)2.0);
            AnchorPane.setRightAnchor((Node)this.head, (Double)2.0);
            AnchorPane.setTopAnchor((Node)this.head, (Double)2.0);
            AnchorPane.setLeftAnchor((Node)this.body, (Double)2.0);
            AnchorPane.setRightAnchor((Node)this.body, (Double)2.0);
            AnchorPane.setTopAnchor((Node)this.body, (Double)27.0);
            AnchorPane.setBottomAnchor((Node)this.body, (Double)2.0);
        }
        stage.getScene().getRoot().requestLayout();
    }

    private void applyTheme() {
        String theme;
        switch (theme = ConfigUtil.getTheme()) {
            case "WIN": {
                this.head.setLeft(null);
                this.icon.setVisible(true);
                this.title.setVisible(true);
                this.head.setRight((Node)this.rightBox);
                break;
            }
            case "MAC": {
                this.head.setRight(null);
                this.icon.setVisible(false);
                this.title.setVisible(false);
                this.head.setLeft((Node)this.leftBox);
            }
        }
    }

    private void clearConsoleLog() {
        this.console.clear();
        Object appConsole = SharedMemory.getDataMap().get((Object)"KEY_CONSOLE_TEXT_AREA");
        if (appConsole instanceof TextArea) {
            ((TextArea)appConsole).clear();
        }
        System.out.println(String.valueOf(SharedMemory.getDataMap().get((Object)"KEY_INFO_TEXT")));
    }

    @FXML
    private void showControls() {
        ((SVGPath)this.leftCloseButton.getGraphic()).setFill(Paint.valueOf((String)"rgb(30, 30, 30)"));
        ((SVGPath)this.leftMinimizeButton.getGraphic()).setFill(Paint.valueOf((String)"rgb(30, 30, 30)"));
        ((SVGPath)this.leftMaximizeButton.getGraphic()).setFill(Paint.valueOf((String)"rgb(30, 30, 30)"));
    }

    @FXML
    private void hideControls() {
        ((SVGPath)this.leftCloseButton.getGraphic()).setFill(Paint.valueOf((String)"transparent"));
        ((SVGPath)this.leftMinimizeButton.getGraphic()).setFill(Paint.valueOf((String)"transparent"));
        ((SVGPath)this.leftMaximizeButton.getGraphic()).setFill(Paint.valueOf((String)"transparent"));
    }

    static PrintStream getConsoleStream() {
        return consoleStream;
    }

    static PrintStream getAdvancedStream() {
        return advancedStream;
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public void onEvent(String event) {
        switch (event) {
            case "EVENT_APPLY_THEME": {
                this.applyTheme();
                break;
            }
            case "EVENT_CLEAR_CONSOLE_LOG": {
                this.clearConsoleLog();
            }
        }
    }
}

