/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.core.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.silentsoft.io.data.DataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVUtil.class);
    private String path;
    private DataSet dataSet;

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public boolean load(String path) {
        this.path = path;
        if (this.isLoadable()) {
            this.dataSet = new DataSet(this.getHeaders());
            try {
                BufferedReader br = new BufferedReader(new FileReader(this.path));
                int nRowCount = 0;
                int contentsCount = 0;
                boolean isHeadLine = true;
                String[] contents = null;
                String str = "";
                while ((str = br.readLine()) != null) {
                    if (isHeadLine) {
                        isHeadLine = false;
                        continue;
                    }
                    this.dataSet.insertRow(nRowCount);
                    contents = str.split(",");
                    contentsCount = contents.length;
                    for (int i = 0; i < contentsCount; ++i) {
                        this.dataSet.setData(nRowCount, i, (Object)contents[i]);
                    }
                    ++nRowCount;
                }
                br.close();
            }
            catch (IOException e) {
                LOGGER.error("I got catch IOException <{}>", (Throwable)e);
            }
        } else {
            LOGGER.error("could not load the csv file <{}>", new Object[]{path});
            return false;
        }
        return true;
    }

    public void save() {
        File file = new File(this.path);
        try {
            int i;
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.path));
            StringBuffer sb = new StringBuffer();
            int nRowCnt = this.dataSet.getRowCount();
            int nColCnt = this.dataSet.getColumnCount();
            for (i = 0; i < nColCnt; ++i) {
                String endOfComma = i >= nColCnt - 1 ? "" : ",";
                String endOfEnter = i >= nColCnt - 1 ? "\r\n" : "";
                sb.append(this.dataSet.getColumnName(i) + endOfComma + endOfEnter);
            }
            for (i = 0; i < nRowCnt; ++i) {
                for (int j = 0; j < nColCnt; ++j) {
                    String endOfComma = j >= nColCnt - 1 ? "" : ",";
                    String endOfEnter = j >= nColCnt - 1 ? "\r\n" : "";
                    sb.append(this.dataSet.getData(i, j) + endOfComma + endOfEnter);
                }
            }
            bw.write(sb.toString());
            bw.close();
        }
        catch (IOException e) {
            LOGGER.error("I got catch IOException <{}>", (Throwable)e);
        }
    }

    public void make(String path, String[] header) {
        this.path = path;
        this.dataSet = new DataSet(header);
        this.save();
    }

    private boolean isLoadable() {
        File file = new File(this.path);
        if (!file.exists()) {
            return false;
        }
        return file.length() > 0L;
    }

    private String[] getHeaders() {
        String[] headers = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.path));
            String str = "";
            str = br.readLine();
            if (str != null) {
                headers = str.split(",");
            }
            br.close();
        }
        catch (IOException e) {
            LOGGER.error("I got catch IOException <{}>", (Throwable)e);
        }
        return headers;
    }
}

