/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.core.otp;

import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class OTP {
    private static final String ALGORITHM = "HmacSHA1";

    public static String create(byte[] secretKey, long distance) throws Exception {
        byte[] data = new byte[8];
        long value = new Date().getTime() / distance;
        int i = 8;
        while (i-- > 0) {
            data[i] = (byte)value;
            value >>>= 8;
        }
        Mac mac = Mac.getInstance(ALGORITHM);
        mac.init(new SecretKeySpec(secretKey, ALGORITHM));
        byte[] hash = mac.doFinal(data);
        int offset = hash[19] & 0xF;
        long truncatedHash = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            truncatedHash <<= 8;
            truncatedHash |= (long)(hash[offset + i2] & 0xFF);
        }
        truncatedHash &= Integer.MAX_VALUE;
        return String.format("%06d", truncatedHash %= 1000000L);
    }

    public static boolean vertify(byte[] secretKey, long distance, String code) throws Exception {
        return OTP.create(secretKey, distance).equals(code);
    }
}

