/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.view.explore;

import java.awt.Desktop;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.silentsoft.actlist.application.App;
import org.silentsoft.actlist.comparator.VersionComparator;
import org.silentsoft.actlist.plugin.PluginManager;
import org.silentsoft.actlist.plugin.messagebox.MessageBox;
import org.silentsoft.actlist.rest.RESTfulAPI;
import org.silentsoft.core.util.ObjectUtil;
import org.silentsoft.io.event.EventHandler;
import org.silentsoft.io.memory.SharedMemory;
import org.silentsoft.ui.viewer.AbstractViewerController;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLElement;

public class ExploreController
extends AbstractViewerController {
    @FXML
    private WebView webView;
    @FXML
    private VBox loadingBox;

    public void initialize(Parent viewer, Object ... parameters) {
        new Thread(() -> Platform.runLater(() -> {
            this.webView.getEngine().setUserAgent(String.valueOf(SharedMemory.getDataMap().get((Object)"KEY_USER_AGENT")));
            this.webView.getEngine().setCreatePopupHandler(popupFeatures -> {
                WebEngine webEngine = new WebEngine();
                webEngine.locationProperty().addListener((observable, oldValue, newValue) -> {
                    if (newValue != null) {
                        if (Desktop.isDesktopSupported()) {
                            try {
                                Desktop.getDesktop().browse(URI.create(newValue));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            this.webView.getEngine().load(newValue);
                        }
                    }
                });
                return webEngine;
            });
            ChangeListener<Worker.State> stateChangeListener = new ChangeListener<Worker.State>(){

                public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                    if (Worker.State.SUCCEEDED.equals((Object)newValue)) {
                        ExploreController.this.loadingBox.setVisible(false);
                        Document document = ExploreController.this.webView.getEngine().getDocument();
                        NodeList anchors = document.getElementsByTagName("a");
                        int j = anchors.getLength();
                        for (int i = 0; i < j; ++i) {
                            Node anchor = anchors.item(i);
                            if (!(anchor instanceof EventTarget)) continue;
                            ((EventTarget)((Object)anchor)).addEventListener("click", new EventListener(){

                                @Override
                                public void handleEvent(Event event) {
                                    HTMLAnchorElement anchorElement = (HTMLAnchorElement)((Object)event.getCurrentTarget());
                                    String className = anchorElement.getClassName();
                                    if (className != null) {
                                        if (className.contains("actlist-plugin-download")) {
                                            if (ObjectUtil.isNotEmpty((Object)anchorElement.getHref())) {
                                                boolean shouldDownload = true;
                                                try {
                                                    String requiredActlist;
                                                    if (anchorElement.hasAttribute("data-required-actlist") && (requiredActlist = anchorElement.getAttribute("data-required-actlist").trim()).matches("\\d+.\\d+.\\d+") && VersionComparator.getInstance().compare("2.1.0", requiredActlist) < 0) {
                                                        ButtonType cancelButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
                                                        ButtonType downloadAnywayButton = new ButtonType("Download anyway", ButtonBar.ButtonData.OK_DONE);
                                                        Alert alert = new Alert(Alert.AlertType.NONE);
                                                        alert.setTitle("Warning");
                                                        alert.getDialogPane().getStyleClass().add((Object)"warning");
                                                        alert.setHeaderText(String.join((CharSequence)"", "This plugin requires at least Actlist ", requiredActlist));
                                                        alert.setContentText("If you don't use the required version of Actlist, the plugin may not work properly. Do you want to download anyway ?");
                                                        alert.getButtonTypes().addAll((Object[])new ButtonType[]{cancelButton, downloadAnywayButton});
                                                        Optional alertResponse = alert.showAndWait();
                                                        shouldDownload = alertResponse.isPresent() && alertResponse.get() == downloadAnywayButton;
                                                    }
                                                }
                                                catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                                if (shouldDownload) {
                                                    Consumer<String> changeChildNodeClassName = value -> {
                                                        Node node;
                                                        if (anchorElement.getChildNodes().getLength() > 0 && (node = anchorElement.getChildNodes().item(0)) instanceof HTMLElement) {
                                                            HTMLElement iElement = (HTMLElement)node;
                                                            iElement.setClassName((String)value);
                                                        }
                                                    };
                                                    changeChildNodeClassName.accept("fa fa-spinner fa-pulse");
                                                    anchorElement.setClassName(className.replace("actlist-plugin-download", "actlist-plugin-installing"));
                                                    new Thread(() -> {
                                                        String href = ExploreController.this.fetch(anchorElement.getHref());
                                                        if (href.toLowerCase().endsWith(".jar")) {
                                                            AtomicBoolean succeedToAutoInstall = new AtomicBoolean(false);
                                                            AtomicBoolean networkUnavailable = new AtomicBoolean(false);
                                                            AtomicInteger responseStatusCode = new AtomicInteger();
                                                            AtomicReference responseReasonPhrase = new AtomicReference();
                                                            AtomicReference exception = new AtomicReference();
                                                            try {
                                                                RESTfulAPI.doGet(href, beforeRequest -> {}, afterResponse -> {
                                                                    block14: {
                                                                        try {
                                                                            Path newPluginFilePath;
                                                                            HttpEntity entity;
                                                                            StatusLine statusLine = afterResponse.getStatusLine();
                                                                            if (statusLine != null) {
                                                                                responseStatusCode.set(statusLine.getStatusCode());
                                                                                responseReasonPhrase.set(statusLine.getReasonPhrase());
                                                                            }
                                                                            if ((entity = afterResponse.getEntity()) == null) break block14;
                                                                            InputStream content = entity.getContent();
                                                                            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
                                                                            Path partialFilePath = Paths.get(System.getProperty("java.io.tmpdir"), uuid.concat(".partial"));
                                                                            if (Files.notExists(partialFilePath.getParent(), new LinkOption[0])) {
                                                                                Files.createDirectories(partialFilePath.getParent(), new FileAttribute[0]);
                                                                            }
                                                                            Files.createFile(partialFilePath, new FileAttribute[0]);
                                                                            FileOutputStream fileStream = new FileOutputStream(partialFilePath.toString());
                                                                            IOUtils.copy((InputStream)content, (OutputStream)fileStream);
                                                                            ((OutputStream)fileStream).close();
                                                                            new JarFile(partialFilePath.toString()).close();
                                                                            String _newPluginFileName = "";
                                                                            try {
                                                                                Header contentDispositionHeader = afterResponse.getFirstHeader("Content-Disposition");
                                                                                if (contentDispositionHeader != null && contentDispositionHeader.getValue() != null) {
                                                                                    _newPluginFileName = URLDecoder.decode(StringUtils.substringAfterLast((String)contentDispositionHeader.getValue().toLowerCase().replaceAll("\"", ""), (String)"filename="), "UTF-8").trim();
                                                                                }
                                                                            }
                                                                            catch (Exception contentDispositionHeader) {
                                                                            }
                                                                            finally {
                                                                                if (ObjectUtil.isEmpty((Object)_newPluginFileName)) {
                                                                                    _newPluginFileName = String.valueOf(Paths.get(URI.create(href).getPath(), new String[0]).getFileName());
                                                                                }
                                                                                if (ObjectUtil.isEmpty((Object)_newPluginFileName)) {
                                                                                    _newPluginFileName = UUID.randomUUID().toString().replaceAll("-", "");
                                                                                }
                                                                            }
                                                                            if (!_newPluginFileName.toLowerCase().endsWith(".jar")) {
                                                                                _newPluginFileName = _newPluginFileName.concat(".jar");
                                                                            }
                                                                            if (Files.exists(newPluginFilePath = Paths.get(System.getProperty("user.dir"), "plugins", _newPluginFileName), new LinkOption[0])) {
                                                                                newPluginFilePath = Paths.get(System.getProperty("user.dir"), "plugins", uuid.concat(".jar"));
                                                                            }
                                                                            String newPluginFileName = String.valueOf(newPluginFilePath.getFileName());
                                                                            Files.move(partialFilePath, newPluginFilePath, new CopyOption[0]);
                                                                            CountDownLatch latch = new CountDownLatch(1);
                                                                            Platform.runLater(() -> {
                                                                                try {
                                                                                    PluginManager.load(newPluginFileName, true);
                                                                                    EventHandler.callEvent(this.getClass(), (String)"EVENT_SAVE_PRIORITY_OF_PLUGINS");
                                                                                }
                                                                                catch (Error | Exception e) {
                                                                                    e.printStackTrace();
                                                                                }
                                                                                finally {
                                                                                    latch.countDown();
                                                                                }
                                                                            });
                                                                            latch.await();
                                                                            succeedToAutoInstall.set(true);
                                                                        }
                                                                        catch (Exception e) {
                                                                            System.out.println(String.format("Failed to install (%s -> status : %d - %s)", href, responseStatusCode.get(), responseReasonPhrase.get()));
                                                                            e.printStackTrace();
                                                                            exception.set(e);
                                                                        }
                                                                    }
                                                                });
                                                            }
                                                            catch (Exception e) {
                                                                e.printStackTrace();
                                                                networkUnavailable.set(true);
                                                            }
                                                            if (succeedToAutoInstall.get()) {
                                                                EventHandler.callEvent(this.getClass(), (String)"EVENT_PLAY_NEW_PLUGINS_ALARM");
                                                                Platform.runLater(() -> {
                                                                    Optional result = MessageBox.showConfirm((Object)App.getStage(), (String)"Succeed to install", (String)"Do you want to check it out the new plugin ?");
                                                                    if (result.isPresent() && result.get() == ButtonType.OK) {
                                                                        EventHandler.callEvent(this.getClass(), (String)"EVENT_SHOW_PLUGINS_VIEW", (boolean)false);
                                                                    }
                                                                });
                                                            } else if (networkUnavailable.get()) {
                                                                if (Desktop.isDesktopSupported()) {
                                                                    try {
                                                                        Desktop.getDesktop().browse(URI.create(href));
                                                                    }
                                                                    catch (Exception e) {
                                                                        e.printStackTrace();
                                                                    }
                                                                }
                                                            } else {
                                                                MessageBox.showException((Object)App.getStage(), (String)String.format("Failed to install (%d)", responseStatusCode.get()), (String)((String)responseReasonPhrase.get()), (Throwable)((Throwable)exception.get()));
                                                            }
                                                        } else if (Desktop.isDesktopSupported()) {
                                                            try {
                                                                Desktop.getDesktop().browse(URI.create(href));
                                                            }
                                                            catch (Exception e) {
                                                                e.printStackTrace();
                                                            }
                                                        }
                                                        Platform.runLater(() -> {
                                                            changeChildNodeClassName.accept("fa fa-download");
                                                            anchorElement.setClassName(className.replace("actlist-plugin-installing", "actlist-plugin-download"));
                                                        });
                                                    }).start();
                                                }
                                            }
                                            event.preventDefault();
                                        } else if (className.contains("actlist-plugin-installing")) {
                                            event.preventDefault();
                                        }
                                    }
                                }
                            }, false);
                        }
                    } else if (Worker.State.FAILED.equals((Object)newValue)) {
                        ExploreController.this.webView.getEngine().getLoadWorker().stateProperty().removeListener((ChangeListener)this);
                        ExploreController.this.showFailureContent();
                    }
                }
            };
            this.webView.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)stateChangeListener);
            this.webView.getEngine().load("http://actlist.silentsoft.org/explore/");
        })).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String fetch(String href) {
        String url = href;
        if (ObjectUtil.isNotEmpty((Object)url)) {
            HttpURLConnection connection;
            block5: {
                connection = null;
                try {
                    String location;
                    connection = (HttpURLConnection)URI.create(href).toURL().openConnection();
                    connection.setInstanceFollowRedirects(false);
                    connection.connect();
                    int responseCode = connection.getResponseCode();
                    if (responseCode != 301 && responseCode != 302 || !ObjectUtil.isNotEmpty((Object)(location = connection.getHeaderField("Location")))) break block5;
                    url = this.fetch(location);
                }
                catch (Exception exception) {
                    IOUtils.close(connection);
                    catch (Throwable throwable) {
                        IOUtils.close(connection);
                        throw throwable;
                    }
                }
            }
            IOUtils.close((URLConnection)connection);
        }
        return url;
    }

    private void showFailureContent() {
        StringBuffer html = new StringBuffer();
        html.append("<html>");
        html.append("    <head>");
        html.append("        <style>");
        html.append("            .container {");
        html.append("                display: table;");
        html.append("                width: 100%;");
        html.append("                height: 100%;");
        html.append("            ");
        html.append("            }");
        html.append("            .content {");
        html.append("                display: table-cell;");
        html.append("                vertical-align: middle;");
        html.append("                text-align: center;");
        html.append("            ");
        html.append("            }");
        html.append("            span {");
        html.append("                font-family: Verdana;");
        html.append("            ");
        html.append("            }");
        html.append("        </style>");
        html.append("    </head>");
        html.append("    <body>");
        html.append("        <div class='container'>");
        html.append("            <div class='content'>");
        html.append("                <div>");
        html.append("                    <svg width='24' height='24'><path d='M12 2.02c-5.51 0-9.98 4.47-9.98 9.98s4.47 9.98 9.98 9.98 9.98-4.47 9.98-9.98S17.51 2.02 12 2.02zM11.48 20v-6.26H8L13 4v6.26h3.35L11.48 20z'/></svg>");
        html.append("                </div>");
        html.append("                <div>");
        html.append("                    <span>Network unavailable.</span>");
        html.append("                </div>");
        html.append("            </div>");
        html.append("        </div>");
        html.append("    </body>");
        html.append("</html>");
        this.webView.getEngine().loadContent(html.toString());
    }
}

