/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.application;

import ch.qos.logback.classic.Level;
import com.tulskiy.keymaster.common.HotKey;
import com.tulskiy.keymaster.common.HotKeyListener;
import com.tulskiy.keymaster.common.Provider;
import de.codecentric.centerdevice.MenuToolkit;
import de.codecentric.centerdevice.glass.AdapterContext;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.application.Preloader;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.http.HttpHost;
import org.silentsoft.actlist.ActlistConfig;
import org.silentsoft.actlist.application.AppController;
import org.silentsoft.actlist.console.Console;
import org.silentsoft.actlist.rest.RESTfulAPI;
import org.silentsoft.actlist.util.ConfigUtil;
import org.silentsoft.core.util.FileUtil;
import org.silentsoft.core.util.JSONUtil;
import org.silentsoft.core.util.SystemUtil;
import org.silentsoft.io.event.EventListener;
import org.silentsoft.io.memory.SharedMemory;
import org.silentsoft.ui.hotkey.HotkeyHandler;
import org.silentsoft.ui.tray.TrayIconHandler;
import org.silentsoft.ui.util.StageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App
extends Application
implements EventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(App.class);
    private static Stage stage;
    private static Parent app;
    private AppController appController;
    private static Provider provider;
    private Stage consoleStage;
    private CountDownLatch pluginCountDownLatch;

    public static void main(String[] args) throws Exception {
        App.loadConfiguration();
        App.launch((String[])args);
    }

    public static Stage getStage() {
        Stage currentStage = StageUtil.getCurrentStage();
        if (currentStage == null) {
            return stage;
        }
        return currentStage;
    }

    static Parent getParent() {
        return app;
    }

    public static List<javafx.scene.image.Image> getIcons() {
        return new Function<int[], List<javafx.scene.image.Image>>(){

            @Override
            public List<javafx.scene.image.Image> apply(int[] values) {
                ArrayList<javafx.scene.image.Image> images = new ArrayList<javafx.scene.image.Image>();
                for (int size : values) {
                    images.add(new javafx.scene.image.Image(String.join((CharSequence)"", "/images/icon/actlist_", String.valueOf(size), ".png")));
                }
                return images;
            }
        }.apply(new int[]{24, 32, 48, 64, 128, 256});
    }

    public static Provider getProvider() {
        if (provider == null) {
            provider = Provider.getCurrentProvider((boolean)false);
        }
        return provider;
    }

    private static void loadConfiguration() throws Exception {
        ActlistConfig actlistConfig = null;
        File configFile = Paths.get(System.getProperty("user.dir"), "actlist.jar.config").toFile();
        if (configFile.exists()) {
            String configContent = FileUtil.readFile((File)configFile);
            actlistConfig = (ActlistConfig)JSONUtil.JSONToObject((String)configContent, ActlistConfig.class);
        } else {
            actlistConfig = new ActlistConfig();
            actlistConfig.put("rootWidth", 506.0);
            actlistConfig.put("rootHeight", 443.0);
            actlistConfig.put("stageWidth", 516.0);
            actlistConfig.put("stageHeight", 453.0);
            actlistConfig.put("stageOpacity", 1.0);
            actlistConfig.put("loggingLevel", "Info");
            actlistConfig.put("showHideActlistHotKeyModifier", 640);
            actlistConfig.put("showHideActlistHotKeyCode", 65);
            actlistConfig.put("alwaysOnTop", false);
            actlistConfig.put("darkMode", false);
            actlistConfig.put("proxyMode", "AUTOMATIC");
            actlistConfig.put("proxyHost", "");
        }
        SharedMemory.getDataMap().put((Object)"KEY_ACTLIST_CONFIG", (Object)actlistConfig);
        App.updateLoggingLevel();
    }

    private static void updateLoggingLevel() {
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT")).setLevel(Level.toLevel((String)ConfigUtil.getLoggingLevel()));
    }

    public void start(Stage stage) throws Exception {
        App.stage = stage;
        new Thread(() -> {
            try {
                this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.2));
                this.heavyLifting();
                this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.3));
                this.initializeWithoutFxThread();
                this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.4));
                Platform.runLater(() -> {
                    try {
                        this.initializeWithFxThread();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    private void heavyLifting() {
        this.generateUserAgentAndInfoText();
        this.updateProxyHost();
    }

    private void generateUserAgentAndInfoText() {
        String osArchitecture = SystemUtil.getOSArchitecture();
        String platformArchitecture = SystemUtil.getPlatformArchitecture();
        StringBuffer userAgent = new StringBuffer();
        userAgent.append("Actlist-");
        userAgent.append("2.1.0");
        if (SystemUtil.isWindows()) {
            userAgent.append(" windows-");
        } else if (SystemUtil.isMac()) {
            userAgent.append(" macosx-");
        } else if (SystemUtil.isLinux()) {
            userAgent.append(" linux-");
        } else {
            userAgent.append(" unknown-");
        }
        userAgent.append(osArchitecture);
        userAgent.append(" platform-");
        userAgent.append(platformArchitecture);
        SharedMemory.getDataMap().put((Object)"KEY_USER_AGENT", (Object)userAgent.toString());
        StringBuffer infoText = new StringBuffer();
        infoText.append(String.format("Actlist %s (%s %s, platform %s)", "2.1.0", SystemUtil.getOSName(), osArchitecture, platformArchitecture));
        infoText.append("\r\n");
        infoText.append(String.format("%s, %s", System.getProperty("java.vm.name"), System.getProperty("java.runtime.version")));
        SharedMemory.getDataMap().put((Object)"KEY_INFO_TEXT", (Object)infoText.toString());
        this.welcome();
    }

    private void welcome() {
        String text = String.valueOf(SharedMemory.getDataMap().get((Object)"KEY_INFO_TEXT"));
        for (String message : text.split("\r\n")) {
            LOGGER.info(message);
        }
    }

    private void updateProxyHost() {
        String proxyHost = "";
        String proxyPort = "";
        HttpHost proxy = RESTfulAPI.getProxyHost();
        if (proxy != null) {
            proxyHost = proxy.getHostName();
            proxyPort = String.valueOf(proxy.getPort());
        }
        System.setProperty("http.proxyHost", proxyHost);
        System.setProperty("http.proxyPort", proxyPort);
        System.setProperty("https.proxyHost", proxyHost);
        System.setProperty("https.proxyPort", proxyPort);
    }

    private void initializeWithoutFxThread() throws Exception {
        Platform.setImplicitExit((boolean)false);
        StageUtil.registerStage((Stage)stage);
        org.silentsoft.io.event.EventHandler.addListener((EventListener)this);
        this.displayStageIcon();
        this.registerTrayIcon();
        this.registerHotkey();
    }

    private void initializeWithFxThread() throws Exception {
        this.initConsole();
        this.registerMenu();
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName().concat(".fxml")));
        app = (Parent)fxmlLoader.load();
        this.appController = (AppController)fxmlLoader.getController();
        this.appController.initialize();
        stage.setTitle("Actlist");
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.setScene(this.createScene());
        stage.setWidth(ConfigUtil.getStageWidth());
        stage.setHeight(ConfigUtil.getStageHeight());
        stage.setOpacity(ConfigUtil.getStageOpacity());
        stage.setAlwaysOnTop(ConfigUtil.isAlwaysOnTop());
        stage.focusedProperty().addListener((observable, oldValue, newValue) -> this.appController.notifyFocusState((boolean)newValue));
    }

    private Scene createScene() {
        Scene scene = null;
        if (SystemUtil.isMac()) {
            BorderPane root = new BorderPane();
            root.setStyle("-fx-background-color: transparent;");
            root.setTop((Node)this.createMenuBar());
            root.setCenter((Node)app);
            scene = new Scene((Parent)root, (Paint)Color.TRANSPARENT);
        }
        return scene == null ? new Scene(app, (Paint)Color.TRANSPARENT) : scene;
    }

    private MenuBar createMenuBar() {
        return null;
    }

    private void initConsole() throws Exception {
        if (this.consoleStage == null) {
            this.consoleStage = new Stage();
            this.consoleStage.setTitle("Console");
            this.consoleStage.initOwner((Window)App.getStage());
            this.consoleStage.initStyle(StageStyle.TRANSPARENT);
            FXMLLoader fxmlLoader = new FXMLLoader(Console.class.getResource(Console.class.getSimpleName().concat(".fxml")));
            Parent app = (Parent)fxmlLoader.load();
            Console console = (Console)fxmlLoader.getController();
            console.initialize(this.consoleStage);
            this.consoleStage.focusedProperty().addListener((observable, oldValue, newValue) -> console.notifyFocusState((boolean)newValue));
            System.setOut(console.getPrintStream());
            System.setErr(console.getPrintStream());
            System.out.println(String.valueOf(SharedMemory.getDataMap().get((Object)"KEY_INFO_TEXT")));
            BorderPane root = new BorderPane();
            root.setStyle("-fx-background-color: transparent;");
            root.setTop((Node)this.createMenuBar());
            root.setCenter((Node)app);
            this.consoleStage.setScene(new Scene((Parent)root, (Paint)Color.TRANSPARENT));
            this.consoleStage.setWidth(400.0);
            this.consoleStage.setHeight(500.0);
            this.consoleStage.getIcons().addAll(App.getIcons());
        }
    }

    private void displayStageIcon() {
        stage.getIcons().addAll(App.getIcons());
    }

    private void registerTrayIcon() {
        if (SystemUtil.isMac()) {
            TrayIconHandler.registerTrayIcon((Image)new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/icon/actlist_64.png")).getImage(), (String)"Actlist", actionEvent -> this.showOrHide());
        } else {
            TrayIconHandler.registerTrayIcon((Image)new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/icon/actlist_16.png")).getImage(), (String)"Actlist", actionEvent -> this.showOrHide());
        }
        TrayIconHandler.addItem((String)String.join((CharSequence)"", "Show/Hide ", "(", ConfigUtil.getShowHideActlistHotKeyText().replaceAll(" ", ""), ")"), actionEvent -> this.showOrHide());
        TrayIconHandler.addItem((String)"Console", actionEvent -> this.showConsole());
        TrayIconHandler.addItem((String)"Configuration", actionEvent -> this.showConfiguration());
        TrayIconHandler.addSeparator();
        TrayIconHandler.addItem((String)"Explore Other Plugins", actionEvent -> this.showExplore());
        TrayIconHandler.addSeparator();
        TrayIconHandler.addItem((String)"Open Plugins Directory", actionEvent -> {
            try {
                File pluginsDirectory = Paths.get(System.getProperty("user.dir"), "plugins").toFile();
                if (!pluginsDirectory.exists()) {
                    pluginsDirectory.mkdirs();
                }
                Desktop.getDesktop().open(pluginsDirectory);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        TrayIconHandler.addSeparator();
        TrayIconHandler.addItem((String)"Browse Homepage", actionEvent -> {
            try {
                Desktop.getDesktop().browse(new URI("http://actlist.silentsoft.org"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        TrayIconHandler.addItem((String)"Feedback", actionEvent -> {
            try {
                Desktop.getDesktop().browse(new URI("https://github.com/silentsoft/actlist/issues"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        TrayIconHandler.addItem((String)"About", actionEvent -> this.showAbout());
        TrayIconHandler.addSeparator();
        TrayIconHandler.addItem((String)"Exit", actionEvent -> this.exit());
    }

    private void registerHotkey() throws Exception {
        App.getProvider().register(KeyStroke.getKeyStroke(ConfigUtil.getShowHideActlistHotKeyCode(), ConfigUtil.getShowHideActlistHotKeyModifier()), new HotKeyListener(){

            public void onHotKey(HotKey arg0) {
                App.this.showOrHide();
            }
        });
        HotkeyHandler.getInstance().registerHotkey(KeyCode.ESCAPE, false, false, false, () -> this.showOrHide());
        stage.addEventHandler(KeyEvent.KEY_RELEASED, (EventHandler)HotkeyHandler.getInstance());
    }

    private void registerMenu() {
        if (SystemUtil.isMac()) {
            String appName = "Actlist";
            MenuToolkit menuToolkit = MenuToolkit.toolkit();
            MenuItem aboutMenuItem = new MenuItem("About " + appName);
            aboutMenuItem.setOnAction(actionEvent -> this.showAbout());
            MenuItem preferencesMenuItem = new MenuItem("Preferences");
            preferencesMenuItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.COMMA, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}));
            preferencesMenuItem.setOnAction(actionEvent -> this.showConfiguration());
            Menu appMenu = new Menu(appName, null, new MenuItem[]{aboutMenuItem, new SeparatorMenuItem(), preferencesMenuItem, new SeparatorMenuItem(), menuToolkit.createHideMenuItem(appName), menuToolkit.createHideOthersMenuItem(), menuToolkit.createUnhideAllMenuItem(), new SeparatorMenuItem(), menuToolkit.createQuitMenuItem(appName)});
            menuToolkit.setApplicationMenu(appMenu);
            Menu fileMenu = new Menu("File");
            fileMenu.getItems().addAll((Object[])new MenuItem[]{menuToolkit.createCloseWindowMenuItem()});
            Menu editMenu = new Menu("Edit");
            Menu viewMenu = new Menu("View");
            Menu windowMenu = new Menu("Window", null, new MenuItem[]{menuToolkit.createMinimizeMenuItem(), menuToolkit.createZoomMenuItem(), menuToolkit.createCycleWindowsItem(), new SeparatorMenuItem(), menuToolkit.createBringAllToFrontItem()});
            menuToolkit.autoAddWindowMenuItems(windowMenu);
            Menu helpMenu = new Menu("Help");
            menuToolkit.setGlobalMenuBar(new MenuBar(new Menu[]{appMenu, fileMenu, editMenu, viewMenu, windowMenu, helpMenu}));
        }
    }

    private void showOrHide() {
        if (stage.isIconified()) {
            Platform.runLater(() -> stage.setIconified(false));
        } else if (stage.isShowing()) {
            if (stage.isFocused()) {
                if (SystemUtil.isMac()) {
                    AdapterContext.getContext().getApplicationAdapter().hide();
                } else {
                    Platform.runLater(() -> stage.hide());
                }
            } else if (SystemUtil.isMac()) {
                Platform.runLater(() -> {
                    stage.toFront();
                    Point previousMouseLocation = MouseInfo.getPointerInfo().getLocation();
                    new Thread(() -> Platform.runLater(() -> {
                        try {
                            Robot robot = new Robot();
                            robot.mouseMove((int)stage.getX() + 10, (int)stage.getY() + 10);
                            robot.mousePress(1024);
                            robot.mouseRelease(1024);
                            robot.mouseMove(previousMouseLocation.x, previousMouseLocation.y);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    })).start();
                });
            } else {
                Platform.runLater(() -> stage.requestFocus());
            }
        } else if (SystemUtil.isMac()) {
            AdapterContext.getContext().getApplicationAdapter().unhideAllApplications();
        } else {
            Platform.runLater(() -> stage.show());
        }
    }

    private void bringToFront() {
        if (App.isHidden()) {
            this.showOrHide();
        }
    }

    public static boolean isShown() {
        return !App.isHidden();
    }

    public static boolean isHidden() {
        return stage.isIconified() || !stage.isShowing() || stage.isShowing() && !stage.isFocused();
    }

    private void showExplore() {
        Platform.runLater(() -> {
            this.bringToFront();
            org.silentsoft.io.event.EventHandler.callEvent(((Object)((Object)this)).getClass(), (String)"EVENT_SHOW_EXPLORE_VIEW", (boolean)false);
        });
    }

    private void showAbout() {
        Platform.runLater(() -> {
            this.bringToFront();
            org.silentsoft.io.event.EventHandler.callEvent(((Object)((Object)this)).getClass(), (String)"EVENT_SHOW_ABOUT_VIEW", (boolean)false);
        });
    }

    private void showConsole() {
        Platform.runLater(() -> this.consoleStage.show());
    }

    private void showConfiguration() {
        Platform.runLater(() -> {
            this.bringToFront();
            org.silentsoft.io.event.EventHandler.callEvent(((Object)((Object)this)).getClass(), (String)"EVENT_SHOW_CONFIGURATION_VIEW", (boolean)false);
        });
    }

    private void exit() {
        App.getProvider().reset();
        App.getProvider().stop();
        org.silentsoft.io.event.EventHandler.callEvent(((Object)((Object)this)).getClass(), (String)"EVENT_APPLICATION_CLOSE_REQUESTED", (boolean)false);
        System.exit(0);
    }

    private void notifyPreloaderPreparingPlugins() {
        this.pluginCountDownLatch = new CountDownLatch((Integer)SharedMemory.getDataMap().get((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS"));
        this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.5));
        new Thread(() -> {
            try {
                this.pluginCountDownLatch.await();
                Thread.sleep(300L);
                this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(1.0));
                Thread.sleep(1200L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.StateChangeNotification(Preloader.StateChangeNotification.Type.BEFORE_START));
                Platform.runLater(() -> stage.show());
            }
        }).start();
    }

    private void notifyPreloaderCountDownPlugin() {
        int numberOfPlugins = (Integer)SharedMemory.getDataMap().get((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS");
        this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.5 + (double)((long)numberOfPlugins - this.pluginCountDownLatch.getCount() + 1L) / (double)numberOfPlugins * 0.5));
        this.pluginCountDownLatch.countDown();
    }

    public void onEvent(String event) {
        switch (event) {
            case "EVENT_NOTIFY_PRELOADER_PREPARING_PLUGINS": {
                this.notifyPreloaderPreparingPlugins();
                break;
            }
            case "EVENT_NOTIFY_PRELOADER_COUNT_DOWN_PLUGIN": {
                this.notifyPreloaderCountDownPlugin();
                break;
            }
            case "EVENT_REGISTER_TRAY_ICON": {
                this.registerTrayIcon();
                break;
            }
            case "EVENT_APPLICATION_SHOW_HIDE": {
                this.showOrHide();
                break;
            }
            case "EVENT_APPLICATION_BRING_TO_FRONT": {
                this.bringToFront();
                break;
            }
            case "EVENT_APPLICATION_EXIT": {
                this.exit();
                break;
            }
            case "EVENT_UPDATE_PROXY_HOST": {
                this.updateProxyHost();
            }
        }
    }
}

