/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class ObjectUtil {
    public static String getIndexCase(String str, int index, IndexCaseType type) {
        StringBuffer sb = new StringBuffer();
        char indexChar = Character.toUpperCase(str.charAt(index));
        if (type == IndexCaseType.LOWER_CASE) {
            indexChar = Character.toLowerCase(str.charAt(index));
        }
        switch (index) {
            case 0: {
                sb.append(indexChar).append(str.substring(index + 1));
                break;
            }
            default: {
                sb.append(str.substring(0, index)).append(indexChar).append(str.substring(index + 1));
            }
        }
        return sb.toString();
    }

    public static String toString(Object obj) {
        return ObjectUtil.isEmpty(obj) ? "" : obj.toString();
    }

    public static String toString(Object obj, String emptyThen) {
        return ObjectUtil.isEmpty(obj) ? emptyThen : ObjectUtil.toString(obj);
    }

    public static int toInt(Object obj) {
        int toInt = 0;
        if (ObjectUtil.isNotEmpty(obj)) {
            if (obj instanceof String) {
                toInt = Integer.valueOf((String)obj);
            } else if (obj instanceof Float) {
                toInt = (int)((Float)obj).floatValue();
            } else if (obj instanceof Double) {
                toInt = (int)((Double)obj).doubleValue();
            } else if (obj instanceof Boolean) {
                toInt = ((Boolean)obj).compareTo(false);
            } else {
                String toString = obj.toString();
                toInt = Integer.valueOf(toString);
            }
        }
        return toInt;
    }

    public static int toInt(Object obj, int emptyThen) {
        return ObjectUtil.isEmpty(obj) ? emptyThen : ObjectUtil.toInt(obj);
    }

    public static boolean toBoolean(Object obj) {
        boolean toBoolean = false;
        if (ObjectUtil.isNotEmpty(obj)) {
            toBoolean = obj instanceof String ? Boolean.valueOf((String)obj) : (obj instanceof Integer ? (Integer)obj == 1 : (Boolean)obj);
        }
        return toBoolean;
    }

    public static boolean toBoolean(Object obj, boolean emptyThen) {
        return ObjectUtil.isEmpty(obj) ? emptyThen : ObjectUtil.toBoolean(obj);
    }

    public static Map toMap(Object obj) {
        try {
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            Field[] fields = obj.getClass().getDeclaredFields();
            int nLength = fields.length;
            for (int i = 0; i < nLength; ++i) {
                fields[i].setAccessible(true);
                returnMap.put(fields[i].getName(), fields[i].get(obj));
            }
            return returnMap;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String fillString(String strData, int iLength, String strFilter) {
        return ObjectUtil.fillString(strData, iLength, strFilter, false);
    }

    public static String fillString(String strData, int iLength, String strFilter, boolean bRight) {
        if (iLength <= strData.length()) {
            return strData;
        }
        StringBuffer returnString = new StringBuffer();
        int iCount = iLength - strData.length();
        for (int i = 0; i < iCount; ++i) {
            returnString.append(strFilter);
        }
        if (bRight) {
            returnString.insert(0, strData);
        } else {
            returnString.insert(iCount, strData);
        }
        return returnString.toString();
    }

    public static <T> T bindValue(T dvo, String methodName, Object emptyValue) throws Exception {
        return ObjectUtil.bindValue(dvo, methodName, emptyValue, false);
    }

    public static <T> T bindValue(T dvo, String methodName, Object emptyValue, boolean force) throws Exception {
        Class<?> clazz = dvo.getClass();
        String _methodName = ObjectUtil.getIndexCase(methodName, 0, IndexCaseType.UPPER_CASE);
        Method getMethod = clazz.getDeclaredMethod("get".concat(_methodName), new Class[0]);
        Object value = getMethod.invoke(dvo, new Object[0]);
        if (force || ObjectUtil.isEmpty(value)) {
            Method setMethod = clazz.getDeclaredMethod("set".concat(_methodName), emptyValue.getClass());
            setMethod.invoke(dvo, emptyValue);
        }
        return dvo;
    }

    public static Map<String, Object> bindMapValue(Map<String, Object> map, String fieldName, Object emptyValue) throws Exception {
        return ObjectUtil.bindMapValue(map, fieldName, emptyValue, false);
    }

    public static Map<String, Object> bindMapValue(Map<String, Object> map, String fieldName, Object emptyValue, boolean force) throws Exception {
        Object value = map.get(fieldName);
        if (force || ObjectUtil.isEmpty(value)) {
            map.put(fieldName, emptyValue);
        }
        return map;
    }

    public static boolean isEmptyVO(Object obj) {
        try {
            Field[] fields = obj.getClass().getDeclaredFields();
            int nLength = fields.length;
            for (int i = 0; i < nLength; ++i) {
                fields[i].setAccessible(true);
                if (!ObjectUtil.isNotEmpty(fields[i].get(obj))) continue;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String || obj instanceof StringBuffer) {
            String str = obj.toString().trim();
            return str.isEmpty() || str.equalsIgnoreCase("null");
        }
        if (obj instanceof Object[]) {
            return ((Object[])obj).length == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        return false;
    }

    public static boolean isNotEmpty(Object obj) {
        return !ObjectUtil.isEmpty(obj);
    }

    public static boolean isEqual(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null && o2 != null || o1 != null && o2 == null) {
            return false;
        }
        return o1.toString().equals(o2.toString());
    }

    public static enum IndexCaseType {
        UPPER_CASE,
        LOWER_CASE;

    }
}

