/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.silentsoft.actlist.plugin.CompatibleVersion;

@CompatibleVersion(value="1.6.0")
public class DebugParameter {
    private boolean isDebugMode;
    private String proxyHost;
    private boolean isDarkMode;
    private boolean shouldAnalyze;
    private Path classesDirectoryToAnalyze;
    private String[] analysisIgnoreReferences;
    private String loggingLevel;

    private DebugParameter() {
    }

    private DebugParameter(DebugParameterBuilder builder) {
        this.isDebugMode = builder.isDebugMode;
        this.proxyHost = builder.proxyHost;
        this.isDarkMode = builder.isDarkMode;
        this.shouldAnalyze = builder.shouldAnalyze;
        this.classesDirectoryToAnalyze = builder.classesDirectoryToAnalyze;
        this.analysisIgnoreReferences = builder.analysisIgnoreReferences;
        this.loggingLevel = builder.loggingLevel;
    }

    @CompatibleVersion(value="1.6.0")
    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    @CompatibleVersion(value="1.6.0")
    public String getProxyHost() {
        return this.proxyHost;
    }

    @CompatibleVersion(value="1.6.0")
    public boolean isDarkMode() {
        return this.isDarkMode;
    }

    @CompatibleVersion(value="1.7.0")
    public boolean shouldAnalyze() {
        return this.shouldAnalyze;
    }

    @CompatibleVersion(value="1.7.0")
    public Path getClassesDirectoryToAnalyze() {
        return this.classesDirectoryToAnalyze;
    }

    @CompatibleVersion(value="1.7.0")
    public String[] getAnalysisIgnoreReferences() {
        return this.analysisIgnoreReferences;
    }

    @CompatibleVersion(value="2.0.0")
    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    @CompatibleVersion(value="1.6.0")
    public static DebugParameterBuilder custom() {
        return new DebugParameterBuilder();
    }

    @CompatibleVersion(value="1.6.0")
    public static class DebugParameterBuilder {
        private boolean isDebugMode = true;
        private String proxyHost = null;
        private boolean isDarkMode = false;
        private boolean shouldAnalyze = true;
        private Path classesDirectoryToAnalyze = Paths.get("target", "classes");
        private String[] analysisIgnoreReferences = null;
        private String loggingLevel = "TRACE";

        private DebugParameterBuilder() {
        }

        @CompatibleVersion(value="1.6.0")
        public DebugParameterBuilder setDebugMode(boolean isDebugMode) {
            this.isDebugMode = isDebugMode;
            return this;
        }

        @CompatibleVersion(value="1.6.0")
        public DebugParameterBuilder setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        @CompatibleVersion(value="1.6.0")
        public DebugParameterBuilder setDarkMode(boolean isDarkMode) {
            this.isDarkMode = isDarkMode;
            return this;
        }

        @CompatibleVersion(value="1.7.0")
        public DebugParameterBuilder setAnalyze(boolean shouldAnalyze) {
            this.shouldAnalyze = shouldAnalyze;
            return this;
        }

        @CompatibleVersion(value="1.7.0")
        public DebugParameterBuilder setClassesDirectoryToAnalyze(Path classesDirectoryToAnalyze) {
            this.classesDirectoryToAnalyze = classesDirectoryToAnalyze;
            return this;
        }

        @CompatibleVersion(value="1.7.0")
        public DebugParameterBuilder setAnalysisIgnoreReferences(String[] analysisIgnoreReferences) {
            this.analysisIgnoreReferences = analysisIgnoreReferences;
            return this;
        }

        @CompatibleVersion(value="2.0.0")
        public DebugParameterBuilder setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        @CompatibleVersion(value="1.6.0")
        public DebugParameter build() {
            return new DebugParameter(this);
        }
    }
}

