/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.plushaze.traynotification.animations.Animations;
import com.jfoenix.controls.JFXHamburger;
import com.jfoenix.controls.JFXSpinner;
import com.jfoenix.controls.JFXToggleButton;
import de.codecentric.centerdevice.glass.AdapterContext;
import java.awt.Desktop;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.animation.FadeTransition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.SVGPath;
import javafx.scene.text.Font;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.expr.ConstructorCall;
import javassist.expr.Expr;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.controlsfx.control.PopOver;
import org.silentsoft.actlist.plugin.ActlistPlugin;
import org.silentsoft.actlist.plugin.AnalysisResult;
import org.silentsoft.actlist.plugin.CompatibleVersion;
import org.silentsoft.actlist.plugin.DebugParameter;
import org.silentsoft.actlist.plugin.PluginConfig;
import org.silentsoft.actlist.plugin.VersionComparator;
import org.silentsoft.actlist.plugin.messagebox.MessageBox;
import org.silentsoft.actlist.plugin.tray.TrayNotification;
import org.silentsoft.core.util.DateUtil;
import org.silentsoft.core.util.FileUtil;
import org.silentsoft.core.util.JSONUtil;
import org.silentsoft.core.util.ObjectUtil;
import org.silentsoft.core.util.SystemUtil;

@Deprecated
@CompatibleVersion(value="1.2.6")
public final class DebugApp
extends Application {
    static DebugParameter debugParameter;
    Stage stage;
    ActlistPlugin plugin;
    PopOver popOver;
    ObservableList<Node> functions;
    HashMap<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> trayNotifications = new HashMap();
    boolean isAvailableNewPlugin = false;
    URI newPluginURI;
    static StringBuffer userAgent;
    Stage aboutStage;
    private volatile Runnable checkForUpdates = () -> {
        block19: {
            Label warningLabel = (Label)this.stage.getScene().lookup("#warningLabel");
            Label updateAlarmLabel = (Label)this.stage.getScene().lookup("#updateAlarmLabel");
            try {
                boolean hasEndOfService;
                boolean hasTurnedOnKillSwitch;
                URI pluginUpdateCheckURI = this.plugin.getPluginUpdateCheckURI();
                if (pluginUpdateCheckURI == null) break block19;
                Map result = null;
                ArrayList<BasicNameValuePair> param = new ArrayList<BasicNameValuePair>();
                param.add(new BasicNameValuePair("version", this.plugin.getPluginVersion()));
                String uri = pluginUpdateCheckURI.toString();
                if (uri.matches("(?i).*\\.js")) {
                    StringBuffer script = new StringBuffer();
                    script.append(String.format("var version = '%s';", this.plugin.getPluginVersion())).append("\r\n");
                    script.append(RESTfulAPI.doGet(pluginUpdateCheckURI.toString(), param, String.class, this.plugin.getBeforeRequest()));
                    ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("nashorn");
                    Object _result = scriptEngine.eval(script.toString());
                    if (_result instanceof Map) {
                        result = (Map)_result;
                    }
                } else {
                    result = RESTfulAPI.doGet(pluginUpdateCheckURI.toString(), param, Map.class, this.plugin.getBeforeRequest());
                }
                if (result == null) {
                    return;
                }
                if (result.containsKey("available")) {
                    this.isAvailableNewPlugin = Boolean.parseBoolean(String.valueOf(result.get("available")));
                    if (this.isAvailableNewPlugin) {
                        URI pluginArchivesURI = this.plugin.getPluginArchivesURI();
                        if (pluginArchivesURI != null) {
                            this.newPluginURI = pluginArchivesURI;
                        }
                        if (result.containsKey("url")) {
                            try {
                                this.newPluginURI = new URI(String.valueOf(result.get("url")));
                                this.plugin.setPluginArchivesURI(this.newPluginURI);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (this.newPluginURI != null) {
                            updateAlarmLabel.setVisible(true);
                            this.playFadeTransition((Node)updateAlarmLabel);
                        } else {
                            updateAlarmLabel.setVisible(false);
                        }
                        if (result.containsKey("jar")) {
                            System.out.println(String.join((CharSequence)"", "[skip automatic update] jar=", String.valueOf(result.get("jar"))));
                        }
                        try {
                            this.plugin.pluginUpdateFound();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (result.containsKey("killSwitch") && (hasTurnedOnKillSwitch = "on".equalsIgnoreCase(String.valueOf(result.get("killSwitch")).trim()))) {
                    String message = "The plugin's kill switch has turned on by the author.";
                    this.makeDisable(new Exception(message), false);
                    warningLabel.setOnMouseClicked(mouseEvent -> MessageBox.showInformation(this.stage, message));
                    warningLabel.setVisible(true);
                    this.playFadeTransition((Node)warningLabel);
                }
                if (result.containsKey("endOfService") && (hasEndOfService = Boolean.parseBoolean(String.valueOf(result.get("endOfService"))))) {
                    warningLabel.setOnMouseClicked(mouseEvent -> MessageBox.showInformation(this.stage, "This plugin has reached end of service by the author."));
                    warningLabel.setVisible(true);
                    this.playFadeTransition((Node)warningLabel);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    static void debug(DebugParameter debugParameter) {
        DebugApp.debugParameter = debugParameter;
        DebugApp.analyze(debugParameter);
        DebugApp.updateLoggingLevel(debugParameter);
        DebugApp.updateProxyHost();
        DebugApp.generateUserAgent();
        System.out.println("::.................< Launching >.................::");
        System.out.println(">-------------------------------------------------<");
        System.out.println();
        DebugApp.launch((String[])new String[]{""});
    }

    static AnalysisResult analyze(final DebugParameter debugParameter) {
        if (debugParameter.shouldAnalyze()) {
            System.out.println("::..............< Start Analyzing >..............::");
            System.out.println(">-------------------------------------------------<");
            try {
                final ArrayList classes = new ArrayList();
                Files.walkFileTree(debugParameter.getClassesDirectoryToAnalyze(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String fileName = file.getFileName().toString();
                        if (fileName.toLowerCase().endsWith(".class")) {
                            String classFileName = debugParameter.getClassesDirectoryToAnalyze().relativize(file).normalize().toString();
                            String className = classFileName.substring(0, classFileName.length() - ".class".length()).replaceAll(Pattern.quote(File.separator), ".");
                            classes.add(className);
                        }
                        return super.visitFile(file, attrs);
                    }
                });
                if (classes.isEmpty()) {
                    return null;
                }
                AtomicReference<String> minimumCompatibleVersion = new AtomicReference<String>("");
                HashSet<String> references = new HashSet<String>();
                class Wrapper {
                    String version;
                    String content;

                    Wrapper(String version, String content) {
                        this.version = version;
                        this.content = content;
                    }

                    public String toString() {
                        return String.format(" : @CompatibleVersion(%s) %s", this.version, this.content);
                    }
                }
                ArrayList<Wrapper> wrappers = new ArrayList<Wrapper>();
                Consumer<String> comparator = version -> {
                    if (minimumCompatibleVersion.get() == null || "".equals(minimumCompatibleVersion.get()) || VersionComparator.getInstance().compare((String)minimumCompatibleVersion.get(), (String)version) < 0) {
                        minimumCompatibleVersion.set((String)version);
                    }
                };
                try {
                    MavenXpp3Reader reader = new MavenXpp3Reader();
                    Model model = reader.read((Reader)new FileReader("pom.xml"));
                    String mainClass = (String)model.getProperties().get("mainClass");
                    if (ObjectUtil.isEmpty((Object)mainClass)) {
                        mainClass = "Plugin";
                    }
                    if (!"Plugin".equals(mainClass)) {
                        String value = "1.4.2";
                        wrappers.add(new Wrapper(value, "pom.xml override <mainClass> property"));
                        comparator.accept(value);
                    }
                }
                catch (Error | Exception reader) {
                    // empty catch block
                }
                final BiConsumer<Expr, CtMember> reference = (expr, ctMember) -> {
                    try {
                        String longName = ctMember instanceof CtBehavior ? ((CtBehavior)ctMember).getLongName() : String.join((CharSequence)".", ctMember.getDeclaringClass().getName(), ctMember.getName());
                        references.add(longName);
                        if (debugParameter.getAnalysisIgnoreReferences() != null && Arrays.asList(debugParameter.getAnalysisIgnoreReferences()).contains(longName)) {
                            return;
                        }
                        if (ctMember.hasAnnotation(CompatibleVersion.class)) {
                            String value = ((CompatibleVersion)ctMember.getAnnotation(CompatibleVersion.class)).value();
                            String packageName = expr.where().getDeclaringClass().getPackageName();
                            String source = packageName == null ? expr.getFileName() : String.join((CharSequence)".", packageName, expr.getFileName());
                            String action = ctMember instanceof CtBehavior ? "call" : "access";
                            wrappers.add(new Wrapper(value, String.format("%s[L:%d] %s <%s>", source, expr.getLineNumber(), action, longName)));
                            comparator.accept(value);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                };
                ExprEditor exprEditor = new ExprEditor(){

                    public void edit(ConstructorCall constructorCall) throws CannotCompileException {
                        try {
                            reference.accept(constructorCall, constructorCall.getConstructor());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    public void edit(NewExpr newExpr) throws CannotCompileException {
                        try {
                            reference.accept(newExpr, newExpr.getConstructor());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    public void edit(MethodCall methodCall) throws CannotCompileException {
                        try {
                            reference.accept(methodCall, methodCall.getMethod());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    public void edit(FieldAccess fieldAccess) throws CannotCompileException {
                        try {
                            reference.accept(fieldAccess, fieldAccess.getField());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                ClassPool classPool = ClassPool.getDefault();
                CtClass ctActlistPlugin = classPool.get(ActlistPlugin.class.getName());
                CtClass[] ctClasses = classPool.get(classes.toArray(new String[0]));
                for (CtClass ctClass : ctClasses) {
                    CtMethod[] ctMethods;
                    Collection refClasses = ctClass.getRefClasses();
                    if (refClasses != null) {
                        references.addAll(refClasses);
                        for (String refClass : refClasses) {
                            CtClass ctRefClass;
                            if (debugParameter.getAnalysisIgnoreReferences() != null && Arrays.asList(debugParameter.getAnalysisIgnoreReferences()).contains(refClass) || !(ctRefClass = classPool.get(refClass)).hasAnnotation(CompatibleVersion.class)) continue;
                            String value = ((CompatibleVersion)ctRefClass.getAnnotation(CompatibleVersion.class)).value();
                            wrappers.add(new Wrapper(value, String.format("%s refer <%s>", ctClass.getName(), ctRefClass.getName())));
                            comparator.accept(value);
                        }
                    }
                    if (ActlistPlugin.class.isAssignableFrom(Class.forName(ctClass.getName())) && (ctMethods = ctClass.getDeclaredMethods()) != null) {
                        for (CtMethod ctMethod : ctMethods) {
                            for (CtMethod superMethod : ctActlistPlugin.getDeclaredMethods()) {
                                if (!superMethod.equals((Object)ctMethod)) continue;
                                references.add(superMethod.getLongName());
                                if (debugParameter.getAnalysisIgnoreReferences() != null && Arrays.asList(debugParameter.getAnalysisIgnoreReferences()).contains(superMethod.getLongName()) || !superMethod.hasAnnotation(CompatibleVersion.class)) continue;
                                String value = ((CompatibleVersion)superMethod.getAnnotation(CompatibleVersion.class)).value();
                                wrappers.add(new Wrapper(value, String.format("%s override <%s>", ctClass.getName(), superMethod.getLongName())));
                                comparator.accept(value);
                            }
                        }
                    }
                    ctClass.instrument(exprEditor);
                }
                wrappers.sort((o1, o2) -> VersionComparator.getInstance().compare(o1.version, o2.version));
                for (Wrapper wrapper : wrappers) {
                    System.out.println(wrapper.toString());
                }
                System.out.println(String.format(">: minimum compatible version = Actlist v%s", minimumCompatibleVersion.get()));
                System.out.println();
                AnalysisResult analysisResult = new AnalysisResult();
                analysisResult.setMinimumCompatibleVersion(minimumCompatibleVersion.get());
                analysisResult.setReferences(references.stream().sorted().collect(Collectors.toList()));
                return analysisResult;
            }
            catch (Error | Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void updateLoggingLevel(DebugParameter debugParameter) {
        LogManager.getRootLogger().setLevel(Level.toLevel((String)debugParameter.getLoggingLevel()));
    }

    private static void updateProxyHost() {
        String proxyHost = "";
        String proxyPort = "";
        HttpHost proxy = RESTfulAPI.getProxyHost();
        if (proxy != null) {
            proxyHost = proxy.getHostName();
            proxyPort = String.valueOf(proxy.getPort());
        }
        System.setProperty("http.proxyHost", proxyHost);
        System.setProperty("http.proxyPort", proxyPort);
        System.setProperty("https.proxyHost", proxyHost);
        System.setProperty("https.proxyPort", proxyPort);
    }

    private static void generateUserAgent() {
        userAgent = new StringBuffer();
        userAgent.append("Actlist-0.0.0");
        if (SystemUtil.isWindows()) {
            userAgent.append(" windows-");
        } else if (SystemUtil.isMac()) {
            userAgent.append(" macosx-");
        } else if (SystemUtil.isLinux()) {
            userAgent.append(" linux-");
        } else {
            userAgent.append(" unknown-");
        }
        userAgent.append(SystemUtil.getOSArchitecture());
        userAgent.append(" platform-");
        userAgent.append(SystemUtil.getPlatformArchitecture());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void start(Stage stage) throws Exception {
        Class<?> pluginClass;
        block24: {
            StringBuffer message;
            String mainClass;
            block23: {
                this.stage = stage;
                mainClass = null;
                pluginClass = null;
                MavenXpp3Reader reader = new MavenXpp3Reader();
                Model model = reader.read((Reader)new FileReader("pom.xml"));
                mainClass = (String)model.getProperties().get("mainClass");
                if (!ObjectUtil.isEmpty((Object)mainClass)) break block23;
                mainClass = "Plugin";
            }
            try {
                pluginClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(mainClass);
            }
            catch (ClassNotFoundException e) {
                message = new StringBuffer();
                message.append(String.join((CharSequence)"", "[ERROR] '", mainClass, "' class is not exists. Please check 'mainClass' property in pom.xml", "\r\n"));
                message.append(String.join((CharSequence)"", ">>", "\r\n"));
                message.append(String.join((CharSequence)"", "    <properties>", "\r\n"));
                message.append(String.join((CharSequence)"", "        <mainClass>your.pkg.Plugin</mainClass>", "\r\n"));
                message.append(String.join((CharSequence)"", "    </properties>", "\r\n"));
                message.append(String.join((CharSequence)"", "<<", "\r\n"));
                System.err.println(message.toString());
            }
            break block24;
            catch (Error | Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        pluginClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(mainClass);
                    }
                    catch (ClassNotFoundException e2) {
                        StringBuffer message2 = new StringBuffer();
                        message2.append(String.join((CharSequence)"", "[ERROR] '", mainClass, "' class is not exists. Please check 'mainClass' property in pom.xml", "\r\n"));
                        message2.append(String.join((CharSequence)"", ">>", "\r\n"));
                        message2.append(String.join((CharSequence)"", "    <properties>", "\r\n"));
                        message2.append(String.join((CharSequence)"", "        <mainClass>your.pkg.Plugin</mainClass>", "\r\n"));
                        message2.append(String.join((CharSequence)"", "    </properties>", "\r\n"));
                        message2.append(String.join((CharSequence)"", "<<", "\r\n"));
                        System.err.println(message2.toString());
                    }
                    throw throwable;
                }
                try {
                    pluginClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(mainClass);
                }
                catch (ClassNotFoundException e3) {
                    message = new StringBuffer();
                    message.append(String.join((CharSequence)"", "[ERROR] '", mainClass, "' class is not exists. Please check 'mainClass' property in pom.xml", "\r\n"));
                    message.append(String.join((CharSequence)"", ">>", "\r\n"));
                    message.append(String.join((CharSequence)"", "    <properties>", "\r\n"));
                    message.append(String.join((CharSequence)"", "        <mainClass>your.pkg.Plugin</mainClass>", "\r\n"));
                    message.append(String.join((CharSequence)"", "    </properties>", "\r\n"));
                    message.append(String.join((CharSequence)"", "<<", "\r\n"));
                    System.err.println(message.toString());
                }
            }
        }
        if (ActlistPlugin.class.isAssignableFrom(pluginClass)) {
            String configContent;
            Object pluginConfig;
            this.popOver = new PopOver((Node)new VBox());
            ((VBox)this.popOver.getContentNode()).setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
            this.popOver.setArrowLocation(PopOver.ArrowLocation.TOP_LEFT);
            this.plugin = (ActlistPlugin)ActlistPlugin.class.cast(pluginClass.newInstance());
            ActlistPlugin.SupportedPlatform currentPlatform = null;
            if (SystemUtil.isWindows()) {
                currentPlatform = ActlistPlugin.SupportedPlatform.WINDOWS;
            } else if (SystemUtil.isMac()) {
                currentPlatform = ActlistPlugin.SupportedPlatform.MACOSX;
            }
            this.plugin.currentPlatformObject().set((Object)currentPlatform);
            ActlistPlugin.SupportedPlatform[] supportedPlatforms = this.plugin.getSupportedPlatforms();
            if (supportedPlatforms != null && supportedPlatforms.length > 0 && !Arrays.asList(supportedPlatforms).contains((Object)currentPlatform)) {
                List listOfSupportedPlatform = Arrays.stream(supportedPlatforms).map(Enum::name).collect(Collectors.toList());
                String errorMessage = String.join((CharSequence)"", "This plugin only supports ", String.join((CharSequence)", ", listOfSupportedPlatform));
                throw new Exception(errorMessage);
            }
            this.plugin.classLoaderObject().set((Object)((Object)((Object)this)).getClass().getClassLoader());
            this.plugin.proxyHostObject().set((Object)RESTfulAPI.getProxyHost());
            this.plugin.darkModeProperty().set(debugParameter.isDarkMode());
            this.plugin.setPluginConfig(new PluginConfig("debug"));
            File configFile = Paths.get(System.getProperty("user.dir"), "plugins", "config", "debug.config").toFile();
            if (configFile.exists() && (pluginConfig = (PluginConfig)JSONUtil.JSONToObject((String)(configContent = FileUtil.readFile((File)configFile)), PluginConfig.class)) != null) {
                if (!"debug".equals(((PluginConfig)pluginConfig).getPlugin())) {
                    ((PluginConfig)pluginConfig).setPlugin("debug");
                    ((PluginConfig)pluginConfig).commit();
                }
                this.plugin.setPluginConfig((PluginConfig)pluginConfig);
            }
            this.plugin.shouldShowLoadingBar().addListener((observable, oldValue, newValue) -> {
                if (oldValue == newValue) {
                    return;
                }
                this.displayLoadingBar((boolean)newValue);
            });
            this.plugin.exceptionObject().addListener((observable, oldValue, newValue) -> {
                if (newValue != null) {
                    this.makeDisable((Throwable)newValue, true);
                    this.plugin.exceptionObject().set(null);
                }
            });
            this.plugin.showTrayNotificationObject().addListener((observable, oldValue, newValue) -> {
                if (newValue != null) {
                    com.github.plushaze.traynotification.notification.TrayNotification trayNotification = new com.github.plushaze.traynotification.notification.TrayNotification();
                    HashMap<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> hashMap = this.trayNotifications;
                    synchronized (hashMap) {
                        this.trayNotifications.put((TrayNotification)newValue, trayNotification);
                    }
                    trayNotification.setRectangleFill(Paint.valueOf((String)"#222222"));
                    trayNotification.setImage(new Image("/images/icon/actlist_128.png"));
                    trayNotification.setAnimation(Animations.POPUP);
                    String titleValue = this.plugin.getPluginName() == null || this.plugin.getPluginName().trim().isEmpty() ? "(empty name)" : this.plugin.getPluginName();
                    String titlePrefix = String.format("[%s] ", titleValue);
                    if (newValue.getTitle() == null || newValue.getTitle().trim().isEmpty()) {
                        trayNotification.setTitle(titlePrefix.concat(""));
                    } else {
                        trayNotification.setTitle(titlePrefix.concat(newValue.getTitle()));
                    }
                    if (newValue.getMessage() == null || newValue.getMessage().trim().isEmpty()) {
                        trayNotification.setMessage("(empty message)");
                    } else {
                        trayNotification.setMessage(newValue.getMessage());
                    }
                    trayNotification.setOnDismiss(actionEvent -> {
                        HashMap<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> hashMap = this.trayNotifications;
                        synchronized (hashMap) {
                            this.trayNotifications.remove(newValue);
                        }
                        if (newValue.getDuration() == null) {
                            this.bringToFront();
                        }
                    });
                    if (newValue.getDuration() == null) {
                        trayNotification.showAndWait();
                    } else {
                        trayNotification.showAndDismiss(newValue.getDuration());
                    }
                    this.plugin.showTrayNotificationObject().set(null);
                }
            });
            Consumer<com.github.plushaze.traynotification.notification.TrayNotification> dismiss = trayNotification -> new Thread(() -> {
                while (!trayNotification.isTrayShowing()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                }
                Platform.runLater(() -> trayNotification.dismiss());
            }).start();
            this.plugin.dismissTrayNotificationObject().addListener((observable, oldValue, newValue) -> {
                if (newValue != null) {
                    HashMap<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> hashMap = this.trayNotifications;
                    synchronized (hashMap) {
                        if (this.trayNotifications.containsKey(newValue)) {
                            com.github.plushaze.traynotification.notification.TrayNotification trayNotification = this.trayNotifications.get(newValue);
                            dismiss.accept(trayNotification);
                        }
                    }
                    this.plugin.dismissTrayNotificationObject().set(null);
                }
            });
            this.plugin.shouldDismissTrayNotifications().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    HashMap<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> hashMap = this.trayNotifications;
                    synchronized (hashMap) {
                        for (Map.Entry<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> entrySet : this.trayNotifications.entrySet()) {
                            com.github.plushaze.traynotification.notification.TrayNotification trayNotification = entrySet.getValue();
                            dismiss.accept(trayNotification);
                        }
                        this.plugin.shouldDismissTrayNotifications().set(false);
                    }
                }
            });
            this.plugin.shouldBrowseActlistArchives().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    try {
                        Desktop.getDesktop().browse(new URI("http://actlist.silentsoft.org/archives/"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.plugin.shouldBrowseActlistArchives().set(false);
                }
            });
            this.plugin.shouldRequestShowActlist().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    if (this.isHidden()) {
                        this.showOrHide();
                    }
                } else if (this.isShown()) {
                    this.showOrHide();
                }
            });
            this.plugin.shouldRequestDeactivate().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    JFXToggleButton toggle = (JFXToggleButton)stage.getScene().lookup("#togActivator");
                    boolean isActivated = toggle.selectedProperty().get();
                    if (isActivated) {
                        toggle.setSelected(false);
                        this.deactivated();
                    }
                    this.plugin.shouldRequestDeactivate().set(false);
                }
            });
            AnchorPane root = new AnchorPane();
            root.setPrefWidth(435.0);
            if (debugParameter.isDarkMode()) {
                root.setStyle("-fx-base: rgb(40, 40, 40); -fx-background-color: -fx-base;");
            } else {
                root.setStyle("-fx-background-color: #ffffff;");
            }
            root.getChildren().add((Object)this.createHamburger());
            root.getChildren().add((Object)this.createHead());
            root.getChildren().add((Object)this.createToggleBox());
            root.getChildren().add((Object)this.createPluginLoadingBox());
            root.getChildren().add((Object)this.createSeparator());
            root.getChildren().add((Object)this.createContentBox());
            root.getChildren().add((Object)this.createContentLoadingBox());
            stage.setScene(new Scene((Parent)new BorderPane((Node)root), (Paint)Color.TRANSPARENT));
            stage.setTitle("Actlist Debug App");
            stage.setOnCloseRequest(windowEvent -> System.exit(0));
            stage.show();
            if (this.plugin.existsGraphic()) {
                this.plugin.getGraphic();
            }
            this.plugin.initialize();
            this.functions = FXCollections.observableArrayList();
            for (ActlistPlugin.Function function : this.plugin.getFunctionMap().values()) {
                this.addFunction(function);
            }
            if (!this.plugin.isOneTimePlugin()) {
                this.activated();
            }
        } else {
            throw new Exception("The Plugin class must be extends ActlistPlugin !");
        }
        HBox pluginLoadingBox = (HBox)stage.getScene().lookup("#pluginLoadingBox");
        pluginLoadingBox.setVisible(false);
        new Thread(() -> {
            boolean shouldCheck = true;
            Date latestCheckDate = null;
            while (true) {
                if (shouldCheck) {
                    this.checkForUpdates.run();
                    latestCheckDate = Calendar.getInstance().getTime();
                }
                try {
                    Thread.sleep((long)Duration.minutes((double)10.0).toMillis());
                }
                catch (InterruptedException interruptedException) {
                    shouldCheck = DateUtil.getDifferenceHoursFromNow(latestCheckDate) >= 24;
                    continue;
                }
                catch (Throwable throwable) {
                    shouldCheck = DateUtil.getDifferenceHoursFromNow(latestCheckDate) >= 24;
                    throw throwable;
                }
                shouldCheck = DateUtil.getDifferenceHoursFromNow((Date)latestCheckDate) >= 24;
                continue;
                break;
            }
        }).start();
    }

    private boolean isInitialized() {
        return this.plugin != null;
    }

    private void showOrHide() {
        if (this.stage.isIconified()) {
            Platform.runLater(() -> this.stage.setIconified(false));
        } else if (this.stage.isShowing()) {
            if (this.stage.isFocused()) {
                if (SystemUtil.isMac()) {
                    AdapterContext.getContext().getApplicationAdapter().hide();
                } else {
                    Platform.runLater(() -> this.stage.hide());
                }
            } else if (SystemUtil.isMac()) {
                Platform.runLater(() -> {
                    this.stage.toFront();
                    Point previousMouseLocation = MouseInfo.getPointerInfo().getLocation();
                    new Thread(() -> Platform.runLater(() -> {
                        try {
                            Robot robot = new Robot();
                            robot.mouseMove((int)this.stage.getX() + 10, (int)this.stage.getY() + 10);
                            robot.mousePress(1024);
                            robot.mouseRelease(1024);
                            robot.mouseMove(previousMouseLocation.x, previousMouseLocation.y);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    })).start();
                });
            } else {
                Platform.runLater(() -> this.stage.requestFocus());
            }
        } else if (SystemUtil.isMac()) {
            AdapterContext.getContext().getApplicationAdapter().unhideAllApplications();
        } else {
            Platform.runLater(() -> this.stage.show());
        }
    }

    private void bringToFront() {
        if (this.isHidden()) {
            this.showOrHide();
        }
    }

    private boolean isShown() {
        return !this.isHidden();
    }

    private boolean isHidden() {
        return this.stage.isIconified() || !this.stage.isShowing() || this.stage.isShowing() && !this.stage.isFocused();
    }

    private void playFadeTransition(Node node) {
        Runnable action = () -> {
            if (node.isVisible()) {
                FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)400.0), node);
                fadeTransition.setFromValue(1.0);
                fadeTransition.setToValue(0.3);
                fadeTransition.setCycleCount(6);
                fadeTransition.setAutoReverse(true);
                fadeTransition.play();
            }
        };
        if (Platform.isFxApplicationThread()) {
            action.run();
        } else {
            Platform.runLater(() -> action.run());
        }
    }

    private void makeDisable(Throwable throwable, boolean shouldTraceException) {
        if (shouldTraceException) {
            throwable.printStackTrace();
        }
        new Thread(() -> {
            JFXToggleButton togActivator = (JFXToggleButton)this.stage.getScene().lookup("#togActivator");
            if (togActivator.selectedProperty().get()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Platform.runLater(() -> {
                Label lblPluginName = (Label)this.stage.getScene().lookup("#lblPluginName");
                lblPluginName.setCursor(Cursor.HAND);
                if (shouldTraceException) {
                    Runnable exceptionDialog = () -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Exception Dialog");
                        alert.setHeaderText(this.plugin.getPluginName());
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        throwable.printStackTrace(pw);
                        String exceptionText = sw.toString();
                        TextArea textArea = new TextArea(exceptionText);
                        textArea.setEditable(false);
                        textArea.setWrapText(true);
                        textArea.setMaxWidth(Double.MAX_VALUE);
                        textArea.setMaxHeight(Double.MAX_VALUE);
                        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
                        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
                        GridPane content = new GridPane();
                        content.setMaxWidth(Double.MAX_VALUE);
                        content.add((Node)textArea, 0, 0);
                        alert.getDialogPane().setContent((Node)content);
                        alert.showAndWait();
                    };
                    lblPluginName.setTooltip(new Tooltip("Click to show the exception log."));
                    lblPluginName.setOnMouseClicked(mouseEvent -> {
                        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                            exceptionDialog.run();
                        }
                    });
                    Label warningLabel = (Label)this.stage.getScene().lookup("#warningLabel");
                    warningLabel.setOnMouseClicked(mouseEvent -> exceptionDialog.run());
                    warningLabel.setVisible(true);
                    this.playFadeTransition((Node)warningLabel);
                } else {
                    lblPluginName.setTooltip(new Tooltip(throwable.getMessage()));
                }
                togActivator.setUnToggleLineColor(Paint.valueOf((String)"#da4242"));
                togActivator.setDisable(true);
                togActivator.setOpacity(1.0);
                togActivator.setSelected(false);
                this.clearPluginGraphic();
            });
        }).start();
    }

    private void addFunction(ActlistPlugin.Function function) {
        this.functions.add((Object)this.createFunctionBox(function.graphic, (EventHandler<? super MouseEvent>)((EventHandler)mouseEvent -> {
            try {
                if (function.action != null) {
                    function.action.run();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        })));
    }

    private HBox createFunctionBox(Node node, EventHandler<? super MouseEvent> action) {
        HBox hBox = new HBox(new Node[]{node});
        hBox.setAlignment(Pos.CENTER);
        hBox.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        hBox.setStyle("-fx-background-color: #fbfbfb;");
        hBox.setOnMouseEntered(mouseEvent -> hBox.setStyle("-fx-background-color: lightgray;"));
        hBox.setOnMouseExited(mouseEvent -> hBox.setStyle("-fx-background-color: #fbfbfb;"));
        hBox.addEventFilter(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
            try {
                this.popOver.hide();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new Thread(() -> Platform.runLater(() -> {
                try {
                    if (action != null) {
                        action.handle(mouseEvent);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            })).start();
        });
        return hBox;
    }

    private HBox createAboutFunction() {
        return this.createFunctionBox((Node)new Label("About"), (EventHandler<? super MouseEvent>)((EventHandler)mouseEvent -> this.stage.getScene().lookup("#updateAlarmLabel").getOnMouseClicked().handle(null)));
    }

    private JFXHamburger createHamburger() {
        JFXHamburger hamburger = new JFXHamburger();
        hamburger.setLayoutX(13.0);
        hamburger.setLayoutY(19.0);
        hamburger.setOpacity(debugParameter.isDarkMode() ? 1.0 : 0.2);
        hamburger.setPrefHeight(14.0);
        hamburger.setPrefWidth(11.0);
        hamburger.setCursor(Cursor.MOVE);
        return hamburger;
    }

    private HBox createHead() {
        Label lblPluginName = new Label();
        lblPluginName.setId("lblPluginName");
        lblPluginName.setText(this.plugin.getPluginName() == null || this.plugin.getPluginName().trim().isEmpty() ? "(empty name)" : this.plugin.getPluginName());
        lblPluginName.setPrefHeight(16.0);
        HBox.setHgrow((Node)lblPluginName, (Priority)Priority.ALWAYS);
        lblPluginName.setFont(Font.font((String)"Arial", (double)14.0));
        String pluginDescription = this.plugin.getPluginDescription();
        if (ObjectUtil.isNotEmpty((Object)pluginDescription)) {
            lblPluginName.setTooltip(new Tooltip(pluginDescription));
        }
        HBox head = new HBox(new Node[]{lblPluginName});
        head.setAlignment(Pos.CENTER_LEFT);
        head.setPrefHeight(45.0);
        AnchorPane.setLeftAnchor((Node)head, (Double)35.0);
        AnchorPane.setRightAnchor((Node)head, (Double)102.0);
        AnchorPane.setTopAnchor((Node)head, (Double)0.0);
        head.setOpaqueInsets(Insets.EMPTY);
        head.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        head.setOnMouseClicked(e -> {
            if (e.getButton() == MouseButton.SECONDARY) {
                ((VBox)this.popOver.getContentNode()).getChildren().clear();
                if (this.isInitialized()) {
                    ((VBox)this.popOver.getContentNode()).getChildren().add((Object)this.createAboutFunction());
                    if (this.isActivated()) {
                        if (this.plugin.getFunctionMap().size() > 0) {
                            ((VBox)this.popOver.getContentNode()).getChildren().add((Object)this.createCustomSeparator());
                        }
                        ((VBox)this.popOver.getContentNode()).getChildren().addAll(this.functions);
                    }
                    ((VBox)this.popOver.getContentNode()).getChildren().add((Object)this.createCustomSeparator());
                    ((VBox)this.popOver.getContentNode()).getChildren().add((Object)this.createCheckForUpdatesFunction());
                }
                ((VBox)this.popOver.getContentNode()).getChildren().add((Object)this.createDeleteFunction());
                this.popOver.show((Window)this.stage, e.getScreenX() - 40.0, e.getScreenY() - 10.0);
            }
        });
        return head;
    }

    private Separator createCustomSeparator() {
        Separator separator = new Separator(Orientation.HORIZONTAL);
        separator.setStyle("-fx-padding: 0.083333em 0.0em 0.0em 0.0em;");
        return separator;
    }

    private HBox createCheckForUpdatesFunction() {
        return this.createFunctionBox((Node)new Label("Check for updates"), (EventHandler<? super MouseEvent>)((EventHandler)mouseEvent -> {
            HBox pluginLoadingBox = (HBox)this.stage.getScene().lookup("#pluginLoadingBox");
            pluginLoadingBox.setVisible(true);
            this.displayLoadingBar(true);
            new Thread(() -> {
                this.checkForUpdates.run();
                pluginLoadingBox.setVisible(false);
                this.displayLoadingBar(false);
            }).start();
        }));
    }

    private HBox createDeleteFunction() {
        Label label = new Label("Delete");
        label.setTextFill(Paint.valueOf((String)"#db0018"));
        return this.createFunctionBox((Node)label, (EventHandler<? super MouseEvent>)((EventHandler)mouseEvent -> this.showRestrictionMessageBox()));
    }

    private void showRestrictionMessageBox() {
        MessageBox.showInformation(this.stage, "This feature isn't available in debug mode.");
    }

    private HBox createToggleBox() {
        Label warningLabel = new Label();
        warningLabel.setId("warningLabel");
        warningLabel.setMaxHeight(6.0);
        warningLabel.setMaxWidth(6.0);
        warningLabel.setMinHeight(6.0);
        warningLabel.setMinWidth(6.0);
        warningLabel.setOnMouseClicked(mouseEvent -> {
            warningLabel.setVisible(false);
            try {
                String warningText = this.plugin.getWarningText();
                if (ObjectUtil.isNotEmpty((Object)warningText)) {
                    MessageBox.showWarning(this.stage, warningText);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        warningLabel.setStyle("-fx-background-color: orange; -fx-background-radius: 5em;");
        warningLabel.setVisible(false);
        warningLabel.setCursor(Cursor.HAND);
        Label updateAlarmLabel = new Label();
        updateAlarmLabel.setId("updateAlarmLabel");
        updateAlarmLabel.setMaxHeight(6.0);
        updateAlarmLabel.setMaxWidth(6.0);
        updateAlarmLabel.setMinHeight(6.0);
        updateAlarmLabel.setMinWidth(6.0);
        updateAlarmLabel.setOnMouseClicked(mouseEvent -> {
            updateAlarmLabel.setVisible(false);
            if (this.aboutStage != null) {
                this.aboutStage.close();
                this.aboutStage = null;
            }
            this.aboutStage = new Stage();
            this.aboutStage.initOwner((Window)this.stage);
            this.aboutStage.initStyle(StageStyle.UTILITY);
            ImageView iconImage = new ImageView();
            iconImage.setFitHeight(48.0);
            iconImage.setFitWidth(48.0);
            iconImage.setPickOnBounds(true);
            iconImage.setPreserveRatio(true);
            iconImage.setImage(new Image("/images/icon/actlist_48.png"));
            VBox iconBox = new VBox(new Node[]{iconImage});
            iconBox.setAlignment(Pos.TOP_CENTER);
            iconBox.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
            Label name = new Label();
            name.setFont(Font.font((double)23.0));
            Label version = new Label();
            Label authorText = new Label();
            Hyperlink authorLink = new Hyperlink();
            authorLink.setFocusTraversable(false);
            HBox versionAndAuthorBox = new HBox(new Node[]{version, authorText, authorLink});
            versionAndAuthorBox.setAlignment(Pos.CENTER);
            SVGPath svg = new SVGPath();
            svg.setContent("M23 12l-2.44-2.78.34-3.68-3.61-.82-1.89-3.18L12 3 8.6 1.54 6.71 4.72l-3.61.81.34 3.68L1 12l2.44 2.78-.34 3.69 3.61.82 1.89 3.18L12 21l3.4 1.46 1.89-3.18 3.61-.82-.34-3.68L23 12zm-10 5h-2v-2h2v2zm0-4h-2V7h2v6z");
            svg.setFill(Paint.valueOf((String)"#4d4d4d"));
            Hyperlink newVersionLink = new Hyperlink();
            newVersionLink.setFocusTraversable(false);
            newVersionLink.setStyle("-fx-padding: 0;");
            newVersionLink.setText("New version available");
            newVersionLink.setTextFill(Paint.valueOf((String)"#ee7676"));
            HBox newVersionBox = new HBox(new Node[]{svg, newVersionLink});
            newVersionBox.setAlignment(Pos.CENTER);
            newVersionBox.setPrefHeight(100.0);
            newVersionBox.setPrefWidth(200.0);
            newVersionBox.setSpacing(3.0);
            newVersionBox.setVisible(false);
            VBox contentBox = new VBox(new Node[]{name, versionAndAuthorBox, newVersionBox});
            contentBox.setAlignment(Pos.TOP_CENTER);
            VBox child = new VBox(new Node[]{iconBox, contentBox});
            child.setPrefHeight(75.0);
            VBox rootVBox = new VBox(new Node[]{child});
            rootVBox.setLayoutX(106.0);
            rootVBox.setLayoutY(63.0);
            rootVBox.setSpacing(7.0);
            AnchorPane.setBottomAnchor((Node)rootVBox, (Double)15.0);
            AnchorPane.setLeftAnchor((Node)rootVBox, (Double)15.0);
            AnchorPane.setRightAnchor((Node)rootVBox, (Double)15.0);
            AnchorPane.setTopAnchor((Node)rootVBox, (Double)15.0);
            AnchorPane rootPane = new AnchorPane(new Node[]{rootVBox});
            rootPane.setMinWidth(360.0);
            rootPane.setStyle("-fx-background-color: white;");
            this.aboutStage.setScene(new Scene((Parent)new BorderPane((Node)rootPane)));
            if (this.plugin.existsIcon()) {
                try {
                    iconImage.setImage(this.plugin.getIcon().getImage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (ObjectUtil.isNotEmpty((Object)this.plugin.getPluginName())) {
                name.setText(this.plugin.getPluginName());
            }
            if (ObjectUtil.isNotEmpty((Object)this.plugin.getPluginVersion())) {
                version.setText(this.plugin.getPluginVersion());
            }
            if (ObjectUtil.isNotEmpty((Object)this.plugin.getPluginAuthor())) {
                if (ObjectUtil.isNotEmpty((Object)this.plugin.getPluginAuthorURI())) {
                    authorLink.setText(this.plugin.getPluginAuthor());
                    authorLink.setOnAction(actionEvent -> {
                        authorLink.setVisited(false);
                        try {
                            Desktop.getDesktop().browse(this.plugin.getPluginAuthorURI());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                } else {
                    authorText.setText(" by ".concat(this.plugin.getPluginAuthor()));
                }
            }
            if (this.isAvailableNewPlugin && this.newPluginURI != null) {
                newVersionBox.setVisible(true);
                newVersionLink.setOnAction(actionEvent -> {
                    newVersionLink.setVisited(false);
                    try {
                        Desktop.getDesktop().browse(this.newPluginURI);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            } else {
                newVersionBox.setVisible(false);
                VBox parent = (VBox)newVersionBox.getParent();
                parent.getChildren().remove((Object)newVersionBox);
            }
            Supplier<TabPane> createContentTabPane = () -> {
                TabPane tabPane = new TabPane();
                tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
                ScrollPane scrollPane = new ScrollPane((Node)tabPane);
                scrollPane.setFitToWidth(true);
                scrollPane.setFitToHeight(true);
                scrollPane.setPrefWidth(330.0);
                scrollPane.setPrefHeight(310.0);
                VBox.setVgrow((Node)scrollPane, (Priority)Priority.ALWAYS);
                rootVBox.getChildren().add((Object)scrollPane);
                return tabPane;
            };
            Consumer<Object[]> makeTabIfContentExists = objects -> {
                boolean existsContent;
                TabPane tabPane = (TabPane)objects[0];
                String title = (String)objects[1];
                URI uri = (URI)objects[2];
                String text = (String)objects[3];
                boolean bl = existsContent = ObjectUtil.isNotEmpty((Object)uri) || ObjectUtil.isNotEmpty((Object)text);
                if (existsContent) {
                    WebView webView = new WebView();
                    BufferedReader reader = null;
                    try {
                        if (ObjectUtil.isNotEmpty((Object)uri)) {
                            if ("jar".equals(uri.getScheme()) || "file".equals(uri.getScheme())) {
                                reader = new BufferedReader(new InputStreamReader(uri.toURL().openStream(), Charset.forName("UTF-8")));
                                StringBuffer buffer = new StringBuffer();
                                String value = null;
                                while ((value = reader.readLine()) != null) {
                                    buffer.append(value.concat("\r\n"));
                                }
                                String content = HtmlRenderer.builder().build().render(Parser.builder().build().parse(buffer.toString()));
                                webView.getEngine().loadContent(content);
                            } else {
                                webView.getEngine().load(uri.toString());
                            }
                        } else if (ObjectUtil.isNotEmpty((Object)text)) {
                            String content = HtmlRenderer.builder().build().render(Parser.builder().build().parse(text));
                            webView.getEngine().loadContent(content);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    tabPane.getTabs().add((Object)new Tab(title, (Node)webView));
                }
            };
            BooleanSupplier haveContentToShow = () -> {
                boolean result = false;
                if (ObjectUtil.isNotEmpty((Object)this.plugin.getPluginDescriptionURI()) || ObjectUtil.isNotEmpty((Object)this.plugin.getPluginDescription())) {
                    result = true;
                } else if (ObjectUtil.isNotEmpty((Object)this.plugin.getPluginChangeLogURI()) || ObjectUtil.isNotEmpty((Object)this.plugin.getPluginChangeLog())) {
                    result = true;
                } else if (ObjectUtil.isNotEmpty((Object)this.plugin.getPluginLicenseURI()) || ObjectUtil.isNotEmpty((Object)this.plugin.getPluginLicense())) {
                    result = true;
                }
                return result;
            };
            if (haveContentToShow.getAsBoolean()) {
                TabPane tabPane = createContentTabPane.get();
                makeTabIfContentExists.accept(new Object[]{tabPane, "Description", this.plugin.getPluginDescriptionURI(), this.plugin.getPluginDescription()});
                makeTabIfContentExists.accept(new Object[]{tabPane, "Change Log", this.plugin.getPluginChangeLogURI(), this.plugin.getPluginChangeLog()});
                makeTabIfContentExists.accept(new Object[]{tabPane, "License", this.plugin.getPluginLicenseURI(), this.plugin.getPluginLicense()});
                this.aboutStage.getScene().getWindow().sizeToScene();
            }
            this.aboutStage.show();
        });
        updateAlarmLabel.setStyle("-fx-background-color: red; -fx-background-radius: 5em;");
        updateAlarmLabel.setVisible(false);
        updateAlarmLabel.setCursor(Cursor.HAND);
        HBox innerBox = new HBox(new Node[]{warningLabel, updateAlarmLabel});
        innerBox.setAlignment(Pos.CENTER);
        innerBox.setSpacing(8.0);
        HBox.setMargin((Node)innerBox, (Insets)Insets.EMPTY);
        JFXToggleButton togActivator = new JFXToggleButton();
        togActivator.setId("togActivator");
        togActivator.setText(" ");
        togActivator.setFocusTraversable(false);
        togActivator.setSelected(false);
        togActivator.setToggleColor(Paint.valueOf((String)"#fafafa"));
        togActivator.setToggleLineColor(Paint.valueOf((String)"#59bf53"));
        togActivator.setUnToggleLineColor(Paint.valueOf((String)"#e0e0e0"));
        togActivator.setOnAction(actionEvent -> {
            if (this.isActivated()) {
                this.activated();
            } else {
                this.deactivated();
            }
        });
        String warningText = this.plugin.getWarningText();
        if (ObjectUtil.isNotEmpty((Object)warningText)) {
            warningLabel.setVisible(true);
            this.playFadeTransition((Node)warningLabel);
        } else {
            warningLabel.setVisible(false);
        }
        if (this.plugin.isOneTimePlugin()) {
            togActivator.setSelected(false);
        } else {
            togActivator.setSelected(true);
        }
        HBox toggleBox = new HBox(new Node[]{innerBox, togActivator});
        toggleBox.setAlignment(Pos.CENTER_LEFT);
        toggleBox.setLayoutX(361.0);
        toggleBox.setLayoutY(-2.0);
        toggleBox.setSpacing(8.0);
        AnchorPane.setRightAnchor((Node)toggleBox, (Double)0.0);
        return toggleBox;
    }

    private Separator createSeparator() {
        Separator separator = new Separator();
        separator.setLayoutX(35.0);
        separator.setLayoutY(50.0);
        separator.setPrefWidth(215.0);
        AnchorPane.setLeftAnchor((Node)separator, (Double)35.0);
        AnchorPane.setRightAnchor((Node)separator, (Double)20.0);
        return separator;
    }

    private HBox createPluginLoadingBox() {
        JFXSpinner spinner = new JFXSpinner();
        spinner.setPrefSize(28.0, 28.0);
        HBox pluginLoadingBox = new HBox(new Node[]{spinner});
        pluginLoadingBox.setId("pluginLoadingBox");
        pluginLoadingBox.setAlignment(Pos.CENTER);
        pluginLoadingBox.setLayoutX(0.0);
        pluginLoadingBox.setLayoutY(45.0);
        pluginLoadingBox.setPrefHeight(45.0);
        AnchorPane.setTopAnchor((Node)pluginLoadingBox, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)pluginLoadingBox, (Double)35.0);
        AnchorPane.setRightAnchor((Node)pluginLoadingBox, (Double)0.0);
        return pluginLoadingBox;
    }

    private VBox createContentBox() {
        VBox contentBox = new VBox();
        contentBox.setId("contentBox");
        contentBox.setLayoutX(35.0);
        contentBox.setLayoutY(51.0);
        contentBox.setPrefWidth(380.0);
        AnchorPane.setRightAnchor((Node)contentBox, (Double)20.0);
        AnchorPane.setLeftAnchor((Node)contentBox, (Double)35.0);
        return contentBox;
    }

    private VBox createContentLoadingBox() {
        VBox contentLoadingBox = new VBox();
        contentLoadingBox.setId("contentLoadingBox");
        contentLoadingBox.setAlignment(Pos.CENTER);
        contentLoadingBox.setLayoutX(35.0);
        contentLoadingBox.setLayoutY(51.0);
        contentLoadingBox.setPrefWidth(380.0);
        contentLoadingBox.setVisible(false);
        AnchorPane.setBottomAnchor((Node)contentLoadingBox, (Double)3.0);
        AnchorPane.setLeftAnchor((Node)contentLoadingBox, (Double)35.0);
        AnchorPane.setRightAnchor((Node)contentLoadingBox, (Double)0.0);
        AnchorPane.setTopAnchor((Node)contentLoadingBox, (Double)51.0);
        return contentLoadingBox;
    }

    private void displayLoadingBar(final boolean shouldShowLoadingBar) {
        if (this.isActivated() && this.plugin.existsGraphic()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    VBox contentBox = (VBox)DebugApp.this.stage.getScene().lookup("#contentBox");
                    VBox contentLoadingBox = (VBox)DebugApp.this.stage.getScene().lookup("#contentLoadingBox");
                    contentLoadingBox.getChildren().clear();
                    if (shouldShowLoadingBar) {
                        JFXSpinner spinner = new JFXSpinner();
                        spinner.setPrefSize(28.0, 28.0);
                        contentLoadingBox.getChildren().add((Object)spinner);
                    }
                    contentBox.setVisible(!shouldShowLoadingBar);
                    contentLoadingBox.setVisible(shouldShowLoadingBar);
                }
            };
            if (Platform.isFxApplicationThread()) {
                runnable.run();
            } else {
                Platform.runLater(() -> runnable.run());
            }
        }
    }

    private void loadPluginGraphic() {
        try {
            Node pluginContent;
            if (this.plugin.existsGraphic() && (pluginContent = this.plugin.getGraphic()) != null) {
                VBox contentBox = (VBox)this.stage.getScene().lookup("#contentBox");
                contentBox.getChildren().add((Object)new BorderPane(pluginContent));
                Separator contentLine = new Separator();
                contentLine.setPrefWidth(215.0);
                contentLine.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
                contentBox.getChildren().add((Object)contentLine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void clearPluginGraphic() {
        ((VBox)this.stage.getScene().lookup("#contentBox")).getChildren().clear();
        ((VBox)this.stage.getScene().lookup("#contentLoadingBox")).getChildren().clear();
        if (this.popOver != null) {
            this.popOver.hide();
        }
    }

    boolean isActivated() {
        JFXToggleButton togActivator = (JFXToggleButton)this.stage.getScene().lookup("#togActivator");
        return togActivator.selectedProperty().get();
    }

    void clearPluginGraphicAndDeactivate() throws Exception {
        this.clearPluginGraphic();
        this.plugin.pluginDeactivated();
    }

    private void activated() {
        this.displayLoadingBar(true);
        new Thread(() -> Platform.runLater(() -> {
            try {
                this.plugin.pluginActivated();
                this.loadPluginGraphic();
            }
            catch (Throwable e) {
                this.makeDisable(e, true);
            }
            finally {
                this.displayLoadingBar(false);
            }
            this.stage.getScene().getWindow().sizeToScene();
        })).start();
    }

    private void deactivated() {
        new Thread(() -> Platform.runLater(() -> {
            try {
                this.clearPluginGraphicAndDeactivate();
            }
            catch (Throwable e) {
                this.makeDisable(e, true);
            }
            this.stage.getScene().getWindow().sizeToScene();
        })).start();
    }

    static class RESTfulAPI
    extends org.silentsoft.net.rest.RESTfulAPI {
        RESTfulAPI() {
        }

        public static <T> T doGet(String uri, Object param, Class<T> returnType) throws Exception {
            return (T)RESTfulAPI.doGet((String)uri, (HttpHost)RESTfulAPI.getProxyHost(), (Object)param, returnType, request -> request.setHeaders(RESTfulAPI.createHeaders()));
        }

        public static <T> T doGet(String uri, Object param, Class<T> returnType, Consumer<HttpRequest> beforeRequest) throws Exception {
            return (T)RESTfulAPI.doGet((String)uri, (HttpHost)RESTfulAPI.getProxyHost(), (Object)param, returnType, request -> {
                if (beforeRequest != null) {
                    beforeRequest.accept((HttpRequest)request);
                }
                request.setHeaders(RESTfulAPI.createHeaders(request.getAllHeaders()));
            });
        }

        public static <T> T doGet(String uri, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
            return (T)RESTfulAPI.doGet((String)uri, (HttpHost)RESTfulAPI.getProxyHost(), null, request -> {
                if (beforeRequest != null) {
                    beforeRequest.accept((HttpRequest)request);
                }
                request.setHeaders(RESTfulAPI.createHeaders(request.getAllHeaders()));
            }, afterResponse);
        }

        public static <T> T doPost(String uri, Object param, Class<T> returnType) throws Exception {
            return (T)RESTfulAPI.doPost((String)uri, (HttpHost)RESTfulAPI.getProxyHost(), (Object)param, returnType, request -> request.setHeaders(RESTfulAPI.createHeaders()));
        }

        public static HttpHost getProxyHost() {
            HttpHost proxyHost;
            block4: {
                proxyHost = null;
                try {
                    if (debugParameter.getProxyHost() == null) {
                        List<Proxy> proxies = ProxySearch.getDefaultProxySearch().getProxySelector().select(URI.create("http://actlist.silentsoft.org"));
                        if (proxies == null || proxies.isEmpty()) break block4;
                        for (Proxy proxy : proxies) {
                            SocketAddress socketAddress = proxy.address();
                            if (!(socketAddress instanceof InetSocketAddress)) continue;
                            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                            proxyHost = new HttpHost(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                            break block4;
                        }
                        break block4;
                    }
                    URI uri = URI.create(debugParameter.getProxyHost());
                    proxyHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return proxyHost;
        }

        private static Header[] createHeaders() {
            return RESTfulAPI.createHeaders(null);
        }

        private static Header[] createHeaders(Header[] append) {
            ArrayList<Object> headers = new ArrayList<Object>();
            if (append != null) {
                headers.addAll(Arrays.asList(append));
            }
            headers.add(new BasicHeader("user-agent", userAgent.toString()));
            return headers.toArray(new Header[headers.size()]);
        }
    }
}

