/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin;

import com.github.plushaze.traynotification.animations.Animations;
import com.jfoenix.controls.JFXHamburger;
import com.jfoenix.controls.JFXSpinner;
import com.jfoenix.controls.JFXToggleButton;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.script.ScriptEngineManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.control.PopOver;
import org.silentsoft.actlist.application.App;
import org.silentsoft.actlist.comparator.VersionComparator;
import org.silentsoft.actlist.plugin.ActlistPlugin;
import org.silentsoft.actlist.plugin.PluginConfig;
import org.silentsoft.actlist.plugin.PluginManager;
import org.silentsoft.actlist.plugin.about.PluginAbout;
import org.silentsoft.actlist.plugin.messagebox.MessageBox;
import org.silentsoft.actlist.plugin.tray.TrayNotification;
import org.silentsoft.actlist.rest.RESTfulAPI;
import org.silentsoft.actlist.util.ConfigUtil;
import org.silentsoft.core.util.DateUtil;
import org.silentsoft.core.util.FileUtil;
import org.silentsoft.core.util.JSONUtil;
import org.silentsoft.core.util.ObjectUtil;
import org.silentsoft.core.util.SystemUtil;
import org.silentsoft.io.event.EventListener;
import org.silentsoft.io.memory.SharedMemory;

public class PluginComponent
implements EventListener {
    @FXML
    private AnchorPane root;
    @FXML
    private JFXHamburger hand;
    @FXML
    private HBox pluginLoadingBox;
    @FXML
    private Label lblPluginName;
    @FXML
    private Label warningLabel;
    @FXML
    private Label updateAlarmLabel;
    @FXML
    private JFXToggleButton togActivator;
    @FXML
    private VBox contentLoadingBox;
    @FXML
    private VBox contentBox;
    private String pluginFileName;
    private ActlistPlugin plugin;
    private PopOver popOver;
    private ObservableList<Node> functions;
    private HashMap<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> trayNotifications = new HashMap();
    private boolean isAvailableNewPlugin = false;
    private URI newPluginURI;
    private Stage aboutStage;
    private volatile Runnable checkForUpdates = () -> {
        block25: {
            try {
                boolean bl;
                boolean bl2;
                Object object;
                Object object2;
                Serializable serializable;
                URI uRI = this.plugin.getPluginUpdateCheckURI();
                if (uRI == null) break block25;
                Map map = null;
                ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
                arrayList.add(new BasicNameValuePair("version", this.plugin.getPluginVersion()));
                String string = uRI.toString();
                if (string.matches("(?i).*\\.js")) {
                    serializable = new StringBuffer();
                    ((StringBuffer)serializable).append(String.format("var version = '%s';", this.plugin.getPluginVersion())).append("\r\n");
                    ((StringBuffer)serializable).append(RESTfulAPI.doGet(uRI.toString(), arrayList, String.class, this.plugin.getBeforeRequest()));
                    object2 = new ScriptEngineManager().getEngineByName("nashorn");
                    object = object2.eval(((StringBuffer)serializable).toString());
                    if (object instanceof Map) {
                        map = (Map)object;
                    }
                } else {
                    map = RESTfulAPI.doGet(uRI.toString(), arrayList, Map.class, this.plugin.getBeforeRequest());
                }
                if (map == null) {
                    return;
                }
                if (map.containsKey("available")) {
                    this.isAvailableNewPlugin = Boolean.parseBoolean(String.valueOf(map.get("available")));
                    if (this.isAvailableNewPlugin) {
                        serializable = new AtomicReference<Object>(null);
                        object2 = this.plugin.getPluginArchivesURI();
                        if (object2 != null) {
                            this.newPluginURI = object2;
                        }
                        if (map.containsKey("url")) {
                            try {
                                this.newPluginURI = new URI(String.valueOf(map.get("url")));
                                this.plugin.setPluginArchivesURI(this.newPluginURI);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (this.newPluginURI != null) {
                            ((AtomicReference)serializable).set(() -> {
                                this.showAboutStage();
                                this.updateAlarmLabel.setVisible(false);
                            });
                        }
                        if (map.containsKey("jar")) {
                            object = String.valueOf(map.get("jar")).trim();
                            AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
                            if (map.containsKey("requiredActlist")) {
                                atomicReference.set(String.valueOf(map.get("requiredActlist")).trim());
                            }
                            ((AtomicReference)serializable).set(() -> this.lambda$null$48(atomicReference, (String)object));
                        }
                        if (((AtomicReference)serializable).get() != null) {
                            this.updateAlarmLabel.setOnMouseClicked(arg_0 -> PluginComponent.lambda$null$49((AtomicReference)serializable, arg_0));
                            this.updateAlarmLabel.setVisible(true);
                            this.playFadeTransition((Node)this.updateAlarmLabel);
                        } else {
                            this.updateAlarmLabel.setVisible(false);
                        }
                        try {
                            this.plugin.pluginUpdateFound();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                if (map.containsKey("killSwitch") && (bl2 = "on".equalsIgnoreCase(String.valueOf(map.get("killSwitch")).trim()))) {
                    object2 = "The plugin's kill switch has turned on by the author.";
                    this.makeDisable(new Exception((String)object2), false);
                    this.warningLabel.setOnMouseClicked(arg_0 -> PluginComponent.lambda$null$50((String)object2, arg_0));
                    this.warningLabel.setVisible(true);
                    this.playFadeTransition((Node)this.warningLabel);
                }
                if (map.containsKey("endOfService") && (bl = Boolean.parseBoolean(String.valueOf(map.get("endOfService"))))) {
                    this.warningLabel.setOnMouseClicked(mouseEvent -> MessageBox.showInformation((Object)App.getStage(), (String)"This plugin has reached end of service by the author."));
                    this.warningLabel.setVisible(true);
                    this.playFadeTransition((Node)this.warningLabel);
                }
            }
            catch (Error | Exception throwable) {
                throwable.printStackTrace();
            }
            finally {
                new Thread(() -> {
                    try {
                        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
                        arrayList.add(new BasicNameValuePair("uuid", ObjectUtil.toString((Object)this.plugin.getPluginStatisticsUUID())));
                        arrayList.add(new BasicNameValuePair("name", ObjectUtil.toString((Object)this.plugin.getPluginName())));
                        arrayList.add(new BasicNameValuePair("version", ObjectUtil.toString((Object)this.plugin.getPluginVersion())));
                        RESTfulAPI.doPost("http://actlist.silentsoft.org/api/plugin/statistics", arrayList);
                    }
                    catch (Error | Exception throwable) {
                        // empty catch block
                    }
                }).start();
            }
        }
    };

    public String getPluginFileName() {
        return this.pluginFileName;
    }

    public void initialize() {
    }

    public void initialize(String string, Class<? extends ActlistPlugin> clazz, boolean bl) {
        this.pluginFileName = string;
        new Thread(() -> {
            AtomicBoolean atomicBoolean = new AtomicBoolean(true);
            try {
                String string2;
                PluginConfig pluginConfig;
                this.makeConsumable();
                this.makeDraggable();
                this.applyDarkMode();
                this.popOver = new PopOver((Node)new VBox());
                ((VBox)this.popOver.getContentNode()).setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
                this.popOver.setArrowLocation(PopOver.ArrowLocation.TOP_LEFT);
                this.plugin = (ActlistPlugin)clazz.newInstance();
                ActlistPlugin.SupportedPlatform supportedPlatform = null;
                if (SystemUtil.isWindows()) {
                    supportedPlatform = ActlistPlugin.SupportedPlatform.WINDOWS;
                } else if (SystemUtil.isMac()) {
                    supportedPlatform = ActlistPlugin.SupportedPlatform.MACOSX;
                }
                this.plugin.currentPlatformObject().set((Object)supportedPlatform);
                ActlistPlugin.SupportedPlatform[] supportedPlatformArray = this.plugin.getSupportedPlatforms();
                if (supportedPlatformArray != null && supportedPlatformArray.length > 0 && !Arrays.asList(supportedPlatformArray).contains(supportedPlatform)) {
                    atomicBoolean.set(false);
                    List list = Arrays.stream(supportedPlatformArray).map(Enum::name).collect(Collectors.toList());
                    String string3 = String.join((CharSequence)"", "This plugin only supports ", String.join((CharSequence)", ", list));
                    Runnable runnable = () -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Error");
                        alert.setHeaderText("Unsupported platform");
                        alert.setContentText(string3);
                        alert.showAndWait();
                    };
                    this.lblPluginName.setOnMouseClicked(mouseEvent -> {
                        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                            runnable.run();
                        }
                    });
                    this.warningLabel.setOnMouseClicked(mouseEvent -> runnable.run());
                    this.warningLabel.setVisible(true);
                    this.playFadeTransition((Node)this.warningLabel);
                    throw new Exception(string3);
                }
                String string4 = this.plugin.getMinimumCompatibleVersion();
                if (string4 != null && VersionComparator.getInstance().compare("2.0.1", string4) < 0) {
                    atomicBoolean.set(false);
                    String string5 = String.join((CharSequence)"", "This plugin requires at least Actlist ", string4);
                    Runnable runnable = () -> {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("Confirmation");
                        alert.setHeaderText(string5);
                        alert.setContentText("Would you like to check latest Actlist now ?");
                        Optional optional = alert.showAndWait();
                        if (optional.isPresent() && optional.get() == ButtonType.OK) {
                            try {
                                Desktop.getDesktop().browse(new URI("http://actlist.silentsoft.org/archives/"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    this.lblPluginName.setOnMouseClicked(mouseEvent -> {
                        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                            runnable.run();
                        }
                    });
                    this.warningLabel.setOnMouseClicked(mouseEvent -> runnable.run());
                    this.warningLabel.setVisible(true);
                    this.playFadeTransition((Node)this.warningLabel);
                    throw new Exception(string5);
                }
                HashMap hashMap = (HashMap)SharedMemory.getDataMap().get((Object)"KEY_PLUGIN_MAP");
                this.plugin.classLoaderObject().set(hashMap.get(string));
                this.plugin.proxyHostObject().set((Object)RESTfulAPI.getProxyHost());
                this.plugin.darkModeProperty().set(ConfigUtil.isDarkMode());
                this.plugin.setPluginConfig(new PluginConfig(string));
                File file = Paths.get(System.getProperty("user.dir"), "plugins", "config", string.concat(".config")).toFile();
                if (file.exists() && (pluginConfig = (PluginConfig)JSONUtil.JSONToObject((String)(string2 = FileUtil.readFile((File)file)), PluginConfig.class)) != null) {
                    if (!string.equals(pluginConfig.getPlugin())) {
                        pluginConfig.setPlugin(string);
                        pluginConfig.commit();
                    }
                    this.plugin.setPluginConfig(pluginConfig);
                }
                Platform.runLater(() -> {
                    try {
                        String string2;
                        String string3 = this.plugin.getPluginName();
                        String string4 = this.plugin.getPluginDescription();
                        this.lblPluginName.setText(string3 == null || string3.trim().isEmpty() ? string : string3);
                        if (ObjectUtil.isNotEmpty((Object)string4)) {
                            this.lblPluginName.setTooltip(new Tooltip(string4));
                        }
                        if (ObjectUtil.isNotEmpty((Object)(string2 = this.plugin.getWarningText()))) {
                            this.warningLabel.setVisible(true);
                            this.playFadeTransition((Node)this.warningLabel);
                        } else {
                            this.warningLabel.setVisible(false);
                        }
                        if (this.plugin.isOneTimePlugin()) {
                            this.togActivator.setSelected(false);
                        } else {
                            this.togActivator.setSelected(bl);
                        }
                        this.plugin.shouldShowLoadingBar().addListener((observableValue, bl, bl2) -> {
                            if (bl == bl2) {
                                return;
                            }
                            this.displayLoadingBar((boolean)bl2);
                        });
                        this.plugin.exceptionObject().addListener((observableValue, throwable, throwable2) -> {
                            if (throwable2 != null) {
                                this.makeDisable((Throwable)throwable2, true);
                                this.plugin.exceptionObject().set(null);
                            }
                        });
                        this.plugin.showTrayNotificationObject().addListener((observableValue, trayNotification, trayNotification2) -> {
                            if (trayNotification2 != null) {
                                com.github.plushaze.traynotification.notification.TrayNotification trayNotification3 = new com.github.plushaze.traynotification.notification.TrayNotification();
                                Object object = this.trayNotifications;
                                synchronized (object) {
                                    this.trayNotifications.put((TrayNotification)trayNotification2, trayNotification3);
                                }
                                trayNotification3.setRectangleFill(Paint.valueOf((String)"#222222"));
                                trayNotification3.setImage(App.getIcons().get(4));
                                trayNotification3.setAnimation(Animations.POPUP);
                                object = this.plugin.getPluginName() == null || this.plugin.getPluginName().trim().isEmpty() ? string : this.plugin.getPluginName();
                                String string2 = String.format("[%s] ", object);
                                if (trayNotification2.getTitle() == null || trayNotification2.getTitle().trim().isEmpty()) {
                                    trayNotification3.setTitle(string2.concat(""));
                                } else {
                                    trayNotification3.setTitle(string2.concat(trayNotification2.getTitle()));
                                }
                                if (trayNotification2.getMessage() == null || trayNotification2.getMessage().trim().isEmpty()) {
                                    trayNotification3.setMessage("(empty message)");
                                } else {
                                    trayNotification3.setMessage(trayNotification2.getMessage());
                                }
                                trayNotification3.setOnDismiss((EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
                                    HashMap<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> hashMap = this.trayNotifications;
                                    synchronized (hashMap) {
                                        this.trayNotifications.remove(trayNotification2);
                                    }
                                    if (trayNotification2.getDuration() == null) {
                                        org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_BRING_TO_FRONT");
                                    }
                                }));
                                if (trayNotification2.getDuration() == null) {
                                    trayNotification3.showAndWait();
                                } else {
                                    trayNotification3.showAndDismiss(trayNotification2.getDuration());
                                }
                                this.plugin.showTrayNotificationObject().set(null);
                            }
                        });
                        Consumer<com.github.plushaze.traynotification.notification.TrayNotification> consumer = trayNotification -> new Thread(() -> {
                            while (!trayNotification.isTrayShowing()) {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (Exception exception) {}
                            }
                            Platform.runLater(() -> trayNotification.dismiss());
                        }).start();
                        this.plugin.dismissTrayNotificationObject().addListener((observableValue, trayNotification, trayNotification2) -> {
                            if (trayNotification2 != null) {
                                HashMap<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> hashMap = this.trayNotifications;
                                synchronized (hashMap) {
                                    if (this.trayNotifications.containsKey(trayNotification2)) {
                                        com.github.plushaze.traynotification.notification.TrayNotification trayNotification3 = this.trayNotifications.get(trayNotification2);
                                        consumer.accept(trayNotification3);
                                    }
                                }
                                this.plugin.dismissTrayNotificationObject().set(null);
                            }
                        });
                        this.plugin.shouldDismissTrayNotifications().addListener((observableValue, bl, bl2) -> {
                            if (bl2.booleanValue()) {
                                HashMap<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> hashMap = this.trayNotifications;
                                synchronized (hashMap) {
                                    for (Map.Entry<TrayNotification, com.github.plushaze.traynotification.notification.TrayNotification> entry : this.trayNotifications.entrySet()) {
                                        com.github.plushaze.traynotification.notification.TrayNotification trayNotification = entry.getValue();
                                        consumer.accept(trayNotification);
                                    }
                                    this.plugin.shouldDismissTrayNotifications().set(false);
                                }
                            }
                        });
                        this.plugin.shouldBrowseActlistArchives().addListener((observableValue, bl, bl2) -> {
                            if (bl2.booleanValue()) {
                                try {
                                    Desktop.getDesktop().browse(new URI("http://actlist.silentsoft.org/archives/"));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                this.plugin.shouldBrowseActlistArchives().set(false);
                            }
                        });
                        this.plugin.shouldRequestShowActlist().addListener((observableValue, bl, bl2) -> {
                            if (bl2.booleanValue()) {
                                if (App.isHidden()) {
                                    org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_SHOW_HIDE", (boolean)false);
                                }
                            } else if (App.isShown()) {
                                org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_SHOW_HIDE", (boolean)false);
                            }
                        });
                        this.plugin.shouldRequestDeactivate().addListener((observableValue, bl, bl2) -> {
                            if (bl2.booleanValue()) {
                                if (this.isActivated()) {
                                    this.togActivator.setSelected(false);
                                    this.deactivated();
                                }
                                this.plugin.shouldRequestDeactivate().set(false);
                            }
                        });
                        if (this.plugin.existsGraphic()) {
                            this.plugin.getGraphic();
                        }
                        this.plugin.initialize();
                        this.functions = FXCollections.observableArrayList();
                        for (ActlistPlugin.Function function : this.plugin.getFunctionMap().values()) {
                            this.addFunction(function);
                        }
                        if (bl && !this.plugin.isOneTimePlugin()) {
                            this.activated();
                        }
                        org.silentsoft.io.event.EventHandler.addListener((EventListener)this);
                    }
                    catch (Throwable throwable3) {
                        this.lblPluginName.setText(string);
                        this.makeDisable(throwable3, atomicBoolean.get());
                    }
                    finally {
                        this.pluginLoadingBox.setVisible(false);
                        new Thread(() -> {
                            boolean bl = true;
                            Date date = null;
                            while (this.plugin != null) {
                                if (bl) {
                                    this.checkForUpdates.run();
                                    date = Calendar.getInstance().getTime();
                                }
                                try {
                                    Thread.sleep((long)Duration.minutes((double)10.0).toMillis());
                                }
                                catch (InterruptedException interruptedException) {
                                    bl = DateUtil.getDifferenceHoursFromNow(date) >= 24;
                                    continue;
                                }
                                catch (Throwable throwable) {
                                    bl = DateUtil.getDifferenceHoursFromNow(date) >= 24;
                                    throw throwable;
                                }
                                bl = DateUtil.getDifferenceHoursFromNow((Date)date) >= 24;
                            }
                        }).start();
                    }
                });
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> {
                    this.lblPluginName.setText(string);
                    this.makeDisable(throwable, atomicBoolean.get());
                    this.pluginLoadingBox.setVisible(false);
                });
            }
        }).start();
    }

    private boolean isInitialized() {
        return this.plugin != null;
    }

    void clear() {
        if (this.isActivated()) {
            try {
                this.clearPluginGraphicAndDeactivate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isInitialized()) {
            this.plugin.classLoaderObject().set(null);
            this.plugin = null;
        }
    }

    private void playFadeTransition(Node node) {
        Runnable runnable = () -> {
            if (node.isVisible()) {
                FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)400.0), node);
                fadeTransition.setFromValue(1.0);
                fadeTransition.setToValue(0.3);
                fadeTransition.setCycleCount(6);
                fadeTransition.setAutoReverse(true);
                fadeTransition.play();
            }
        };
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater(() -> runnable.run());
        }
    }

    private void makeDisable(Throwable throwable, boolean bl) {
        if (bl) {
            throwable.printStackTrace();
        }
        new Thread(() -> {
            if (this.togActivator.selectedProperty().get()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Platform.runLater(() -> {
                this.lblPluginName.setCursor(Cursor.HAND);
                if (bl) {
                    Runnable runnable = () -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setTitle("Exception Dialog");
                        alert.setHeaderText(this.pluginFileName);
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        throwable.printStackTrace(printWriter);
                        String string = stringWriter.toString();
                        TextArea textArea = new TextArea(string);
                        textArea.setEditable(false);
                        textArea.setWrapText(true);
                        textArea.setMaxWidth(Double.MAX_VALUE);
                        textArea.setMaxHeight(Double.MAX_VALUE);
                        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
                        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
                        GridPane gridPane = new GridPane();
                        gridPane.setMaxWidth(Double.MAX_VALUE);
                        gridPane.add((Node)textArea, 0, 0);
                        alert.getDialogPane().setContent((Node)gridPane);
                        alert.showAndWait();
                    };
                    this.lblPluginName.setTooltip(new Tooltip("Click to show the exception log."));
                    this.lblPluginName.setOnMouseClicked(mouseEvent -> {
                        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                            runnable.run();
                        }
                    });
                    this.warningLabel.setOnMouseClicked(mouseEvent -> runnable.run());
                    this.warningLabel.setVisible(true);
                    this.playFadeTransition((Node)this.warningLabel);
                } else {
                    this.lblPluginName.setTooltip(new Tooltip(throwable.getMessage()));
                }
                this.togActivator.setUnToggleLineColor(Paint.valueOf((String)"#da4242"));
                this.togActivator.setDisable(true);
                this.togActivator.setOpacity(1.0);
                this.togActivator.setSelected(false);
                this.clearPluginGraphic();
                org.silentsoft.io.event.EventHandler.removeListener((EventListener)this);
            });
        }).start();
    }

    private void makeConsumable() {
        this.root.addEventHandler(MouseEvent.MOUSE_RELEASED, mouseEvent -> mouseEvent.consume());
    }

    private void makeDraggable() {
        this.hand.setOnDragDetected(mouseEvent -> {
            this.createSnapshot((MouseEvent)mouseEvent);
            this.root.startFullDrag();
        });
        this.root.addEventFilter(MouseDragEvent.MOUSE_DRAG_ENTERED, mouseDragEvent -> {
            VBox vBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
            if (vBox.getUserData() != null) {
                if (ConfigUtil.isDarkMode()) {
                    this.root.setStyle("-fx-background-color: #2d2d2d;");
                } else {
                    this.root.setStyle("-fx-background-color: #f2f2f2;");
                }
            }
        });
        this.root.addEventFilter(MouseDragEvent.MOUSE_DRAG_RELEASED, mouseDragEvent -> {
            VBox vBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
            if (vBox.getUserData() != null) {
                HashMap hashMap = (HashMap)vBox.getUserData();
                int n = vBox.getChildren().indexOf(hashMap.get("dragging"));
                int n2 = vBox.getChildren().indexOf((Object)this.root);
                if (n >= 0 && n2 >= 0) {
                    Node node = (Node)vBox.getChildren().remove(n);
                    vBox.getChildren().add(n2, (Object)node);
                }
                this.deleteSnapshot();
                org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_SAVE_PRIORITY_OF_PLUGINS");
            }
        });
        this.root.addEventFilter(MouseDragEvent.MOUSE_DRAG_EXITED, mouseDragEvent -> {
            if (ConfigUtil.isDarkMode()) {
                this.root.setStyle("-fx-background-color: rgb(40, 40, 40);");
            } else {
                this.root.setStyle("-fx-background-color: #ffffff;");
            }
        });
        this.hand.setOnMouseReleased(mouseEvent -> this.deleteSnapshot());
    }

    private void applyDarkMode() {
        this.hand.setOpacity(ConfigUtil.isDarkMode() ? 1.0 : 0.2);
        String string = ConfigUtil.isDarkMode() ? "-fx-background-color: rgb(40, 40, 40);" : "-fx-background-color: #ffffff;";
        this.root.setStyle(string);
        this.pluginLoadingBox.setStyle(string);
        this.contentLoadingBox.setStyle(string);
    }

    private void createSnapshot(MouseEvent mouseEvent) {
        ImageView imageView = new ImageView((Image)this.root.snapshot(null, null));
        imageView.setManaged(false);
        imageView.setMouseTransparent(true);
        imageView.setEffect((Effect)new DropShadow(3.0, 0.0, 1.5, Color.valueOf((String)"#333333")));
        imageView.setVisible(false);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("snapshot", imageView);
        hashMap.put("dragging", this.root);
        VBox vBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
        vBox.getChildren().add((Object)imageView);
        vBox.setUserData(hashMap);
        vBox.setOnMouseDragged(mouseEvent2 -> {
            imageView.setVisible(true);
            imageView.relocate(mouseEvent2.getX() - mouseEvent.getX(), mouseEvent2.getY() - mouseEvent.getY());
        });
    }

    private void deleteSnapshot() {
        VBox vBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
        vBox.setOnMouseDragged(null);
        if (vBox.getUserData() != null) {
            HashMap hashMap = (HashMap)vBox.getUserData();
            vBox.getChildren().remove(hashMap.get("snapshot"));
        }
        vBox.setUserData(null);
    }

    private void addFunction(ActlistPlugin.Function function) {
        this.functions.add((Object)this.createFunctionBox(function.graphic, (EventHandler<? super MouseEvent>)((EventHandler)mouseEvent -> {
            try {
                if (function.action != null) {
                    function.action.run();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        })));
    }

    private HBox createFunctionBox(Node node, EventHandler<? super MouseEvent> eventHandler) {
        HBox hBox = new HBox(new Node[]{node});
        hBox.setAlignment(Pos.CENTER);
        hBox.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        hBox.setStyle("-fx-background-color: #fbfbfb;");
        hBox.setOnMouseEntered(mouseEvent -> hBox.setStyle("-fx-background-color: lightgray;"));
        hBox.setOnMouseExited(mouseEvent -> hBox.setStyle("-fx-background-color: #fbfbfb;"));
        hBox.addEventFilter(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
            try {
                this.popOver.hide();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new Thread(() -> Platform.runLater(() -> {
                try {
                    if (eventHandler != null) {
                        eventHandler.handle(mouseEvent);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            })).start();
        });
        return hBox;
    }

    private HBox createAboutFunction() {
        return this.createFunctionBox((Node)new Label("About"), (EventHandler<? super MouseEvent>)((EventHandler)mouseEvent -> this.showAboutStage()));
    }

    @FXML
    private void showAboutStage() {
        if (this.aboutStage != null) {
            this.aboutStage.close();
            this.aboutStage = null;
        }
        this.aboutStage = new Stage();
        this.aboutStage.initOwner((Window)App.getStage());
        this.aboutStage.initStyle(StageStyle.UTILITY);
        BorderPane borderPane = new BorderPane();
        borderPane.setCenter((Node)new PluginAbout(this.plugin, this.isAvailableNewPlugin, this.newPluginURI).getViewer());
        this.aboutStage.setScene(new Scene((Parent)borderPane));
        this.aboutStage.show();
    }

    @FXML
    private void showWarningText() {
        this.warningLabel.setVisible(false);
        try {
            String string = this.plugin.getWarningText();
            if (ObjectUtil.isNotEmpty((Object)string)) {
                MessageBox.showWarning((Object)App.getStage(), (String)string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private HBox createCheckForUpdatesFunction() {
        return this.createFunctionBox((Node)new Label("Check for updates"), (EventHandler<? super MouseEvent>)((EventHandler)mouseEvent -> {
            this.pluginLoadingBox.setVisible(true);
            this.displayLoadingBar(true);
            new Thread(() -> {
                this.checkForUpdates.run();
                this.pluginLoadingBox.setVisible(false);
                this.displayLoadingBar(false);
            }).start();
        }));
    }

    private HBox createDeleteFunction() {
        Label label = new Label("Delete");
        label.setTextFill(Paint.valueOf((String)"#db0018"));
        return this.createFunctionBox((Node)label, (EventHandler<? super MouseEvent>)((EventHandler)mouseEvent -> {
            Optional optional = MessageBox.showConfirm((Object)App.getStage(), (String)"Are you sure you want to delete this plugin? You may need to restart the application for the best effect.");
            if (optional.isPresent() && optional.get() == ButtonType.OK) {
                try {
                    PluginManager.delete(this.pluginFileName);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    MessageBox.showError((Object)App.getStage(), (String)exception.getMessage());
                }
            }
        }));
    }

    private void displayLoadingBar(final boolean bl) {
        if (this.isActivated() && this.plugin.existsGraphic()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PluginComponent.this.contentLoadingBox.getChildren().clear();
                    if (bl) {
                        JFXSpinner jFXSpinner = new JFXSpinner();
                        jFXSpinner.setPrefSize(28.0, 28.0);
                        PluginComponent.this.contentLoadingBox.getChildren().add((Object)jFXSpinner);
                    }
                    PluginComponent.this.contentBox.setVisible(!bl);
                    PluginComponent.this.contentLoadingBox.setVisible(bl);
                }
            };
            if (Platform.isFxApplicationThread()) {
                runnable.run();
            } else {
                Platform.runLater(() -> runnable.run());
            }
        }
    }

    @FXML
    private void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == MouseButton.SECONDARY) {
            ((VBox)this.popOver.getContentNode()).getChildren().clear();
            if (this.isInitialized()) {
                ((VBox)this.popOver.getContentNode()).getChildren().add((Object)this.createAboutFunction());
                if (this.isActivated()) {
                    if (this.plugin.getFunctionMap().size() > 0) {
                        ((VBox)this.popOver.getContentNode()).getChildren().add((Object)this.createCustomSeparator());
                    }
                    ((VBox)this.popOver.getContentNode()).getChildren().addAll(this.functions);
                }
                ((VBox)this.popOver.getContentNode()).getChildren().add((Object)this.createCustomSeparator());
                ((VBox)this.popOver.getContentNode()).getChildren().add((Object)this.createCheckForUpdatesFunction());
            }
            ((VBox)this.popOver.getContentNode()).getChildren().add((Object)this.createDeleteFunction());
            this.popOver.show((Window)App.getStage(), mouseEvent.getScreenX() - 40.0, mouseEvent.getScreenY() - 10.0);
        }
    }

    private Separator createCustomSeparator() {
        Separator separator = new Separator(Orientation.HORIZONTAL);
        separator.setStyle("-fx-padding: 0.083333em 0.0em 0.0em 0.0em;");
        return separator;
    }

    @FXML
    private void toggleOnAction() {
        if (this.isActivated()) {
            this.activated();
        } else {
            this.deactivated();
        }
    }

    private void loadPluginGraphic() {
        try {
            Node node;
            if (this.plugin.existsGraphic() && (node = this.plugin.getGraphic()) != null) {
                this.contentBox.getChildren().add((Object)new BorderPane(node));
                Separator separator = new Separator();
                separator.setPrefWidth(215.0);
                separator.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
                this.contentBox.getChildren().add((Object)separator);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void clearPluginGraphic() {
        this.contentBox.getChildren().clear();
        this.contentLoadingBox.getChildren().clear();
        if (this.popOver != null) {
            this.popOver.hide();
        }
    }

    boolean isActivated() {
        return this.togActivator.selectedProperty().get();
    }

    void clearPluginGraphicAndDeactivate() throws Exception {
        this.clearPluginGraphic();
        this.plugin.pluginDeactivated();
    }

    private void activated() {
        this.displayLoadingBar(true);
        new Thread(() -> Platform.runLater(() -> {
            try {
                this.plugin.pluginActivated();
                this.loadPluginGraphic();
                if (!this.plugin.isOneTimePlugin()) {
                    List list = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
                    list.remove(this.pluginFileName);
                    org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_SAVE_DEACTIVATED_PLUGINS");
                }
            }
            catch (Throwable throwable) {
                this.makeDisable(throwable, true);
            }
            finally {
                this.displayLoadingBar(false);
            }
        })).start();
    }

    private void deactivated() {
        new Thread(() -> Platform.runLater(() -> {
            try {
                if (!this.plugin.isOneTimePlugin()) {
                    List list = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
                    list.add(this.pluginFileName);
                    org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_SAVE_DEACTIVATED_PLUGINS");
                }
                this.clearPluginGraphicAndDeactivate();
            }
            catch (Throwable throwable) {
                this.makeDisable(throwable, true);
            }
        })).start();
    }

    public void onEvent(String string) {
        if (this.isActivated()) {
            try {
                switch (string) {
                    case "EVENT_APPLICATION_ACTIVATED": {
                        this.plugin.applicationActivated();
                        break;
                    }
                    case "EVENT_APPLICATION_DEACTIVATED": {
                        this.plugin.applicationDeactivated();
                        break;
                    }
                    case "EVENT_APPLICATION_CLOSE_REQUESTED": {
                        this.plugin.applicationCloseRequested();
                        break;
                    }
                    case "EVENT_UPDATE_PROXY_HOST": {
                        this.plugin.proxyHostObject().set((Object)RESTfulAPI.getProxyHost());
                        this.plugin.applicationConfigChanged();
                        break;
                    }
                    case "EVENT_APPLY_DARK_MODE": {
                        this.plugin.darkModeProperty().set(ConfigUtil.isDarkMode());
                        this.plugin.applicationConfigChanged();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            switch (string) {
                case "EVENT_APPLY_DARK_MODE": {
                    this.applyDarkMode();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static /* synthetic */ void lambda$null$50(String string, MouseEvent mouseEvent) {
        MessageBox.showInformation((Object)App.getStage(), (String)string);
    }

    private static /* synthetic */ void lambda$null$49(AtomicReference atomicReference, MouseEvent mouseEvent) {
        ((Runnable)atomicReference.get()).run();
    }

    private /* synthetic */ void lambda$null$48(AtomicReference atomicReference, String string) {
        AtomicBoolean atomicBoolean;
        boolean bl = false;
        try {
            if (atomicReference.get() != null && !((String)atomicReference.get()).isEmpty() && VersionComparator.getInstance().compare("2.0.1", (String)atomicReference.get()) < 0) {
                atomicBoolean = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
                ButtonType buttonType = new ButtonType("Update anyway", ButtonBar.ButtonData.OK_DONE);
                Alert alert = new Alert(Alert.AlertType.NONE);
                alert.setTitle("Warning");
                alert.getDialogPane().getStyleClass().add((Object)"warning");
                alert.setHeaderText(String.join((CharSequence)"", "This update requires at least Actlist ", (CharSequence)atomicReference.get()));
                alert.setContentText("This update may cause the plugin to crash. Do you want to update anyway ?");
                alert.getButtonTypes().addAll((Object[])new ButtonType[]{atomicBoolean, buttonType});
                Optional optional = alert.showAndWait();
                if (optional.isPresent() && optional.get() != buttonType) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            this.updateAlarmLabel.setVisible(false);
            return;
        }
        atomicBoolean = new AtomicBoolean(false);
        this.pluginLoadingBox.setVisible(true);
        this.displayLoadingBar(true);
        new Thread(() -> {
            AtomicBoolean atomicBoolean2 = new AtomicBoolean(false);
            AtomicReference atomicReference = new AtomicReference();
            try {
                RESTfulAPI.doGet(string, this.plugin.getBeforeRequest(), httpResponse -> {
                    block14: {
                        try {
                            Object object;
                            Object object2;
                            HttpEntity httpEntity = httpResponse.getEntity();
                            if (httpEntity == null) break block14;
                            InputStream inputStream = httpEntity.getContent();
                            String string2 = UUID.randomUUID().toString().replaceAll("-", "");
                            Path path = Paths.get(System.getProperty("java.io.tmpdir"), string2.concat(".partial"));
                            if (Files.notExists(path.getParent(), new LinkOption[0])) {
                                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                            }
                            Files.createFile(path, new FileAttribute[0]);
                            FileOutputStream fileOutputStream = new FileOutputStream(path.toString());
                            IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                            ((OutputStream)fileOutputStream).close();
                            new JarFile(path.toString()).close();
                            String string3 = "";
                            try {
                                object2 = httpResponse.getFirstHeader("Content-Disposition");
                                if (object2 != null && object2.getValue() != null) {
                                    string3 = URLDecoder.decode(StringUtils.substringAfterLast((String)object2.getValue().toLowerCase().replaceAll("\"", ""), (String)"filename="), "UTF-8").trim();
                                }
                            }
                            catch (Exception exception) {
                            }
                            finally {
                                if (ObjectUtil.isEmpty((Object)string3)) {
                                    string3 = String.valueOf(Paths.get(URI.create(string).getPath(), new String[0]).getFileName());
                                }
                                if (ObjectUtil.isEmpty((Object)string3)) {
                                    string3 = UUID.randomUUID().toString().replaceAll("-", "");
                                }
                            }
                            if (!string3.toLowerCase().endsWith(".jar")) {
                                string3 = string3.concat(".jar");
                            }
                            if (Files.exists((Path)(object2 = Paths.get(System.getProperty("user.dir"), "plugins", string3)), new LinkOption[0])) {
                                object2 = Paths.get(System.getProperty("user.dir"), "plugins", string2.concat(".jar"));
                            }
                            String string4 = String.valueOf(object2.getFileName());
                            Files.move(path, (Path)object2, new CopyOption[0]);
                            Path path2 = Paths.get(System.getProperty("user.dir"), "plugins", "config", this.pluginFileName.concat(".config"));
                            if (Files.exists(path2, new LinkOption[0])) {
                                object = Paths.get(System.getProperty("user.dir"), "plugins", "config", string4.concat(".config"));
                                Files.copy(path2, (Path)object, StandardCopyOption.REPLACE_EXISTING);
                            }
                            object = new CountDownLatch(1);
                            Platform.runLater(() -> this.lambda$null$44(string4, (CountDownLatch)object));
                            ((CountDownLatch)object).await();
                            atomicBoolean.set(true);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            atomicReference.set(exception);
                        }
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
                atomicBoolean2.set(true);
            }
            if (!atomicBoolean.get()) {
                Platform.runLater(() -> {
                    this.pluginLoadingBox.setVisible(false);
                    this.displayLoadingBar(false);
                    this.updateAlarmLabel.setVisible(false);
                });
                if (atomicBoolean2.get()) {
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(URI.create(string));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                } else {
                    MessageBox.showException((Object)App.getStage(), (String)"Failed to update", (Throwable)((Throwable)atomicReference.get()));
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$null$44(String string, CountDownLatch countDownLatch) {
        try {
            VBox vBox;
            VBox vBox2 = vBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
            synchronized (vBox2) {
                int n = vBox.getChildren().indexOf((Object)this.root);
                if (!this.isActivated()) {
                    List list = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
                    list.add(string);
                    org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_SAVE_DEACTIVATED_PLUGINS");
                }
                PluginManager.delete(this.pluginFileName);
                PluginManager.load(string, this.isActivated(), n);
                org.silentsoft.io.event.EventHandler.callEvent(this.getClass(), (String)"EVENT_SAVE_PRIORITY_OF_PLUGINS");
            }
        }
        catch (Error | Exception throwable) {
            throwable.printStackTrace();
        }
        finally {
            countDownLatch.countDown();
        }
    }
}

