/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.net.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.markusbernhardt.proxy.ProxySearch;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.silentsoft.net.http.HttpClientFactory;
import org.silentsoft.net.item.StoreItem;
import org.silentsoft.net.pojo.FilePOJO;
import org.slf4j.helpers.MessageFormatter;

public class HttpClientManager {
    static boolean useDefaultProxy = false;
    static HttpHost proxyHost;

    public static boolean isUseDefaultProxy() {
        return useDefaultProxy;
    }

    public static void setUseDefaultProxy(boolean useDefaultProxy) {
        HttpClientManager.useDefaultProxy = useDefaultProxy;
    }

    private static HttpHost getDefaultProxyHost(String dummyUri) {
        List<Proxy> proxies;
        if (useDefaultProxy && proxyHost == null && (proxies = ProxySearch.getDefaultProxySearch().getProxySelector().select(URI.create(dummyUri))) != null && !proxies.isEmpty()) {
            for (Proxy proxy : proxies) {
                SocketAddress socketAddress = proxy.address();
                if (!(socketAddress instanceof InetSocketAddress)) continue;
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                proxyHost = new HttpHost(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                break;
            }
        }
        return proxyHost;
    }

    public static <T> T doGet(String uri, Class<T> returnType) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, null, null, returnType, null, null, null);
    }

    public static <T> T doGet(String uri, Class<T> returnType, String charsetName) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, null, null, returnType, charsetName, null, null);
    }

    public static <T> T doGet(String uri, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, null, null, returnType, charsetName, beforeRequest, null);
    }

    public static <T> T doGet(String uri, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, null, null, returnType, charsetName, beforeRequest, afterResponse);
    }

    public static <T> T doGet(String uri, HttpHost proxy, Class<T> returnType) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, proxy, null, returnType, null, null, null);
    }

    public static <T> T doGet(String uri, HttpHost proxy, Class<T> returnType, String charsetName) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, proxy, null, returnType, charsetName, null, null);
    }

    public static <T> T doGet(String uri, HttpHost proxy, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, proxy, null, returnType, charsetName, beforeRequest, null);
    }

    public static <T> T doGet(String uri, HttpHost proxy, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, proxy, null, returnType, charsetName, beforeRequest, afterResponse);
    }

    public static <T> T doGet(String uri, Object param, Class<T> returnType) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, null, param, returnType, null, null, null);
    }

    public static <T> T doGet(String uri, Object param, Class<T> returnType, String charsetName) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, null, param, returnType, charsetName, null, null);
    }

    public static <T> T doGet(String uri, Object param, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, null, param, returnType, charsetName, beforeRequest, null);
    }

    public static <T> T doGet(String uri, Object param, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, null, param, returnType, charsetName, beforeRequest, afterResponse);
    }

    public static <T> T doGet(String uri, HttpHost proxy, Object param, Class<T> returnType) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, proxy, param, returnType, null, null, null);
    }

    public static <T> T doGet(String uri, HttpHost proxy, Object param, Class<T> returnType, String charsetName) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, proxy, param, returnType, charsetName, null, null);
    }

    public static <T> T doGet(String uri, HttpHost proxy, Object param, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, proxy, param, returnType, charsetName, beforeRequest, null);
    }

    public static <T> T doGet(String uri, HttpHost proxy, Object param, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, proxy, param, returnType, charsetName, beforeRequest, afterResponse);
    }

    public static <T> T doGet(String uri, Class<T> returnType, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, null, null, returnType, null, beforeRequest, null);
    }

    public static <T> T doGet(String uri, Class<T> returnType, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, null, null, returnType, null, beforeRequest, afterResponse);
    }

    public static <T> T doGet(String uri, Object param, Class<T> returnType, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, null, param, returnType, null, beforeRequest, null);
    }

    public static <T> T doGet(String uri, Object param, Class<T> returnType, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, null, param, returnType, null, beforeRequest, afterResponse);
    }

    public static <T> T doGet(String uri, HttpHost proxy, Class<T> returnType, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, proxy, null, returnType, null, beforeRequest, null);
    }

    public static <T> T doGet(String uri, HttpHost proxy, Class<T> returnType, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, proxy, null, returnType, null, beforeRequest, afterResponse);
    }

    public static <T> T doGet(String uri, HttpHost proxy, Object param, Class<T> returnType, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, proxy, param, returnType, null, beforeRequest, null);
    }

    public static <T> T doGet(String uri, HttpHost proxy, Object param, Class<T> returnType, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.GET, uri, proxy, param, returnType, null, beforeRequest, afterResponse);
    }

    public static <T> T doPost(String uri, Class<T> returnType) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, null, null, returnType, null, null, null);
    }

    public static <T> T doPost(String uri, Class<T> returnType, String charsetName) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, null, null, returnType, charsetName, null, null);
    }

    public static <T> T doPost(String uri, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, null, null, returnType, charsetName, beforeRequest, null);
    }

    public static <T> T doPost(String uri, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, null, null, returnType, charsetName, beforeRequest, afterResponse);
    }

    public static <T> T doPost(String uri, HttpHost proxy, Class<T> returnType) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, proxy, null, returnType, null, null, null);
    }

    public static <T> T doPost(String uri, HttpHost proxy, Class<T> returnType, String charsetName) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, proxy, null, returnType, charsetName, null, null);
    }

    public static <T> T doPost(String uri, HttpHost proxy, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, proxy, null, returnType, charsetName, beforeRequest, null);
    }

    public static <T> T doPost(String uri, HttpHost proxy, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, proxy, null, returnType, charsetName, beforeRequest, afterResponse);
    }

    public static <T> T doPost(String uri, Object param, Class<T> returnType) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, null, param, returnType, null, null, null);
    }

    public static <T> T doPost(String uri, Object param, Class<T> returnType, String charsetName) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, null, param, returnType, charsetName, null, null);
    }

    public static <T> T doPost(String uri, Object param, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, null, param, returnType, charsetName, beforeRequest, null);
    }

    public static <T> T doPost(String uri, Object param, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, null, param, returnType, charsetName, beforeRequest, afterResponse);
    }

    public static <T> T doPost(String uri, HttpHost proxy, Object param, Class<T> returnType) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, proxy, param, returnType, null, null, null);
    }

    public static <T> T doPost(String uri, HttpHost proxy, Object param, Class<T> returnType, String charsetName) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, proxy, param, returnType, charsetName, null, null);
    }

    public static <T> T doPost(String uri, HttpHost proxy, Object param, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, proxy, param, returnType, charsetName, beforeRequest, null);
    }

    public static <T> T doPost(String uri, HttpHost proxy, Object param, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, proxy, param, returnType, charsetName, beforeRequest, afterResponse);
    }

    public static <T> T doPost(String uri, Class<T> returnType, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, null, null, returnType, null, beforeRequest, null);
    }

    public static <T> T doPost(String uri, Class<T> returnType, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, null, null, returnType, null, beforeRequest, afterResponse);
    }

    public static <T> T doPost(String uri, Object param, Class<T> returnType, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, null, param, returnType, null, beforeRequest, null);
    }

    public static <T> T doPost(String uri, Object param, Class<T> returnType, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, null, param, returnType, null, beforeRequest, afterResponse);
    }

    public static <T> T doPost(String uri, HttpHost proxy, Class<T> returnType, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, proxy, null, returnType, null, beforeRequest, null);
    }

    public static <T> T doPost(String uri, HttpHost proxy, Class<T> returnType, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, proxy, null, returnType, null, beforeRequest, afterResponse);
    }

    public static <T> T doPost(String uri, HttpHost proxy, Object param, Class<T> returnType, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, proxy, param, returnType, null, beforeRequest, null);
    }

    public static <T> T doPost(String uri, HttpHost proxy, Object param, Class<T> returnType, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.POST, uri, proxy, param, returnType, null, beforeRequest, afterResponse);
    }

    public static <T> T doMultipart(String uri, Class<T> returnType) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, null, null, returnType, null, null, null);
    }

    public static <T> T doMultipart(String uri, Class<T> returnType, String charsetName) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, null, null, returnType, charsetName, null, null);
    }

    public static <T> T doMultipart(String uri, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, null, null, returnType, charsetName, beforeRequest, null);
    }

    public static <T> T doMultipart(String uri, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, null, null, returnType, charsetName, beforeRequest, afterResponse);
    }

    public static <T> T doMultipart(String uri, HttpHost proxy, Class<T> returnType) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, proxy, null, returnType, null, null, null);
    }

    public static <T> T doMultipart(String uri, HttpHost proxy, Class<T> returnType, String charsetName) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, proxy, null, returnType, charsetName, null, null);
    }

    public static <T> T doMultipart(String uri, HttpHost proxy, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, proxy, null, returnType, charsetName, beforeRequest, null);
    }

    public static <T> T doMultipart(String uri, HttpHost proxy, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, proxy, null, returnType, charsetName, beforeRequest, afterResponse);
    }

    public static <T> T doMultipart(String uri, Object param, Class<T> returnType) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, null, param, returnType, null, null, null);
    }

    public static <T> T doMultipart(String uri, Object param, Class<T> returnType, String charsetName) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, null, param, returnType, charsetName, null, null);
    }

    public static <T> T doMultipart(String uri, Object param, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, null, param, returnType, charsetName, beforeRequest, null);
    }

    public static <T> T doMultipart(String uri, Object param, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, null, param, returnType, charsetName, beforeRequest, afterResponse);
    }

    public static <T> T doMultipart(String uri, HttpHost proxy, Object param, Class<T> returnType) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, proxy, param, returnType, null, null, null);
    }

    public static <T> T doMultipart(String uri, HttpHost proxy, Object param, Class<T> returnType, String charsetName) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, proxy, param, returnType, charsetName, null, null);
    }

    public static <T> T doMultipart(String uri, HttpHost proxy, Object param, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, proxy, param, returnType, charsetName, beforeRequest, null);
    }

    public static <T> T doMultipart(String uri, HttpHost proxy, Object param, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, proxy, param, returnType, charsetName, beforeRequest, afterResponse);
    }

    public static <T> T doMultipart(String uri, Class<T> returnType, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, null, null, returnType, null, beforeRequest, null);
    }

    public static <T> T doMultipart(String uri, Class<T> returnType, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, null, null, returnType, null, beforeRequest, afterResponse);
    }

    public static <T> T doMultipart(String uri, Object param, Class<T> returnType, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, null, param, returnType, null, beforeRequest, null);
    }

    public static <T> T doMultipart(String uri, Object param, Class<T> returnType, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, null, param, returnType, null, beforeRequest, afterResponse);
    }

    public static <T> T doMultipart(String uri, HttpHost proxy, Class<T> returnType, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, proxy, null, returnType, null, beforeRequest, null);
    }

    public static <T> T doMultipart(String uri, HttpHost proxy, Class<T> returnType, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, proxy, null, returnType, null, beforeRequest, afterResponse);
    }

    public static <T> T doMultipart(String uri, HttpHost proxy, Object param, Class<T> returnType, Consumer<HttpRequest> beforeRequest) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, proxy, param, returnType, null, beforeRequest, null);
    }

    public static <T> T doMultipart(String uri, HttpHost proxy, Object param, Class<T> returnType, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        return HttpClientManager.doAction(RequestType.MULTIPART, uri, proxy, param, returnType, null, beforeRequest, afterResponse);
    }

    private static <T> T doAction(RequestType requestType, String uri, HttpHost proxy, Object param, Class<T> returnType, String charsetName, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws Exception {
        Object returnValue = null;
        HttpGet httpGet = null;
        HttpPost httpPost = null;
        HttpEntity httpEntity = null;
        CloseableHttpResponse httpResponse = null;
        String _charsetName = charsetName == null || "".equals(charsetName) ? "UTF-8" : charsetName;
        try {
            switch (requestType) {
                case GET: {
                    httpGet = new HttpGet(uri);
                    if (proxy == null) {
                        proxy = HttpClientManager.getDefaultProxyHost(uri);
                    }
                    if (proxy != null) {
                        httpGet.setConfig(RequestConfig.custom().setProxy(proxy).build());
                    }
                    if (param != null && HttpClientManager.isUrlEncodedFormEntity(param)) {
                        httpGet.setURI(new URIBuilder(httpGet.getURI()).addParameters((List)param).build());
                    }
                    httpResponse = HttpClientManager.execute((HttpUriRequest)httpGet, beforeRequest, afterResponse);
                    break;
                }
                case POST: {
                    httpPost = new HttpPost(uri);
                    if (proxy == null) {
                        proxy = HttpClientManager.getDefaultProxyHost(uri);
                    }
                    if (proxy != null) {
                        httpPost.setConfig(RequestConfig.custom().setProxy(proxy).build());
                    }
                    if (param != null) {
                        if (HttpClientManager.isUrlEncodedFormEntity(param)) {
                            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity((Iterable)((List)param), Charset.forName(_charsetName));
                            urlEncodedFormEntity.setContentType("application/x-www-form-urlencoded; charset=".concat(_charsetName));
                            httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
                        } else {
                            String json = "";
                            json = param instanceof String ? new JSONObject((String)param).toString() : new ObjectMapper().writeValueAsString(param);
                            StringEntity stringEntity = new StringEntity(json, Charset.forName(_charsetName));
                            stringEntity.setContentType("application/json; charset=".concat(_charsetName));
                            httpPost.setEntity((HttpEntity)stringEntity);
                        }
                    }
                    httpResponse = HttpClientManager.execute((HttpUriRequest)httpPost, beforeRequest, afterResponse);
                    break;
                }
                case MULTIPART: {
                    ObjectBackupManager bytesBackupManager;
                    ObjectBackupManager fileBackupManager;
                    MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setCharset(Charset.forName(_charsetName));
                    if (param instanceof StoreItem) {
                        StoreItem storeItem = (StoreItem)param;
                        boolean hasContainsDirectory = storeItem.stream().anyMatch(filePOJO -> filePOJO.isDirectory());
                        if (hasContainsDirectory) {
                            throw new Exception("Cannot contain directory to StoreItem !");
                        }
                        fileBackupManager = new ObjectBackupManager();
                        bytesBackupManager = new ObjectBackupManager();
                        for (FilePOJO filePOJO2 : storeItem) {
                            if (!filePOJO2.isDirectory() && filePOJO2.getFile() != null) {
                                multipartEntityBuilder.addBinaryBody("binary", filePOJO2.getFile(), ContentType.APPLICATION_OCTET_STREAM, filePOJO2.getNameWithExtension());
                            }
                            fileBackupManager.backup(filePOJO2, filePOJO2.getFile());
                            bytesBackupManager.backup(filePOJO2, filePOJO2.getBytes());
                            filePOJO2.setFile(null);
                            filePOJO2.setBytes(null);
                        }
                        multipartEntityBuilder.addTextBody("json", new ObjectMapper().writeValueAsString((Object)storeItem), ContentType.APPLICATION_JSON);
                        for (FilePOJO filePOJO2 : storeItem) {
                            filePOJO2.setFile((File)fileBackupManager.restore(filePOJO2));
                            filePOJO2.setBytes((byte[])bytesBackupManager.restore(filePOJO2));
                        }
                    } else {
                        T storeItem = null;
                        return storeItem;
                    }
                    fileBackupManager.clean();
                    bytesBackupManager.clean();
                    httpPost = new HttpPost(uri);
                    if (proxy == null) {
                        proxy = HttpClientManager.getDefaultProxyHost(uri);
                    }
                    if (proxy != null) {
                        httpPost.setConfig(RequestConfig.custom().setProxy(proxy).build());
                    }
                    httpPost.setEntity(multipartEntityBuilder.build());
                    httpResponse = HttpClientManager.execute((HttpUriRequest)httpPost, beforeRequest, afterResponse);
                    break;
                }
            }
            if (returnType != null && (httpEntity = httpResponse.getEntity()) != null) {
                if (returnType == String.class) {
                    returnValue = EntityUtils.toString((HttpEntity)httpEntity, (Charset)Charset.forName(_charsetName));
                } else {
                    InputStream content = httpEntity.getContent();
                    if (content != null) {
                        try {
                            returnValue = new ObjectMapper().readValue(content, returnType);
                        }
                        catch (Exception e) {
                            returnValue = null;
                        }
                    }
                }
            }
            EntityUtils.consume(httpEntity);
        }
        catch (Exception e) {
            throw new Exception(MessageFormatter.arrayFormat((String)"Failed connection to <{}> !", (Object[])new Object[]{uri}).getMessage(), e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException ioe) {
                    throw new Exception("Failed close to http response !", ioe);
                }
            }
        }
        return (T)returnValue;
    }

    private static boolean isUrlEncodedFormEntity(Object param) {
        boolean isUrlEncodedFormEntity = false;
        if (param instanceof List) {
            Object object;
            List list = (List)param;
            int j = list.size();
            for (int i = 0; i < j && (object = list.get(i)) instanceof NameValuePair; ++i) {
                if (i != j - 1) continue;
                isUrlEncodedFormEntity = true;
            }
        }
        return isUrlEncodedFormEntity;
    }

    private static CloseableHttpResponse execute(HttpUriRequest request, Consumer<HttpRequest> beforeRequest, Consumer<HttpResponse> afterResponse) throws ClientProtocolException, IOException {
        CloseableHttpResponse httpResponse = null;
        if (beforeRequest != null) {
            beforeRequest.accept((HttpRequest)request);
        }
        httpResponse = HttpClientFactory.getHttpClient().execute(request);
        if (afterResponse != null) {
            afterResponse.accept((HttpResponse)httpResponse);
        }
        return httpResponse;
    }

    static {
        Logger.getLogger((String)"org.apache.http").setLevel(Level.OFF);
    }

    private static enum RequestType {
        GET,
        POST,
        MULTIPART;

    }

    static class ObjectBackupManager {
        private Map<Object, Object> map;

        ObjectBackupManager() {
        }

        private Map<Object, Object> getMap() {
            if (this.map == null) {
                this.map = new HashMap<Object, Object>();
            }
            return this.map;
        }

        public boolean backup(Object key, Object value) {
            if (key == null) {
                return false;
            }
            this.getMap().put(key, value);
            return true;
        }

        public Object restore(Object key) {
            return this.restore(key, true);
        }

        public Object restore(Object key, boolean remove) {
            if (key == null) {
                return null;
            }
            Object value = this.getMap().get(key);
            if (remove && this.getMap().containsKey(key)) {
                this.getMap().remove(key);
            }
            return value;
        }

        public void clean() {
            if (this.map != null) {
                this.map.clear();
                this.map = null;
            }
        }
    }
}

