/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin;

import com.jfoenix.controls.JFXToggleButton;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Paint;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.silentsoft.actlist.plugin.AnalysisResult;
import org.silentsoft.actlist.plugin.CompatibleVersion;
import org.silentsoft.actlist.plugin.DebugApp;
import org.silentsoft.actlist.plugin.DebugParameter;
import org.silentsoft.actlist.plugin.PluginConfig;
import org.silentsoft.actlist.plugin.VersionComparator;
import org.silentsoft.actlist.plugin.tray.TrayNotification;

@CompatibleVersion(value="1.0.0")
public abstract class ActlistPlugin {
    private String version = "1.7.0.alpha";
    private String pluginName = null;
    private String pluginVersion = null;
    private String pluginDescription = null;
    private URI pluginDescriptionURI = null;
    private String pluginAuthor = null;
    private URI pluginAuthorURI = null;
    private String pluginChangeLog = null;
    private URI pluginChangeLogURI = null;
    private String pluginLicense = null;
    private URI pluginLicenseURI = null;
    private String minimumCompatibleVersion = null;
    private String warningText = null;
    private URI pluginUpdateCheckURI = null;
    private URI pluginArchivesURI = null;
    private Consumer<HttpRequest> beforeRequest = null;
    private boolean oneTimePlugin = false;
    private SupportedPlatform[] supportedPlatforms = null;
    private String pluginStatisticsUUID = null;
    private PluginConfig pluginConfig = null;
    private LinkedHashMap<String, Function> functionMap = new LinkedHashMap();
    private BooleanProperty shouldShowLoadingBar = new SimpleBooleanProperty(false);
    private ObjectProperty<Throwable> exceptionObject = new SimpleObjectProperty(null);
    private ObjectProperty<TrayNotification> showTrayNotificationObject = new SimpleObjectProperty(null);
    private ObjectProperty<TrayNotification> dismissTrayNotificationObject = new SimpleObjectProperty(null);
    private BooleanProperty shouldDismissTrayNotifications = new SimpleBooleanProperty(false);
    private ObjectProperty<ClassLoader> classLoaderObject = new SimpleObjectProperty(null);
    private ObjectProperty<HttpHost> proxyHostObject = new SimpleObjectProperty(null);
    private BooleanProperty shouldBrowseActlistArchives = new SimpleBooleanProperty(false);
    private ObjectProperty<Boolean> shouldRequestShowActlist = new SimpleObjectProperty(null);
    private BooleanProperty shouldRequestDeactivate = new SimpleBooleanProperty(false);
    private ObjectProperty<SupportedPlatform> currentPlatformObject = new SimpleObjectProperty(null);
    private BooleanProperty darkModeProperty = new SimpleBooleanProperty(false);
    Class<?> buildVersionClass;
    private Boolean existsIcon;
    private ImageView icon;
    private Boolean existsGraphic;
    private Node graphic;

    @CompatibleVersion(value="1.0.0")
    public ActlistPlugin(String pluginName) {
        this.pluginName = pluginName;
    }

    @CompatibleVersion(value="1.2.6")
    protected static void debug() {
        DebugApp.debug(DebugParameter.custom().build());
    }

    @Deprecated
    @CompatibleVersion(value="1.5.1")
    protected static void debug(boolean isDebugMode) {
        DebugApp.debug(DebugParameter.custom().setDebugMode(isDebugMode).build());
    }

    @Deprecated
    @CompatibleVersion(value="1.5.1")
    protected static void debug(String proxyHost) {
        DebugApp.debug(DebugParameter.custom().setProxyHost(proxyHost).build());
    }

    @Deprecated
    @CompatibleVersion(value="1.5.1")
    protected static void debug(boolean isDebugMode, String proxyHost) {
        DebugApp.debug(DebugParameter.custom().setDebugMode(isDebugMode).setProxyHost(proxyHost).build());
    }

    @CompatibleVersion(value="1.6.0")
    protected static void debug(DebugParameter debugParameter) {
        DebugApp.debug(debugParameter);
    }

    @CompatibleVersion(value="1.5.1")
    public static boolean isDebugMode() {
        if (DebugApp.debugParameter == null) {
            return false;
        }
        return DebugApp.debugParameter.isDebugMode();
    }

    @CompatibleVersion(value="1.7.0")
    public static AnalysisResult analyze() {
        return DebugApp.analyze(DebugParameter.custom().build());
    }

    @CompatibleVersion(value="1.7.0")
    public static AnalysisResult analyze(DebugParameter debugParameter) {
        return DebugApp.analyze(debugParameter);
    }

    @CompatibleVersion(value="1.0.0")
    protected abstract void initialize() throws Exception;

    @CompatibleVersion(value="1.0.0")
    public abstract void pluginActivated() throws Exception;

    @CompatibleVersion(value="1.0.0")
    public abstract void pluginDeactivated() throws Exception;

    @CompatibleVersion(value="1.2.6")
    public void pluginUpdateFound() throws Exception {
    }

    @CompatibleVersion(value="1.0.0")
    public void applicationActivated() throws Exception {
    }

    @CompatibleVersion(value="1.0.0")
    public void applicationDeactivated() throws Exception {
    }

    @CompatibleVersion(value="1.2.2")
    public void applicationCloseRequested() throws Exception {
    }

    @CompatibleVersion(value="1.6.0")
    public void applicationConfigChanged() throws Exception {
    }

    @CompatibleVersion(value="1.2.6")
    protected String getActlistVersion() {
        String actlistVersion = null;
        Class<?> buildVersionClass = this.getBuildVersionClass();
        if (buildVersionClass != null) {
            try {
                actlistVersion = (String)buildVersionClass.getField("VERSION").get(null);
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
        return actlistVersion;
    }

    @CompatibleVersion(value="1.2.6")
    protected String getActlistBuildTime() {
        String actlistBuildTime = null;
        Class<?> buildVersionClass = this.getBuildVersionClass();
        if (buildVersionClass != null) {
            try {
                actlistBuildTime = (String)buildVersionClass.getField("BUILD_TIME").get(null);
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
        return actlistBuildTime;
    }

    Class<?> getBuildVersionClass() {
        if (this.buildVersionClass == null) {
            try {
                this.buildVersionClass = Class.forName("org.silentsoft.actlist.version.BuildVersion");
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
        return this.buildVersionClass;
    }

    @CompatibleVersion(value="1.2.6")
    protected boolean isActlistVersionLowerThan(int major, int minor, int patch) {
        return VersionComparator.getInstance().compare(this.getActlistVersion(), String.format("%d.%d.%d", major, minor, patch)) < 0;
    }

    @CompatibleVersion(value="1.2.6")
    protected boolean isActlistVersionSameWith(int major, int minor, int patch) {
        return VersionComparator.getInstance().compare(this.getActlistVersion(), String.format("%d.%d.%d", major, minor, patch)) == 0;
    }

    @CompatibleVersion(value="1.2.6")
    protected boolean isActlistVersionHigherThan(int major, int minor, int patch) {
        return VersionComparator.getInstance().compare(this.getActlistVersion(), String.format("%d.%d.%d", major, minor, patch)) > 0;
    }

    @CompatibleVersion(value="1.0.0")
    public String getPluginName() {
        return this.pluginName;
    }

    @CompatibleVersion(value="1.2.0")
    public String getPluginVersion() {
        return this.pluginVersion;
    }

    @CompatibleVersion(value="1.2.0")
    protected void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    @CompatibleVersion(value="1.0.0")
    public String getPluginDescription() {
        return this.pluginDescription;
    }

    @CompatibleVersion(value="1.2.0")
    protected void setPluginDescription(String pluginDescription) {
        this.pluginDescription = pluginDescription;
    }

    @CompatibleVersion(value="1.2.6")
    protected void setPluginDescription(URI uri) {
        this.pluginDescriptionURI = uri;
    }

    @CompatibleVersion(value="1.2.6")
    public URI getPluginDescriptionURI() {
        return this.pluginDescriptionURI;
    }

    @CompatibleVersion(value="1.2.0")
    public String getPluginAuthor() {
        return this.pluginAuthor;
    }

    @CompatibleVersion(value="1.2.0")
    protected void setPluginAuthor(String pluginAuthor) {
        this.pluginAuthor = pluginAuthor;
    }

    @CompatibleVersion(value="1.2.6")
    protected void setPluginAuthor(String pluginAuthor, URI uri) {
        this.pluginAuthor = pluginAuthor;
        this.pluginAuthorURI = uri;
    }

    @CompatibleVersion(value="1.2.6")
    public URI getPluginAuthorURI() {
        return this.pluginAuthorURI;
    }

    @CompatibleVersion(value="1.2.6")
    public String getPluginChangeLog() {
        return this.pluginChangeLog;
    }

    @CompatibleVersion(value="1.2.6")
    protected void setPluginChangeLog(String pluginChangeLog) {
        this.pluginChangeLog = pluginChangeLog;
    }

    @CompatibleVersion(value="1.2.6")
    protected void setPluginChangeLog(URI uri) {
        this.pluginChangeLogURI = uri;
    }

    @CompatibleVersion(value="1.2.6")
    public URI getPluginChangeLogURI() {
        return this.pluginChangeLogURI;
    }

    @CompatibleVersion(value="1.2.6")
    public String getPluginLicense() {
        return this.pluginLicense;
    }

    @CompatibleVersion(value="1.2.6")
    protected void setPluginLicense(String pluginLicense) {
        this.pluginLicense = pluginLicense;
    }

    @CompatibleVersion(value="1.2.6")
    protected void setPluginLicense(URI uri) {
        this.pluginLicenseURI = uri;
    }

    @CompatibleVersion(value="1.2.6")
    public URI getPluginLicenseURI() {
        return this.pluginLicenseURI;
    }

    @CompatibleVersion(value="1.2.4")
    public String getMinimumCompatibleVersion() {
        return this.minimumCompatibleVersion;
    }

    @CompatibleVersion(value="1.2.4")
    protected void setMinimumCompatibleVersion(int major, int minor, int patch) {
        this.minimumCompatibleVersion = String.format("%d.%d.%d", major, minor, patch);
    }

    @CompatibleVersion(value="1.2.6")
    public String getWarningText() {
        return this.warningText;
    }

    @CompatibleVersion(value="1.2.6")
    protected void setWarningText(String warningText) {
        this.warningText = warningText;
    }

    @CompatibleVersion(value="1.2.6")
    public URI getPluginUpdateCheckURI() {
        return this.pluginUpdateCheckURI;
    }

    @CompatibleVersion(value="1.2.6")
    protected void setPluginUpdateCheckURI(URI pluginUpdateCheckURI) {
        this.pluginUpdateCheckURI = pluginUpdateCheckURI;
    }

    @CompatibleVersion(value="1.2.6")
    protected void setPluginUpdateCheckURI(URI pluginUpdateCheckURI, URI pluginArchivesURI) {
        this.pluginUpdateCheckURI = pluginUpdateCheckURI;
        this.pluginArchivesURI = pluginArchivesURI;
    }

    @CompatibleVersion(value="1.5.0")
    protected void setPluginUpdateCheckURI(URI pluginUpdateCheckURI, Consumer<HttpRequest> beforeRequest) {
        this.pluginUpdateCheckURI = pluginUpdateCheckURI;
        this.beforeRequest = beforeRequest;
    }

    @CompatibleVersion(value="1.2.6")
    public URI getPluginArchivesURI() {
        return this.pluginArchivesURI;
    }

    @CompatibleVersion(value="1.2.6")
    protected void setPluginArchivesURI(URI pluginArchivesURI) {
        this.pluginArchivesURI = pluginArchivesURI;
    }

    @CompatibleVersion(value="1.5.0")
    public Consumer<HttpRequest> getBeforeRequest() {
        return this.beforeRequest;
    }

    @CompatibleVersion(value="1.5.0")
    protected void setBeforeRequest(Consumer<HttpRequest> beforeRequest) {
        this.beforeRequest = beforeRequest;
    }

    @CompatibleVersion(value="1.2.10")
    public boolean isOneTimePlugin() {
        return this.oneTimePlugin;
    }

    @CompatibleVersion(value="1.2.10")
    protected void setOneTimePlugin(boolean oneTimePlugin) {
        this.oneTimePlugin = oneTimePlugin;
    }

    @CompatibleVersion(value="1.3.0")
    public SupportedPlatform[] getSupportedPlatforms() {
        return this.supportedPlatforms;
    }

    @CompatibleVersion(value="1.3.0")
    protected void setSupportedPlatforms(SupportedPlatform ... supportedPlatforms) {
        this.supportedPlatforms = supportedPlatforms;
    }

    @CompatibleVersion(value="1.6.0")
    public String getPluginStatisticsUUID() {
        return this.pluginStatisticsUUID;
    }

    @CompatibleVersion(value="1.6.0")
    protected void setPluginStatisticsUUID(String pluginStatisticsUUID) {
        this.pluginStatisticsUUID = pluginStatisticsUUID;
    }

    PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    void setPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
    }

    private URL getPNG() {
        return this.getClassLoader().getResource(this.getClass().getName().replaceAll("\\.", "/").concat(".png"));
    }

    private URL getFXML() {
        return this.getClassLoader().getResource(this.getClass().getName().replaceAll("\\.", "/").concat(".fxml"));
    }

    @CompatibleVersion(value="1.2.0")
    public boolean existsIcon() {
        if (this.existsIcon == null) {
            this.existsIcon = true;
            try {
                this.getPNG().openStream().close();
            }
            catch (Exception e) {
                this.existsIcon = false;
            }
        }
        return this.existsIcon;
    }

    @CompatibleVersion(value="1.2.0")
    public ImageView getIcon() throws Exception {
        if (this.icon == null) {
            this.icon = new ImageView(this.getPNG().toExternalForm());
        }
        return this.icon;
    }

    @CompatibleVersion(value="1.1.0")
    public boolean existsGraphic() {
        if (this.existsGraphic == null) {
            this.existsGraphic = true;
            try {
                this.getFXML().openStream().close();
            }
            catch (Exception e) {
                this.existsGraphic = false;
            }
        }
        return this.existsGraphic;
    }

    @CompatibleVersion(value="1.0.0")
    public Node getGraphic() throws Exception {
        if (this.graphic == null) {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getFXML());
            fxmlLoader.setClassLoader(this.getClassLoader());
            fxmlLoader.setController((Object)this);
            this.graphic = (Node)fxmlLoader.load();
        }
        return this.graphic;
    }

    LinkedHashMap<String, Function> getFunctionMap() {
        return this.functionMap;
    }

    BooleanProperty shouldShowLoadingBar() {
        return this.shouldShowLoadingBar;
    }

    ObjectProperty<Throwable> exceptionObject() {
        return this.exceptionObject;
    }

    ObjectProperty<TrayNotification> showTrayNotificationObject() {
        return this.showTrayNotificationObject;
    }

    ObjectProperty<TrayNotification> dismissTrayNotificationObject() {
        return this.dismissTrayNotificationObject;
    }

    BooleanProperty shouldDismissTrayNotifications() {
        return this.shouldDismissTrayNotifications;
    }

    ObjectProperty<ClassLoader> classLoaderObject() {
        return this.classLoaderObject;
    }

    ObjectProperty<HttpHost> proxyHostObject() {
        return this.proxyHostObject;
    }

    BooleanProperty shouldBrowseActlistArchives() {
        return this.shouldBrowseActlistArchives;
    }

    ObjectProperty<Boolean> shouldRequestShowActlist() {
        return this.shouldRequestShowActlist;
    }

    BooleanProperty shouldRequestDeactivate() {
        return this.shouldRequestDeactivate;
    }

    ObjectProperty<SupportedPlatform> currentPlatformObject() {
        return this.currentPlatformObject;
    }

    BooleanProperty darkModeProperty() {
        return this.darkModeProperty;
    }

    @CompatibleVersion(value="1.0.0")
    protected void putFunction(String functionName, Function function) throws Exception {
        if (this.getFunctionMap().containsKey(functionName)) {
            throw new Exception(String.format("The function '%s' is already exists !", functionName));
        }
        this.getFunctionMap().put(functionName, function);
    }

    @CompatibleVersion(value="1.7.0")
    protected Function getFunction(String functionName) {
        return this.getFunctionMap().get(functionName);
    }

    @CompatibleVersion(value="1.0.0")
    protected void removeFunction(String functionName) {
        this.getFunctionMap().remove(functionName);
    }

    @CompatibleVersion(value="1.0.0")
    protected void replaceFunction(String functionName, Function function) {
        this.getFunctionMap().replace(functionName, function);
    }

    @CompatibleVersion(value="1.1.0")
    public <T> T getConfig(String key) throws Exception {
        return this.getPluginConfig().get(key);
    }

    @CompatibleVersion(value="1.1.0")
    public void putConfig(String key, Object value) throws Exception {
        this.getPluginConfig().put(key, value);
    }

    @CompatibleVersion(value="1.1.0")
    public void removeConfig(String key) throws Exception {
        this.getPluginConfig().remove(key);
    }

    @CompatibleVersion(value="1.2.0")
    public void showLoadingBar() {
        this.shouldShowLoadingBar().set(true);
    }

    @CompatibleVersion(value="1.2.0")
    public void hideLoadingBar() {
        this.shouldShowLoadingBar().set(false);
    }

    @CompatibleVersion(value="1.2.1")
    public void throwException(Throwable exception) {
        this.exceptionObject().set((Object)exception);
    }

    @CompatibleVersion(value="1.2.4")
    public void showTrayNotification(TrayNotification trayNotification) {
        this.showTrayNotificationObject().set((Object)trayNotification);
    }

    @CompatibleVersion(value="1.2.4")
    public void dismissTrayNotification(TrayNotification trayNotification) {
        this.dismissTrayNotificationObject().set((Object)trayNotification);
    }

    @CompatibleVersion(value="1.2.4")
    public void dismissTrayNotifications() {
        this.shouldDismissTrayNotifications().set(true);
    }

    @CompatibleVersion(value="1.2.6")
    public void browseActlistArchives() {
        this.shouldBrowseActlistArchives().set(true);
    }

    @CompatibleVersion(value="1.2.6")
    public ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoaderObject().get();
    }

    @CompatibleVersion(value="1.2.6")
    public HttpHost getProxyHost() {
        return (HttpHost)this.proxyHostObject().get();
    }

    @CompatibleVersion(value="1.2.10")
    public void requestShowActlist() {
        this.shouldRequestShowActlist().set((Object)true);
    }

    @CompatibleVersion(value="1.2.10")
    public void requestHideActlist() {
        this.shouldRequestShowActlist().set((Object)false);
    }

    @CompatibleVersion(value="1.2.10")
    public void requestDeactivate() {
        this.shouldRequestDeactivate().set(true);
    }

    @CompatibleVersion(value="1.3.0")
    public SupportedPlatform getCurrentPlatform() {
        return (SupportedPlatform)((Object)this.currentPlatformObject().get());
    }

    @CompatibleVersion(value="1.6.0")
    public boolean isDarkMode() {
        return this.darkModeProperty().get();
    }

    @CompatibleVersion(value="1.7.0")
    public class ToggleFunction
    extends GraphicFunction {
        @CompatibleVersion(value="1.7.0")
        public ToggleFunction(final String text, final boolean selected, final ChangeListener<? super Boolean> listener) {
            super(new Supplier<Node>(){

                @Override
                public Node get() {
                    Label label = new Label(text);
                    label.setAlignment(Pos.CENTER_RIGHT);
                    label.setMaxWidth(Double.MAX_VALUE);
                    JFXToggleButton toggleButton = new JFXToggleButton();
                    toggleButton.setText("");
                    toggleButton.setSelected(selected);
                    toggleButton.selectedProperty().addListener(listener);
                    toggleButton.setContentDisplay(ContentDisplay.RIGHT);
                    toggleButton.setMinHeight(23.0);
                    toggleButton.setPrefHeight(23.0);
                    toggleButton.setMaxHeight(23.0);
                    toggleButton.setToggleColor(Paint.valueOf((String)"#fafafa"));
                    toggleButton.setToggleLineColor(Paint.valueOf((String)"#59bf53"));
                    toggleButton.setUnToggleLineColor(Paint.valueOf((String)"#e0e0e0"));
                    toggleButton.setDisableVisualFocus(Boolean.valueOf(true));
                    BorderPane borderPane = new BorderPane();
                    borderPane.setCenter((Node)label);
                    borderPane.setRight((Node)toggleButton);
                    HBox.setHgrow((Node)borderPane, (Priority)Priority.ALWAYS);
                    return borderPane;
                }
            }.get(), null);
        }
    }

    @CompatibleVersion(value="1.0.0")
    public class GraphicFunction
    extends Function {
        @CompatibleVersion(value="1.0.0")
        public GraphicFunction(Node graphic, Runnable action) {
            super(graphic, action);
        }
    }

    @CompatibleVersion(value="1.0.0")
    public class TextFunction
    extends Function {
        @CompatibleVersion(value="1.0.0")
        public TextFunction(String text, Runnable action) {
            super((Node)new Label(text), action);
        }
    }

    @CompatibleVersion(value="1.0.0")
    public class Function {
        Node graphic;
        Runnable action;

        Function(Node graphic, Runnable action) {
            this.graphic = graphic;
            this.action = action;
        }

        @CompatibleVersion(value="1.7.0")
        public Node getGraphic() {
            return this.graphic;
        }

        @CompatibleVersion(value="1.7.0")
        protected void setGraphic(Node graphic) {
            this.graphic = graphic;
        }
    }

    @CompatibleVersion(value="1.3.0")
    public static enum SupportedPlatform {
        WINDOWS,
        MACOSX;

    }
}

