/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.ui.model;

import javafx.collections.ObservableList;
import javafx.geometry.Rectangle2D;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.silentsoft.ui.model.Delta;

public class MaximizeProperty {
    private boolean isMaximized;
    private Delta delta;

    public MaximizeProperty(Stage stage) {
        this.isMaximized = stage.isMaximized();
        this.delta = new Delta();
        this.delta.setX(stage.getX());
        this.delta.setY(stage.getY());
        this.delta.setWidth(stage.getWidth());
        this.delta.setHeight(stage.getHeight());
    }

    public void setMaximized(Stage stage, boolean value) {
        this.isMaximized = value;
        if (this.isMaximized) {
            ObservableList screens = Screen.getScreensForRectangle((Rectangle2D)new Rectangle2D(stage.getX(), stage.getY(), stage.getWidth(), stage.getHeight()));
            if (screens != null && screens.size() >= 1) {
                this.delta.setX(stage.getX());
                this.delta.setY(stage.getY());
                this.delta.setWidth(stage.getWidth());
                this.delta.setHeight(stage.getHeight());
                double stageDistance = 0.0;
                Rectangle stageRectangle = new Rectangle(this.delta.getX(), this.delta.getY(), this.delta.getWidth(), this.delta.getHeight());
                for (Screen screen : screens) {
                    Rectangle2D screenVisualBounds = screen.getVisualBounds();
                    Shape shape = Rectangle.intersect((Shape)stageRectangle, (Shape)new Rectangle(screenVisualBounds.getMinX(), screenVisualBounds.getMinY(), screenVisualBounds.getWidth(), screenVisualBounds.getHeight()));
                    double shapeDistance = shape.getLayoutBounds().getWidth() + shape.getLayoutBounds().getHeight();
                    if (!(stageDistance <= shapeDistance)) continue;
                    stage.setX(screenVisualBounds.getMinX());
                    stage.setY(screenVisualBounds.getMinY());
                    stage.setWidth(screenVisualBounds.getWidth());
                    stage.setHeight(screenVisualBounds.getHeight());
                    stageDistance = shapeDistance;
                }
            }
        } else {
            stage.setX(this.delta.getX());
            stage.setY(this.delta.getY());
            stage.setWidth(this.delta.getWidth());
            stage.setHeight(this.delta.getHeight());
        }
    }

    public boolean isMaximized() {
        return this.isMaximized;
    }
}

