/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin;

import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import org.silentsoft.core.util.FileUtil;
import org.silentsoft.core.util.JSONUtil;

class PluginConfig {
    private String plugin;
    private HashMap<String, Object> config;

    public PluginConfig() {
        this(null);
    }

    public PluginConfig(String plugin) {
        this.plugin = plugin;
        this.config = new HashMap();
    }

    public String getPlugin() {
        return this.plugin;
    }

    public void setPlugin(String plugin) {
        this.plugin = plugin;
    }

    public HashMap<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(HashMap<String, Object> config) {
        this.config = config;
    }

    public <T> T get(String key) throws Exception {
        return (T)this.config.get(key);
    }

    public void put(String key, Object value) throws Exception {
        this.config.put(key, value);
        this.commit();
    }

    public void remove(String key) throws Exception {
        this.config.remove(key);
        this.commit();
    }

    final void commit() throws Exception {
        File configFile = Paths.get(System.getProperty("user.dir"), "plugins", "config", this.plugin.concat(".config")).toFile();
        if (!configFile.getParentFile().exists()) {
            configFile.getParentFile().mkdirs();
        }
        if (!configFile.exists()) {
            configFile.createNewFile();
        }
        FileUtil.saveFile((File)configFile, (String)JSONUtil.ObjectToString((Object)this));
    }
}

