/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.core.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import org.silentsoft.core.util.ObjectUtil;
import org.silentsoft.core.util.elevator.core.Elevator;
import org.silentsoft.core.util.elevator.extend.CLibrary;

public final class SystemUtil {
    private static final String REGQUERY_UTIL = "reg query ";
    private static final String REGADD_UTIL = "reg add ";
    private static final String REGTYPE_DWORD = "REG_DWORD";
    private static final String REGTYPE_QWORD = "REG_QWORD";
    private static final int REGINFO_TYPE = 2;
    private static final int REGINFO_RSLT = 3;
    private static Map<String, BufferedImage> extensionMap = new HashMap<String, BufferedImage>();

    public static String getHostAddress() {
        InetAddress localAddress = SystemUtil.getLocalAddress();
        if (localAddress == null) {
            try {
                return Inet4Address.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
            }
        } else {
            return localAddress.getHostAddress();
        }
        return "";
    }

    private static InetAddress getLocalAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                List<InterfaceAddress> interfaceAddresses = networkInterfaces.nextElement().getInterfaceAddresses();
                for (InterfaceAddress interfaceAddress : interfaceAddresses) {
                    InetAddress address = interfaceAddress.getAddress();
                    if (!address.isSiteLocalAddress()) continue;
                    return address;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Process runCommand(String command) throws IOException {
        if (SystemUtil.isWindows()) {
            return Runtime.getRuntime().exec("cmd /C " + command);
        }
        return Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
    }

    public static void runCommandAsAdmin(String command) {
        Elevator.executeAsAdmin("c:\\windows\\system32\\cmd.exe", "/C " + command);
    }

    public static void runProgram(String target) throws IOException {
        SystemUtil.runProgram(target, "");
    }

    public static void runProgram(String target, String args) throws IOException {
        args = args == null ? "" : args;
        Runtime.getRuntime().exec("cmd /C start " + target + " " + args);
    }

    public static void runProgramAsAdmin(String target) {
        SystemUtil.runProgramAsAdmin(target, "");
    }

    public static void runProgramAsAdmin(String target, String args) {
        args = args == null ? "" : args;
        Elevator.executeAsAdmin("c:\\windows\\system32\\cmd.exe", "/C start " + target + " " + args);
    }

    public static void executeAsAdmin(String target) {
        SystemUtil.executeProgramAsAdmin(target, "");
    }

    public static void executeProgramAsAdmin(String target, String args) {
        args = args == null ? "" : args;
        Elevator.executeAsAdmin(target, args);
    }

    public static String getLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public static boolean isSystemLanguage(String language) {
        return SystemUtil.getLanguage().equals(new Locale(language).getLanguage());
    }

    public static Image getIconFromExtensionFx(String extension) {
        return SystemUtil.getIconFromExtensionFx(extension, 0, 0);
    }

    public static Image getIconFromExtensionFx(String extension, int width, int height) {
        return SwingFXUtils.toFXImage((BufferedImage)SystemUtil.getIconFromExtension(extension, width, height), null);
    }

    public static BufferedImage getIconFromExtension(String extension) {
        return SystemUtil.getIconFromExtension(extension, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getIconFromExtension(String extension, int width, int height) {
        if (extension == null) {
            return null;
        }
        BufferedImage bufferedImage = extensionMap.get(extension);
        if (bufferedImage == null) {
            File file = null;
            try {
                boolean isDirectory = extension.length() <= 0;
                file = isDirectory ? Files.createTempDirectory("temp", new FileAttribute[0]).toFile() : Files.createTempFile("temp", ".".concat(extension), new FileAttribute[0]).toFile();
                Icon icon = FileSystemView.getFileSystemView().getSystemIcon(file);
                width = width == 0 ? icon.getIconWidth() : width;
                height = height == 0 ? icon.getIconHeight() : height;
                bufferedImage = new BufferedImage(width, height, 2);
                icon.paintIcon(null, bufferedImage.getGraphics(), 0, 0);
                extensionMap.put(extension, bufferedImage);
            }
            catch (Exception exception) {
            }
            finally {
                if (file != null) {
                    file.delete();
                }
            }
        }
        return bufferedImage;
    }

    public static String getSystemTime() {
        StringBuffer systemTime = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        systemTime.append(ObjectUtil.fillString(ObjectUtil.toString(calendar.get(1)), 4, "0"));
        systemTime.append(ObjectUtil.fillString(ObjectUtil.toString(calendar.get(2) + 1), 2, "0"));
        systemTime.append(ObjectUtil.fillString(ObjectUtil.toString(calendar.get(5)), 2, "0"));
        systemTime.append(ObjectUtil.fillString(ObjectUtil.toString(calendar.get(11)), 2, "0"));
        systemTime.append(ObjectUtil.fillString(ObjectUtil.toString(calendar.get(12)), 2, "0"));
        systemTime.append(ObjectUtil.fillString(ObjectUtil.toString(calendar.get(13)), 2, "0"));
        return systemTime.toString();
    }

    public static void setSystemTime(Date date) throws IOException {
        StringBuffer paramDate = new StringBuffer();
        StringBuffer paramTime = new StringBuffer();
        paramDate.append(ObjectUtil.fillString(ObjectUtil.toString(date.getMonth() + 1), 2, "0"));
        paramDate.append("-");
        paramDate.append(ObjectUtil.fillString(ObjectUtil.toString(date.getDate()), 2, "0"));
        paramDate.append("-");
        paramDate.append(ObjectUtil.toString(date.getYear()).substring(2, 4));
        paramTime.append(ObjectUtil.fillString(ObjectUtil.toString(date.getHours()), 2, "0"));
        paramTime.append(":");
        paramTime.append(ObjectUtil.fillString(ObjectUtil.toString(date.getMinutes()), 2, "0"));
        paramTime.append(":");
        paramTime.append(ObjectUtil.fillString(ObjectUtil.toString(date.getSeconds()), 2, "0"));
        SystemUtil.setSystemTime(paramDate.toString(), paramTime.toString());
    }

    public static void setSystemTime(String date, String time) throws IOException {
        SystemUtil.runCommand(String.format("%s%s", "date ", date));
        SystemUtil.runCommand(String.format("%s%s", "time ", time));
    }

    public static String readRegistry(String location, String key) throws Exception {
        if (SystemUtil.isWindows()) {
            Process process = Runtime.getRuntime().exec("reg query \"" + location + "\" /v \"" + key + "\"");
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String[] result = reader.getResult().split("    ");
            if (result[2].trim().equals(REGTYPE_DWORD) || result[2].trim().equals(REGTYPE_QWORD)) {
                return new BigInteger(result[3].trim().substring("0x".length()), 16).toString();
            }
            return result[3].trim();
        }
        return null;
    }

    public static void writeRegistry(String location, String key, RegType regType, Object value) throws IOException {
        if (SystemUtil.isWindows()) {
            Runtime.getRuntime().exec("reg add \"" + location + "\" /v \"" + key + "\" /t " + regType.name() + " /d " + (regType == RegType.REG_SZ ? "\"" + value + "\"" : value) + " /f");
        }
    }

    public static void writeRegistryAsAdmin(String location, String key, RegType regType, Object value) {
        if (SystemUtil.isWindows()) {
            Elevator.executeAsAdmin("c:\\windows\\system32\\reg.exe", "add \"" + location + "\" /v \"" + key + "\" /t " + regType.name() + " /d " + (regType == RegType.REG_SZ ? "\"" + value + "\"" : value) + " /f");
        }
    }

    public static String getCurrentProcessId() {
        if (SystemUtil.isMac() || SystemUtil.isLinux()) {
            return String.valueOf(CLibrary.INSTANCE.getpid());
        }
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    public static boolean findProcessByImageName(String imageName) {
        return !SystemUtil.getProcessInfoByImageName(imageName).isEmpty();
    }

    public static boolean findProcessByImageName(String imageName, String excludePid) {
        List<ProcessInfo> processes = SystemUtil.getProcessInfoByImageName(imageName);
        return processes.stream().filter(processInfo -> !processInfo.getPid().equals(excludePid)).count() != 0L;
    }

    public static boolean findProcessByPID(String pid) {
        return SystemUtil.getProcessInfoByPID(pid) != null;
    }

    public static List<ProcessInfo> getProcessInfoByImageName(String imageName) {
        return SystemUtil.findProcess("IMAGENAME", imageName);
    }

    public static ProcessInfo getProcessInfoByPID(String pid) {
        List<ProcessInfo> processes = SystemUtil.findProcess("PID", pid);
        return processes.isEmpty() ? null : processes.get(0);
    }

    private static List<ProcessInfo> findProcess(String command, String target) {
        ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
        try {
            if (target != null && target.length() > 0) {
                Process process = null;
                if (SystemUtil.isWindows()) {
                    process = SystemUtil.runCommand(String.join((CharSequence)"", "tasklist /V /FO \"CSV\" /FI \"", command, " eq ", target, "\" | find /I \"", target, "\""));
                } else if ("IMAGENAME".equals(command)) {
                    process = SystemUtil.runCommand(String.join((CharSequence)"", "ps -eo ucomm=,pid=,sess=,user= | grep -w \"^", target, " \"", " | awk '{print ", "\"\\\"\"", String.join((CharSequence)"\"\\\",\" \"\\\"\"", "$1", "$2", "$3", "$4"), "\"\\\"\"}'"));
                } else if ("PID".equals(command)) {
                    process = SystemUtil.runCommand(String.join((CharSequence)"", "ps -eo ucomm=,pid=,sess=,user= ", target, " | awk '{print ", "\"\\\"\"", String.join((CharSequence)"\"\\\",\" \"\\\"\"", "$1", "$2", "$3", "$4"), "\"\\\"\"}'"));
                }
                if (process != null) {
                    String[] rows;
                    StreamReader reader = new StreamReader(process.getInputStream());
                    reader.start();
                    process.waitFor();
                    reader.join();
                    for (String row : rows = reader.getResult().split("\r\n")) {
                        String[] cols;
                        if ("".equals(row) || row.trim().length() == 0) continue;
                        if (SystemUtil.isWindows()) {
                            cols = row.split("\",\"");
                            cols[0] = cols[0].replaceAll("\"", "");
                            cols[cols.length - 1] = cols[cols.length - 1].replaceAll("\"", "");
                            processes.add(new ProcessInfo(cols[1], cols[3], cols[6], cols[0]));
                            continue;
                        }
                        cols = row.split("\t");
                        cols[0] = cols[0].replaceAll("\"", "");
                        cols = cols[0].split(",");
                        cols[cols.length - 1] = cols[cols.length - 1].replaceAll("\n", "");
                        processes.add(new ProcessInfo(cols[1], cols[2], cols[3], cols[0]));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return processes;
    }

    public static boolean addLibraryPath(String pathToAdd) {
        boolean result = true;
        try {
            Field usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
            usrPathsField.setAccessible(true);
            String[] paths = (String[])usrPathsField.get(null);
            if (Arrays.stream(paths).anyMatch(path -> path.equals(pathToAdd))) {
                return true;
            }
            String[] newPaths = Arrays.copyOf(paths, paths.length + 1);
            newPaths[newPaths.length - 1] = pathToAdd;
            usrPathsField.set(null, newPaths);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static String getOSArchitecture() {
        String osArchitecture = "";
        if (SystemUtil.isWindows()) {
            try {
                Process process = SystemUtil.runCommand("wmic OS get OSArchitecture");
                StreamReader reader = new StreamReader(process.getInputStream());
                reader.start();
                process.waitFor();
                reader.join();
                osArchitecture = reader.getResult().trim().split("\r\n")[1].contains("64") ? "x64" : "x86";
            }
            catch (Exception exception) {}
        } else {
            osArchitecture = System.getProperty("os.arch").contains("64") ? "x64" : "x86";
        }
        return osArchitecture;
    }

    public static String getPlatformArchitecture() {
        return System.getProperty("os.arch").contains("64") ? "x64" : "x86";
    }

    public static OS getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return OS.Windows;
        }
        if (osName.contains("nix") || osName.contains("nux")) {
            return OS.Linux;
        }
        if (osName.contains("mac")) {
            return OS.Mac;
        }
        return null;
    }

    public static String getOSName() {
        if (SystemUtil.isWindows()) {
            return "windows";
        }
        if (SystemUtil.isMac()) {
            return "macosx";
        }
        if (SystemUtil.isLinux()) {
            return "linux";
        }
        return "unknown";
    }

    public static boolean isWindows() {
        return SystemUtil.getOS() == OS.Windows;
    }

    public static boolean isLinux() {
        return SystemUtil.getOS() == OS.Linux;
    }

    public static boolean isMac() {
        return SystemUtil.getOS() == OS.Mac;
    }

    public static enum OS {
        Windows,
        Linux,
        Mac;

    }

    public static enum RegType {
        REG_SZ,
        REG_DWORD;

    }

    public static class ProcessInfo {
        private String pid;
        private String sessionId;
        private String userName;
        private String imageName;

        public ProcessInfo(String pid, String sessionId, String userName, String imageName) {
            this.pid = pid;
            this.sessionId = sessionId;
            this.userName = userName;
            this.imageName = imageName;
        }

        public String getPid() {
            return this.pid;
        }

        public void setPid(String pid) {
            this.pid = pid;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getImageName() {
            return this.imageName;
        }

        public void setImageName(String imageName) {
            this.imageName = imageName;
        }
    }

    private static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw;

        StreamReader(InputStream is) {
            this.is = is;
            this.sw = new StringWriter();
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        String getResult() {
            return this.sw.toString();
        }
    }
}

