/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.transitions;

import com.jfoenix.transitions.CacheMemento;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.animation.AnimationTimer;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.util.Duration;

public class JFXAnimationTimer
extends AnimationTimer {
    private Set<AnimationHandler> animationHandlers = new HashSet<AnimationHandler>();
    private long startTime = -1L;
    private boolean running = false;
    private List<CacheMemento> caches = new ArrayList<CacheMemento>();
    private double totalElapsedMilliseconds;
    private HashMap<JFXKeyFrame, AnimationHandler> mutableFrames = new HashMap();
    private Runnable onFinished = null;

    public JFXAnimationTimer(JFXKeyFrame ... keyFrames) {
        for (JFXKeyFrame keyFrame : keyFrames) {
            Duration duration = keyFrame.getTime();
            Set<JFXKeyValue<?>> keyValuesSet = keyFrame.getValues();
            if (keyValuesSet.isEmpty()) continue;
            this.animationHandlers.add(new AnimationHandler(duration, keyFrame.getValues()));
        }
    }

    public void addKeyFrame(JFXKeyFrame keyFrame) throws Exception {
        if (this.isRunning()) {
            throw new Exception("Can't update animation timer while running");
        }
        Duration duration = keyFrame.getTime();
        Set<JFXKeyValue<?>> keyValuesSet = keyFrame.getValues();
        if (!keyValuesSet.isEmpty()) {
            AnimationHandler handler = new AnimationHandler(duration, keyFrame.getValues());
            this.animationHandlers.add(handler);
            this.mutableFrames.put(keyFrame, handler);
        }
    }

    public void removeKeyFrame(JFXKeyFrame keyFrame) throws Exception {
        if (this.isRunning()) {
            throw new Exception("Can't update animation timer while running");
        }
        AnimationHandler handler = this.mutableFrames.get(keyFrame);
        this.animationHandlers.remove(handler);
    }

    public void start() {
        super.start();
        this.running = true;
        this.startTime = -1L;
        for (AnimationHandler animationHandler : this.animationHandlers) {
            animationHandler.init();
        }
        for (CacheMemento cache : this.caches) {
            cache.cache();
        }
    }

    public void handle(long now) {
        this.startTime = this.startTime == -1L ? now : this.startTime;
        this.totalElapsedMilliseconds = (double)(now - this.startTime) / 1000000.0;
        boolean stop = true;
        for (AnimationHandler handler : this.animationHandlers) {
            handler.animate(this.totalElapsedMilliseconds);
            if (handler.finished) continue;
            stop = false;
        }
        if (stop) {
            this.stop();
        }
    }

    public void reverseAndContinue() {
        if (this.isRunning()) {
            super.stop();
            for (AnimationHandler handler : this.animationHandlers) {
                handler.reverse(this.totalElapsedMilliseconds);
            }
            this.startTime = -1L;
            super.start();
        } else {
            this.start();
        }
    }

    public void stop() {
        super.stop();
        this.running = false;
        for (AnimationHandler handler : this.animationHandlers) {
            handler.clear();
        }
        for (CacheMemento cache : this.caches) {
            cache.restore();
        }
        if (this.onFinished != null) {
            this.onFinished.run();
        }
    }

    public void applyEndValues() {
        if (this.isRunning()) {
            super.stop();
        }
        for (AnimationHandler handler : this.animationHandlers) {
            handler.applyEndValues();
        }
        this.startTime = -1L;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setOnFinished(Runnable onFinished) {
        this.onFinished = onFinished;
    }

    public void setCacheNodes(Node ... nodesToCache) {
        this.caches.clear();
        if (nodesToCache != null) {
            for (Node node : nodesToCache) {
                this.caches.add(new CacheMemento(node));
            }
        }
    }

    public void dispose() {
        this.caches.clear();
        for (AnimationHandler handler : this.animationHandlers) {
            handler.dispose();
        }
        this.animationHandlers.clear();
    }

    static class AnimationHandler {
        private double duration;
        private double currentDuration;
        private Set<JFXKeyValue<?>> keyValues;
        private boolean finished = false;
        private HashMap<WritableValue<?>, Object> initialValuesMap = new HashMap();
        private HashMap<WritableValue<?>, Object> endValuesMap = new HashMap();

        AnimationHandler(Duration duration, Set<JFXKeyValue<?>> keyValues) {
            this.currentDuration = this.duration = duration.toMillis();
            this.keyValues = keyValues;
        }

        public void init() {
            this.finished = false;
            for (JFXKeyValue<?> keyValue : this.keyValues) {
                if (keyValue.getTarget() == null) continue;
                if (!this.initialValuesMap.containsKey(keyValue.getTarget())) {
                    this.initialValuesMap.put(keyValue.getTarget(), keyValue.getTarget().getValue());
                }
                if (this.endValuesMap.containsKey(keyValue.getTarget())) continue;
                this.endValuesMap.put(keyValue.getTarget(), keyValue.getEndValue());
            }
        }

        void reverse(double now) {
            this.currentDuration = this.duration - (this.currentDuration - now);
            for (JFXKeyValue<?> keyValue : this.keyValues) {
                WritableValue<?> target = keyValue.getTarget();
                if (target == null) continue;
                this.initialValuesMap.put(target, target.getValue());
                this.endValuesMap.put(target, keyValue.getEndValue());
            }
        }

        public void animate(double now) {
            if (now <= this.currentDuration) {
                for (JFXKeyValue<?> keyValue : this.keyValues) {
                    WritableValue<?> target;
                    Object endValue;
                    if (!keyValue.isValid() || (endValue = this.endValuesMap.get(target = keyValue.getTarget())) == null || target == null || target.getValue().equals(endValue)) continue;
                    target.setValue(keyValue.getInterpolator().interpolate(this.initialValuesMap.get(target), endValue, now / this.currentDuration));
                }
            } else if (!this.finished) {
                this.finished = true;
                for (JFXKeyValue<?> keyValue : this.keyValues) {
                    Object endValue;
                    WritableValue<?> target;
                    if (!keyValue.isValid() || (target = keyValue.getTarget()) == null || (endValue = keyValue.getEndValue()) == null) continue;
                    target.setValue(endValue);
                }
                this.currentDuration = this.duration;
            }
        }

        public void applyEndValues() {
            for (JFXKeyValue<?> keyValue : this.keyValues) {
                Object endValue;
                WritableValue<?> target;
                if (!keyValue.isValid() || (target = keyValue.getTarget()) == null || (endValue = keyValue.getEndValue()) == null || target.getValue().equals(endValue)) continue;
                target.setValue(endValue);
            }
        }

        public void clear() {
            this.initialValuesMap.clear();
            this.endValuesMap.clear();
        }

        void dispose() {
            this.clear();
            this.keyValues.clear();
        }
    }
}

