/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin;

import java.net.URI;
import java.net.URL;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.silentsoft.actlist.plugin.DebugApp;
import org.silentsoft.actlist.plugin.DebugParameter;
import org.silentsoft.actlist.plugin.DuplicateNameException;
import org.silentsoft.actlist.plugin.PluginConfig;
import org.silentsoft.actlist.plugin.tray.TrayNotification;

public abstract class ActlistPlugin {
    private String version = "1.6.0";
    private String pluginName = null;
    private String pluginVersion = null;
    private String pluginDescription = null;
    private URI pluginDescriptionURI = null;
    private String pluginAuthor = null;
    private URI pluginAuthorURI = null;
    private String pluginChangeLog = null;
    private URI pluginChangeLogURI = null;
    private String pluginLicense = null;
    private URI pluginLicenseURI = null;
    private String minimumCompatibleVersion = null;
    private String warningText = null;
    private URI pluginUpdateCheckURI = null;
    private URI pluginArchivesURI = null;
    private Consumer<HttpRequest> beforeRequest = null;
    private boolean oneTimePlugin = false;
    private SupportedPlatform[] supportedPlatforms = null;
    private String pluginStatisticsUUID = null;
    private PluginConfig pluginConfig = null;
    private LinkedHashMap<String, Function> functionMap = new LinkedHashMap();
    private BooleanProperty shouldShowLoadingBar = new SimpleBooleanProperty(false);
    private ObjectProperty<Throwable> exceptionObject = new SimpleObjectProperty(null);
    private ObjectProperty<TrayNotification> showTrayNotificationObject = new SimpleObjectProperty(null);
    private ObjectProperty<TrayNotification> dismissTrayNotificationObject = new SimpleObjectProperty(null);
    private BooleanProperty shouldDismissTrayNotifications = new SimpleBooleanProperty(false);
    private ObjectProperty<ClassLoader> classLoaderObject = new SimpleObjectProperty(null);
    private ObjectProperty<HttpHost> proxyHostObject = new SimpleObjectProperty(null);
    private BooleanProperty shouldBrowseActlistArchives = new SimpleBooleanProperty(false);
    private ObjectProperty<Boolean> shouldRequestShowActlist = new SimpleObjectProperty(null);
    private BooleanProperty shouldRequestDeactivate = new SimpleBooleanProperty(false);
    private ObjectProperty<SupportedPlatform> currentPlatformObject = new SimpleObjectProperty(null);
    private BooleanProperty darkModeProperty = new SimpleBooleanProperty(false);
    Class<?> buildVersionClass;
    private Comparator<String> versionComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            Integer o2Major;
            if (o1.equals(o2)) {
                return 0;
            }
            String[] _o1 = o1.split("\\.");
            String[] _o2 = o2.split("\\.");
            Integer o1Major = Integer.valueOf(_o1[0]);
            int majorCompare = o1Major.compareTo(o2Major = Integer.valueOf(_o2[0]));
            if (majorCompare == 0) {
                Integer o2Minor;
                Integer o1Minor = Integer.valueOf(_o1[1]);
                int minorCompare = o1Minor.compareTo(o2Minor = Integer.valueOf(_o2[1]));
                if (minorCompare == 0) {
                    Integer o1Patch = Integer.valueOf(_o1[2]);
                    Integer o2Patch = Integer.valueOf(_o2[2]);
                    return o1Patch.compareTo(o2Patch);
                }
                return minorCompare;
            }
            return majorCompare;
        }
    };
    private Boolean existsIcon;
    private ImageView icon;
    private Boolean existsGraphic;
    private Node graphic;

    public ActlistPlugin(String pluginName) {
        this.pluginName = pluginName;
    }

    protected static void debug() {
        DebugApp.debug();
    }

    @Deprecated
    protected static void debug(boolean isDebugMode) {
        DebugApp.debug(DebugParameter.custom().setDebugMode(isDebugMode).build());
    }

    @Deprecated
    protected static void debug(String proxyHost) {
        DebugApp.debug(DebugParameter.custom().setProxyHost(proxyHost).build());
    }

    @Deprecated
    protected static void debug(boolean isDebugMode, String proxyHost) {
        DebugApp.debug(DebugParameter.custom().setDebugMode(isDebugMode).setProxyHost(proxyHost).build());
    }

    protected static void debug(DebugParameter debugParameter) {
        DebugApp.debug(debugParameter);
    }

    public static boolean isDebugMode() {
        if (DebugApp.debugParameter == null) {
            return false;
        }
        return DebugApp.debugParameter.isDebugMode();
    }

    protected abstract void initialize() throws Exception;

    public abstract void pluginActivated() throws Exception;

    public abstract void pluginDeactivated() throws Exception;

    public void pluginUpdateFound() throws Exception {
    }

    public void applicationActivated() throws Exception {
    }

    public void applicationDeactivated() throws Exception {
    }

    public void applicationCloseRequested() throws Exception {
    }

    public void applicationConfigChanged() throws Exception {
    }

    protected String getActlistVersion() {
        String actlistVersion = null;
        Class<?> buildVersionClass = this.getBuildVersionClass();
        if (buildVersionClass != null) {
            try {
                actlistVersion = (String)buildVersionClass.getField("VERSION").get(null);
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
        return actlistVersion;
    }

    protected String getActlistBuildTime() {
        String actlistBuildTime = null;
        Class<?> buildVersionClass = this.getBuildVersionClass();
        if (buildVersionClass != null) {
            try {
                actlistBuildTime = (String)buildVersionClass.getField("BUILD_TIME").get(null);
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
        return actlistBuildTime;
    }

    Class<?> getBuildVersionClass() {
        if (this.buildVersionClass == null) {
            try {
                this.buildVersionClass = Class.forName("org.silentsoft.actlist.version.BuildVersion");
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
        return this.buildVersionClass;
    }

    protected boolean isActlistVersionLowerThan(int major, int minor, int patch) {
        return this.versionComparator.compare(this.getActlistVersion(), String.format("%d.%d.%d", major, minor, patch)) < 0;
    }

    protected boolean isActlistVersionSameWith(int major, int minor, int patch) {
        return this.versionComparator.compare(this.getActlistVersion(), String.format("%d.%d.%d", major, minor, patch)) == 0;
    }

    protected boolean isActlistVersionHigherThan(int major, int minor, int patch) {
        return this.versionComparator.compare(this.getActlistVersion(), String.format("%d.%d.%d", major, minor, patch)) > 0;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    protected void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public String getPluginDescription() {
        return this.pluginDescription;
    }

    protected void setPluginDescription(String pluginDescription) {
        this.pluginDescription = pluginDescription;
    }

    protected void setPluginDescription(URI uri) {
        this.pluginDescriptionURI = uri;
    }

    public URI getPluginDescriptionURI() {
        return this.pluginDescriptionURI;
    }

    public String getPluginAuthor() {
        return this.pluginAuthor;
    }

    protected void setPluginAuthor(String pluginAuthor) {
        this.pluginAuthor = pluginAuthor;
    }

    protected void setPluginAuthor(String pluginAuthor, URI uri) {
        this.pluginAuthor = pluginAuthor;
        this.pluginAuthorURI = uri;
    }

    public URI getPluginAuthorURI() {
        return this.pluginAuthorURI;
    }

    public String getPluginChangeLog() {
        return this.pluginChangeLog;
    }

    protected void setPluginChangeLog(String pluginChangeLog) {
        this.pluginChangeLog = pluginChangeLog;
    }

    protected void setPluginChangeLog(URI uri) {
        this.pluginChangeLogURI = uri;
    }

    public URI getPluginChangeLogURI() {
        return this.pluginChangeLogURI;
    }

    public String getPluginLicense() {
        return this.pluginLicense;
    }

    protected void setPluginLicense(String pluginLicense) {
        this.pluginLicense = pluginLicense;
    }

    protected void setPluginLicense(URI uri) {
        this.pluginLicenseURI = uri;
    }

    public URI getPluginLicenseURI() {
        return this.pluginLicenseURI;
    }

    public String getMinimumCompatibleVersion() {
        return this.minimumCompatibleVersion;
    }

    protected void setMinimumCompatibleVersion(int major, int minor, int patch) {
        this.minimumCompatibleVersion = String.format("%d.%d.%d", major, minor, patch);
    }

    public String getWarningText() {
        return this.warningText;
    }

    protected void setWarningText(String warningText) {
        this.warningText = warningText;
    }

    public URI getPluginUpdateCheckURI() {
        return this.pluginUpdateCheckURI;
    }

    protected void setPluginUpdateCheckURI(URI pluginUpdateCheckURI) {
        this.pluginUpdateCheckURI = pluginUpdateCheckURI;
    }

    protected void setPluginUpdateCheckURI(URI pluginUpdateCheckURI, URI pluginArchivesURI) {
        this.pluginUpdateCheckURI = pluginUpdateCheckURI;
        this.pluginArchivesURI = pluginArchivesURI;
    }

    protected void setPluginUpdateCheckURI(URI pluginUpdateCheckURI, Consumer<HttpRequest> beforeRequest) {
        this.pluginUpdateCheckURI = pluginUpdateCheckURI;
        this.beforeRequest = beforeRequest;
    }

    public URI getPluginArchivesURI() {
        return this.pluginArchivesURI;
    }

    protected void setPluginArchivesURI(URI pluginArchivesURI) {
        this.pluginArchivesURI = pluginArchivesURI;
    }

    public Consumer<HttpRequest> getBeforeRequest() {
        return this.beforeRequest;
    }

    protected void setBeforeRequest(Consumer<HttpRequest> beforeRequest) {
        this.beforeRequest = beforeRequest;
    }

    public boolean isOneTimePlugin() {
        return this.oneTimePlugin;
    }

    protected void setOneTimePlugin(boolean oneTimePlugin) {
        this.oneTimePlugin = oneTimePlugin;
    }

    public SupportedPlatform[] getSupportedPlatforms() {
        return this.supportedPlatforms;
    }

    protected void setSupportedPlatforms(SupportedPlatform ... supportedPlatforms) {
        this.supportedPlatforms = supportedPlatforms;
    }

    public String getPluginStatisticsUUID() {
        return this.pluginStatisticsUUID;
    }

    protected void setPluginStatisticsUUID(String pluginStatisticsUUID) {
        this.pluginStatisticsUUID = pluginStatisticsUUID;
    }

    PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    void setPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
    }

    private URL getPNG() {
        return this.getClassLoader().getResource(this.getClass().getName().replaceAll("\\.", "/").concat(".png"));
    }

    private URL getFXML() {
        return this.getClassLoader().getResource(this.getClass().getName().replaceAll("\\.", "/").concat(".fxml"));
    }

    public boolean existsIcon() {
        if (this.existsIcon == null) {
            this.existsIcon = true;
            try {
                this.getPNG().openStream().close();
            }
            catch (Exception e) {
                this.existsIcon = false;
            }
        }
        return this.existsIcon;
    }

    public ImageView getIcon() throws Exception {
        if (this.icon == null) {
            this.icon = new ImageView(this.getPNG().toExternalForm());
        }
        return this.icon;
    }

    public boolean existsGraphic() {
        if (this.existsGraphic == null) {
            this.existsGraphic = true;
            try {
                this.getFXML().openStream().close();
            }
            catch (Exception e) {
                this.existsGraphic = false;
            }
        }
        return this.existsGraphic;
    }

    public Node getGraphic() throws Exception {
        if (this.graphic == null) {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getFXML());
            fxmlLoader.setClassLoader(this.getClassLoader());
            fxmlLoader.setController((Object)this);
            this.graphic = (Node)fxmlLoader.load();
        }
        return this.graphic;
    }

    LinkedHashMap<String, Function> getFunctionMap() {
        return this.functionMap;
    }

    BooleanProperty shouldShowLoadingBar() {
        return this.shouldShowLoadingBar;
    }

    ObjectProperty<Throwable> exceptionObject() {
        return this.exceptionObject;
    }

    ObjectProperty<TrayNotification> showTrayNotificationObject() {
        return this.showTrayNotificationObject;
    }

    ObjectProperty<TrayNotification> dismissTrayNotificationObject() {
        return this.dismissTrayNotificationObject;
    }

    BooleanProperty shouldDismissTrayNotifications() {
        return this.shouldDismissTrayNotifications;
    }

    ObjectProperty<ClassLoader> classLoaderObject() {
        return this.classLoaderObject;
    }

    ObjectProperty<HttpHost> proxyHostObject() {
        return this.proxyHostObject;
    }

    BooleanProperty shouldBrowseActlistArchives() {
        return this.shouldBrowseActlistArchives;
    }

    ObjectProperty<Boolean> shouldRequestShowActlist() {
        return this.shouldRequestShowActlist;
    }

    BooleanProperty shouldRequestDeactivate() {
        return this.shouldRequestDeactivate;
    }

    ObjectProperty<SupportedPlatform> currentPlatformObject() {
        return this.currentPlatformObject;
    }

    BooleanProperty darkModeProperty() {
        return this.darkModeProperty;
    }

    protected void putFunction(String functionName, Function function) throws DuplicateNameException {
        if (this.getFunctionMap().containsKey(functionName)) {
            throw new DuplicateNameException("The function '{}' is already exists !", new Object[]{functionName});
        }
        this.getFunctionMap().put(functionName, function);
    }

    protected void removeFunction(String functionName) {
        this.getFunctionMap().remove(functionName);
    }

    protected void replaceFunction(String functionName, Function function) {
        this.getFunctionMap().replace(functionName, function);
    }

    public <T> T getConfig(String key) throws Exception {
        return this.getPluginConfig().get(key);
    }

    public void putConfig(String key, Object value) throws Exception {
        this.getPluginConfig().put(key, value);
    }

    public void removeConfig(String key) throws Exception {
        this.getPluginConfig().remove(key);
    }

    public void showLoadingBar() {
        this.shouldShowLoadingBar().set(true);
    }

    public void hideLoadingBar() {
        this.shouldShowLoadingBar().set(false);
    }

    public void throwException(Throwable exception) {
        this.exceptionObject().set((Object)exception);
    }

    public void showTrayNotification(TrayNotification trayNotification) {
        this.showTrayNotificationObject().set((Object)trayNotification);
    }

    public void dismissTrayNotification(TrayNotification trayNotification) {
        this.dismissTrayNotificationObject().set((Object)trayNotification);
    }

    public void dismissTrayNotifications() {
        this.shouldDismissTrayNotifications().set(true);
    }

    public void browseActlistArchives() {
        this.shouldBrowseActlistArchives().set(true);
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoaderObject().get();
    }

    public HttpHost getProxyHost() {
        return (HttpHost)this.proxyHostObject().get();
    }

    public void requestShowActlist() {
        this.shouldRequestShowActlist().set((Object)true);
    }

    public void requestHideActlist() {
        this.shouldRequestShowActlist().set((Object)false);
    }

    public void requestDeactivate() {
        this.shouldRequestDeactivate().set(true);
    }

    public SupportedPlatform getCurrentPlatform() {
        return (SupportedPlatform)((Object)this.currentPlatformObject().get());
    }

    public boolean isDarkMode() {
        return this.darkModeProperty().get();
    }

    public class GraphicFunction
    extends Function {
        public GraphicFunction(Node graphic, Runnable action) {
            super(graphic, action);
        }
    }

    public class TextFunction
    extends Function {
        public TextFunction(String text, Runnable action) {
            super((Node)new Label(text), action);
        }
    }

    public class Function {
        Node graphic;
        Runnable action;

        Function(Node graphic, Runnable action) {
            this.graphic = graphic;
            this.action = action;
        }
    }

    public static enum SupportedPlatform {
        WINDOWS,
        MACOSX;

    }
}

