/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXRippler;
import com.sun.javafx.scene.control.skin.RadioButtonSkin;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class JFXRadioButtonSkin
extends RadioButtonSkin {
    private boolean invalid = true;
    private double padding = 15.0;
    private double contWidth;
    private double contHeight;
    private double maxHeight;
    private double radioRadius = 7.0;
    private final JFXRippler rippler;
    private Circle radio;
    private Circle dot;
    private Timeline timeline;
    private final AnchorPane container = new AnchorPane();
    private double labelOffset = -10.0;

    public JFXRadioButtonSkin(JFXRadioButton control) {
        super((RadioButton)control);
        this.radio = new Circle(this.radioRadius);
        this.radio.getStyleClass().setAll((Object[])new String[]{"radio"});
        this.radio.setStrokeWidth(2.0);
        this.radio.setFill((Paint)Color.TRANSPARENT);
        this.dot = new Circle();
        this.dot.getStyleClass().setAll((Object[])new String[]{"dot"});
        this.dot.setRadius(this.radioRadius);
        this.dot.fillProperty().bind(control.selectedColorProperty());
        this.dot.setScaleX(0.0);
        this.dot.setScaleY(0.0);
        StackPane boxContainer = new StackPane();
        boxContainer.getChildren().addAll((Object[])new Node[]{this.radio, this.dot});
        boxContainer.setPadding(new Insets(this.padding));
        this.rippler = new JFXRippler((Node)boxContainer, JFXRippler.RipplerMask.CIRCLE);
        this.container.getChildren().add((Object)this.rippler);
        AnchorPane.setRightAnchor((Node)this.rippler, (Double)this.labelOffset);
        this.updateChildren();
        this.registerChangeListener((ObservableValue)control.selectedColorProperty(), "SELECTED_COLOR");
        this.registerChangeListener((ObservableValue)control.unSelectedColorProperty(), "UNSELECTED_COLOR");
        this.registerChangeListener((ObservableValue)control.selectedProperty(), "SELECTED");
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.radio != null) {
            this.removeRadio();
            this.getChildren().add((Object)this.container);
        }
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("SELECTED_COLOR".equals(p)) {
            this.updateAnimation();
            boolean isSelected = ((RadioButton)this.getSkinnable()).isSelected();
            Color unSelectedColor = ((JFXRadioButton)this.getSkinnable()).getUnSelectedColor();
            Color selectedColor = ((JFXRadioButton)this.getSkinnable()).getSelectedColor();
            this.rippler.setRipplerFill((Paint)(isSelected ? selectedColor : unSelectedColor));
            if (isSelected) {
                this.radio.strokeProperty().set((Object)selectedColor);
            }
        } else if ("UNSELECTED_COLOR".equals(p)) {
            this.updateAnimation();
            boolean isSelected = ((RadioButton)this.getSkinnable()).isSelected();
            Color unSelectedColor = ((JFXRadioButton)this.getSkinnable()).getUnSelectedColor();
            Color selectedColor = ((JFXRadioButton)this.getSkinnable()).getSelectedColor();
            this.rippler.setRipplerFill((Paint)(isSelected ? selectedColor : unSelectedColor));
            if (!isSelected) {
                this.radio.strokeProperty().set((Object)unSelectedColor);
            }
        } else if ("SELECTED".equals(p)) {
            boolean isSelected = ((RadioButton)this.getSkinnable()).isSelected();
            Color unSelectedColor = ((JFXRadioButton)this.getSkinnable()).getUnSelectedColor();
            Color selectedColor = ((JFXRadioButton)this.getSkinnable()).getSelectedColor();
            this.rippler.setRipplerFill((Paint)(isSelected ? selectedColor : unSelectedColor));
            this.playAnimation();
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        RadioButton radioButton = (RadioButton)this.getSkinnable();
        this.contWidth = this.snapSize(this.container.prefWidth(-1.0)) + (double)(this.invalid ? 2 : 0);
        this.contHeight = this.snapSize(this.container.prefHeight(-1.0)) + (double)(this.invalid ? 2 : 0);
        double computeWidth = Math.min(radioButton.prefWidth(-1.0), radioButton.minWidth(-1.0)) + this.labelOffset + 2.0 * this.padding;
        double labelWidth = Math.min(computeWidth - this.contWidth, w - this.snapSize(this.contWidth)) + this.labelOffset + 2.0 * this.padding;
        double labelHeight = Math.min(radioButton.prefHeight(labelWidth), h);
        this.maxHeight = Math.max(this.contHeight, labelHeight);
        double xOffset = JFXRadioButtonSkin.computeXOffset(w, labelWidth + this.contWidth, radioButton.getAlignment().getHpos()) + x;
        double yOffset = JFXRadioButtonSkin.computeYOffset(h, this.maxHeight, radioButton.getAlignment().getVpos()) + x;
        if (this.invalid) {
            this.initializeComponents(x, y, w, h);
            this.invalid = false;
        }
        this.layoutLabelInArea(xOffset + this.contWidth, yOffset, labelWidth, this.maxHeight, radioButton.getAlignment());
        ((Text)this.getChildren().get(this.getChildren().get(0) instanceof Text ? 0 : 1)).textProperty().set(((RadioButton)this.getSkinnable()).textProperty().get());
        this.container.resize(this.snapSize(this.contWidth), this.snapSize(this.contHeight));
        this.positionInArea((Node)this.container, xOffset, yOffset, this.contWidth, this.maxHeight, 0.0, radioButton.getAlignment().getHpos(), radioButton.getAlignment().getVpos());
    }

    private void initializeComponents(double x, double y, double w, double h) {
        Color unSelectedColor = ((JFXRadioButton)this.getSkinnable()).getUnSelectedColor();
        Color selectedColor = ((JFXRadioButton)this.getSkinnable()).getSelectedColor();
        this.radio.setStroke((Paint)unSelectedColor);
        this.rippler.setRipplerFill((Paint)(((RadioButton)this.getSkinnable()).isSelected() ? selectedColor : unSelectedColor));
        this.updateAnimation();
        this.playAnimation();
    }

    private void playAnimation() {
        this.timeline.setRate(((RadioButton)this.getSkinnable()).isSelected() ? 1.0 : -1.0);
        this.timeline.play();
    }

    private void updateAnimation() {
        Color unSelectedColor = ((JFXRadioButton)this.getSkinnable()).getUnSelectedColor();
        Color selectedColor = ((JFXRadioButton)this.getSkinnable()).getSelectedColor();
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.dot.scaleXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.dot.scaleYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.radio.strokeProperty(), (Object)unSelectedColor, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)this.dot.scaleXProperty(), (Object)0.6, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.dot.scaleYProperty(), (Object)0.6, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.radio.strokeProperty(), (Object)selectedColor, Interpolator.EASE_BOTH)})});
    }

    private void removeRadio() {
        for (int i = 0; i < this.getChildren().size(); ++i) {
            if (!"radio".equals(((Node)this.getChildren().get(i)).getStyleClass().get(0))) continue;
            this.getChildren().remove(i);
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.radio.minWidth(-1.0)) + this.labelOffset + 2.0 * this.padding;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.radio.prefWidth(-1.0)) + this.labelOffset + 2.0 * this.padding;
    }

    static double computeXOffset(double width, double contentWidth, HPos hpos) {
        switch (hpos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (width - contentWidth) / 2.0;
            }
            case RIGHT: {
                return width - contentWidth;
            }
        }
        return 0.0;
    }

    static double computeYOffset(double height, double contentHeight, VPos vpos) {
        switch (vpos) {
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (height - contentHeight) / 2.0;
            }
            case BOTTOM: {
                return height - contentHeight;
            }
        }
        return 0.0;
    }
}

