/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXRippler$$Lambda$1;
import com.jfoenix.controls.JFXRippler$$Lambda$2;
import com.jfoenix.controls.JFXRippler$$Lambda$3;
import com.jfoenix.controls.JFXRippler$$Lambda$4;
import com.jfoenix.controls.JFXRippler$$Lambda$5;
import com.jfoenix.controls.JFXRippler$$Lambda$6;
import com.jfoenix.controls.JFXRippler$$Lambda$7;
import com.jfoenix.controls.JFXRippler$RippleGenerator$$Lambda$1;
import com.jfoenix.controls.JFXRippler$RippleGenerator$$Lambda$4;
import com.jfoenix.controls.JFXRippler$RippleGenerator$OverLayRipple$$Lambda$1;
import com.jfoenix.converters.RipplerMaskTypeConverter;
import com.jfoenix.transitions.CachedAnimation;
import com.jfoenix.transitions.CachedTransition;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

@DefaultProperty(value="control")
public class JFXRippler
extends StackPane {
    protected RippleGenerator rippler;
    protected Pane ripplerPane;
    protected Node control;
    private boolean enabled = true;
    private double RIPPLE_MAX_RADIUS = 300.0;
    private Interpolator rippleInterpolator = Interpolator.SPLINE((double)0.0825, (double)0.3025, (double)0.0875, (double)0.9975);
    private static final String DEFAULT_STYLE_CLASS = "jfx-rippler";
    private StyleableObjectProperty<Boolean> ripplerRecenter = new SimpleStyleableObjectProperty(StyleableProperties.access$700(), (Object)this, "ripplerRecenter", (Object)false);
    private StyleableObjectProperty<Number> ripplerRadius = new SimpleStyleableObjectProperty(StyleableProperties.access$800(), (Object)this, "ripplerRadius", (Object)-1.0);
    private StyleableObjectProperty<Paint> ripplerFill = new SimpleStyleableObjectProperty(StyleableProperties.access$900(), (Object)this, "ripplerFill", (Object)Color.rgb((int)0, (int)200, (int)255));
    private StyleableObjectProperty<RipplerMask> maskType = new SimpleStyleableObjectProperty(StyleableProperties.access$1000(), (Object)this, "maskType", (Object)RipplerMask.RECT);
    protected ObjectProperty<RipplerPos> position = new SimpleObjectProperty();

    public JFXRippler() {
        this(null, RipplerMask.RECT, RipplerPos.FRONT);
    }

    public JFXRippler(Node control) {
        this(control, RipplerMask.RECT, RipplerPos.FRONT);
    }

    public JFXRippler(Node control, RipplerPos pos) {
        this(control, RipplerMask.RECT, pos);
    }

    public JFXRippler(Node control, RipplerMask mask) {
        this(control, mask, RipplerPos.FRONT);
    }

    public JFXRippler(Node control, RipplerMask mask, RipplerPos pos) {
        this.initialize();
        this.maskType.set((Object)mask);
        this.position.set((Object)pos);
        this.setControl(control);
        this.setCache(true);
        this.setCacheHint(CacheHint.SPEED);
        this.setCacheShape(true);
        this.setSnapToPixel(false);
    }

    public void setControl(Node control) {
        if (control != null) {
            this.control = control;
            this.rippler = new RippleGenerator();
            this.ripplerPane = new StackPane();
            this.ripplerPane.getChildren().add((Object)this.rippler);
            if (this.position.get() == RipplerPos.BACK) {
                this.ripplerPane.getChildren().add((Object)this.control);
            } else {
                this.getChildren().add((Object)this.control);
            }
            this.position.addListener(JFXRippler$$Lambda$1.lambdaFactory$(this));
            this.getChildren().add((Object)this.ripplerPane);
            this.initListeners();
        }
    }

    public Node getControl() {
        return this.control;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    protected Node getMask() {
        Rectangle mask;
        double borderWidth = this.ripplerPane.getBorder() != null ? this.ripplerPane.getBorder().getInsets().getTop() : 0.0;
        Bounds bounds = this.control.getBoundsInParent();
        double width = this.control.getLayoutBounds().getWidth();
        double height = this.control.getLayoutBounds().getHeight();
        double diffMinX = Math.abs(this.control.getBoundsInLocal().getMinX() - this.control.getLayoutBounds().getMinX());
        double diffMinY = Math.abs(this.control.getBoundsInLocal().getMinY() - this.control.getLayoutBounds().getMinY());
        double diffMaxX = Math.abs(this.control.getBoundsInLocal().getMaxX() - this.control.getLayoutBounds().getMaxX());
        double diffMaxY = Math.abs(this.control.getBoundsInLocal().getMaxY() - this.control.getLayoutBounds().getMaxY());
        switch (this.getMaskType()) {
            case RECT: {
                mask = new Rectangle(bounds.getMinX() + diffMinX, bounds.getMinY() + diffMinY, width - 0.1 - 2.0 * borderWidth, height - 0.1 - 2.0 * borderWidth);
                break;
            }
            case CIRCLE: {
                double radius = Math.min(width / 2.0 - 0.1 - 2.0 * borderWidth, height / 2.0 - 0.1 - 2.0 * borderWidth);
                mask = new Circle((bounds.getMinX() + diffMinX + bounds.getMaxX() - diffMaxX) / 2.0, (bounds.getMinY() + diffMinY + bounds.getMaxY() - diffMaxY) / 2.0, radius, (Paint)Color.BLUE);
                break;
            }
            default: {
                mask = new Rectangle(bounds.getMinX() + diffMinX, bounds.getMinY() + diffMinY, width - 0.1 - 2.0 * borderWidth, height - 0.1 - 2.0 * borderWidth);
            }
        }
        if (this.control instanceof Shape || this.control instanceof Region && ((Region)this.control).getShape() != null) {
            mask = new StackPane();
            ((Region)mask).setShape(this.control instanceof Shape ? (Shape)this.control : ((Region)this.control).getShape());
            ((Region)mask).setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
            mask.resize(width, height);
            mask.relocate(bounds.getMinX() + diffMinX, bounds.getMinY() + diffMinY);
        }
        return mask;
    }

    protected double computeRippleRadius() {
        double width2 = this.control.getLayoutBounds().getWidth() * this.control.getLayoutBounds().getWidth();
        double height2 = this.control.getLayoutBounds().getHeight() * this.control.getLayoutBounds().getHeight();
        double radius = Math.min(Math.sqrt(width2 + height2), this.RIPPLE_MAX_RADIUS) * 1.1 + 5.0;
        return radius;
    }

    protected void initListeners() {
        this.ripplerPane.setOnMousePressed(JFXRippler$$Lambda$2.lambdaFactory$(this));
        this.ripplerPane.setOnMouseReleased(JFXRippler$$Lambda$3.lambdaFactory$(this));
        this.ripplerPane.setOnMouseClicked(JFXRippler$$Lambda$4.lambdaFactory$(this));
        this.control.layoutBoundsProperty().addListener(JFXRippler$$Lambda$5.lambdaFactory$(this));
        this.control.boundsInParentProperty().addListener(JFXRippler$$Lambda$6.lambdaFactory$(this));
    }

    protected void createRipple(double x, double y) {
        this.rippler.setGeneratorCenterX(x);
        this.rippler.setGeneratorCenterY(y);
        this.rippler.createRipple();
    }

    public void fireEventProgrammatically(Event event) {
        if (!event.isConsumed()) {
            this.ripplerPane.fireEvent(event);
        }
    }

    private void resetOverLay() {
        if (this.rippler.overlayRect != null) {
            ((RippleGenerator)this.rippler).overlayRect.inAnimation.stop();
            RippleGenerator.OverLayRipple oldOverlay = this.rippler.overlayRect;
            ((RippleGenerator)this.rippler).overlayRect.outAnimation.setOnFinished(JFXRippler$$Lambda$7.lambdaFactory$(this, oldOverlay));
            ((RippleGenerator)this.rippler).overlayRect.outAnimation.play();
            this.rippler.overlayRect = null;
        }
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public Boolean isRipplerRecenter() {
        return this.ripplerRecenter == null ? Boolean.valueOf(false) : (Boolean)this.ripplerRecenter.get();
    }

    public StyleableObjectProperty<Boolean> ripplerRecenterProperty() {
        return this.ripplerRecenter;
    }

    public void setRipplerRecenter(Boolean radius) {
        this.ripplerRecenter.set((Object)radius);
    }

    public Number getRipplerRadius() {
        return this.ripplerRadius == null ? (Number)-1.0 : (Number)((Number)this.ripplerRadius.get());
    }

    public StyleableObjectProperty<Number> ripplerRadiusProperty() {
        return this.ripplerRadius;
    }

    public void setRipplerRadius(Number radius) {
        this.ripplerRadius.set((Object)radius);
    }

    public Paint getRipplerFill() {
        return this.ripplerFill == null ? Color.rgb((int)0, (int)200, (int)255) : (Paint)this.ripplerFill.get();
    }

    public StyleableObjectProperty<Paint> ripplerFillProperty() {
        return this.ripplerFill;
    }

    public void setRipplerFill(Paint color) {
        this.ripplerFill.set((Object)color);
    }

    public RipplerMask getMaskType() {
        return this.maskType == null ? RipplerMask.RECT : (RipplerMask)((Object)this.maskType.get());
    }

    public StyleableObjectProperty<RipplerMask> maskTypeProperty() {
        return this.maskType;
    }

    public void setMaskType(RipplerMask type) {
        this.maskType.set((Object)type);
    }

    public void setPosition(RipplerPos pos) {
        this.position.set((Object)pos);
    }

    public RipplerPos getPosition() {
        return this.position == null ? RipplerPos.FRONT : (RipplerPos)((Object)this.position.get());
    }

    public ObjectProperty<RipplerPos> positionProperty() {
        return this.position;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return JFXRippler.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private /* synthetic */ void lambda$resetOverLay$154(RippleGenerator.OverLayRipple oldOverlay, ActionEvent finish) {
        this.rippler.getChildren().remove((Object)oldOverlay);
    }

    private /* synthetic */ void lambda$initListeners$150(ObservableValue o, Bounds oldVal, Bounds newVal) {
        this.resetOverLay();
    }

    private /* synthetic */ void lambda$initListeners$149(ObservableValue o, Bounds oldVal, Bounds newVal) {
        this.resetOverLay();
    }

    private /* synthetic */ void lambda$initListeners$148(MouseEvent event) {
        if (this.position.get() == RipplerPos.FRONT) {
            this.control.fireEvent((Event)event);
        }
    }

    private /* synthetic */ void lambda$initListeners$147(MouseEvent event) {
        if (this.position.get() == RipplerPos.FRONT) {
            this.control.fireEvent((Event)event);
        }
    }

    private /* synthetic */ void lambda$initListeners$146(MouseEvent event) {
        this.createRipple(event.getX(), event.getY());
        if (this.position.get() == RipplerPos.FRONT) {
            this.control.fireEvent((Event)event);
        }
    }

    private /* synthetic */ void lambda$setControl$145(ObservableValue o, RipplerPos oldVal, RipplerPos newVal) {
        if (this.position.get() == RipplerPos.BACK) {
            this.ripplerPane.getChildren().add((Object)this.control);
        } else {
            this.getChildren().add((Object)this.control);
        }
    }

    static /* synthetic */ void access$lambda$0(JFXRippler jFXRippler, ObservableValue observableValue, RipplerPos ripplerPos, RipplerPos ripplerPos2) {
        jFXRippler.lambda$setControl$145(observableValue, ripplerPos, ripplerPos2);
    }

    static /* synthetic */ void access$lambda$1(JFXRippler jFXRippler, MouseEvent mouseEvent) {
        jFXRippler.lambda$initListeners$146(mouseEvent);
    }

    static /* synthetic */ void access$lambda$2(JFXRippler jFXRippler, MouseEvent mouseEvent) {
        jFXRippler.lambda$initListeners$147(mouseEvent);
    }

    static /* synthetic */ void access$lambda$3(JFXRippler jFXRippler, MouseEvent mouseEvent) {
        jFXRippler.lambda$initListeners$148(mouseEvent);
    }

    static /* synthetic */ void access$lambda$4(JFXRippler jFXRippler, ObservableValue observableValue, Bounds bounds, Bounds bounds2) {
        jFXRippler.lambda$initListeners$149(observableValue, bounds, bounds2);
    }

    static /* synthetic */ void access$lambda$5(JFXRippler jFXRippler, ObservableValue observableValue, Bounds bounds, Bounds bounds2) {
        jFXRippler.lambda$initListeners$150(observableValue, bounds, bounds2);
    }

    static /* synthetic */ void access$lambda$6(JFXRippler jFXRippler, RippleGenerator.OverLayRipple overLayRipple, ActionEvent actionEvent) {
        jFXRippler.lambda$resetOverLay$154(overLayRipple, actionEvent);
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXRippler, Boolean> RIPPLER_RECENTER = new CssMetaData<JFXRippler, Boolean>("-fx-rippler-recenter", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(JFXRippler control) {
                return control.ripplerRecenter == null || !control.ripplerRecenter.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(JFXRippler control) {
                return control.ripplerRecenterProperty();
            }
        };
        private static final CssMetaData<JFXRippler, Paint> RIPPLER_FILL = new CssMetaData<JFXRippler, Paint>("-fx-rippler-fill", PaintConverter.getInstance(), (Paint)Color.rgb((int)0, (int)200, (int)255)){

            public boolean isSettable(JFXRippler control) {
                return control.ripplerFill == null || !control.ripplerFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXRippler control) {
                return control.ripplerFillProperty();
            }
        };
        private static final CssMetaData<JFXRippler, Number> RIPPLER_RADIUS = new CssMetaData<JFXRippler, Number>("-fx-rippler-radius", SizeConverter.getInstance(), (Number)-1.0){

            public boolean isSettable(JFXRippler control) {
                return control.ripplerRadius == null || !control.ripplerRadius.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(JFXRippler control) {
                return control.ripplerRadiusProperty();
            }
        };
        private static final CssMetaData<JFXRippler, RipplerMask> MASK_TYPE = new CssMetaData<JFXRippler, RipplerMask>("-fx-mask-type", RipplerMaskTypeConverter.getInstance(), RipplerMask.RECT){

            public boolean isSettable(JFXRippler control) {
                return control.maskType == null || !control.maskType.isBound();
            }

            public StyleableProperty<RipplerMask> getStyleableProperty(JFXRippler control) {
                return control.maskTypeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$700() {
            return RIPPLER_RECENTER;
        }

        static /* synthetic */ CssMetaData access$800() {
            return RIPPLER_RADIUS;
        }

        static /* synthetic */ CssMetaData access$900() {
            return RIPPLER_FILL;
        }

        static /* synthetic */ CssMetaData access$1000() {
            return MASK_TYPE;
        }

        static {
            ArrayList styleables = new ArrayList(Parent.getClassCssMetaData());
            Collections.addAll(styleables, RIPPLER_RECENTER, RIPPLER_RADIUS, RIPPLER_FILL, MASK_TYPE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    class RippleGenerator
    extends Group {
        private double generatorCenterX = 0.0;
        private double generatorCenterY = 0.0;
        private OverLayRipple overlayRect;
        private AtomicBoolean generating = new AtomicBoolean(false);
        private boolean cacheRipplerClip = false;

        public RippleGenerator() {
            this.setManaged(false);
        }

        public void createRipple() {
            if (JFXRippler.this.enabled && !this.generating.getAndSet(true)) {
                this.createOverlay();
                if (this.getClip() == null || this.getChildren().size() == 1 && !this.cacheRipplerClip) {
                    this.setClip(JFXRippler.this.getMask());
                }
                Ripple ripple = new Ripple(this.generatorCenterX, this.generatorCenterY);
                this.getChildren().add((Object)ripple);
                this.overlayRect.outAnimation.stop();
                this.overlayRect.inAnimation.play();
                ripple.inAnimation.getAnimation().play();
                JFXRippler.this.ripplerPane.setOnMouseReleased(JFXRippler$RippleGenerator$$Lambda$1.lambdaFactory$(this, ripple));
            }
        }

        void cacheRippleClip(boolean cached) {
            this.cacheRipplerClip = cached;
        }

        public void createOverlay() {
            if (this.overlayRect == null) {
                this.overlayRect = new OverLayRipple();
                this.overlayRect.setClip(JFXRippler.this.getMask());
                this.getChildren().add(0, (Object)this.overlayRect);
                this.overlayRect.setFill((Paint)new Color(((Color)JFXRippler.this.ripplerFill.get()).getRed(), ((Color)JFXRippler.this.ripplerFill.get()).getGreen(), ((Color)JFXRippler.this.ripplerFill.get()).getBlue(), 0.2));
            }
        }

        public void setGeneratorCenterX(double generatorCenterX) {
            this.generatorCenterX = generatorCenterX;
        }

        public void setGeneratorCenterY(double generatorCenterY) {
            this.generatorCenterY = generatorCenterY;
        }

        public void clear() {
            this.getChildren().clear();
            this.generating.set(false);
        }

        private /* synthetic */ void lambda$createRipple$152(Ripple ripple, MouseEvent e) {
            if (this.generating.getAndSet(false)) {
                if (this.overlayRect != null) {
                    this.overlayRect.inAnimation.stop();
                }
                ripple.inAnimation.getAnimation().stop();
                ripple.outAnimation = new CachedAnimation((Animation)new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)Math.min(800.0, 450.0 / ripple.getScaleX())), ripple.outKeyValues)}), new Node[]{this});
                ripple.outAnimation.getAnimation().setOnFinished(JFXRippler$RippleGenerator$$Lambda$4.lambdaFactory$(this, ripple));
                ripple.outAnimation.getAnimation().play();
                if (this.overlayRect != null) {
                    this.overlayRect.outAnimation.play();
                }
            }
        }

        private /* synthetic */ void lambda$null$151(Ripple ripple, ActionEvent event) {
            this.getChildren().remove((Object)ripple);
        }

        static /* synthetic */ void access$lambda$0(RippleGenerator rippleGenerator, Ripple ripple, MouseEvent mouseEvent) {
            rippleGenerator.lambda$createRipple$152(ripple, mouseEvent);
        }

        static /* synthetic */ void access$lambda$1(RippleGenerator rippleGenerator, Ripple ripple, ActionEvent actionEvent) {
            rippleGenerator.lambda$null$151(ripple, actionEvent);
        }

        private class Ripple
        extends Circle {
            KeyValue[] outKeyValues;
            CachedAnimation outAnimation;
            CachedAnimation inAnimation;

            private Ripple(double centerX, double centerY) {
                super(centerX, centerY, ((Number)JFXRippler.this.ripplerRadius.get()).doubleValue() == -1.0 ? JFXRippler.this.computeRippleRadius() : ((Number)JFXRippler.this.ripplerRadius.get()).doubleValue(), null);
                this.outAnimation = null;
                this.inAnimation = null;
                KeyValue[] inKeyValues = new KeyValue[JFXRippler.this.isRipplerRecenter() != false ? 4 : 2];
                this.outKeyValues = new KeyValue[JFXRippler.this.isRipplerRecenter() != false ? 5 : 3];
                inKeyValues[0] = new KeyValue((WritableValue)this.scaleXProperty(), (Object)0.9, JFXRippler.this.rippleInterpolator);
                inKeyValues[1] = new KeyValue((WritableValue)this.scaleYProperty(), (Object)0.9, JFXRippler.this.rippleInterpolator);
                this.outKeyValues[0] = new KeyValue((WritableValue)this.scaleXProperty(), (Object)1, JFXRippler.this.rippleInterpolator);
                this.outKeyValues[1] = new KeyValue((WritableValue)this.scaleYProperty(), (Object)1, JFXRippler.this.rippleInterpolator);
                this.outKeyValues[2] = new KeyValue((WritableValue)this.opacityProperty(), (Object)0, JFXRippler.this.rippleInterpolator);
                if (JFXRippler.this.isRipplerRecenter().booleanValue()) {
                    double dx = (JFXRippler.this.control.getLayoutBounds().getWidth() / 2.0 - centerX) / 1.55;
                    double dy = (JFXRippler.this.control.getLayoutBounds().getHeight() / 2.0 - centerY) / 1.55;
                    inKeyValues[2] = this.outKeyValues[3] = new KeyValue((WritableValue)this.translateXProperty(), (Object)(Math.signum(dx) * Math.min(Math.abs(dx), this.getRadius() / 2.0)), JFXRippler.this.rippleInterpolator);
                    inKeyValues[3] = this.outKeyValues[4] = new KeyValue((WritableValue)this.translateYProperty(), (Object)(Math.signum(dy) * Math.min(Math.abs(dy), this.getRadius() / 2.0)), JFXRippler.this.rippleInterpolator);
                }
                this.inAnimation = new CachedAnimation((Animation)new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.scaleXProperty(), (Object)0, JFXRippler.this.rippleInterpolator), new KeyValue((WritableValue)this.scaleYProperty(), (Object)0, JFXRippler.this.rippleInterpolator), new KeyValue((WritableValue)this.translateXProperty(), (Object)0, JFXRippler.this.rippleInterpolator), new KeyValue((WritableValue)this.translateYProperty(), (Object)0, JFXRippler.this.rippleInterpolator), new KeyValue((WritableValue)this.opacityProperty(), (Object)1, JFXRippler.this.rippleInterpolator)}), new KeyFrame(Duration.millis((double)900.0), inKeyValues)}), new Node[]{this});
                this.setCache(true);
                this.setCacheHint(CacheHint.SPEED);
                JFXRippler.this.setCacheShape(true);
                JFXRippler.this.setSnapToPixel(false);
                this.setScaleX(0.0);
                this.setScaleY(0.0);
                if (JFXRippler.this.ripplerFill.get() instanceof Color) {
                    Color circleColor = new Color(((Color)JFXRippler.this.ripplerFill.get()).getRed(), ((Color)JFXRippler.this.ripplerFill.get()).getGreen(), ((Color)JFXRippler.this.ripplerFill.get()).getBlue(), 0.3);
                    this.setStroke((Paint)circleColor);
                    this.setFill((Paint)circleColor);
                } else {
                    this.setStroke((Paint)JFXRippler.this.ripplerFill.get());
                    this.setFill((Paint)JFXRippler.this.ripplerFill.get());
                }
            }
        }

        private class OverLayRipple
        extends Rectangle {
            CachedTransition inAnimation;
            CachedTransition outAnimation;

            public OverLayRipple() {
                super(JFXRippler.this.control.getLayoutBounds().getWidth() - 0.1, JFXRippler.this.control.getLayoutBounds().getHeight() - 0.1);
                this.inAnimation = new CachedTransition((Node)this, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1300.0), new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)1, Interpolator.EASE_IN)})})){
                    {
                        this.setDelay(Duration.millis((double)0.0));
                        this.setCycleDuration(Duration.millis((double)300.0));
                    }
                };
                this.outAnimation = new CachedTransition((Node)this, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1300.0), new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)0, Interpolator.EASE_OUT)})})){
                    {
                        this.setDelay(Duration.millis((double)0.0));
                        this.setCycleDuration(Duration.millis((double)300.0));
                    }
                };
                this.getStyleClass().add((Object)"jfx-rippler-overlay");
                double diffMinX = Math.abs(JFXRippler.this.control.getBoundsInLocal().getMinX() - JFXRippler.this.control.getLayoutBounds().getMinX());
                double diffMinY = Math.abs(JFXRippler.this.control.getBoundsInLocal().getMinY() - JFXRippler.this.control.getLayoutBounds().getMinY());
                Bounds bounds = JFXRippler.this.control.getBoundsInParent();
                this.setX(bounds.getMinX() + diffMinX);
                this.setY(bounds.getMinY() + diffMinY);
                this.setOpacity(0.0);
                this.setCache(true);
                this.setCacheHint(CacheHint.SPEED);
                JFXRippler.this.setCacheShape(true);
                JFXRippler.this.setSnapToPixel(false);
                this.outAnimation.setOnFinished(JFXRippler$RippleGenerator$OverLayRipple$$Lambda$1.lambdaFactory$(this));
            }

            private /* synthetic */ void lambda$new$153(ActionEvent finish) {
                JFXRippler.this.resetOverLay();
            }

            static /* synthetic */ void access$lambda$0(OverLayRipple overLayRipple, ActionEvent actionEvent) {
                overLayRipple.lambda$new$153(actionEvent);
            }
        }
    }

    public static enum RipplerMask {
        CIRCLE,
        RECT;

    }

    public static enum RipplerPos {
        FRONT,
        BACK;

    }
}

