/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.view.explore;

import java.awt.Desktop;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.silentsoft.actlist.application.App;
import org.silentsoft.actlist.plugin.PluginManager;
import org.silentsoft.actlist.plugin.messagebox.MessageBox;
import org.silentsoft.actlist.rest.RESTfulAPI;
import org.silentsoft.io.event.EventHandler;
import org.silentsoft.io.memory.SharedMemory;
import org.silentsoft.ui.viewer.AbstractViewerController;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLElement;

public class ExploreController
extends AbstractViewerController {
    @FXML
    private WebView webView;
    @FXML
    private VBox loadingBox;

    public void initialize(Parent parent, Object ... objectArray) {
        new Thread(() -> Platform.runLater(() -> {
            this.webView.getEngine().setUserAgent(String.valueOf(SharedMemory.getDataMap().get((Object)"KEY_USER_AGENT")));
            this.webView.getEngine().setCreatePopupHandler(popupFeatures -> {
                WebEngine webEngine = new WebEngine();
                webEngine.locationProperty().addListener((observableValue, string, string2) -> {
                    if (string2 != null) {
                        if (Desktop.isDesktopSupported()) {
                            try {
                                Desktop.getDesktop().browse(URI.create(string2));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        } else {
                            this.webView.getEngine().load(string2);
                        }
                    }
                });
                return webEngine;
            });
            ChangeListener<Worker.State> changeListener = new ChangeListener<Worker.State>(){

                public void changed(ObservableValue<? extends Worker.State> observableValue, Worker.State state, Worker.State state2) {
                    if (Worker.State.SUCCEEDED.equals((Object)state2)) {
                        ExploreController.this.loadingBox.setVisible(false);
                        Document document = ExploreController.this.webView.getEngine().getDocument();
                        NodeList nodeList = document.getElementsByTagName("a");
                        int n = nodeList.getLength();
                        for (int i = 0; i < n; ++i) {
                            Node node = nodeList.item(i);
                            if (!(node instanceof EventTarget)) continue;
                            ((EventTarget)((Object)node)).addEventListener("click", new EventListener(){

                                @Override
                                public void handleEvent(Event event) {
                                    HTMLAnchorElement hTMLAnchorElement = (HTMLAnchorElement)((Object)event.getCurrentTarget());
                                    String string2 = hTMLAnchorElement.getClassName();
                                    if (string2 != null) {
                                        if (string2.contains("actlist-plugin-download")) {
                                            String string3 = hTMLAnchorElement.getHref();
                                            if (string3 != null) {
                                                if (string3.toLowerCase().endsWith(".jar")) {
                                                    Consumer<String> consumer = string -> {
                                                        Node node;
                                                        if (hTMLAnchorElement.getChildNodes().getLength() > 0 && (node = hTMLAnchorElement.getChildNodes().item(0)) instanceof HTMLElement) {
                                                            HTMLElement hTMLElement = (HTMLElement)node;
                                                            hTMLElement.setClassName((String)string);
                                                        }
                                                    };
                                                    consumer.accept("fa fa-spinner fa-pulse");
                                                    hTMLAnchorElement.setClassName(string2.replace("actlist-plugin-download", "actlist-plugin-installing"));
                                                    new Thread(() -> {
                                                        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                                                        AtomicBoolean atomicBoolean2 = new AtomicBoolean(false);
                                                        AtomicInteger atomicInteger = new AtomicInteger();
                                                        AtomicReference atomicReference = new AtomicReference();
                                                        AtomicReference atomicReference2 = new AtomicReference();
                                                        try {
                                                            RESTfulAPI.doGet(string3, httpRequest -> {}, httpResponse -> {
                                                                try {
                                                                    HttpEntity httpEntity;
                                                                    StatusLine statusLine = httpResponse.getStatusLine();
                                                                    if (statusLine != null) {
                                                                        atomicInteger.set(statusLine.getStatusCode());
                                                                        atomicReference.set(statusLine.getReasonPhrase());
                                                                    }
                                                                    if ((httpEntity = httpResponse.getEntity()) != null) {
                                                                        Path path;
                                                                        InputStream inputStream = httpEntity.getContent();
                                                                        String string2 = UUID.randomUUID().toString().replaceAll("-", "");
                                                                        Path path2 = Paths.get(System.getProperty("java.io.tmpdir"), string2.concat(".partial"));
                                                                        if (Files.notExists(path2.getParent(), new LinkOption[0])) {
                                                                            Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                                                                        }
                                                                        Files.createFile(path2, new FileAttribute[0]);
                                                                        FileOutputStream fileOutputStream = new FileOutputStream(path2.toString());
                                                                        IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                                                                        ((OutputStream)fileOutputStream).close();
                                                                        new JarFile(path2.toString()).close();
                                                                        String string3 = String.valueOf(Paths.get(URI.create(string3).getPath(), new String[0]).getFileName());
                                                                        if (!string3.toLowerCase().endsWith(".jar")) {
                                                                            string3 = string3.concat(".jar");
                                                                        }
                                                                        if (Files.exists(path = Paths.get(System.getProperty("user.dir"), "plugins", string3), new LinkOption[0])) {
                                                                            path = Paths.get(System.getProperty("user.dir"), "plugins", string2.concat(".jar"));
                                                                        }
                                                                        String string4 = String.valueOf(path.getFileName());
                                                                        Files.move(path2, path, new CopyOption[0]);
                                                                        CountDownLatch countDownLatch = new CountDownLatch(1);
                                                                        Platform.runLater(() -> {
                                                                            try {
                                                                                PluginManager.load(string4, true);
                                                                                EventHandler.callEvent(this.getClass(), (String)"EVENT_SAVE_PRIORITY_OF_PLUGINS");
                                                                            }
                                                                            catch (Error | Exception throwable) {
                                                                                throwable.printStackTrace();
                                                                            }
                                                                            finally {
                                                                                countDownLatch.countDown();
                                                                            }
                                                                        });
                                                                        countDownLatch.await();
                                                                        atomicBoolean.set(true);
                                                                    }
                                                                }
                                                                catch (Exception exception) {
                                                                    System.out.println(String.format("Failed to install (%s -> status : %d - %s)", string3, atomicInteger.get(), atomicReference.get()));
                                                                    exception.printStackTrace();
                                                                    atomicReference2.set(exception);
                                                                }
                                                            });
                                                        }
                                                        catch (Exception exception) {
                                                            exception.printStackTrace();
                                                            atomicBoolean2.set(true);
                                                        }
                                                        if (atomicBoolean.get()) {
                                                            EventHandler.callEvent(this.getClass(), (String)"EVENT_PLAY_NEW_PLUGINS_ALARM");
                                                            Platform.runLater(() -> {
                                                                Optional optional = MessageBox.showConfirm((Object)App.getStage(), (String)"Succeed to install", (String)"Do you want to check it out the new plugin ?");
                                                                if (optional.isPresent() && optional.get() == ButtonType.OK) {
                                                                    EventHandler.callEvent(this.getClass(), (String)"EVENT_SHOW_PLUGINS_VIEW", (boolean)false);
                                                                }
                                                            });
                                                        } else if (atomicBoolean2.get()) {
                                                            if (Desktop.isDesktopSupported()) {
                                                                try {
                                                                    Desktop.getDesktop().browse(URI.create(string3));
                                                                }
                                                                catch (Exception exception) {
                                                                    exception.printStackTrace();
                                                                }
                                                            }
                                                        } else {
                                                            MessageBox.showException((Object)App.getStage(), (String)String.format("Failed to install (%d)", atomicInteger.get()), (String)((String)atomicReference.get()), (Throwable)((Throwable)atomicReference2.get()));
                                                        }
                                                        Platform.runLater(() -> {
                                                            consumer.accept("fa fa-download");
                                                            hTMLAnchorElement.setClassName(string2.replace("actlist-plugin-installing", "actlist-plugin-download"));
                                                        });
                                                    }).start();
                                                } else if (Desktop.isDesktopSupported()) {
                                                    try {
                                                        Desktop.getDesktop().browse(URI.create(string3));
                                                    }
                                                    catch (Exception exception) {
                                                        exception.printStackTrace();
                                                    }
                                                }
                                            }
                                            event.preventDefault();
                                        } else if (string2.contains("actlist-plugin-installing")) {
                                            event.preventDefault();
                                        }
                                    }
                                }
                            }, false);
                        }
                    } else if (Worker.State.FAILED.equals((Object)state2)) {
                        ExploreController.this.webView.getEngine().getLoadWorker().stateProperty().removeListener((ChangeListener)this);
                        ExploreController.this.showFailureContent();
                    }
                }
            };
            this.webView.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)changeListener);
            this.webView.getEngine().load("http://actlist.silentsoft.org/explore/");
        })).start();
    }

    private void showFailureContent() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append("    <head>");
        stringBuffer.append("        <style>");
        stringBuffer.append("            .container {");
        stringBuffer.append("                display: table;");
        stringBuffer.append("                width: 100%;");
        stringBuffer.append("                height: 100%;");
        stringBuffer.append("            ");
        stringBuffer.append("            }");
        stringBuffer.append("            .content {");
        stringBuffer.append("                display: table-cell;");
        stringBuffer.append("                vertical-align: middle;");
        stringBuffer.append("                text-align: center;");
        stringBuffer.append("            ");
        stringBuffer.append("            }");
        stringBuffer.append("            span {");
        stringBuffer.append("                font-family: Verdana;");
        stringBuffer.append("            ");
        stringBuffer.append("            }");
        stringBuffer.append("        </style>");
        stringBuffer.append("    </head>");
        stringBuffer.append("    <body>");
        stringBuffer.append("        <div class='container'>");
        stringBuffer.append("            <div class='content'>");
        stringBuffer.append("                <div>");
        stringBuffer.append("                    <svg width='24' height='24'><path d='M12 2.02c-5.51 0-9.98 4.47-9.98 9.98s4.47 9.98 9.98 9.98 9.98-4.47 9.98-9.98S17.51 2.02 12 2.02zM11.48 20v-6.26H8L13 4v6.26h3.35L11.48 20z'/></svg>");
        stringBuffer.append("                </div>");
        stringBuffer.append("                <div>");
        stringBuffer.append("                    <span>Network unavailable.</span>");
        stringBuffer.append("                </div>");
        stringBuffer.append("            </div>");
        stringBuffer.append("        </div>");
        stringBuffer.append("    </body>");
        stringBuffer.append("</html>");
        this.webView.getEngine().loadContent(stringBuffer.toString());
    }
}

