/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.wbmp;

import com.sun.imageio.plugins.common.I18N;
import com.sun.imageio.plugins.wbmp.WBMPMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class WBMPImageWriter
extends ImageWriter {
    private ImageOutputStream stream = null;

    private static int getNumBits(int n) {
        int n2 = 32;
        for (int i = Integer.MIN_VALUE; i != 0 && (n & i) == 0; i >>>= 1) {
            --n2;
        }
        return n2;
    }

    private static byte[] intToMultiByte(int n) {
        int n2 = WBMPImageWriter.getNumBits(n);
        byte[] byArray = new byte[(n2 + 6) / 7];
        int n3 = byArray.length - 1;
        for (int i = 0; i <= n3; ++i) {
            byArray[i] = (byte)(n >>> (n3 - i) * 7 & 0x7F);
            if (i == n3) continue;
            int n4 = i;
            byArray[n4] = (byte)(byArray[n4] | 0xFFFFFF80);
        }
        return byArray;
    }

    public WBMPImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    @Override
    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("WBMPImageWriter"));
            }
            this.stream = (ImageOutputStream)object;
        } else {
            this.stream = null;
        }
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        WBMPMetadata wBMPMetadata = new WBMPMetadata();
        wBMPMetadata.wbmpType = 0;
        return wBMPMetadata;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    @Override
    public boolean canWriteRasters() {
        return true;
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        WritableRaster writableRaster;
        if (this.stream == null) {
            throw new IllegalStateException(I18N.getString("WBMPImageWriter3"));
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException(I18N.getString("WBMPImageWriter4"));
        }
        this.clearAbortRequest();
        this.processImageStarted(0);
        if (imageWriteParam == null) {
            imageWriteParam = this.getDefaultWriteParam();
        }
        RenderedImage renderedImage = null;
        Raster raster = null;
        boolean bl = iIOImage.hasRaster();
        Rectangle rectangle = imageWriteParam.getSourceRegion();
        SampleModel sampleModel = null;
        if (bl) {
            raster = iIOImage.getRaster();
            sampleModel = raster.getSampleModel();
        } else {
            renderedImage = iIOImage.getRenderedImage();
            sampleModel = renderedImage.getSampleModel();
            raster = renderedImage.getData();
        }
        this.checkSampleModel(sampleModel);
        rectangle = rectangle == null ? raster.getBounds() : rectangle.intersection(raster.getBounds());
        if (rectangle.isEmpty()) {
            throw new RuntimeException(I18N.getString("WBMPImageWriter1"));
        }
        int n6 = imageWriteParam.getSourceXSubsampling();
        int n7 = imageWriteParam.getSourceYSubsampling();
        int n8 = imageWriteParam.getSubsamplingXOffset();
        int n9 = imageWriteParam.getSubsamplingYOffset();
        rectangle.translate(n8, n9);
        rectangle.width -= n8;
        rectangle.height -= n9;
        int n10 = rectangle.x / n6;
        int n11 = rectangle.y / n7;
        int n12 = (rectangle.width + n6 - 1) / n6;
        int n13 = (rectangle.height + n7 - 1) / n7;
        Rectangle rectangle2 = new Rectangle(n10, n11, n12, n13);
        SampleModel sampleModel2 = sampleModel = sampleModel.createCompatibleSampleModel(n12, n13);
        if (sampleModel.getDataType() != 0 || !(sampleModel instanceof MultiPixelPackedSampleModel) || ((MultiPixelPackedSampleModel)sampleModel).getDataBitOffset() != 0) {
            sampleModel2 = new MultiPixelPackedSampleModel(0, n12, n13, 1, n12 + 7 >> 3, 0);
        }
        if (!rectangle2.equals(rectangle)) {
            if (n6 == 1 && n7 == 1) {
                raster = raster.createChild(raster.getMinX(), raster.getMinY(), n12, n13, n10, n11, null);
            } else {
                writableRaster = Raster.createWritableRaster(sampleModel2, new Point(n10, n11));
                object = ((DataBufferByte)writableRaster.getDataBuffer()).getData();
                n5 = n11;
                int n14 = rectangle.y;
                n4 = 0;
                while (n5 < n11 + n13) {
                    n3 = 0;
                    n2 = rectangle.x;
                    while (n3 < n12) {
                        n = raster.getSample(n2, n14, 0);
                        Object object2 = object;
                        int n15 = n4 + (n3 >> 3);
                        object2[n15] = (byte)(object2[n15] | n << 7 - (n3 & 7));
                        ++n3;
                        n2 += n6;
                    }
                    n4 += n12 + 7 >> 3;
                    ++n5;
                    n14 += n7;
                }
                raster = writableRaster;
            }
        }
        if (!sampleModel2.equals(raster.getSampleModel())) {
            writableRaster = Raster.createWritableRaster(sampleModel2, new Point(raster.getMinX(), raster.getMinY()));
            writableRaster.setRect(raster);
            raster = writableRaster;
        }
        boolean bl2 = false;
        if (!bl && renderedImage.getColorModel() instanceof IndexColorModel) {
            object = (IndexColorModel)renderedImage.getColorModel();
            bl2 = ((IndexColorModel)object).getRed(0) > ((IndexColorModel)object).getRed(1);
        }
        int n16 = ((MultiPixelPackedSampleModel)sampleModel2).getScanlineStride();
        n5 = (n12 + 7) / 8;
        byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
        this.stream.write(0);
        this.stream.write(0);
        this.stream.write(WBMPImageWriter.intToMultiByte(n12));
        this.stream.write(WBMPImageWriter.intToMultiByte(n13));
        if (!bl2 && n16 == n5) {
            this.stream.write(byArray, 0, n13 * n5);
            this.processImageProgress(100.0f);
        } else {
            n4 = 0;
            if (!bl2) {
                for (n3 = 0; n3 < n13 && !this.abortRequested(); ++n3) {
                    this.stream.write(byArray, n4, n5);
                    n4 += n16;
                    this.processImageProgress(100.0f * (float)n3 / (float)n13);
                }
            } else {
                byte[] byArray2 = new byte[n5];
                for (n2 = 0; n2 < n13 && !this.abortRequested(); ++n2) {
                    for (n = 0; n < n5; ++n) {
                        byArray2[n] = ~byArray[n + n4];
                    }
                    this.stream.write(byArray2, 0, n5);
                    n4 += n16;
                    this.processImageProgress(100.0f * (float)n2 / (float)n13);
                }
            }
        }
        if (this.abortRequested()) {
            this.processWriteAborted();
        } else {
            this.processImageComplete();
            this.stream.flushBefore(this.stream.getStreamPosition());
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.stream = null;
    }

    private void checkSampleModel(SampleModel sampleModel) {
        int n = sampleModel.getDataType();
        if (n < 0 || n > 3 || sampleModel.getNumBands() != 1 || sampleModel.getSampleSize(0) != 1) {
            throw new IllegalArgumentException(I18N.getString("WBMPImageWriter2"));
        }
    }
}

