/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.core.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INIUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(INIUtil.class);
    private String path;
    private Map<String, Map<String, Object>> iniUtil;

    public INIUtil(String path) {
        this.path = path;
        this.iniUtil = new LinkedHashMap<String, Map<String, Object>>();
        if (this.isExists()) {
            try {
                String str = "";
                String section = "";
                BufferedReader br = new BufferedReader(new FileReader(this.path));
                LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
                while ((str = br.readLine()) != null) {
                    if (str.startsWith("[") && str.endsWith("]")) {
                        if (str.length() <= 2) continue;
                        section = str.substring(1, str.length() - 1);
                        data = new LinkedHashMap();
                        continue;
                    }
                    String[] array = str.split("=");
                    if (array.length != 2) continue;
                    data.put(array[0], array[1]);
                    this.iniUtil.put(section, data);
                }
                br.close();
            }
            catch (IOException e) {
                LOGGER.error("I got catch IOException <{}>", (Throwable)e);
            }
        }
    }

    public boolean isExists() {
        return new File(this.path).exists();
    }

    public String getData(String section, String key) {
        String data = "";
        try {
            data = (String)this.iniUtil.get(section).get(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public void setData(String section, String key, Object data) {
        if (this.iniUtil.get(section) != null) {
            this.iniUtil.get(section).put(key, data);
        } else {
            LinkedHashMap<String, Object> newData = new LinkedHashMap<String, Object>();
            newData.put(key, data);
            this.iniUtil.put(section, newData);
        }
        try {
            Boolean isFirst = true;
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.path));
            StringBuffer sBuffer = new StringBuffer();
            Iterator<String> sectionItr = this.iniUtil.keySet().iterator();
            while (sectionItr.hasNext()) {
                if (!isFirst.booleanValue()) {
                    sBuffer.append("\r\n");
                }
                String secName = sectionItr.next();
                sBuffer.append("[" + secName + "]\r\n");
                isFirst = false;
                Iterator<String> keyItr = this.iniUtil.get(secName).keySet().iterator();
                while (keyItr.hasNext()) {
                    String keyName = keyItr.next();
                    String enterStr = !sectionItr.hasNext() && !keyItr.hasNext() ? "" : "\r\n";
                    sBuffer.append(keyName + "=" + this.iniUtil.get(secName).get(keyName) + enterStr);
                }
            }
            bw.write(sBuffer.toString());
            bw.close();
        }
        catch (IOException e) {
            LOGGER.error("I got catch IOException <{}>", (Throwable)e);
        }
    }
}

