/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.application;

import com.tulskiy.keymaster.common.HotKey;
import com.tulskiy.keymaster.common.HotKeyListener;
import com.tulskiy.keymaster.common.Provider;
import de.codecentric.centerdevice.MenuToolkit;
import de.codecentric.centerdevice.glass.AdapterContext;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.application.Preloader;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.http.HttpHost;
import org.silentsoft.actlist.application.AppController;
import org.silentsoft.actlist.console.Console;
import org.silentsoft.actlist.rest.RESTfulAPI;
import org.silentsoft.actlist.util.ConfigUtil;
import org.silentsoft.core.util.SystemUtil;
import org.silentsoft.io.event.EventListener;
import org.silentsoft.io.memory.SharedMemory;
import org.silentsoft.ui.hotkey.HotkeyHandler;
import org.silentsoft.ui.tray.TrayIconHandler;
import org.silentsoft.ui.util.StageUtil;

public class App
extends Application
implements EventListener {
    private static Stage stage;
    private static Parent app;
    private AppController appController;
    private static Provider provider;
    private Stage consoleStage;
    private CountDownLatch pluginCountDownLatch;

    public static void main(String[] stringArray) {
        App.loadConfiguration();
        App.launch((String[])stringArray);
    }

    public static Stage getStage() {
        Stage stage = StageUtil.getCurrentStage();
        if (stage == null) {
            return App.stage;
        }
        return stage;
    }

    static Parent getParent() {
        return app;
    }

    public static List<javafx.scene.image.Image> getIcons() {
        return new Function<int[], List<javafx.scene.image.Image>>(){

            @Override
            public List<javafx.scene.image.Image> apply(int[] nArray) {
                ArrayList<javafx.scene.image.Image> arrayList = new ArrayList<javafx.scene.image.Image>();
                for (int n : nArray) {
                    arrayList.add(new javafx.scene.image.Image(String.join((CharSequence)"", "/images/icon/actlist_", String.valueOf(n), ".png")));
                }
                return arrayList;
            }
        }.apply(new int[]{24, 32, 48, 64, 128, 256});
    }

    public static Provider getProvider() {
        if (provider == null) {
            provider = Provider.getCurrentProvider((boolean)false);
        }
        return provider;
    }

    private static void loadConfiguration() {
        try {
            if (SharedMemory.getDataMap().get((Object)"KEY_ACTLIST_CONFIG") == null) {
                org.silentsoft.actlist.preloader.App.loadConfiguration();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start(Stage stage) throws Exception {
        App.stage = stage;
        new Thread(() -> {
            try {
                this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.2));
                this.heavyLifting();
                this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.3));
                this.initializeWithoutFxThread();
                this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.4));
                Platform.runLater(() -> {
                    try {
                        this.initializeWithFxThread();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }).start();
    }

    private void heavyLifting() {
        this.updateProxyHost();
    }

    private void updateProxyHost() {
        String string = "";
        String string2 = "";
        HttpHost httpHost = RESTfulAPI.getProxyHost();
        if (httpHost != null) {
            string = httpHost.getHostName();
            string2 = String.valueOf(httpHost.getPort());
        }
        System.setProperty("http.proxyHost", string);
        System.setProperty("http.proxyPort", string2);
        System.setProperty("https.proxyHost", string);
        System.setProperty("https.proxyPort", string2);
    }

    private void initializeWithoutFxThread() throws Exception {
        Platform.setImplicitExit((boolean)false);
        StageUtil.registerStage((Stage)stage);
        org.silentsoft.io.event.EventHandler.addListener((EventListener)this);
        this.displayStageIcon();
        this.registerTrayIcon();
        this.registerHotkey();
    }

    private void initializeWithFxThread() throws Exception {
        this.initConsole();
        this.registerMenu();
        FXMLLoader fXMLLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName().concat(".fxml")));
        app = (Parent)fXMLLoader.load();
        this.appController = (AppController)fXMLLoader.getController();
        this.appController.initialize();
        stage.setTitle("Actlist");
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.setScene(this.createScene());
        stage.setWidth(ConfigUtil.getStageWidth());
        stage.setHeight(ConfigUtil.getStageHeight());
        stage.setOpacity(ConfigUtil.getStageOpacity());
        stage.setAlwaysOnTop(ConfigUtil.isAlwaysOnTop());
        stage.focusedProperty().addListener((observableValue, bl, bl2) -> this.appController.notifyFocusState((boolean)bl2));
    }

    private Scene createScene() {
        Scene scene = null;
        if (SystemUtil.isMac()) {
            BorderPane borderPane = new BorderPane();
            borderPane.setStyle("-fx-background-color: transparent;");
            borderPane.setTop((Node)this.createMenuBar());
            borderPane.setCenter((Node)app);
            scene = new Scene((Parent)borderPane, (Paint)Color.TRANSPARENT);
        }
        return scene == null ? new Scene(app, (Paint)Color.TRANSPARENT) : scene;
    }

    private MenuBar createMenuBar() {
        return null;
    }

    private void initConsole() throws Exception {
        if (this.consoleStage == null) {
            this.consoleStage = new Stage();
            this.consoleStage.setTitle("Console");
            this.consoleStage.initOwner((Window)App.getStage());
            this.consoleStage.initStyle(StageStyle.TRANSPARENT);
            FXMLLoader fXMLLoader = new FXMLLoader(Console.class.getResource(Console.class.getSimpleName().concat(".fxml")));
            Parent parent = (Parent)fXMLLoader.load();
            Console console = (Console)fXMLLoader.getController();
            console.initialize(this.consoleStage);
            this.consoleStage.focusedProperty().addListener((observableValue, bl, bl2) -> console.notifyFocusState((boolean)bl2));
            System.setOut(console.getPrintStream());
            System.setErr(console.getPrintStream());
            System.out.println(String.format("Actlist %s (%s %s, platform %s)", "1.5.1", SystemUtil.getOSName(), SystemUtil.getOSArchitecture(), SystemUtil.getPlatformArchitecture()));
            System.out.println(String.format("%s, %s", System.getProperty("java.vm.name"), System.getProperty("java.runtime.version")));
            BorderPane borderPane = new BorderPane();
            borderPane.setStyle("-fx-background-color: transparent;");
            borderPane.setTop((Node)this.createMenuBar());
            borderPane.setCenter((Node)parent);
            this.consoleStage.setScene(new Scene((Parent)borderPane, (Paint)Color.TRANSPARENT));
            this.consoleStage.setWidth(400.0);
            this.consoleStage.setHeight(500.0);
            this.consoleStage.getIcons().addAll(App.getIcons());
        }
    }

    private void displayStageIcon() {
        stage.getIcons().addAll(App.getIcons());
    }

    private void registerTrayIcon() {
        if (SystemUtil.isMac()) {
            TrayIconHandler.registerTrayIcon((Image)new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/icon/actlist_64.png")).getImage(), (String)"Actlist", actionEvent -> this.showOrHide());
        } else {
            TrayIconHandler.registerTrayIcon((Image)new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/icon/actlist_16.png")).getImage(), (String)"Actlist", actionEvent -> this.showOrHide());
        }
        TrayIconHandler.addItem((String)String.join((CharSequence)"", "Show/Hide ", "(", ConfigUtil.getShowHideActlistHotKeyText().replaceAll(" ", ""), ")"), actionEvent -> this.showOrHide());
        TrayIconHandler.addItem((String)"Console", actionEvent -> this.showConsole());
        TrayIconHandler.addItem((String)"Configuration", actionEvent -> this.showConfiguration());
        TrayIconHandler.addSeparator();
        TrayIconHandler.addItem((String)"Explore Other Plugins", actionEvent -> this.showExplore());
        TrayIconHandler.addSeparator();
        TrayIconHandler.addItem((String)"Open Plugins Directory", actionEvent -> {
            try {
                File file = Paths.get(System.getProperty("user.dir"), "plugins").toFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                Desktop.getDesktop().open(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        TrayIconHandler.addSeparator();
        TrayIconHandler.addItem((String)"Browse Homepage", actionEvent -> {
            try {
                Desktop.getDesktop().browse(new URI("http://actlist.silentsoft.org"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        TrayIconHandler.addItem((String)"Feedback", actionEvent -> {
            try {
                Desktop.getDesktop().browse(new URI("https://github.com/silentsoft/actlist/issues"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        TrayIconHandler.addItem((String)"About", actionEvent -> this.showAbout());
        TrayIconHandler.addSeparator();
        TrayIconHandler.addItem((String)"Exit", actionEvent -> this.exit());
    }

    private void registerHotkey() throws Exception {
        App.getProvider().register(KeyStroke.getKeyStroke(ConfigUtil.getShowHideActlistHotKeyCode(), ConfigUtil.getShowHideActlistHotKeyModifier()), new HotKeyListener(){

            public void onHotKey(HotKey hotKey) {
                App.this.showOrHide();
            }
        });
        HotkeyHandler.getInstance().registerHotkey(KeyCode.ESCAPE, false, false, false, () -> this.showOrHide());
        stage.addEventHandler(KeyEvent.KEY_RELEASED, (EventHandler)HotkeyHandler.getInstance());
    }

    private void registerMenu() {
        if (SystemUtil.isMac()) {
            String string = "Actlist";
            MenuToolkit menuToolkit = MenuToolkit.toolkit();
            MenuItem menuItem = new MenuItem("About " + string);
            menuItem.setOnAction(actionEvent -> this.showAbout());
            MenuItem menuItem2 = new MenuItem("Preferences");
            menuItem2.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.COMMA, new KeyCombination.Modifier[]{KeyCombination.META_DOWN}));
            menuItem2.setOnAction(actionEvent -> this.showConfiguration());
            Menu menu = new Menu(string, null, new MenuItem[]{menuItem, new SeparatorMenuItem(), menuItem2, new SeparatorMenuItem(), menuToolkit.createHideMenuItem(string), menuToolkit.createHideOthersMenuItem(), menuToolkit.createUnhideAllMenuItem(), new SeparatorMenuItem(), menuToolkit.createQuitMenuItem(string)});
            menuToolkit.setApplicationMenu(menu);
            Menu menu2 = new Menu("File");
            menu2.getItems().addAll((Object[])new MenuItem[]{menuToolkit.createCloseWindowMenuItem()});
            Menu menu3 = new Menu("Edit");
            Menu menu4 = new Menu("View");
            Menu menu5 = new Menu("Window", null, new MenuItem[]{menuToolkit.createMinimizeMenuItem(), menuToolkit.createZoomMenuItem(), menuToolkit.createCycleWindowsItem(), new SeparatorMenuItem(), menuToolkit.createBringAllToFrontItem()});
            menuToolkit.autoAddWindowMenuItems(menu5);
            Menu menu6 = new Menu("Help");
            menuToolkit.setGlobalMenuBar(new MenuBar(new Menu[]{menu, menu2, menu3, menu4, menu5, menu6}));
        }
    }

    private void showOrHide() {
        if (stage.isIconified()) {
            Platform.runLater(() -> stage.setIconified(false));
        } else if (stage.isShowing()) {
            if (stage.isFocused()) {
                if (SystemUtil.isMac()) {
                    AdapterContext.getContext().getApplicationAdapter().hide();
                } else {
                    Platform.runLater(() -> stage.hide());
                }
            } else if (SystemUtil.isMac()) {
                Platform.runLater(() -> {
                    stage.toFront();
                    Point point = MouseInfo.getPointerInfo().getLocation();
                    new Thread(() -> Platform.runLater(() -> {
                        try {
                            Robot robot = new Robot();
                            robot.mouseMove((int)stage.getX() + 10, (int)stage.getY() + 10);
                            robot.mousePress(1024);
                            robot.mouseRelease(1024);
                            robot.mouseMove(point.x, point.y);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    })).start();
                });
            } else {
                Platform.runLater(() -> stage.requestFocus());
            }
        } else if (SystemUtil.isMac()) {
            AdapterContext.getContext().getApplicationAdapter().unhideAllApplications();
        } else {
            Platform.runLater(() -> stage.show());
        }
    }

    private void bringToFront() {
        if (App.isHidden()) {
            this.showOrHide();
        }
    }

    public static boolean isShown() {
        return !App.isHidden();
    }

    public static boolean isHidden() {
        return stage.isIconified() || !stage.isShowing() || stage.isShowing() && !stage.isFocused();
    }

    private void showExplore() {
        Platform.runLater(() -> {
            this.bringToFront();
            org.silentsoft.io.event.EventHandler.callEvent(((Object)((Object)this)).getClass(), (String)"EVENT_SHOW_EXPLORE_VIEW", (boolean)false);
        });
    }

    private void showAbout() {
        Platform.runLater(() -> {
            this.bringToFront();
            org.silentsoft.io.event.EventHandler.callEvent(((Object)((Object)this)).getClass(), (String)"EVENT_SHOW_ABOUT_VIEW", (boolean)false);
        });
    }

    private void showConsole() {
        Platform.runLater(() -> this.consoleStage.show());
    }

    private void showConfiguration() {
        Platform.runLater(() -> {
            this.bringToFront();
            org.silentsoft.io.event.EventHandler.callEvent(((Object)((Object)this)).getClass(), (String)"EVENT_SHOW_CONFIGURATION_VIEW", (boolean)false);
        });
    }

    private void exit() {
        App.getProvider().reset();
        App.getProvider().stop();
        org.silentsoft.io.event.EventHandler.callEvent(((Object)((Object)this)).getClass(), (String)"EVENT_APPLICATION_CLOSE_REQUESTED", (boolean)false);
        System.exit(0);
    }

    private void notifyPreloaderPreparingPlugins() {
        this.pluginCountDownLatch = new CountDownLatch((Integer)SharedMemory.getDataMap().get((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS"));
        this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.5));
        new Thread(() -> {
            try {
                this.pluginCountDownLatch.await();
                Thread.sleep(300L);
                this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(1.0));
                Thread.sleep(1200L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.StateChangeNotification(Preloader.StateChangeNotification.Type.BEFORE_START));
                Platform.runLater(() -> stage.show());
            }
        }).start();
    }

    private void notifyPreloaderCountDownPlugin() {
        int n = (Integer)SharedMemory.getDataMap().get((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS");
        this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.5 + (double)((long)n - this.pluginCountDownLatch.getCount() + 1L) / (double)n * 0.5));
        this.pluginCountDownLatch.countDown();
    }

    public void onEvent(String string) {
        switch (string) {
            case "EVENT_NOTIFY_PRELOADER_PREPARING_PLUGINS": {
                this.notifyPreloaderPreparingPlugins();
                break;
            }
            case "EVENT_NOTIFY_PRELOADER_COUNT_DOWN_PLUGIN": {
                this.notifyPreloaderCountDownPlugin();
                break;
            }
            case "EVENT_REGISTER_TRAY_ICON": {
                this.registerTrayIcon();
                break;
            }
            case "EVENT_APPLICATION_SHOW_HIDE": {
                this.showOrHide();
                break;
            }
            case "EVENT_APPLICATION_BRING_TO_FRONT": {
                this.bringToFront();
                break;
            }
            case "EVENT_APPLICATION_EXIT": {
                this.exit();
                break;
            }
            case "EVENT_UPDATE_PROXY_HOST": {
                this.updateProxyHost();
            }
        }
    }
}

