/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.centerdevice.util;

import com.sun.javafx.stage.StageHelper;
import java.util.List;
import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.geometry.Rectangle2D;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class StageUtils {
    public static void bringAllToFront() {
        Optional<Stage> focusedStage = StageUtils.getFocusedStage();
        StageUtils.getStages().forEach(stage -> stage.toFront());
        focusedStage.ifPresent(stage -> stage.toFront());
    }

    public static void zoomFocusedStage() {
        StageUtils.getFocusedStage().ifPresent(stage -> {
            ObservableList screens = Screen.getScreensForRectangle((double)stage.getX(), (double)stage.getY(), (double)stage.getWidth(), (double)stage.getHeight());
            if (screens.size() == 1) {
                StageUtils.setStageSize(stage, ((Screen)screens.get(0)).getBounds());
            }
        });
    }

    public static void minimizeFocusedStage() {
        StageUtils.getFocusedStage().ifPresent(stage -> stage.setIconified(true));
    }

    public static void closeCurrentStage() {
        StageUtils.getFocusedStage().ifPresent(stage -> stage.close());
    }

    public static void focusNextStage() {
        ObservableList<Stage> stages = StageUtils.getStages();
        int currentStageIndex = StageUtils.getFocusedStageIndex(stages);
        if (currentStageIndex < stages.size() - 1) {
            ((Stage)stages.get(currentStageIndex + 1)).toFront();
        } else if (stages.size() > 0) {
            ((Stage)stages.get(0)).toFront();
        }
    }

    public static ObservableList<Stage> getStages() {
        return StageHelper.getStages();
    }

    public static Optional<Stage> getFocusedStage() {
        return StageHelper.getStages().stream().filter(stage -> stage.isFocused()).findFirst();
    }

    public static int getFocusedStageIndex(List<Stage> stages) {
        int i = 0;
        while (i < stages.size()) {
            if (stages.get(i).isFocused()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void setStageSize(Stage stage, Rectangle2D screenBounds) {
        stage.setX(screenBounds.getMinX());
        stage.setY(screenBounds.getMinY());
        stage.setWidth(screenBounds.getMaxX() - screenBounds.getMinX());
        stage.setHeight(screenBounds.getMaxY() - screenBounds.getMinY());
    }
}

