/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.transitions;

import javafx.animation.Animation;
import javafx.animation.Transition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.CacheHint;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public final class JFXFillTransition
extends Transition {
    private Color start;
    private Color end;
    private CacheHint oldCacheHint = CacheHint.DEFAULT;
    private boolean oldCache = false;
    private ObjectProperty<Region> region;
    private ObjectProperty<Duration> duration;
    private static final Duration DEFAULT_DURATION = Duration.millis((double)400.0);
    private ObjectProperty<Color> fromValue;
    private static final Color DEFAULT_FROM_VALUE = null;
    private ObjectProperty<Color> toValue;
    private static final Color DEFAULT_TO_VALUE = null;
    private CornerRadii radii;
    private Insets insets;

    public final void setRegion(Region value) {
        if (this.region != null || value != null) {
            this.regionProperty().set((Object)value);
        }
    }

    public final Region getRegion() {
        return this.region == null ? null : (Region)this.region.get();
    }

    public final ObjectProperty<Region> regionProperty() {
        if (this.region == null) {
            this.region = new SimpleObjectProperty((Object)this, "region", null);
        }
        return this.region;
    }

    public final void setDuration(Duration value) {
        if (this.duration != null || !DEFAULT_DURATION.equals((Object)value)) {
            this.durationProperty().set((Object)value);
        }
    }

    public final Duration getDuration() {
        return this.duration == null ? DEFAULT_DURATION : (Duration)this.duration.get();
    }

    public final ObjectProperty<Duration> durationProperty() {
        if (this.duration == null) {
            this.duration = new ObjectPropertyBase<Duration>(DEFAULT_DURATION){

                public void invalidated() {
                    try {
                        JFXFillTransition.this.setCycleDuration(JFXFillTransition.this.getDuration());
                    }
                    catch (IllegalArgumentException e) {
                        if (this.isBound()) {
                            this.unbind();
                        }
                        this.set(JFXFillTransition.this.getCycleDuration());
                        throw e;
                    }
                }

                public Object getBean() {
                    return JFXFillTransition.this;
                }

                public String getName() {
                    return "duration";
                }
            };
        }
        return this.duration;
    }

    public final void setFromValue(Color value) {
        if (this.fromValue != null || value != null) {
            this.fromValueProperty().set((Object)value);
        }
    }

    public final Color getFromValue() {
        return this.fromValue == null ? DEFAULT_FROM_VALUE : (Color)this.fromValue.get();
    }

    public final ObjectProperty<Color> fromValueProperty() {
        if (this.fromValue == null) {
            this.fromValue = new SimpleObjectProperty((Object)this, "fromValue", (Object)DEFAULT_FROM_VALUE);
        }
        return this.fromValue;
    }

    public final void setToValue(Color value) {
        if (this.toValue != null || value != null) {
            this.toValueProperty().set((Object)value);
        }
    }

    public final Color getToValue() {
        return this.toValue == null ? DEFAULT_TO_VALUE : (Color)this.toValue.get();
    }

    public final ObjectProperty<Color> toValueProperty() {
        if (this.toValue == null) {
            this.toValue = new SimpleObjectProperty((Object)this, "toValue", (Object)DEFAULT_TO_VALUE);
        }
        return this.toValue;
    }

    public JFXFillTransition(Duration duration, Region shape, Color fromValue, Color toValue) {
        this.setDuration(duration);
        this.setRegion(shape);
        this.setFromValue(fromValue);
        this.setToValue(toValue);
        this.setCycleDuration(duration);
        this.statusProperty().addListener((ChangeListener)new ChangeListener<Animation.Status>(){

            public void changed(ObservableValue<? extends Animation.Status> ov, Animation.Status t, Animation.Status newStatus) {
                switch (newStatus) {
                    case RUNNING: {
                        JFXFillTransition.this.starting();
                        break;
                    }
                    default: {
                        JFXFillTransition.this.stopping();
                    }
                }
            }
        });
    }

    public JFXFillTransition(Duration duration, Color fromValue, Color toValue) {
        this(duration, null, fromValue, toValue);
    }

    public JFXFillTransition(Duration duration, Region shape) {
        this(duration, shape, null, null);
    }

    public JFXFillTransition(Duration duration) {
        this(duration, null, null, null);
    }

    public JFXFillTransition() {
        this(DEFAULT_DURATION, null);
    }

    protected void starting() {
        if (this.start == null) {
            this.oldCache = ((Region)this.region.get()).isCache();
            this.oldCacheHint = ((Region)this.region.get()).getCacheHint();
            this.radii = ((Region)this.region.get()).getBackground() == null ? null : ((BackgroundFill)((Region)this.region.get()).getBackground().getFills().get(0)).getRadii();
            this.insets = ((Region)this.region.get()).getBackground() == null ? null : ((BackgroundFill)((Region)this.region.get()).getBackground().getFills().get(0)).getInsets();
            this.start = (Color)this.fromValue.get();
            this.end = (Color)this.toValue.get();
            ((Region)this.region.get()).setCache(true);
            ((Region)this.region.get()).setCacheHint(CacheHint.SPEED);
        }
    }

    protected void stopping() {
        ((Region)this.region.get()).setCache(this.oldCache);
        ((Region)this.region.get()).setCacheHint(this.oldCacheHint);
    }

    protected void interpolate(double frac) {
        if (this.start == null) {
            this.starting();
        }
        Color newColor = this.start.interpolate(this.end, frac);
        ((Region)this.region.get()).setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)newColor, this.radii, this.insets)}));
    }
}

