/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.application;

import com.jfoenix.controls.JFXButton;
import de.codecentric.centerdevice.glass.AdapterContext;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.SVGPath;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.control.PopOver;
import org.silentsoft.actlist.application.App;
import org.silentsoft.actlist.plugin.PluginComponent;
import org.silentsoft.actlist.plugin.PluginManager;
import org.silentsoft.actlist.plugin.messagebox.MessageBox;
import org.silentsoft.actlist.rest.RESTfulAPI;
import org.silentsoft.actlist.util.ConfigUtil;
import org.silentsoft.actlist.view.about.About;
import org.silentsoft.actlist.view.configuration.Configuration;
import org.silentsoft.actlist.view.explore.Explore;
import org.silentsoft.core.util.DateUtil;
import org.silentsoft.core.util.FileUtil;
import org.silentsoft.core.util.SystemUtil;
import org.silentsoft.io.event.EventHandler;
import org.silentsoft.io.event.EventListener;
import org.silentsoft.io.memory.SharedMemory;
import org.silentsoft.ui.model.Delta;
import org.silentsoft.ui.model.MaximizeProperty;
import org.silentsoft.ui.util.StageDragResizer;

public class AppController
implements EventListener {
    @FXML
    private AnchorPane root;
    @FXML
    private BorderPane head;
    @FXML
    private Label headMinimizeButton;
    @FXML
    private Label headMaximizeButton;
    @FXML
    private Label headCloseButton;
    @FXML
    private BorderPane body;
    @FXML
    private Pane handPaneMac;
    @FXML
    private VBox sideArea;
    @FXML
    private HBox sideControls;
    @FXML
    private Label sideMinimizeButton;
    @FXML
    private Label sideMaximizeButton;
    @FXML
    private Label sideCloseButton;
    @FXML
    private VBox sideNav;
    @FXML
    private Region navPluginsMac;
    @FXML
    private Region navExploreMac;
    @FXML
    private Region navConsoleMac;
    @FXML
    private Region navAboutMac;
    @FXML
    private Region navConfigurationMac;
    @FXML
    private Region navPluginsWin;
    @FXML
    private Region navExploreWin;
    @FXML
    private Region navConsoleWin;
    @FXML
    private Region navAboutWin;
    @FXML
    private Region navConfigurationWin;
    @FXML
    private Label appUpdateAlarmLabelMac;
    @FXML
    private Label appUpdateAlarmLabelWin;
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private BorderPane contentPane;
    @FXML
    private VBox componentBox;
    private TextArea consoleTextArea;
    private PopOver updatePopOver;
    private MaximizeProperty maximizeProperty;
    private HashMap<String, URLClassLoader> pluginMap;

    protected void initialize() {
        EventHandler.addListener((EventListener)this);
        this.initConsole();
        this.root.setPrefWidth(ConfigUtil.getRootWidth());
        this.root.setPrefHeight(ConfigUtil.getRootHeight());
        this.maximizeProperty = new MaximizeProperty(App.getStage());
        this.pluginMap = new HashMap();
        this.makeDraggable(App.getStage(), (Node)this.head);
        this.makeNormalizable(App.getStage(), (Node)this.head);
        this.makeMinimizable(App.getStage(), (Node)this.headMinimizeButton);
        this.makeMaximizable(App.getStage(), (Node)this.headMaximizeButton);
        this.makeClosable(App.getStage(), (Node)this.headCloseButton);
        this.makeDraggable(App.getStage(), (Node)this.sideNav);
        this.makeNormalizable(App.getStage(), (Node)this.sideNav);
        this.makeMinimizable(App.getStage(), (Node)this.sideMinimizeButton);
        this.makeMaximizable(App.getStage(), (Node)this.sideMaximizeButton);
        this.makeClosable(App.getStage(), (Node)this.sideCloseButton);
        this.makeDraggable(App.getStage(), (Node)this.handPaneMac);
        this.makeNormalizable(App.getStage(), (Node)this.handPaneMac);
        this.applyTheme();
        this.makeResizable(App.getStage(), (Region)this.root);
        this.initUpdatePopOver();
        this.checkUpdate();
        SharedMemory.getDataMap().put((Object)"KEY_PLUGIN_MAP", this.pluginMap);
        SharedMemory.getDataMap().put((Object)"KEY_COMPONENT_BOX", (Object)this.componentBox);
        this.loadPlugins();
        this.enableContextMenu();
        this.enableDragAndDrop();
    }

    public void notifyFocusState(boolean bl) {
        if (ConfigUtil.isMacTheme()) {
            if (bl) {
                this.sideCloseButton.setStyle("-fx-background-color: red; -fx-background-radius: 5em;");
                this.sideMinimizeButton.setStyle("-fx-background-color: orange; -fx-background-radius: 5em;");
                this.sideMaximizeButton.setStyle("-fx-background-color: #59bf53; -fx-background-radius: 5em;");
            } else {
                this.sideCloseButton.setStyle("-fx-background-color: #808080; -fx-background-radius: 5em;");
                this.sideMinimizeButton.setStyle("-fx-background-color: #808080; -fx-background-radius: 5em;");
                this.sideMaximizeButton.setStyle("-fx-background-color: #808080; -fx-background-radius: 5em;");
            }
        }
    }

    private void initConsole() {
        this.consoleTextArea = new TextArea();
        this.consoleTextArea.setContextMenu(new ContextMenu());
        this.consoleTextArea.setEditable(false);
        this.consoleTextArea.setFont(Font.font((String)"Consolas", (double)13.0));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-fx-control-inner-background: rgb(30, 30, 30); ");
        stringBuffer.append("-fx-background-color: -fx-control-inner-background; ");
        stringBuffer.append("-fx-background-radius: 0; ");
        stringBuffer.append("-fx-faint-focus-color: transparent;");
        this.consoleTextArea.setStyle(stringBuffer.toString());
        SharedMemory.getDataMap().put((Object)"KEY_CONSOLE_TEXT_AREA", (Object)this.consoleTextArea);
    }

    private void makeDraggable(Stage stage, Node node) {
        Delta delta = new Delta();
        node.setOnMousePressed(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                delta.setX(stage.getX() - mouseEvent.getScreenX());
                delta.setY(stage.getY() - mouseEvent.getScreenY());
                node.setOpacity(0.98);
            }
        });
        node.setOnMouseDragged(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                if (this.maximizeProperty.isMaximized()) {
                    double d = mouseEvent.getScreenX() - stage.getX();
                    double d2 = mouseEvent.getScreenY() - stage.getY();
                    this.changeMaximizeProperty(stage);
                    delta.setX(-1.0 * (stage.getWidth() / 2.0));
                    delta.setY(-1.0 * mouseEvent.getSceneY());
                } else {
                    stage.setX(mouseEvent.getScreenX() + delta.getX());
                    stage.setY(mouseEvent.getScreenY() + delta.getY());
                }
            }
        });
        node.setOnMouseReleased(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                node.setOpacity(1.0);
            }
        });
    }

    private void makeNormalizable(Stage stage, Node node) {
        node.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getClickCount() >= 2) {
                this.changeMaximizeProperty(stage);
            }
        });
    }

    private void makeMinimizable(Stage stage, Node node) {
        node.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                stage.setIconified(true);
            }
        });
    }

    private void makeMaximizable(Stage stage, Node node) {
        node.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                this.changeMaximizeProperty(stage);
            }
        });
    }

    private void makeClosable(Stage stage, Node node) {
        node.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                if (SystemUtil.isMac()) {
                    AdapterContext.getContext().getApplicationAdapter().hide();
                } else {
                    stage.hide();
                }
            }
        });
    }

    private void makeResizable(Stage stage, Region region) {
        StageDragResizer.makeResizable((Stage)stage, (Region)region, (int)7, (int)10, () -> {
            try {
                ConfigUtil.setRootWidth(region.getWidth());
                ConfigUtil.setRootHeight(region.getHeight());
                ConfigUtil.setStageWidth(App.getStage().getWidth());
                ConfigUtil.setStageHeight(App.getStage().getHeight());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
    }

    private void changeMaximizeProperty(Stage stage) {
        this.maximizeProperty.setMaximized(stage, !this.maximizeProperty.isMaximized());
        if (this.maximizeProperty.isMaximized()) {
            AnchorPane.setLeftAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setTopAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)this.body, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.body, (Double)0.0);
            AnchorPane.setTopAnchor((Node)this.body, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)this.body, (Double)0.0);
        } else {
            AnchorPane.setLeftAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setRightAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setTopAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setBottomAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setLeftAnchor((Node)this.body, (Double)2.0);
            AnchorPane.setRightAnchor((Node)this.body, (Double)2.0);
            AnchorPane.setTopAnchor((Node)this.body, (Double)2.0);
            AnchorPane.setBottomAnchor((Node)this.body, (Double)2.0);
        }
    }

    private void applyTheme() {
        if (this.isWinTheme()) {
            this.body.setTop((Node)this.head);
            this.body.setLeft(null);
            this.handPaneMac.setVisible(false);
        } else if (this.isMacTheme()) {
            this.body.setTop(null);
            this.body.setLeft((Node)this.sideArea);
            this.handPaneMac.setVisible(true);
        }
    }

    @FXML
    private void showPluginsView() {
        this.toggleNav(this.navPluginsWin, this.navPluginsMac);
        this.contentPane.setCenter((Node)this.componentBox);
    }

    @FXML
    private void showExploreView() {
        this.toggleNav(this.navExploreWin, this.navExploreMac);
        this.contentPane.setCenter((Node)new Explore().getViewer());
    }

    @FXML
    private void showConsoleView() {
        this.toggleNav(this.navConsoleWin, this.navConsoleMac);
        this.contentPane.setCenter((Node)this.consoleTextArea);
    }

    @FXML
    private void showAboutView() {
        this.toggleNav(this.navAboutWin, this.navAboutMac);
        this.contentPane.setCenter((Node)new About().getViewer());
    }

    @FXML
    private void showConfigurationView() {
        this.toggleNav(this.navConfigurationWin, this.navConfigurationMac);
        this.contentPane.setCenter((Node)new Configuration().getViewer());
    }

    @FXML
    private void eventNavMouseEntered(MouseEvent mouseEvent) {
        Region region;
        if (mouseEvent.getSource() instanceof Region && (region = (Region)mouseEvent.getSource()).getOpacity() != 1.0) {
            region.setOpacity(0.9);
        }
    }

    @FXML
    private void eventNavMouseExited(MouseEvent mouseEvent) {
        Region region;
        if (mouseEvent.getSource() instanceof Region && (region = (Region)mouseEvent.getSource()).getOpacity() != 1.0) {
            region.setOpacity(0.75);
        }
    }

    private void toggleNav(Region region, Region region2) {
        Arrays.asList(this.navPluginsWin, this.navExploreWin, this.navConsoleWin, this.navAboutWin, this.navConfigurationWin, this.navPluginsMac, this.navExploreMac, this.navConsoleMac, this.navAboutMac, this.navConfigurationMac).forEach(region3 -> {
            if (region3 == region || region3 == region2) {
                region3.setOpacity(1.0);
            } else {
                region3.setOpacity(0.75);
            }
        });
    }

    private boolean isWinTheme() {
        return "WIN".equals(ConfigUtil.getTheme());
    }

    private boolean isMacTheme() {
        return "MAC".equals(ConfigUtil.getTheme());
    }

    private void initUpdatePopOver() {
        this.updatePopOver = new PopOver();
        Label label = new Label("Actlist Update Alarm");
        label.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)12.0));
        label.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        Label label2 = new Label("New Actlist is available. Would you like to browse now ?");
        label2.setWrapText(true);
        label2.setFont(Font.font((String)"Verdana", (double)12.0));
        label2.setTextAlignment(TextAlignment.CENTER);
        label2.setPrefWidth(194.0);
        label2.setPrefHeight(40.0);
        JFXButton jFXButton = new JFXButton("Not Now");
        jFXButton.setCursor(Cursor.HAND);
        jFXButton.setPrefWidth(97.0);
        jFXButton.setButtonType(JFXButton.ButtonType.RAISED);
        jFXButton.setRipplerFill(Paint.valueOf((String)"#eeeeee"));
        jFXButton.setFont(Font.font((String)"Verdana", (double)12.0));
        jFXButton.setTextFill(Paint.valueOf((String)"#0b7aea"));
        jFXButton.setOnMouseClicked(mouseEvent -> this.hideUpdatePopOver());
        JFXButton jFXButton2 = new JFXButton("Browse");
        jFXButton2.setCursor(Cursor.HAND);
        jFXButton2.setPrefWidth(97.0);
        jFXButton2.setButtonType(JFXButton.ButtonType.RAISED);
        jFXButton2.setRipplerFill(Paint.valueOf((String)"#eeeeee"));
        jFXButton2.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)12.0));
        jFXButton2.setTextFill(Paint.valueOf((String)"#1c81f9"));
        jFXButton2.setOnMouseClicked(mouseEvent -> {
            try {
                Desktop.getDesktop().browse(new URI("http://actlist.silentsoft.org/archives/"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hideUpdatePopOver();
        });
        HBox hBox = new HBox(new Node[]{jFXButton, jFXButton2});
        hBox.setAlignment(Pos.CENTER);
        hBox.setStyle("-fx-border-color: lightgray; -fx-border-width: 1 0 0 0;");
        VBox vBox = new VBox(new Node[]{label, label2, hBox});
        vBox.setAlignment(Pos.CENTER);
        vBox.setStyle("-fx-background-color: white;");
        vBox.setSpacing(5.0);
        vBox.setPrefWidth(214.0);
        vBox.setPrefHeight(103.0);
        this.updatePopOver.setContentNode((Node)vBox);
    }

    private void checkUpdate() {
        new Thread(() -> {
            Runnable runnable = () -> {
                try {
                    boolean bl = false;
                    ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
                    arrayList.add(new BasicNameValuePair("version", "1.5.0"));
                    arrayList.add(new BasicNameValuePair("os", SystemUtil.getOSName()));
                    arrayList.add(new BasicNameValuePair("architecture", SystemUtil.getPlatformArchitecture()));
                    Map map = RESTfulAPI.doGet("http://actlist.silentsoft.org/api/update/check", arrayList, Map.class);
                    if (map == null) {
                        return;
                    }
                    if (map.containsKey("available")) {
                        bl = Boolean.parseBoolean(String.valueOf(map.get("available")));
                    }
                    SharedMemory.getDataMap().put((Object)"KEY_IS_AVAILABLE_NEW_ACTLIST", (Object)bl);
                    if (bl) {
                        Platform.runLater(() -> {
                            this.appUpdateAlarmLabelWin.setVisible(true);
                            this.appUpdateAlarmLabelMac.setVisible(true);
                            FadeTransition fadeTransition = null;
                            if (this.isWinTheme()) {
                                fadeTransition = new FadeTransition(Duration.millis((double)400.0), (Node)this.appUpdateAlarmLabelWin);
                            } else if (this.isMacTheme()) {
                                fadeTransition = new FadeTransition(Duration.millis((double)400.0), (Node)this.appUpdateAlarmLabelMac);
                            }
                            if (fadeTransition != null) {
                                fadeTransition.setFromValue(1.0);
                                fadeTransition.setToValue(0.3);
                                fadeTransition.setCycleCount(6);
                                fadeTransition.setAutoReverse(true);
                                fadeTransition.play();
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            };
            boolean bl = true;
            Date date = null;
            while (true) {
                if (bl) {
                    runnable.run();
                    date = Calendar.getInstance().getTime();
                }
                try {
                    Thread.sleep((long)Duration.minutes((double)10.0).toMillis());
                }
                catch (InterruptedException interruptedException) {
                    bl = DateUtil.getDifferenceHoursFromNow((Date)date) >= 24;
                    continue;
                    catch (Throwable throwable) {
                        bl = DateUtil.getDifferenceHoursFromNow((Date)date) >= 24;
                        throw throwable;
                    }
                }
                bl = DateUtil.getDifferenceHoursFromNow((Date)date) >= 24;
                continue;
                break;
            }
        }).start();
    }

    @FXML
    private void showControls() {
        ((SVGPath)this.sideCloseButton.getGraphic()).setFill(Paint.valueOf((String)"rgb(35, 35, 35)"));
        ((SVGPath)this.sideMinimizeButton.getGraphic()).setFill(Paint.valueOf((String)"rgb(35, 35, 35)"));
        ((SVGPath)this.sideMaximizeButton.getGraphic()).setFill(Paint.valueOf((String)"rgb(35, 35, 35)"));
    }

    @FXML
    private void hideControls() {
        ((SVGPath)this.sideCloseButton.getGraphic()).setFill(Paint.valueOf((String)"transparent"));
        ((SVGPath)this.sideMinimizeButton.getGraphic()).setFill(Paint.valueOf((String)"transparent"));
        ((SVGPath)this.sideMaximizeButton.getGraphic()).setFill(Paint.valueOf((String)"transparent"));
    }

    @FXML
    private void showUpdatePopOver() {
        if (!this.updatePopOver.isShowing()) {
            if (this.isWinTheme()) {
                this.updatePopOver.setArrowLocation(PopOver.ArrowLocation.TOP_RIGHT);
                this.updatePopOver.show((Node)this.appUpdateAlarmLabelWin);
            } else if (this.isMacTheme()) {
                this.updatePopOver.setArrowLocation(PopOver.ArrowLocation.BOTTOM_LEFT);
                this.updatePopOver.show((Node)this.appUpdateAlarmLabelMac);
            }
        }
    }

    private void hideUpdatePopOver() {
        this.updatePopOver.hide();
        this.appUpdateAlarmLabelWin.setVisible(false);
        this.appUpdateAlarmLabelMac.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPlugins() {
        this.componentBox.getChildren().clear();
        try {
            File file = Paths.get(System.getProperty("user.dir"), "plugins").toFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            List<String> list = this.readPurgeTargetPlugins();
            SharedMemory.getDataMap().put((Object)"KEY_PURGE_TARGET_PLUGINS", list);
            List<String> list2 = this.readDeactivatedPlugins();
            SharedMemory.getDataMap().put((Object)"KEY_DEACTIVATED_PLUGINS", list2);
            List<String> list3 = this.readPriorityOfPlugins();
            SharedMemory.getDataMap().put((Object)"KEY_PRIORITY_OF_PLUGINS", list3);
            for (int i = list.size() - 1; i >= 0; --i) {
                Path path2 = Paths.get(System.getProperty("user.dir"), "plugins", list.get(i));
                if (Files.exists(path2, new LinkOption[0])) {
                    try {
                        Files.delete(path2);
                        list.remove(i);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    continue;
                }
                list.remove(i);
            }
            this.savePurgeTargetPlugins();
            ArrayList<String> arrayList = new ArrayList<String>();
            Files.walk(Paths.get(System.getProperty("user.dir"), "plugins"), 1, new FileVisitOption[0]).forEach(path -> {
                if (this.isAssignableFromJarFile((Path)path)) {
                    arrayList.add(path.getFileName().toString());
                }
            });
            for (int i = list2.size() - 1; i >= 0; --i) {
                String string = list2.get(i);
                if (arrayList.contains(string)) continue;
                list2.remove(i);
            }
            this.saveDeactivatedPlugins();
            Path path3 = Paths.get(System.getProperty("user.dir"), "plugins", "config");
            if (Files.exists(path3, new LinkOption[0]) && Files.isDirectory(path3, new LinkOption[0])) {
                Files.walk(path3, 1, new FileVisitOption[0]).forEach(path -> {
                    String string = path.getFileName().toString();
                    if (string.toLowerCase().endsWith(".config") && !arrayList.contains(string = string.substring(0, string.length() - ".config".length()))) {
                        try {
                            Files.delete(path);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            }
            for (int i = list3.size() - 1; i >= 0; --i) {
                String string = list3.get(i);
                if (arrayList.contains(string)) {
                    arrayList.remove(string);
                    arrayList.add(0, string);
                    continue;
                }
                list3.remove(i);
            }
            list3.clear();
            list3.addAll(arrayList);
            this.savePriorityOfPlugins();
            SharedMemory.getDataMap().put((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS", (Object)arrayList.size());
            EventHandler.callEvent(this.getClass(), (String)"EVENT_NOTIFY_PRELOADER_PREPARING_PLUGINS");
            for (String string : arrayList) {
                try {
                    Path path4 = Paths.get(System.getProperty("user.dir"), "plugins", string);
                    if (!this.isAssignableFromJarFile(path4)) continue;
                    this.loadPlugin(path4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    EventHandler.callEvent(this.getClass(), (String)"EVENT_NOTIFY_PRELOADER_COUNT_DOWN_PLUGIN");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (SharedMemory.getDataMap().get((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS") == null) {
                SharedMemory.getDataMap().put((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS", (Object)0);
                EventHandler.callEvent(this.getClass(), (String)"EVENT_NOTIFY_PRELOADER_PREPARING_PLUGINS");
            }
            this.createPromptComponent();
        }
        App.getStage().showingProperty().addListener((observableValue, bl, bl2) -> {
            if (!bl.booleanValue() && bl2.booleanValue()) {
                EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_ACTIVATED");
            } else if (bl.booleanValue() && !bl2.booleanValue()) {
                EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_DEACTIVATED");
            }
        });
        App.getStage().iconifiedProperty().addListener((observableValue, bl, bl2) -> {
            if (!bl.booleanValue() && bl2.booleanValue()) {
                EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_DEACTIVATED");
            } else if (bl.booleanValue() && !bl2.booleanValue()) {
                EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_ACTIVATED");
            }
        });
        App.getStage().setOnCloseRequest(windowEvent -> EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_EXIT"));
    }

    private void enableContextMenu() {
        MenuItem menuItem = new MenuItem("Add a new plugin");
        menuItem.setOnAction(actionEvent -> {
            FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter("Actlist Plugin File", new String[]{"*.jar"});
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Select a new Actlist plugin file");
            fileChooser.setInitialDirectory(Paths.get(System.getProperty("user.dir"), "plugins").toFile());
            fileChooser.getExtensionFilters().add((Object)extensionFilter);
            fileChooser.setSelectedExtensionFilter(extensionFilter);
            File file = fileChooser.showOpenDialog((Window)App.getStage());
            if (file == null) {
                return;
            }
            this.installAndLoadThePlugin(file, true);
        });
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{menuItem});
        this.scrollPane.setOnMouseReleased(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                contextMenu.show((Window)App.getStage(), mouseEvent.getScreenX(), mouseEvent.getScreenY());
            }
        });
    }

    private void enableDragAndDrop() {
        Predicate<Dragboard> predicate = dragboard -> {
            if (dragboard.hasFiles()) {
                List list = dragboard.getFiles();
                for (File file : list) {
                    if (file.isFile() && file.getName().toLowerCase().endsWith(".jar")) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        };
        this.scrollPane.setOnDragOver(dragEvent -> {
            if (predicate.test(dragEvent.getDragboard())) {
                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            } else {
                dragEvent.consume();
            }
        });
        this.scrollPane.setOnDragDropped(dragEvent -> {
            dragEvent.setDropCompleted(false);
            if (predicate.test(dragEvent.getDragboard())) {
                for (File file : dragEvent.getDragboard().getFiles()) {
                    this.installAndLoadThePlugin(file, false);
                    dragEvent.setDropCompleted(true);
                }
            }
            dragEvent.consume();
        });
    }

    private void installAndLoadThePlugin(File file, boolean bl) {
        try {
            Path path = PluginManager.install(file, bl);
            if (path != null) {
                PluginManager.load(String.valueOf(path.getFileName()), true);
                this.savePriorityOfPlugins();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MessageBox.showError((Object)App.getStage(), (String)"Oops... something is weird !");
        }
    }

    private boolean isAssignableFromJarFile(Path path) {
        String string;
        String string2;
        File file = path.toFile();
        return file.isFile() && (string2 = file.getName()).contains(".") && ".jar".equalsIgnoreCase(string = string2.substring(string2.lastIndexOf("."), string2.length()));
    }

    private List<String> readPurgeTargetPlugins() {
        return FileUtil.readFileByLine((Path)Paths.get(System.getProperty("user.dir"), "plugins", "purge.ini"), (boolean)true).stream().distinct().collect(Collectors.toList());
    }

    private void savePurgeTargetPlugins() {
        try {
            List list = (List)SharedMemory.getDataMap().get((Object)"KEY_PURGE_TARGET_PLUGINS");
            list = list.stream().distinct().collect(Collectors.toList());
            SharedMemory.getDataMap().put((Object)"KEY_PURGE_TARGET_PLUGINS", list);
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : list) {
                stringBuffer.append(string);
                stringBuffer.append("\r\n");
            }
            FileUtil.saveFile((Path)Paths.get(System.getProperty("user.dir"), "plugins", "purge.ini"), (String)stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private List<String> readDeactivatedPlugins() {
        return FileUtil.readFileByLine((Path)Paths.get(System.getProperty("user.dir"), "plugins", "deactivated.ini"), (boolean)true).stream().distinct().collect(Collectors.toList());
    }

    private void saveDeactivatedPlugins() {
        try {
            List list = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
            list = list.stream().distinct().collect(Collectors.toList());
            SharedMemory.getDataMap().put((Object)"KEY_DEACTIVATED_PLUGINS", list);
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : list) {
                stringBuffer.append(string);
                stringBuffer.append("\r\n");
            }
            FileUtil.saveFile((Path)Paths.get(System.getProperty("user.dir"), "plugins", "deactivated.ini"), (String)stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private List<String> readPriorityOfPlugins() {
        return FileUtil.readFileByLine((Path)Paths.get(System.getProperty("user.dir"), "plugins", "priority.ini"), (boolean)true).stream().distinct().collect(Collectors.toList());
    }

    private void savePriorityOfPlugins() {
        try {
            List<String> list;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.componentBox.getChildren().isEmpty()) {
                list = (List)SharedMemory.getDataMap().get((Object)"KEY_PRIORITY_OF_PLUGINS");
            } else {
                list = new ArrayList();
                for (String string : this.componentBox.getChildrenUnmodifiable()) {
                    list.add(((PluginComponent)string.getUserData()).getPluginFileName());
                }
            }
            for (String string : list) {
                stringBuffer.append(string);
                stringBuffer.append("\r\n");
            }
            FileUtil.saveFile((Path)Paths.get(System.getProperty("user.dir"), "plugins", "priority.ini"), (String)stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadPlugin(Path path) throws Exception {
        String string = path.getFileName().toString();
        List list = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
        PluginManager.load(string, !list.contains(string));
    }

    private void createPromptComponent() {
        Runnable runnable = () -> {
            VBox vBox = this.componentBox;
            synchronized (vBox) {
                if (this.componentBox.getChildren().isEmpty()) {
                    Label label = new Label();
                    label.setText("No plugins available.");
                    Hyperlink hyperlink = new Hyperlink();
                    hyperlink.setText("Explore");
                    hyperlink.setOnMouseReleased(mouseEvent -> {
                        hyperlink.setVisited(false);
                        this.showExploreView();
                    });
                    Label label2 = new Label();
                    label2.setText("or drag and drop.");
                    HBox hBox = new HBox(new Node[]{hyperlink, label2});
                    hBox.setAlignment(Pos.CENTER);
                    VBox vBox2 = new VBox(new Node[]{label, hBox});
                    vBox2.setAlignment(Pos.CENTER);
                    vBox2.setSpacing(15.0);
                    AnchorPane.setTopAnchor((Node)vBox2, (Double)0.0);
                    AnchorPane.setRightAnchor((Node)vBox2, (Double)0.0);
                    AnchorPane.setBottomAnchor((Node)vBox2, (Double)0.0);
                    AnchorPane.setLeftAnchor((Node)vBox2, (Double)0.0);
                    AnchorPane anchorPane = new AnchorPane(new Node[]{vBox2});
                    anchorPane.setStyle("-fx-background-color: #ffffff;");
                    anchorPane.setPrefWidth(310.0);
                    anchorPane.setPrefHeight(310.0);
                    this.componentBox.getChildren().add((Object)anchorPane);
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public void onEvent(String string) {
        switch (string) {
            case "EVENT_APPLY_THEME": {
                this.applyTheme();
                break;
            }
            case "EVENT_SHOW_EXPLORE_VIEW": {
                this.showExploreView();
                break;
            }
            case "EVENT_SHOW_ABOUT_VIEW": {
                this.showAboutView();
                break;
            }
            case "EVENT_SHOW_CONFIGURATION_VIEW": {
                this.showConfigurationView();
                break;
            }
            case "EVENT_SAVE_PURGE_TARGET_PLUGINS": {
                this.savePurgeTargetPlugins();
                break;
            }
            case "EVENT_SAVE_DEACTIVATED_PLUGINS": {
                this.saveDeactivatedPlugins();
                break;
            }
            case "EVENT_SAVE_PRIORITY_OF_PLUGINS": {
                this.savePriorityOfPlugins();
                break;
            }
            case "EVENT_CREATE_PROMPT_COMPONENT": {
                this.createPromptComponent();
            }
        }
    }
}

