/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.ui.tray;

import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrayIconHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(TrayIconHandler.class);
    private static TrayIcon trayIcon;

    private static PopupMenu getPopupMenu() {
        PopupMenu popupMenu = trayIcon.getPopupMenu();
        if (popupMenu == null) {
            popupMenu = new PopupMenu();
        }
        return popupMenu;
    }

    private static void add(MenuItem item) {
        if (TrayIconHandler.isNotRegistered()) {
            return;
        }
        PopupMenu popupMenu = TrayIconHandler.getPopupMenu();
        popupMenu.add(item);
        trayIcon.setPopupMenu(popupMenu);
    }

    private static void addToMenu(String menu, MenuItem item) {
        if (TrayIconHandler.isNotRegistered()) {
            return;
        }
        if (TrayIconHandler.isNotExistsMenu(menu)) {
            TrayIconHandler.addMenu(menu);
        }
        int j = TrayIconHandler.getPopupMenu().getItemCount();
        for (int i = 0; i < j; ++i) {
            Menu menuitem;
            if (!(TrayIconHandler.getPopupMenu().getItem(i) instanceof Menu) || !(menuitem = (Menu)TrayIconHandler.getPopupMenu().getItem(i)).getLabel().equals(menu)) continue;
            menuitem.add(item);
            TrayIconHandler.getPopupMenu().insert(menuitem, i);
            break;
        }
    }

    public static boolean isRegistered() {
        return trayIcon != null && TrayIconHandler.getPopupMenu() != null;
    }

    public static boolean isNotRegistered() {
        return !TrayIconHandler.isRegistered();
    }

    public static boolean isExistsMenu(String menu) {
        if (TrayIconHandler.isNotRegistered()) {
            return false;
        }
        int j = TrayIconHandler.getPopupMenu().getItemCount();
        for (int i = 0; i < j; ++i) {
            Menu item;
            if (!(TrayIconHandler.getPopupMenu().getItem(i) instanceof Menu) || !(item = (Menu)TrayIconHandler.getPopupMenu().getItem(i)).getLabel().equals(menu)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotExistsMenu(String menu) {
        return !TrayIconHandler.isExistsMenu(menu);
    }

    public static void registerTrayIcon(Image image) {
        TrayIconHandler.registerTrayIcon(image, null, null);
    }

    public static void registerTrayIcon(Image image, String toolTip) {
        TrayIconHandler.registerTrayIcon(image, toolTip, null);
    }

    public static void registerTrayIcon(Image image, String toolTip, ActionListener action) {
        if (SystemTray.isSupported()) {
            if (trayIcon != null) {
                trayIcon = null;
            }
            trayIcon = new TrayIcon(image);
            trayIcon.setImageAutoSize(true);
            if (toolTip != null) {
                trayIcon.setToolTip(toolTip);
            }
            if (action != null) {
                trayIcon.addActionListener(action);
            }
            try {
                for (TrayIcon registeredTrayIcon : SystemTray.getSystemTray().getTrayIcons()) {
                    SystemTray.getSystemTray().remove(registeredTrayIcon);
                }
                SystemTray.getSystemTray().add(trayIcon);
            }
            catch (AWTException e) {
                LOGGER.error("I got catch an error during add system tray !", (Throwable)e);
            }
        } else {
            LOGGER.error("System tray is not supported !");
        }
    }

    public static void setToolTip(String toolTip) {
        if (TrayIconHandler.isNotRegistered()) {
            return;
        }
        trayIcon.setToolTip(toolTip);
    }

    public static void setImage(Image image) {
        if (TrayIconHandler.isNotRegistered()) {
            return;
        }
        trayIcon.setImage(image);
    }

    public static void displayMessage(String caption, String text, TrayIcon.MessageType messageType) {
        if (TrayIconHandler.isNotRegistered()) {
            return;
        }
        trayIcon.displayMessage(caption, text, messageType);
    }

    public static void addSeparator() {
        if (TrayIconHandler.isNotRegistered()) {
            return;
        }
        TrayIconHandler.getPopupMenu().addSeparator();
    }

    public static void addSeparator(String menu) {
        if (TrayIconHandler.isNotRegistered()) {
            return;
        }
        int j = TrayIconHandler.getPopupMenu().getItemCount();
        for (int i = 0; i < j; ++i) {
            Menu item;
            if (!(TrayIconHandler.getPopupMenu().getItem(i) instanceof Menu) || !(item = (Menu)TrayIconHandler.getPopupMenu().getItem(i)).getLabel().equals(menu)) continue;
            item.addSeparator();
            TrayIconHandler.getPopupMenu().insert(item, i);
            break;
        }
    }

    public static void addMenu(String menu) {
        TrayIconHandler.add(new Menu(menu));
    }

    public static void addItem(String label, ActionListener action) {
        MenuItem menuItem = new MenuItem(label);
        menuItem.addActionListener(action);
        TrayIconHandler.add(menuItem);
    }

    public static void addCheckBox(String label, ItemListener action) {
        TrayIconHandler.addCheckBox(label, false, action);
    }

    public static void addCheckBox(String label, boolean state, ItemListener action) {
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(label, state);
        checkboxMenuItem.addItemListener(action);
        TrayIconHandler.add(checkboxMenuItem);
    }

    public static void addItemToMenu(String menu, String label, ActionListener action) {
        MenuItem menuItem = new MenuItem(label);
        menuItem.addActionListener(action);
        TrayIconHandler.addToMenu(menu, menuItem);
    }

    public static void addCheckBoxToMenu(String menu, String label, ItemListener action) {
        TrayIconHandler.addCheckBoxToMenu(menu, label, false, action);
    }

    public static void addCheckBoxToMenu(String menu, String label, boolean state, ItemListener action) {
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(label, state);
        checkboxMenuItem.addItemListener(action);
        TrayIconHandler.addToMenu(menu, checkboxMenuItem);
    }
}

