/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXNodesList$$Lambda$1;
import com.jfoenix.controls.JFXNodesList$$Lambda$2;
import com.jfoenix.controls.JFXNodesList$$Lambda$3;
import com.jfoenix.controls.JFXNodesList$$Lambda$4;
import com.jfoenix.controls.JFXNodesList$$Lambda$5;
import com.jfoenix.controls.JFXNodesList$$Lambda$6;
import com.jfoenix.controls.JFXNodesList$$Lambda$7;
import java.util.ArrayList;
import java.util.HashMap;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.Duration;

public class JFXNodesList
extends VBox {
    HashMap<Node, Callback<Boolean, ArrayList<KeyValue>>> animationsMap = new HashMap();
    private boolean expanded = false;
    private Timeline animateTimeline = new Timeline();

    public JFXNodesList() {
        this.setPickOnBounds(false);
        this.getStyleClass().add((Object)"jfx-nodes-list");
    }

    public void addAnimatedNode(Region node) {
        this.addAnimatedNode(node, null);
    }

    public void addAnimatedNode(Region node, Callback<Boolean, ArrayList<KeyValue>> animationCallBack) {
        if (node instanceof JFXNodesList) {
            StackPane container = new StackPane(new Node[]{node});
            container.setPickOnBounds(false);
            this.addAnimatedNode((Region)container, animationCallBack);
            return;
        }
        node.setVisible(false);
        node.minWidthProperty().bind((ObservableValue)node.prefWidthProperty());
        node.minHeightProperty().bind((ObservableValue)node.prefHeightProperty());
        if (this.getChildren().size() > 0) {
            this.initNode((Node)node);
        } else {
            if (node instanceof Button) {
                ((Button)node).setOnAction(JFXNodesList$$Lambda$1.lambdaFactory$(this));
            } else {
                node.setOnMouseClicked(JFXNodesList$$Lambda$2.lambdaFactory$(this));
            }
            node.getStyleClass().add((Object)"trigger-node");
        }
        if (this.getChildren().size() == 0) {
            node.setVisible(true);
            this.minHeightProperty().bind((ObservableValue)node.prefHeightProperty());
            this.maxHeightProperty().bind((ObservableValue)node.prefHeightProperty());
            this.minWidthProperty().bind((ObservableValue)node.prefWidthProperty());
            this.maxWidthProperty().bind((ObservableValue)node.prefWidthProperty());
        }
        this.getChildren().add((Object)node);
        this.rotateProperty().addListener(JFXNodesList$$Lambda$3.lambdaFactory$(node));
        if (animationCallBack == null && this.getChildren().size() != 1) {
            animationCallBack = JFXNodesList$$Lambda$4.lambdaFactory$(this, node);
        } else if (animationCallBack == null && this.getChildren().size() == 1) {
            animationCallBack = JFXNodesList$$Lambda$5.lambdaFactory$();
        }
        this.animationsMap.put((Node)node, animationCallBack);
    }

    public void animateList() {
        boolean bl = this.expanded = !this.expanded;
        if (this.animateTimeline.getStatus().equals((Object)Animation.Status.RUNNING)) {
            this.animateTimeline.stop();
        }
        this.animateTimeline.getKeyFrames().clear();
        double duration = 120 / this.getChildren().size();
        if (this.expanded) {
            this.getChildren().forEach(JFXNodesList$$Lambda$6.lambdaFactory$());
        }
        for (int i = 1; i < this.getChildren().size(); ++i) {
            Node child = (Node)this.getChildren().get(i);
            ArrayList keyValues = (ArrayList)this.animationsMap.get(child).call((Object)this.expanded);
            this.animateTimeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)((double)i * duration)), keyValues.toArray(new KeyValue[keyValues.size()])));
        }
        ArrayList keyValues = (ArrayList)this.animationsMap.get(this.getChildren().get(0)).call((Object)this.expanded);
        this.animateTimeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)160.0), keyValues.toArray(new KeyValue[keyValues.size()])));
        if (!this.expanded) {
            this.animateTimeline.setOnFinished(JFXNodesList$$Lambda$7.lambdaFactory$(this));
        } else {
            this.animateTimeline.setOnFinished(null);
        }
        this.animateTimeline.play();
    }

    protected void initNode(Node node) {
        node.setScaleX(0.0);
        node.setScaleY(0.0);
        node.getStyleClass().add((Object)"sub-node");
    }

    private ArrayList<KeyValue> initDefaultAnimation(Region region, boolean expanded) {
        ArrayList<KeyValue> defaultAnimationValues = new ArrayList<KeyValue>();
        defaultAnimationValues.add(new KeyValue((WritableValue)region.scaleXProperty(), (Object)(expanded ? 1 : 0), Interpolator.EASE_BOTH));
        defaultAnimationValues.add(new KeyValue((WritableValue)region.scaleYProperty(), (Object)(expanded ? 1 : 0), Interpolator.EASE_BOTH));
        return defaultAnimationValues;
    }

    private /* synthetic */ void lambda$animateList$190(ActionEvent finish) {
        for (int i = 1; i < this.getChildren().size(); ++i) {
            ((Node)this.getChildren().get(i)).setVisible(false);
        }
    }

    private static /* synthetic */ ArrayList lambda$addAnimatedNode$188(Boolean expanded) {
        return new ArrayList();
    }

    private /* synthetic */ ArrayList lambda$addAnimatedNode$187(Region node, Boolean expanded) {
        return this.initDefaultAnimation(node, expanded);
    }

    private /* synthetic */ void lambda$addAnimatedNode$185(MouseEvent click) {
        this.animateList();
    }

    private /* synthetic */ void lambda$addAnimatedNode$184(ActionEvent action) {
        this.animateList();
    }

    static /* synthetic */ void access$lambda$0(JFXNodesList jFXNodesList, ActionEvent actionEvent) {
        jFXNodesList.lambda$addAnimatedNode$184(actionEvent);
    }

    static /* synthetic */ void access$lambda$1(JFXNodesList jFXNodesList, MouseEvent mouseEvent) {
        jFXNodesList.lambda$addAnimatedNode$185(mouseEvent);
    }

    static /* synthetic */ void access$lambda$2(Region region, ObservableValue observableValue, Number number, Number number2) {
        region.setRotate(number2.doubleValue() % 180.0 == 0.0 ? number2.doubleValue() : -number2.doubleValue());
    }

    static /* synthetic */ ArrayList access$lambda$3(JFXNodesList jFXNodesList, Region region, Boolean bl) {
        return jFXNodesList.lambda$addAnimatedNode$187(region, bl);
    }

    static /* synthetic */ ArrayList access$lambda$4(Boolean bl) {
        return JFXNodesList.lambda$addAnimatedNode$188(bl);
    }

    static /* synthetic */ void access$lambda$5(Node node) {
        node.setVisible(true);
    }

    static /* synthetic */ void access$lambda$6(JFXNodesList jFXNodesList, ActionEvent actionEvent) {
        jFXNodesList.lambda$animateList$190(actionEvent);
    }
}

