/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.table;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;

public class DistinctMappingList<V, E>
extends ObservableListBase<E> {
    private List<E> mapped;
    private Function<V, E> mapper;

    public DistinctMappingList(ObservableList<V> source, Function<V, E> mapper) {
        this.mapper = mapper;
        this.mapped = this.applyMapper((List<? extends V>)source);
        ListChangeListener l = c -> this.sourceChanged(c);
        source.addListener(l);
    }

    private void sourceChanged(ListChangeListener.Change<? extends V> c) {
        this.beginChange();
        List<E> backing = this.applyMapper((List<? extends V>)c.getList());
        while (c.next()) {
            if (c.wasAdded()) {
                this.wasAdded(c, backing);
                continue;
            }
            if (c.wasRemoved()) {
                this.wasRemoved(c, backing);
                continue;
            }
            if (!c.wasPermutated()) continue;
        }
        this.endChange();
    }

    private void wasRemoved(ListChangeListener.Change<? extends V> c, List<E> backing) {
        List<E> removedCategories = this.applyMapper(c.getRemoved());
        for (E e : removedCategories) {
            if (backing.contains(e)) continue;
            int index = this.indexOf(e);
            this.mapped.remove(index);
            this.nextRemove(index, e);
        }
    }

    private void wasAdded(ListChangeListener.Change<? extends V> c, List<E> backing) {
        List<E> addedCategories = this.applyMapper(c.getAddedSubList());
        for (E e : addedCategories) {
            if (this.contains(e)) continue;
            int last = this.size();
            this.mapped.add(e);
            this.nextAdd(last, last + 1);
        }
    }

    private List<E> applyMapper(List<? extends V> list) {
        List backing = list.stream().map(p -> this.mapper.apply(p)).distinct().collect(Collectors.toList());
        return backing;
    }

    public E get(int index) {
        return this.mapped.get(index);
    }

    public int size() {
        return this.mapped.size();
    }
}

