/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXRippler;
import com.jfoenix.skins.JFXRadioButtonOldSkin$$Lambda$1;
import com.jfoenix.skins.JFXRadioButtonOldSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.RadioButtonSkin;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class JFXRadioButtonOldSkin
extends RadioButtonSkin {
    private boolean invalid = true;
    private double padding = 15.0;
    private double contWidth;
    private double contHeight;
    private double maxHeight;
    private double radioRadius = 8.0;
    private double minRadius = 0.0;
    private final JFXRippler rippler;
    private Circle radio;
    private Circle dot;
    private Color unSelectedColor = Color.valueOf((String)"#5A5A5A");
    private Color selectedColor = Color.valueOf((String)"#0F9D58");
    private Timeline timeline;
    private final AnchorPane container = new AnchorPane();
    private double labelOffset = -1.0;

    public JFXRadioButtonOldSkin(RadioButton control) {
        super(control);
        this.radio = new Circle(this.radioRadius);
        this.radio.setStrokeWidth(2.0);
        this.radio.setFill((Paint)Color.TRANSPARENT);
        this.radio.getStyleClass().setAll((Object[])new String[]{"radio"});
        this.dot = new Circle();
        this.dot.setRadius(this.minRadius);
        this.dot.setFill((Paint)this.selectedColor);
        this.dot.fillProperty().addListener(JFXRadioButtonOldSkin$$Lambda$1.lambdaFactory$(this));
        this.dot.getStyleClass().setAll((Object[])new String[]{"dot"});
        StackPane boxContainer = new StackPane();
        boxContainer.getChildren().addAll((Object[])new Node[]{this.radio, this.dot});
        boxContainer.setPadding(new Insets(this.padding));
        this.rippler = new JFXRippler((Node)boxContainer, JFXRippler.RipplerMask.CIRCLE);
        this.container.getChildren().add((Object)this.rippler);
        AnchorPane.setRightAnchor((Node)this.rippler, (Double)this.labelOffset);
        this.updateChildren();
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.radio != null) {
            this.removeRadio();
            this.getChildren().add((Object)this.container);
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        RadioButton radioButton = (RadioButton)this.getSkinnable();
        this.contWidth = this.snapSize(this.container.prefWidth(-1.0)) + (double)(this.invalid ? 2 : 0);
        this.contHeight = this.snapSize(this.container.prefHeight(-1.0)) + (double)(this.invalid ? 2 : 0);
        double computeWidth = Math.min(radioButton.prefWidth(-1.0), radioButton.minWidth(-1.0)) + this.labelOffset + 2.0 * this.padding;
        double labelWidth = Math.min(computeWidth - this.contWidth, w - this.snapSize(this.contWidth)) + this.labelOffset + 2.0 * this.padding;
        double labelHeight = Math.min(radioButton.prefHeight(labelWidth), h);
        this.maxHeight = Math.max(this.contHeight, labelHeight);
        double xOffset = JFXRadioButtonOldSkin.computeXOffset(w, labelWidth + this.contWidth, radioButton.getAlignment().getHpos()) + x;
        double yOffset = JFXRadioButtonOldSkin.computeYOffset(h, this.maxHeight, radioButton.getAlignment().getVpos()) + x;
        if (this.invalid) {
            this.initializeComponents(x, y, w, h);
            this.invalid = false;
        }
        this.layoutLabelInArea(xOffset + this.contWidth, yOffset, labelWidth, this.maxHeight, radioButton.getAlignment());
        ((Text)this.getChildren().get(0)).textProperty().set(((RadioButton)this.getSkinnable()).textProperty().get());
        this.container.resize(this.snapSize(this.contWidth), this.snapSize(this.contHeight));
        this.positionInArea((Node)this.container, xOffset, yOffset, this.contWidth, this.maxHeight, 0.0, radioButton.getAlignment().getHpos(), radioButton.getAlignment().getVpos());
    }

    private void initializeComponents(double x, double y, double w, double h) {
        this.radio.setStroke((Paint)this.unSelectedColor);
        ((RadioButton)this.getSkinnable()).selectedProperty().addListener(JFXRadioButtonOldSkin$$Lambda$2.lambdaFactory$(this));
        this.rippler.setRipplerFill((Paint)(((RadioButton)this.getSkinnable()).isSelected() ? this.unSelectedColor : this.selectedColor));
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.dot.radiusProperty(), (Object)this.minRadius, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)this.dot.radiusProperty(), (Object)(this.radioRadius + this.radio.getStrokeWidth() / 2.0), Interpolator.EASE_BOTH)})});
        this.rippler.setRipplerFill((Paint)(((RadioButton)this.getSkinnable()).isSelected() ? this.unSelectedColor : this.selectedColor));
        this.timeline.setRate(((RadioButton)this.getSkinnable()).isSelected() ? 1.0 : -1.0);
        this.timeline.play();
    }

    private void removeRadio() {
        for (int i = 0; i < this.getChildren().size(); ++i) {
            if (!"radio".equals(((Node)this.getChildren().get(i)).getStyleClass().get(0))) continue;
            this.getChildren().remove(i);
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.radio.minWidth(-1.0)) + this.labelOffset + 2.0 * this.padding;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.radio.prefWidth(-1.0)) + this.labelOffset + 2.0 * this.padding;
    }

    static double computeXOffset(double width, double contentWidth, HPos hpos) {
        switch (hpos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (width - contentWidth) / 2.0;
            }
            case RIGHT: {
                return width - contentWidth;
            }
        }
        return 0.0;
    }

    static double computeYOffset(double height, double contentHeight, VPos vpos) {
        switch (vpos) {
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (height - contentHeight) / 2.0;
            }
            case BOTTOM: {
                return height - contentHeight;
            }
        }
        return 0.0;
    }

    private /* synthetic */ void lambda$initializeComponents$396(ObservableValue o, Boolean oldVal, Boolean newVal) {
        this.rippler.setRipplerFill((Paint)(newVal != false ? this.unSelectedColor : this.selectedColor));
        this.timeline.setRate(newVal != false ? 1.0 : -1.0);
        this.timeline.play();
    }

    private /* synthetic */ void lambda$new$395(ObservableValue o, Paint oldVal, Paint newVal) {
        this.selectedColor = (Color)newVal;
    }

    static /* synthetic */ void access$lambda$0(JFXRadioButtonOldSkin jFXRadioButtonOldSkin, ObservableValue observableValue, Paint paint, Paint paint2) {
        jFXRadioButtonOldSkin.lambda$new$395(observableValue, paint, paint2);
    }

    static /* synthetic */ void access$lambda$1(JFXRadioButtonOldSkin jFXRadioButtonOldSkin, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        jFXRadioButtonOldSkin.lambda$initializeComponents$396(observableValue, bl, bl2);
    }
}

