/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.skins.JFXProgressBarSkin$$Lambda$1;
import com.jfoenix.skins.JFXProgressBarSkin$$Lambda$2;
import com.jfoenix.skins.JFXProgressBarSkin$$Lambda$3;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import java.util.Collections;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.util.Duration;

public class JFXProgressBarSkin
extends BehaviorSkinBase<ProgressIndicator, BehaviorBase<ProgressIndicator>> {
    private Color indicatorColor = Color.valueOf((String)"#0F9D58");
    private Color trackColor = Color.valueOf((String)"#CCCCCC");
    private double trackStart;
    private double trackLength;
    private Line track;
    private Line bar;
    private boolean initialization;
    private boolean isIndeterminate;
    private Timeline timeline;

    public JFXProgressBarSkin(JFXProgressBar bar) {
        super((Control)bar, new BehaviorBase((Control)bar, Collections.emptyList()));
        this.initialize();
        bar.requestLayout();
    }

    private void initialize() {
        this.track = new Line();
        this.track.setStroke((Paint)this.trackColor);
        this.track.setStrokeWidth(3.0);
        this.track.getStyleClass().setAll((Object[])new String[]{"track"});
        this.bar = new Line();
        this.bar.setStroke((Paint)this.indicatorColor);
        this.bar.strokeWidthProperty().bind((ObservableValue)this.track.strokeWidthProperty());
        this.bar.getStyleClass().setAll((Object[])new String[]{"bar"});
        this.getChildren().clear();
        this.getChildren().addAll((Object[])new Node[]{this.track, this.bar});
        ((ProgressIndicator)this.getSkinnable()).indeterminateProperty().addListener(JFXProgressBarSkin$$Lambda$1.lambdaFactory$(this));
        ((ProgressIndicator)this.getSkinnable()).progressProperty().addListener(JFXProgressBarSkin$$Lambda$2.lambdaFactory$(this));
        ((ProgressIndicator)this.getSkinnable()).prefWidthProperty().addListener(JFXProgressBarSkin$$Lambda$3.lambdaFactory$(this));
        ((ProgressIndicator)this.getSkinnable()).maxHeightProperty().bind((ObservableValue)this.track.strokeWidthProperty());
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        if (!this.initialization) {
            this.isIndeterminate = ((ProgressIndicator)this.getSkinnable()).isIndeterminate();
            double trackHeight = this.snapSize(this.track.getStrokeWidth());
            this.trackLength = this.snapSize(((ProgressIndicator)this.getSkinnable()).getPrefWidth() - this.track.getStrokeWidth() - (((ProgressIndicator)this.getSkinnable()).snappedLeftInset() + ((ProgressIndicator)this.getSkinnable()).snappedRightInset()));
            this.trackStart = this.snapPosition(x);
            ((ProgressIndicator)this.getSkinnable()).setMaxWidth(this.trackLength);
            this.track.setStartX(this.trackStart);
            this.track.setEndX(this.trackStart + this.trackLength);
            this.track.setStartY(y + trackHeight / 2.0);
            this.track.setEndY(y + trackHeight / 2.0);
            this.bar.setStartX(this.trackStart);
            this.bar.setStartY(y + trackHeight / 2.0);
            this.bar.setEndY(y + trackHeight / 2.0);
            if (!this.isIndeterminate) {
                double barWidth = (double)((int)(this.trackLength - this.snappedLeftInset() - this.snappedRightInset()) * 2) * Math.min(1.0, Math.max(0.0, ((ProgressIndicator)this.getSkinnable()).getProgress())) / 2.0;
                this.bar.setEndX(barWidth);
            }
            if (this.isIndeterminate) {
                this.initializeTimeline();
                this.timeline.setCycleCount(-1);
                this.timeline.setRate(1.0);
                this.timeline.play();
            }
            this.initialization = true;
        }
    }

    private void initializeTimeline() {
        double first = this.trackLength / 3.0;
        double second = 2.0 * this.trackLength / 3.0;
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.bar.startXProperty(), (Object)0, Interpolator.LINEAR), new KeyValue((WritableValue)this.bar.endXProperty(), (Object)0, Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)0.5), new KeyValue[]{new KeyValue((WritableValue)this.bar.startXProperty(), (Object)first, Interpolator.LINEAR), new KeyValue((WritableValue)this.bar.endXProperty(), (Object)second, Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)1.0), new KeyValue[]{new KeyValue((WritableValue)this.bar.startXProperty(), (Object)this.trackLength, Interpolator.LINEAR), new KeyValue((WritableValue)this.bar.endXProperty(), (Object)this.trackLength, Interpolator.LINEAR)})});
    }

    private /* synthetic */ void lambda$initialize$394(ObservableValue o, Number oldVal, Number newVal) {
        this.initialization = false;
    }

    private /* synthetic */ void lambda$initialize$393(ObservableValue o, Number oldVal, Number newVal) {
        if (!this.isIndeterminate) {
            double barWidth = (double)((int)(this.trackLength - this.snappedLeftInset() - this.snappedRightInset()) * 2) * Math.min(1.0, Math.max(0.0, newVal.doubleValue())) / 2.0;
            this.bar.setEndX(barWidth);
        }
    }

    private /* synthetic */ void lambda$initialize$392(ObservableValue o, Boolean oldVal, Boolean newVal) {
        if (this.timeline != null) {
            this.timeline.stop();
        }
        this.initialization = false;
        ((ProgressIndicator)this.getSkinnable()).requestLayout();
    }

    static /* synthetic */ void access$lambda$0(JFXProgressBarSkin jFXProgressBarSkin, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        jFXProgressBarSkin.lambda$initialize$392(observableValue, bl, bl2);
    }

    static /* synthetic */ void access$lambda$1(JFXProgressBarSkin jFXProgressBarSkin, ObservableValue observableValue, Number number, Number number2) {
        jFXProgressBarSkin.lambda$initialize$393(observableValue, number, number2);
    }

    static /* synthetic */ void access$lambda$2(JFXProgressBarSkin jFXProgressBarSkin, ObservableValue observableValue, Number number, Number number2) {
        jFXProgressBarSkin.lambda$initialize$394(observableValue, number, number2);
    }
}

