/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import org.silentsoft.actlist.application.App;
import org.silentsoft.actlist.plugin.ActlistPlugin;
import org.silentsoft.actlist.plugin.PluginComponent;
import org.silentsoft.actlist.plugin.messagebox.MessageBox;
import org.silentsoft.core.util.ObjectUtil;
import org.silentsoft.io.memory.SharedMemory;

public class PluginManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean install(File file) throws Exception {
        if (file == null) {
            return false;
        }
        HashMap hashMap = (HashMap)SharedMemory.getDataMap().get((Object)"KEY_PLUGIN_MAP");
        boolean bl = true;
        if (file.getPath().equals(Paths.get(System.getProperty("user.dir"), "plugins", file.getName()).toString())) {
            if (hashMap.containsKey(file.getName())) {
                MessageBox.showError((Object)App.getStage(), (String)"You can not select an already loaded plugin !");
                return false;
            }
            bl = false;
        }
        Path path = Paths.get(file.toURI());
        Path path2 = Paths.get(System.getProperty("user.dir"), "plugins", file.getName());
        if (bl) {
            Files.copy(path, path2, new CopyOption[0]);
        }
        boolean bl2 = false;
        try (URLClassLoader uRLClassLoader = null;){
            Class<?> clazz = null;
            InputStream inputStream = null;
            uRLClassLoader = new URLClassLoader(new URL[]{path2.toUri().toURL()});
            try {
                URL uRL = uRLClassLoader.findResource("META-INF/MANIFEST.MF");
                inputStream = uRL.openStream();
                Manifest manifest = new Manifest(inputStream);
                String string = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS).trim();
                if (ObjectUtil.isNotEmpty((Object)string)) {
                    clazz = uRLClassLoader.loadClass(string);
                }
            }
            catch (Error | Exception throwable) {
                throwable.printStackTrace();
            }
            finally {
                if (clazz == null) {
                    clazz = uRLClassLoader.loadClass("Plugin");
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            if (!ActlistPlugin.class.isAssignableFrom(clazz)) {
                bl2 = true;
            }
        }
        if (bl2) {
            if (bl) {
                Files.delete(path2);
            }
            MessageBox.showError((Object)App.getStage(), (String)"This file is not kind of Actlist plugin !");
            return false;
        }
        return true;
    }

    public static void delete(String string) throws Exception {
        PluginManager.unload(string);
        Files.delete(Paths.get(System.getProperty("user.dir"), "plugins", string));
    }

    public static void load(String string, boolean bl) throws Exception {
        PluginManager.load(string, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(String string, boolean bl, Integer n) throws Exception {
        String string2;
        Serializable serializable;
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{Paths.get(System.getProperty("user.dir"), "plugins", string).toUri().toURL()});
        Class<?> clazz = null;
        InputStream inputStream = null;
        try {
            serializable = uRLClassLoader.findResource("META-INF/MANIFEST.MF");
            inputStream = ((URL)serializable).openStream();
            Manifest manifest = new Manifest(inputStream);
            string2 = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS).trim();
            if (ObjectUtil.isNotEmpty((Object)string2)) {
                clazz = uRLClassLoader.loadClass(string2);
            }
        }
        catch (Error | Exception throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (clazz == null) {
                clazz = uRLClassLoader.loadClass("Plugin");
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (ActlistPlugin.class.isAssignableFrom(clazz)) {
            serializable = (HashMap)SharedMemory.getDataMap().get((Object)"KEY_PLUGIN_MAP");
            boolean bl2 = ((HashMap)serializable).size() == 0;
            ((HashMap)serializable).put(string, uRLClassLoader);
            string2 = new FXMLLoader(PluginComponent.class.getResource(PluginComponent.class.getSimpleName().concat(".fxml")));
            Node node = (Node)string2.load();
            PluginComponent pluginComponent = (PluginComponent)string2.getController();
            pluginComponent.initialize(string, clazz, bl);
            node.setUserData((Object)pluginComponent);
            VBox vBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
            if (bl2) {
                vBox.getChildren().clear();
            }
            if (n == null) {
                vBox.getChildren().add((Object)node);
            } else {
                vBox.getChildren().add(n.intValue(), (Object)node);
            }
        }
    }

    public static void unload(String string) throws Exception {
        VBox vBox = (VBox)SharedMemory.getDataMap().get((Object)"KEY_COMPONENT_BOX");
        int n = vBox.getChildren().size();
        for (int i = 0; i < n; ++i) {
            PluginComponent pluginComponent = (PluginComponent)((Node)vBox.getChildren().get(i)).getUserData();
            if (!pluginComponent.getPluginFileName().equals(string)) continue;
            pluginComponent.clear();
            vBox.getChildren().remove(i);
            HashMap hashMap = (HashMap)SharedMemory.getDataMap().get((Object)"KEY_PLUGIN_MAP");
            ((URLClassLoader)hashMap.get(string)).close();
            hashMap.remove(string);
            break;
        }
    }
}

