/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.preloader;

import java.awt.Robot;
import java.io.File;
import java.nio.file.Paths;
import javafx.application.Preloader;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.silentsoft.actlist.ActlistConfig;
import org.silentsoft.actlist.util.ConfigUtil;
import org.silentsoft.core.util.FileUtil;
import org.silentsoft.core.util.JSONUtil;
import org.silentsoft.core.util.SystemUtil;
import org.silentsoft.io.memory.SharedMemory;

public class App
extends Preloader {
    private Stage stage;
    @FXML
    private Label statusLabel;
    @FXML
    private ProgressBar statusProgressBar;

    public void start(Stage stage) throws Exception {
        App.loadConfiguration();
        App.checkSingleInstance();
        this.stage = stage;
        stage.initStyle(StageStyle.TRANSPARENT);
        FXMLLoader fXMLLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName().concat(".fxml")));
        fXMLLoader.setController((Object)this);
        stage.setScene(new Scene((Parent)fXMLLoader.load(), (Paint)Color.TRANSPARENT));
        stage.setWidth(400.0);
        stage.setHeight(360.0);
        stage.show();
    }

    public static void loadConfiguration() {
        try {
            ActlistConfig actlistConfig = null;
            File file = Paths.get(System.getProperty("user.dir"), "actlist.jar.config").toFile();
            if (file.exists()) {
                String string = FileUtil.readFile((File)file);
                actlistConfig = (ActlistConfig)JSONUtil.JSONToObject((String)string, ActlistConfig.class);
            } else {
                actlistConfig = new ActlistConfig();
                actlistConfig.put("rootWidth", 506.0);
                actlistConfig.put("rootHeight", 443.0);
                actlistConfig.put("stageWidth", 516.0);
                actlistConfig.put("stageHeight", 453.0);
                actlistConfig.put("stageOpacity", 1.0);
                actlistConfig.put("showHideActlistHotKeyModifier", 640);
                actlistConfig.put("showHideActlistHotKeyCode", 65);
                actlistConfig.put("alwaysOnTop", false);
                actlistConfig.put("proxyMode", "AUTOMATIC");
                actlistConfig.put("proxyHost", "");
            }
            SharedMemory.getDataMap().put((Object)"KEY_ACTLIST_CONFIG", (Object)actlistConfig);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void checkSingleInstance() {
        String string = "Actlist";
        if (SystemUtil.isWindows()) {
            string = string + ".exe";
        }
        if (SystemUtil.findProcessByImageName((String)string, (String)SystemUtil.getCurrentProcessId())) {
            try {
                Robot robot = new Robot();
                int n = ConfigUtil.getShowHideActlistHotKeyCode();
                int n2 = ConfigUtil.getShowHideActlistHotKeyModifier();
                if ((n2 & 0x80) == 128) {
                    robot.keyPress(17);
                }
                if ((n2 & 0x200) == 512) {
                    robot.keyPress(18);
                }
                if ((n2 & 0x40) == 64) {
                    robot.keyPress(16);
                }
                if ((n2 & 0x100) == 256) {
                    robot.keyPress(524);
                }
                robot.keyPress(n);
                if ((n2 & 0x80) == 128) {
                    robot.keyRelease(17);
                }
                if ((n2 & 0x200) == 512) {
                    robot.keyRelease(18);
                }
                if ((n2 & 0x40) == 64) {
                    robot.keyRelease(16);
                }
                if ((n2 & 0x100) == 256) {
                    robot.keyRelease(524);
                }
                robot.keyRelease(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public void handleApplicationNotification(Preloader.PreloaderNotification preloaderNotification) {
        if (preloaderNotification instanceof Preloader.ProgressNotification) {
            double d = ((Preloader.ProgressNotification)preloaderNotification).getProgress();
            this.statusProgressBar.setProgress(d);
            if (Double.compare(d, 0.3) == 0) {
                this.statusLabel.setText("Preparing engine");
            } else if (Double.compare(d, 0.5) == 0) {
                this.statusLabel.setText("Preparing plugins");
            } else if (Double.compare(d, 1.0) >= 0) {
                this.statusLabel.setText("Enjoy your own Actlist !");
            }
        } else if (preloaderNotification instanceof Preloader.StateChangeNotification && ((Preloader.StateChangeNotification)preloaderNotification).getType() == Preloader.StateChangeNotification.Type.BEFORE_START) {
            this.stage.hide();
        }
    }
}

