/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.ui.hotkey;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;

public class HotkeyHandler
implements EventHandler<KeyEvent> {
    private static HotkeyHandler hotkeyHandler;
    private Map<KeyCodeCombination, Runnable> hotkeyMap;

    private HotkeyHandler() {
    }

    public static HotkeyHandler getInstance() {
        if (hotkeyHandler == null) {
            hotkeyHandler = new HotkeyHandler();
        }
        return hotkeyHandler;
    }

    private Map<KeyCodeCombination, Runnable> getHotkeyMap() {
        if (this.hotkeyMap == null) {
            this.hotkeyMap = new HashMap<KeyCodeCombination, Runnable>();
        }
        return this.hotkeyMap;
    }

    public boolean registerHotkey(KeyCode keyCode, boolean shiftDown, boolean controlDown, boolean altDown, Runnable action) {
        boolean result = true;
        if (keyCode.isModifierKey()) {
            result = false;
        } else {
            this.getHotkeyMap().put(new KeyCodeCombination(keyCode, this.makeModifiers(shiftDown, controlDown, altDown)), action);
        }
        return result;
    }

    private KeyCombination.Modifier[] makeModifiers(boolean shiftDown, boolean controlDown, boolean altDown) {
        ArrayList<KeyCombination.Modifier> modifiers = new ArrayList<KeyCombination.Modifier>();
        if (shiftDown) {
            modifiers.add(KeyCombination.SHIFT_DOWN);
        }
        if (controlDown) {
            modifiers.add(KeyCombination.CONTROL_DOWN);
        }
        if (altDown) {
            modifiers.add(KeyCombination.ALT_DOWN);
        }
        return modifiers.toArray(new KeyCombination.Modifier[0]);
    }

    public void handle(KeyEvent event) {
        if (!event.getCode().isModifierKey()) {
            for (Map.Entry<KeyCodeCombination, Runnable> entry : this.getHotkeyMap().entrySet()) {
                if (!entry.getKey().match(event)) continue;
                entry.getValue().run();
            }
        }
    }
}

