/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.net.pojo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

@JsonIgnoreProperties(value={"nameWithExtension"})
public class FilePOJO {
    private File file;
    private byte[] bytes;
    private String tag;
    private boolean isDirectory;
    private String name;
    private String extension;
    private long length;
    private String size;

    public FilePOJO() {
    }

    public FilePOJO(String tag) {
        this.setTag(tag);
    }

    public FilePOJO(File file) {
        this(null, file);
    }

    public FilePOJO(String tag, File file) {
        this(tag);
        this.setFile(file);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        if (this.getFile() != null) {
            this.setDirectory(this.getFile().isDirectory());
            String name = this.getFile().getName();
            String extension = "";
            int lastIndexOfSeparator = name.lastIndexOf(File.separator);
            int lastIndexOfDot = name.lastIndexOf(".");
            if (lastIndexOfDot != -1 && lastIndexOfDot > lastIndexOfSeparator) {
                extension = name.substring(lastIndexOfDot + 1, name.length());
            }
            lastIndexOfDot = lastIndexOfDot > lastIndexOfSeparator ? lastIndexOfDot : name.length();
            name = name.substring(lastIndexOfSeparator + 1, lastIndexOfDot);
            this.setName(name);
            this.setExtension(extension);
            this.setLength(this.getFile().length());
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    private void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getNameWithExtension() {
        return this.getName().concat(".").concat(this.getExtension());
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
        this.setSize(String.valueOf(this.length).concat(" byte"));
        double sizeKB = (double)this.length / 1024.0;
        if (sizeKB >= 1.0) {
            this.setSize(String.format("%.2f", sizeKB).concat(" KB"));
            double sizeMB = (double)this.length / 1024.0 / 1024.0;
            if (sizeMB >= 1.0) {
                this.setSize(String.format("%.2f", sizeMB).concat(" MB"));
                double sizeGB = (double)this.length / 1024.0 / 1024.0 / 1024.0;
                if (sizeGB >= 1.0) {
                    this.setSize(String.format("%.2f", sizeGB).concat(" GB"));
                }
            }
        }
    }

    public String getSize() {
        return this.size;
    }

    private void setSize(String size) {
        this.size = size;
    }

    public boolean store(String destination) throws Exception {
        return this.store(new File(destination));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean store(File destination) throws Exception {
        if (this.getBytes() == null) {
            throw new NullPointerException("Source bytes cannot be null !");
        }
        if (destination == null) {
            throw new NullPointerException("Destination cannot be null !");
        }
        File parentFile = destination.getParentFile();
        if (parentFile != null && !parentFile.mkdirs() && !parentFile.isDirectory()) {
            throw new IOException("Cannot create destination '".concat(parentFile.toString()).concat("' directory"));
        }
        if (destination.exists() && !destination.canWrite()) {
            throw new IOException("Destination '".concat(destination.toString()).concat("' exist. but it is read-only"));
        }
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(destination);
            IOUtils.write((byte[])this.getBytes(), (OutputStream)fileOutputStream);
        }
        return true;
    }
}

