/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXSlider;
import com.jfoenix.skins.JFXSliderSkinOLD$$Lambda$1;
import com.jfoenix.skins.JFXSliderSkinOLD$$Lambda$10;
import com.jfoenix.skins.JFXSliderSkinOLD$$Lambda$11;
import com.jfoenix.skins.JFXSliderSkinOLD$$Lambda$2;
import com.jfoenix.skins.JFXSliderSkinOLD$$Lambda$3;
import com.jfoenix.skins.JFXSliderSkinOLD$$Lambda$4;
import com.jfoenix.skins.JFXSliderSkinOLD$$Lambda$5;
import com.jfoenix.skins.JFXSliderSkinOLD$$Lambda$6;
import com.jfoenix.skins.JFXSliderSkinOLD$$Lambda$7;
import com.jfoenix.skins.JFXSliderSkinOLD$$Lambda$8;
import com.jfoenix.skins.JFXSliderSkinOLD$$Lambda$9;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.SliderBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import java.util.concurrent.Callable;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Slider;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class JFXSliderSkinOLD
extends BehaviorSkinBase<Slider, SliderBehavior> {
    private boolean isHorizontal;
    private boolean isIndicatorLeft;
    private Paint thumbColor = Color.valueOf((String)"#0F9D58");
    private Paint trackColor = Color.valueOf((String)"#CCCCCC");
    private double thumbRadius;
    private double trackStart;
    private double trackLength;
    private double thumbTop;
    private double thumbLeft;
    private double preDragThumbPos;
    private double indicatorRotation;
    private double horizontalRotation;
    private double rotationAngle = 45.0;
    private double shifting;
    private Point2D dragStart;
    private Circle thumb;
    private StackPane animatedThumb;
    private Line track;
    private Line coloredTrack;
    private Text sliderValue;
    private boolean trackClicked;
    private boolean initialization;
    private Timeline timeline;
    private double trackSize;
    private boolean internalChange = false;

    public JFXSliderSkinOLD(JFXSlider slider) {
        super((Control)slider, (BehaviorBase)new SliderBehavior((Slider)slider));
        this.isIndicatorLeft = slider.getIndicatorPosition() == JFXSlider.IndicatorPosition.LEFT;
        this.initialize();
        slider.requestLayout();
        this.registerChangeListener((ObservableValue)slider.minProperty(), "MIN");
        this.registerChangeListener((ObservableValue)slider.maxProperty(), "MAX");
        this.registerChangeListener((ObservableValue)slider.valueProperty(), "VALUE");
        this.registerChangeListener((ObservableValue)slider.orientationProperty(), "ORIENTATION");
    }

    private void initialize() {
        this.isHorizontal = ((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
        this.thumb = new Circle();
        this.thumb.setStrokeWidth(2.0);
        this.thumb.setRadius(7.0);
        this.thumb.setFill(this.thumbColor);
        this.thumb.setStroke(this.thumbColor);
        this.thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
        this.track = new Line();
        this.track.setStroke(this.trackColor);
        this.track.setStrokeWidth(3.0);
        this.track.getStyleClass().setAll((Object[])new String[]{"track"});
        this.coloredTrack = new Line();
        this.coloredTrack.strokeProperty().bind((ObservableValue)this.thumb.strokeProperty());
        this.coloredTrack.strokeWidthProperty().bind((ObservableValue)this.track.strokeWidthProperty());
        this.sliderValue = new Text();
        this.sliderValue.setStroke((Paint)Color.WHITE);
        this.sliderValue.setFont(new Font(10.0));
        this.sliderValue.getStyleClass().setAll((Object[])new String[]{"sliderValue"});
        this.animatedThumb = new StackPane();
        this.animatedThumb.getChildren().add((Object)this.sliderValue);
        this.getChildren().clear();
        this.getChildren().addAll((Object[])new Node[]{this.track, this.coloredTrack, this.animatedThumb, this.thumb});
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        if (this.trackSize != (this.isHorizontal ? w : h)) {
            double d = this.trackSize = this.isHorizontal ? w : h;
            if (!this.initialization) {
                this.initializeVariables();
            }
            if (this.isHorizontal) {
                double trackHeight = this.snapSize(this.track.getStrokeWidth());
                double trackAreaHeight = Math.max(trackHeight, 2.0 * this.thumbRadius);
                double startY = y + Math.max(h, trackAreaHeight) / 2.0;
                this.trackLength = this.snapSize(w - 2.0 * this.thumbRadius);
                this.trackStart = this.snapPosition(x + this.thumbRadius);
                double trackTop = (int)(startY - trackHeight / 2.0);
                this.thumbTop = (int)startY;
                this.track.setStartX(this.trackStart);
                this.track.setEndX(this.trackStart + this.trackLength);
                this.track.setStartY(trackTop + trackHeight / 2.0);
                this.track.setEndY(trackTop + trackHeight / 2.0);
                this.coloredTrack.setStartX(this.trackStart);
                this.coloredTrack.setStartY(trackTop + trackHeight / 2.0);
                this.coloredTrack.setEndY(trackTop + trackHeight / 2.0);
            } else {
                double trackWidth = this.snapSize(this.track.getStrokeWidth());
                double trackAreaWidth = Math.max(trackWidth, 2.0 * this.thumbRadius);
                double startX = x + Math.max(w, trackAreaWidth) / 2.0;
                this.trackLength = this.snapSize(h - 2.0 * this.thumbRadius);
                this.trackStart = this.snapPosition(y + this.thumbRadius);
                double trackLeft = (int)(startX - trackWidth / 2.0);
                this.thumbLeft = (int)startX;
                this.track.setStartX(trackLeft + trackWidth / 2.0);
                this.track.setEndX(trackLeft + trackWidth / 2.0);
                this.track.setStartY(this.trackStart);
                this.track.setEndY(this.trackStart + this.trackLength);
                this.coloredTrack.setStartY(this.trackStart + this.trackLength);
                this.coloredTrack.setStartX(trackLeft + trackWidth / 2.0);
                this.coloredTrack.setEndX(trackLeft + trackWidth / 2.0);
            }
            if (!this.initialization) {
                this.initializeMouseEvents();
                this.initializeTimeline();
                this.initialization = true;
            }
            this.positionThumb(true);
        }
    }

    private void initializeVariables() {
        double radius;
        double stroke = this.thumb.getStrokeWidth();
        this.thumbRadius = stroke > (radius = this.thumb.getRadius()) ? stroke : radius;
        this.trackColor = (Color)this.track.getStroke();
        this.thumbColor = (Color)this.thumb.getStroke();
        this.track.strokeProperty().addListener(JFXSliderSkinOLD$$Lambda$1.lambdaFactory$(this));
        this.thumb.strokeProperty().addListener(JFXSliderSkinOLD$$Lambda$2.lambdaFactory$(this));
        this.shifting = 30.0 + this.thumbRadius;
        if (!this.isHorizontal) {
            this.horizontalRotation = -90.0;
        }
        if (!this.isIndicatorLeft) {
            this.indicatorRotation = 180.0;
            this.shifting = -this.shifting;
        }
        this.sliderValue.setRotate(this.rotationAngle + this.indicatorRotation + 3.0 * this.horizontalRotation);
        this.animatedThumb.resize(30.0, 30.0);
        this.animatedThumb.setRotate(-this.rotationAngle + this.indicatorRotation + this.horizontalRotation);
        this.animatedThumb.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding((Callable)JFXSliderSkinOLD$$Lambda$3.lambdaFactory$(this), (Observable[])new Observable[]{this.thumb.strokeProperty()}));
        this.animatedThumb.setScaleX(0.0);
        this.animatedThumb.setScaleY(0.0);
    }

    private void initializeMouseEvents() {
        ((Slider)this.getSkinnable()).setOnMousePressed(JFXSliderSkinOLD$$Lambda$4.lambdaFactory$(this));
        ((Slider)this.getSkinnable()).setOnMouseReleased(JFXSliderSkinOLD$$Lambda$5.lambdaFactory$(this));
        ((Slider)this.getSkinnable()).setOnMouseDragged(JFXSliderSkinOLD$$Lambda$6.lambdaFactory$(this));
        this.thumb.setOnMousePressed(JFXSliderSkinOLD$$Lambda$7.lambdaFactory$(this));
        this.thumb.setOnMouseReleased(JFXSliderSkinOLD$$Lambda$8.lambdaFactory$(this));
        this.thumb.setOnMouseDragged(JFXSliderSkinOLD$$Lambda$9.lambdaFactory$(this));
        this.thumb.layoutXProperty().addListener(JFXSliderSkinOLD$$Lambda$10.lambdaFactory$(this));
        this.thumb.layoutYProperty().addListener(JFXSliderSkinOLD$$Lambda$11.lambdaFactory$(this));
    }

    private void initializeTimeline() {
        if (this.isHorizontal) {
            double thumbPosY = this.thumb.getLayoutY() - this.thumbRadius;
            this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.animatedThumb.scaleXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.animatedThumb.scaleYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.animatedThumb.layoutYProperty(), (Object)thumbPosY, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.2), new KeyValue[]{new KeyValue((WritableValue)this.animatedThumb.scaleXProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.animatedThumb.scaleYProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.animatedThumb.layoutYProperty(), (Object)(thumbPosY - this.shifting), Interpolator.EASE_BOTH)})});
        } else {
            double thumbPosX = this.thumb.getLayoutX() - this.thumbRadius;
            this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.animatedThumb.scaleXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.animatedThumb.scaleYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.animatedThumb.layoutXProperty(), (Object)thumbPosX, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.2), new KeyValue[]{new KeyValue((WritableValue)this.animatedThumb.scaleXProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.animatedThumb.scaleYProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.animatedThumb.layoutXProperty(), (Object)(thumbPosX - this.shifting), Interpolator.EASE_BOTH)})});
        }
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("ORIENTATION".equals(p)) {
            ((Slider)this.getSkinnable()).requestLayout();
        } else if ("VALUE".equals(p)) {
            this.positionThumb(this.trackClicked);
        } else if ("MIN".equals(p)) {
            ((Slider)this.getSkinnable()).requestLayout();
        } else if ("MAX".equals(p)) {
            ((Slider)this.getSkinnable()).requestLayout();
        }
    }

    private void positionThumb(boolean animate) {
        double endY;
        Slider s = (Slider)this.getSkinnable();
        if (s.getValue() > s.getMax()) {
            return;
        }
        final double endX = this.isHorizontal ? this.trackStart + this.trackLength * ((s.getValue() - s.getMin()) / (s.getMax() - s.getMin())) - this.snappedLeftInset() : this.thumbLeft;
        double d = endY = this.isHorizontal ? this.thumbTop : this.snappedTopInset() + this.thumbRadius + this.trackLength - this.trackLength * ((s.getValue() - s.getMin()) / (s.getMax() - s.getMin()));
        if (animate) {
            final double startX = this.thumb.getLayoutX();
            final double startY = this.thumb.getLayoutY();
            Transition transition = new Transition(){
                {
                    this.setCycleDuration(Duration.millis((double)20.0));
                }

                protected void interpolate(double frac) {
                    if (!Double.isNaN(startX)) {
                        JFXSliderSkinOLD.this.thumb.setLayoutX(startX + frac * (endX - startX));
                    }
                    if (!Double.isNaN(startY)) {
                        JFXSliderSkinOLD.this.thumb.setLayoutY(startY + frac * (endY - startY));
                    }
                }
            };
            transition.play();
        } else {
            this.thumb.setLayoutX(endX);
            this.thumb.setLayoutY(endY);
        }
    }

    double minTrackLength() {
        return 2.0 * this.thumb.prefWidth(-1.0);
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.isHorizontal) {
            return leftInset + this.minTrackLength() + this.thumb.minWidth(-1.0) + rightInset;
        }
        return leftInset + this.thumb.prefWidth(-1.0) + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.isHorizontal) {
            return topInset + this.thumb.prefHeight(-1.0) + bottomInset;
        }
        return topInset + this.minTrackLength() + this.thumb.prefHeight(-1.0) + bottomInset;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.isHorizontal) {
            return 140.0;
        }
        return leftInset + Math.max(this.thumb.prefWidth(-1.0), this.track.prefWidth(-1.0)) + rightInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.isHorizontal) {
            return topInset + Math.max(this.thumb.prefHeight(-1.0), this.track.prefHeight(-1.0)) + bottomInset;
        }
        return 140.0;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.isHorizontal) {
            return Double.MAX_VALUE;
        }
        return ((Slider)this.getSkinnable()).prefWidth(-1.0);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.isHorizontal) {
            return ((Slider)this.getSkinnable()).prefHeight(width);
        }
        return Double.MAX_VALUE;
    }

    private /* synthetic */ void lambda$initializeMouseEvents$422(ObservableValue o, Number oldVal, Number newVal) {
        if (!this.isHorizontal) {
            this.animatedThumb.setLayoutY(newVal.doubleValue() - 2.0 * this.thumbRadius - 1.0);
            long value = Math.round(((Slider)this.getSkinnable()).getValue());
            this.sliderValue.setText("" + value);
            if (this.coloredTrack.getStartY() > newVal.doubleValue()) {
                this.coloredTrack.setEndY(newVal.doubleValue() + this.thumbRadius);
            } else {
                this.coloredTrack.setEndY(this.coloredTrack.getStartY());
            }
            this.internalChange = true;
            if (value == 0L) {
                this.thumb.setFill(this.trackColor);
                this.thumb.setStroke(this.trackColor);
                this.coloredTrack.setVisible(false);
            } else {
                this.thumb.setFill(this.thumbColor);
                this.thumb.setStroke(this.thumbColor);
                this.coloredTrack.setVisible(true);
            }
            this.internalChange = false;
        }
    }

    private /* synthetic */ void lambda$initializeMouseEvents$421(ObservableValue o, Number oldVal, Number newVal) {
        if (this.isHorizontal) {
            this.animatedThumb.setLayoutX(newVal.doubleValue() - 2.0 * this.thumbRadius - 1.0);
            long value = Math.round(((Slider)this.getSkinnable()).getValue());
            this.sliderValue.setText("" + value);
            if (this.coloredTrack.getStartX() < newVal.doubleValue()) {
                this.coloredTrack.setEndX(newVal.doubleValue());
            } else {
                this.coloredTrack.setEndX(this.coloredTrack.getStartX());
            }
            this.internalChange = true;
            if (value == 0L) {
                this.thumb.setFill(this.trackColor);
                this.thumb.setStroke(this.trackColor);
                this.coloredTrack.setVisible(false);
            } else {
                this.thumb.setFill(this.thumbColor);
                this.thumb.setStroke(this.thumbColor);
                this.coloredTrack.setVisible(true);
            }
            this.internalChange = false;
        }
    }

    private /* synthetic */ void lambda$initializeMouseEvents$420(MouseEvent me) {
        Point2D cur = this.thumb.localToParent(me.getX(), me.getY());
        double dragPos = this.isHorizontal ? cur.getX() - this.dragStart.getX() : -(cur.getY() - this.dragStart.getY());
        ((SliderBehavior)this.getBehavior()).thumbDragged(me, this.preDragThumbPos + dragPos / this.trackLength);
    }

    private /* synthetic */ void lambda$initializeMouseEvents$419(MouseEvent me) {
        ((SliderBehavior)this.getBehavior()).thumbReleased(me);
    }

    private /* synthetic */ void lambda$initializeMouseEvents$418(MouseEvent me) {
        ((SliderBehavior)this.getBehavior()).thumbPressed(me, 0.0);
        this.dragStart = this.thumb.localToParent(me.getX(), me.getY());
        this.preDragThumbPos = (((Slider)this.getSkinnable()).getValue() - ((Slider)this.getSkinnable()).getMin()) / (((Slider)this.getSkinnable()).getMax() - ((Slider)this.getSkinnable()).getMin());
    }

    private /* synthetic */ void lambda$initializeMouseEvents$417(MouseEvent me) {
        if (!this.thumb.isPressed()) {
            if (this.isHorizontal) {
                ((SliderBehavior)this.getBehavior()).trackPress(me, me.getX() / this.trackLength);
            } else {
                ((SliderBehavior)this.getBehavior()).trackPress(me, me.getY() / this.trackLength);
            }
        }
    }

    private /* synthetic */ void lambda$initializeMouseEvents$416(MouseEvent me) {
        this.timeline.setRate(-1.0);
        this.timeline.play();
    }

    private /* synthetic */ void lambda$initializeMouseEvents$415(MouseEvent me) {
        if (!this.thumb.isPressed()) {
            this.trackClicked = true;
            if (this.isHorizontal) {
                ((SliderBehavior)this.getBehavior()).trackPress(me, me.getX() / this.trackLength);
            } else {
                ((SliderBehavior)this.getBehavior()).trackPress(me, me.getY() / this.trackLength);
            }
            this.trackClicked = false;
        }
        this.timeline.setRate(1.0);
        this.timeline.play();
    }

    private /* synthetic */ Background lambda$initializeVariables$414() throws Exception {
        return new Background(new BackgroundFill[]{new BackgroundFill(this.thumb.getStroke(), new CornerRadii(50.0, 50.0, 50.0, 0.0, true), null)});
    }

    private /* synthetic */ void lambda$initializeVariables$413(ObservableValue o, Paint oldVal, Paint newVal) {
        if (!this.internalChange) {
            this.thumbColor = newVal;
            if (((Slider)this.getSkinnable()).getValue() == 0.0) {
                this.internalChange = true;
                this.thumb.setFill(this.trackColor);
                this.thumb.setStroke(this.trackColor);
                this.internalChange = false;
            }
        }
    }

    private /* synthetic */ void lambda$initializeVariables$412(ObservableValue o, Paint oldVal, Paint newVal) {
        if (!this.internalChange) {
            this.trackColor = newVal;
        }
    }

    static /* synthetic */ void access$lambda$0(JFXSliderSkinOLD jFXSliderSkinOLD, ObservableValue observableValue, Paint paint, Paint paint2) {
        jFXSliderSkinOLD.lambda$initializeVariables$412(observableValue, paint, paint2);
    }

    static /* synthetic */ void access$lambda$1(JFXSliderSkinOLD jFXSliderSkinOLD, ObservableValue observableValue, Paint paint, Paint paint2) {
        jFXSliderSkinOLD.lambda$initializeVariables$413(observableValue, paint, paint2);
    }

    static /* synthetic */ Background access$lambda$2(JFXSliderSkinOLD jFXSliderSkinOLD) {
        return jFXSliderSkinOLD.lambda$initializeVariables$414();
    }

    static /* synthetic */ void access$lambda$3(JFXSliderSkinOLD jFXSliderSkinOLD, MouseEvent mouseEvent) {
        jFXSliderSkinOLD.lambda$initializeMouseEvents$415(mouseEvent);
    }

    static /* synthetic */ void access$lambda$4(JFXSliderSkinOLD jFXSliderSkinOLD, MouseEvent mouseEvent) {
        jFXSliderSkinOLD.lambda$initializeMouseEvents$416(mouseEvent);
    }

    static /* synthetic */ void access$lambda$5(JFXSliderSkinOLD jFXSliderSkinOLD, MouseEvent mouseEvent) {
        jFXSliderSkinOLD.lambda$initializeMouseEvents$417(mouseEvent);
    }

    static /* synthetic */ void access$lambda$6(JFXSliderSkinOLD jFXSliderSkinOLD, MouseEvent mouseEvent) {
        jFXSliderSkinOLD.lambda$initializeMouseEvents$418(mouseEvent);
    }

    static /* synthetic */ void access$lambda$7(JFXSliderSkinOLD jFXSliderSkinOLD, MouseEvent mouseEvent) {
        jFXSliderSkinOLD.lambda$initializeMouseEvents$419(mouseEvent);
    }

    static /* synthetic */ void access$lambda$8(JFXSliderSkinOLD jFXSliderSkinOLD, MouseEvent mouseEvent) {
        jFXSliderSkinOLD.lambda$initializeMouseEvents$420(mouseEvent);
    }

    static /* synthetic */ void access$lambda$9(JFXSliderSkinOLD jFXSliderSkinOLD, ObservableValue observableValue, Number number, Number number2) {
        jFXSliderSkinOLD.lambda$initializeMouseEvents$421(observableValue, number, number2);
    }

    static /* synthetic */ void access$lambda$10(JFXSliderSkinOLD jFXSliderSkinOLD, ObservableValue observableValue, Number number, Number number2) {
        jFXSliderSkinOLD.lambda$initializeMouseEvents$422(observableValue, number, number2);
    }
}

