/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.io.data;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class DataSet {
    private Map<String, Map<Integer, Object>> column = new TreeMap<String, Map<Integer, Object>>();
    private Map<Integer, Map<String, Map<Integer, Object>>> dataset = new TreeMap<Integer, Map<String, Map<Integer, Object>>>();

    public DataSet(String[] columnName) {
        int nColCnt = columnName.length;
        for (int i = 0; i < nColCnt; ++i) {
            this.column.put(columnName[i], new HashMap());
            this.column.get(columnName[i]).put(i, new Object());
        }
    }

    public int getColumn(String sName) {
        return this.column.get(sName).keySet().iterator().next();
    }

    public String getColumnName(int nCol) {
        String colName = "";
        Iterator<String> colNameItr = this.column.keySet().iterator();
        while ((colName = colNameItr.next()) != null && this.column.get(colName).keySet().iterator().next() != nCol) {
        }
        return colName;
    }

    public int getColumnCount() {
        return this.column.size();
    }

    public int getRowCount() {
        return this.dataset.size();
    }

    public Object getData(int nRow, int nCol) {
        return this.dataset.get(nRow).get(this.getColumnName(nCol)).values().iterator().next();
    }

    public void setData(int nRow, int nCol, Object oValue) {
        this.dataset.get(nRow).get(this.getColumnName(nCol)).put(nCol, oValue);
    }

    public Object getDataByName(String sName, int nRow) {
        return this.dataset.get(nRow).get(sName).values().iterator().next();
    }

    public void setDataByName(String sName, int nRow, Object oValue) {
        this.dataset.get(nRow).get(sName).put(this.getColumn(sName), oValue);
    }

    public void init() {
        int nLength = this.getRowCount();
        for (int i = 0; i < nLength; ++i) {
            this.removeRow(i);
        }
    }

    public void insertRow(int nRow) {
        int i;
        int nRowCnt = this.getRowCount();
        int nColCnt = this.getColumnCount();
        TreeMap column = new TreeMap();
        for (i = 0; i < nColCnt; ++i) {
            column.put(this.getColumnName(i), new HashMap());
            ((Map)column.get(this.getColumnName(i))).put(this.column.get(this.getColumnName(i)).keySet().iterator().next(), new Object());
        }
        for (i = 0; i < nRow; ++i) {
            if (this.dataset.get(i) != null) continue;
            this.dataset.put(i, column);
        }
        if (this.dataset.get(nRow) != null) {
            for (i = nRowCnt - 1; i >= nRow; --i) {
                this.dataset.put(i + 1, this.dataset.get(i));
            }
        }
        this.dataset.put(nRow, column);
    }

    public void removeRow(int nRowIdx) {
        int nRowCnt = this.getRowCount();
        for (int i = nRowIdx + 1; i < nRowCnt; ++i) {
            this.dataset.put(i - 1, this.dataset.get(i));
        }
        this.dataset.remove(nRowCnt - 1);
    }
}

