/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXPopup$$Lambda$1;
import com.jfoenix.controls.JFXPopup$$Lambda$2;
import com.jfoenix.controls.JFXPopup$$Lambda$3;
import com.jfoenix.controls.JFXPopup$$Lambda$4;
import com.jfoenix.controls.JFXPopup$$Lambda$5;
import com.jfoenix.controls.JFXPopup$$Lambda$6;
import com.jfoenix.controls.JFXTabPane;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.transitions.CachedTransition;
import java.util.concurrent.Callable;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.DefaultProperty;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

@DefaultProperty(value="content")
public class JFXPopup
extends AnchorPane {
    private AnchorPane contentHolder;
    private Scale scaleTransform = new Scale(0.0, 0.0, 0.0, 0.0);
    private double offsetX = -1.0;
    private double offsetY = -1.0;
    private Pane popupContainer;
    private Region content;
    private Transition animation;
    private Node source;
    private static final String DEFAULT_STYLE_CLASS = "jfx-popup";

    public JFXPopup() {
        this(null, null);
    }

    public JFXPopup(Pane popupContainer, Region content) {
        this.initialize();
        this.setContent(content);
        this.setPopupContainer(popupContainer);
    }

    public Pane getPopupContainer() {
        return this.popupContainer;
    }

    public void setPopupContainer(Pane popupContainer) {
        if (popupContainer != null) {
            this.popupContainer = popupContainer;
            this.setOnMouseClicked(JFXPopup$$Lambda$1.lambdaFactory$(this));
            this.animation = new PopupTransition();
        }
    }

    public Region getContent() {
        return this.content;
    }

    public void setContent(Region content) {
        if (content != null) {
            this.content = content;
            this.contentHolder = new AnchorPane();
            this.contentHolder.getChildren().add((Object)this.content);
            this.contentHolder.prefWidthProperty().bind((ObservableValue)this.content.prefWidthProperty());
            this.contentHolder.prefHeightProperty().bind((ObservableValue)this.content.prefHeightProperty());
            this.contentHolder.getStyleClass().add((Object)"jfx-popup-container");
            this.contentHolder.getTransforms().add((Object)this.scaleTransform);
            JFXDepthManager.setDepth((Node)this.contentHolder, 4);
            this.contentHolder.setPickOnBounds(false);
            this.getChildren().add((Object)this.contentHolder);
            this.getStyleClass().add((Object)"jfx-popup-overlay-pane");
            this.setVisible(false);
            this.contentHolder.addEventHandler(MouseEvent.ANY, JFXPopup$$Lambda$2.lambdaFactory$());
        }
    }

    public Node getSource() {
        return this.source;
    }

    public void setSource(Node source) {
        this.source = source;
    }

    public void show(PopupVPosition vAlign, PopupHPosition hAlign, Pane popupContainer) {
        this.setPopupContainer(popupContainer);
        this.show(vAlign, hAlign);
    }

    public void show(PopupVPosition vAlign, PopupHPosition hAlign) {
        this.show(vAlign, hAlign, 0.0, 0.0);
    }

    public void show(PopupVPosition vAlign, PopupHPosition hAlign, double initOffsetX, double initOffsetY) {
        this.offsetX = 0.0;
        this.offsetY = 0.0;
        Node tempSource = this.source;
        Bounds bound = tempSource.localToParent(tempSource.getBoundsInLocal());
        this.offsetX = bound.getMinX() + initOffsetX;
        this.offsetY = bound.getMinY() + initOffsetY;
        if (this.popupContainer == null) {
            this.setPopupContainer((Pane)this.source.getScene().getRoot());
        }
        if (!this.popupContainer.getChildren().contains((Object)this)) {
            this.popupContainer.getChildren().add((Object)this);
        }
        while (!tempSource.getParent().equals(this.popupContainer)) {
            tempSource = tempSource.getParent();
            bound = tempSource.localToParent(tempSource.getBoundsInLocal());
            if (tempSource.getClass().getName().contains("ScrollPaneSkin")) {
                this.offsetX += bound.getMinX();
                this.offsetY += bound.getMinY();
            }
            if (tempSource instanceof JFXTabPane) {
                this.offsetX -= bound.getWidth() * (double)((JFXTabPane)tempSource).getSelectionModel().getSelectedIndex();
                continue;
            }
            if (bound.getMinX() > 0.0) {
                this.offsetX += bound.getMinX();
            }
            if (!(bound.getMinY() > 0.0)) continue;
            this.offsetY += bound.getMinY();
        }
        if (hAlign.equals((Object)PopupHPosition.RIGHT)) {
            this.scaleTransform.pivotXProperty().bind((ObservableValue)this.content.widthProperty());
            this.contentHolder.translateXProperty().bind((ObservableValue)Bindings.createDoubleBinding((Callable)JFXPopup$$Lambda$3.lambdaFactory$(this), (Observable[])new Observable[]{this.content.widthProperty(), this.source.boundsInLocalProperty()}));
        } else {
            this.scaleTransform.pivotXProperty().unbind();
            this.contentHolder.translateXProperty().unbind();
            this.scaleTransform.setPivotX(0.0);
            this.contentHolder.setTranslateX(this.offsetX);
        }
        if (vAlign.equals((Object)PopupVPosition.BOTTOM)) {
            this.scaleTransform.pivotYProperty().bind((ObservableValue)this.content.heightProperty());
            this.contentHolder.translateYProperty().bind((ObservableValue)Bindings.createDoubleBinding((Callable)JFXPopup$$Lambda$4.lambdaFactory$(this), (Observable[])new Observable[]{this.content.heightProperty(), this.source.boundsInLocalProperty()}));
        } else {
            this.scaleTransform.pivotYProperty().unbind();
            this.contentHolder.translateYProperty().unbind();
            this.scaleTransform.setPivotY(0.0);
            this.contentHolder.setTranslateY(this.offsetY);
        }
        this.animation.setRate(1.0);
        this.animation.setOnFinished(JFXPopup$$Lambda$5.lambdaFactory$());
        this.animation.play();
    }

    public void close() {
        this.animation.setRate(-1.0);
        this.animation.play();
        this.animation.setOnFinished(JFXPopup$$Lambda$6.lambdaFactory$(this));
    }

    private void resetProperties() {
        this.popupContainer.getChildren().remove((Object)this);
        this.setVisible(false);
        this.scaleTransform.setX(0.0);
        this.scaleTransform.setY(0.0);
    }

    private void initialize() {
        this.setVisible(false);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    private /* synthetic */ void lambda$close$196(ActionEvent e) {
        this.resetProperties();
    }

    private static /* synthetic */ void lambda$show$195(ActionEvent e) {
    }

    private /* synthetic */ Double lambda$show$194() throws Exception {
        return -this.content.getHeight() + this.source.getBoundsInLocal().getHeight() + this.offsetY;
    }

    private /* synthetic */ Double lambda$show$193() throws Exception {
        return -this.content.getWidth() + this.source.getBoundsInLocal().getWidth() + this.offsetX;
    }

    private /* synthetic */ void lambda$setPopupContainer$191(MouseEvent e) {
        if (e.isStillSincePress()) {
            this.close();
        }
    }

    static /* synthetic */ void access$lambda$0(JFXPopup jFXPopup, MouseEvent mouseEvent) {
        jFXPopup.lambda$setPopupContainer$191(mouseEvent);
    }

    static /* synthetic */ void access$lambda$1(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    static /* synthetic */ Double access$lambda$2(JFXPopup jFXPopup) {
        return jFXPopup.lambda$show$193();
    }

    static /* synthetic */ Double access$lambda$3(JFXPopup jFXPopup) {
        return jFXPopup.lambda$show$194();
    }

    static /* synthetic */ void access$lambda$4(ActionEvent actionEvent) {
        JFXPopup.lambda$show$195(actionEvent);
    }

    static /* synthetic */ void access$lambda$5(JFXPopup jFXPopup, ActionEvent actionEvent) {
        jFXPopup.lambda$close$196(actionEvent);
    }

    private class PopupTransition
    extends CachedTransition {
        public PopupTransition() {
            super((Node)JFXPopup.this, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)JFXPopup.this.visibleProperty(), (Object)false, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXPopup.this.content.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)10.0), new KeyValue[]{new KeyValue((WritableValue)JFXPopup.this.visibleProperty(), (Object)true, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXPopup.this.opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXPopup.this.scaleTransform.xProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXPopup.this.scaleTransform.yProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)700.0), new KeyValue[]{new KeyValue((WritableValue)JFXPopup.this.content.opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXPopup.this.scaleTransform.xProperty(), (Object)1, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)JFXPopup.this.content.opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXPopup.this.opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXPopup.this.scaleTransform.yProperty(), (Object)1, Interpolator.EASE_BOTH)})}));
            this.setCycleDuration(Duration.seconds((double)0.4));
            this.setDelay(Duration.seconds((double)0.0));
        }
    }

    public static enum PopupVPosition {
        TOP,
        BOTTOM;

    }

    public static enum PopupHPosition {
        RIGHT,
        LEFT;

    }
}

