/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jdk.internal.util.EnvUtils;
import sun.usagetracker.UsageTrackerClient;

public class PostVMInitHook {
    private static final String ORCL_UT_CONFIG_FILE_NAME = "usagetracker.properties";

    public static void run() {
        PostVMInitHook.trackJavaUsage();
    }

    private static void trackJavaUsage() {
        if (PostVMInitHook.getConfigFilePrivileged() != null || System.getProperty("os.name").toLowerCase().startsWith("win")) {
            UsageTrackerClient usageTrackerClient = new UsageTrackerClient();
            usageTrackerClient.run("VM start", System.getProperty("sun.java.command"));
        }
    }

    private static File getConfigFilePrivileged() {
        File file = null;
        String[] stringArray = new String[]{System.getProperty("com.oracle.usagetracker.config.file"), PostVMInitHook.getOSSpecificConfigFilePath(), System.getProperty("java.home") + File.separator + "conf" + File.separator + "management" + File.separator + ORCL_UT_CONFIG_FILE_NAME};
        for (final String string : stringArray) {
            if (string != null && (file = AccessController.doPrivileged(new PrivilegedAction<File>(){

                @Override
                public File run() {
                    File file = new File(string);
                    return file.exists() ? file : null;
                }
            })) != null) break;
        }
        return file;
    }

    private static String getOSSpecificConfigFilePath() {
        String string = System.getProperty("os.name");
        if (string != null) {
            if ((string = string.toLowerCase()).startsWith("sunos")) {
                return "/etc/oracle/java/usagetracker.properties";
            }
            if (string.startsWith("mac")) {
                return "/Library/Application Support/Oracle/Java/usagetracker.properties";
            }
            if (string.startsWith("win")) {
                String string2 = PostVMInitHook.getEnvPrivileged("ProgramData");
                return string2 == null ? null : string2 + "\\Oracle\\Java\\" + ORCL_UT_CONFIG_FILE_NAME;
            }
            if (string.startsWith("linux")) {
                return "/etc/oracle/java/usagetracker.properties";
            }
        }
        return null;
    }

    private static String getEnvPrivileged(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return EnvUtils.getEnvVar(string);
            }
        });
    }
}

