/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.ui.component.popup;

import javafx.collections.ObservableMap;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import org.silentsoft.ui.component.popup.Popup;

public class PopupController {
    @FXML
    private AnchorPane main;
    @FXML
    private AnchorPane head;
    @FXML
    private AnchorPane body;
    @FXML
    private Label title;
    @FXML
    private Button closeButton;
    private Parent popup;
    private Node backgroundNode;
    private static final String TOP_ANCHOR = "pane-top-anchor";
    private static final String LEFT_ANCHOR = "pane-left-anchor";
    private static final String BOTTOM_ANCHOR = "pane-bottom-anchor";
    private static final String RIGHT_ANCHOR = "pane-right-anchor";

    protected void initialize(Node backgroundNode, String title, Parent popup, Popup.CloseType closeType) {
        this.backgroundNode = backgroundNode;
        this.title.setText(title);
        this.popup = popup;
        switch (closeType) {
            case FOCUS_BASE: 
            case PLATFORM_FRAME_BASE: {
                this.closeButton.setVisible(false);
                break;
            }
            case BUTTON_BASE: {
                this.closeButton.setVisible(true);
                break;
            }
            case BUILT_IN_BASE: {
                this.head.setVisible(false);
                this.body.setLayoutY(0.0);
                AnchorPane.setTopAnchor((Node)this.body, (Double)0.0);
            }
        }
        ObservableMap prop = popup.getProperties();
        prop.put((Object)TOP_ANCHOR, (Object)0.0);
        prop.put((Object)LEFT_ANCHOR, (Object)0.0);
        prop.put((Object)BOTTOM_ANCHOR, (Object)0.0);
        prop.put((Object)RIGHT_ANCHOR, (Object)0.0);
        this.body.getChildren().clear();
        this.body.getChildren().add((Object)popup);
    }

    @FXML
    private void close_OnActionClick() {
        Popup.close(this.popup, this.backgroundNode);
    }
}

