/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.application;

import com.jfoenix.controls.JFXButton;
import de.codecentric.centerdevice.glass.AdapterContext;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.SVGPath;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.control.PopOver;
import org.silentsoft.actlist.application.App;
import org.silentsoft.actlist.plugin.PluginComponent;
import org.silentsoft.actlist.plugin.PluginManager;
import org.silentsoft.actlist.plugin.messagebox.MessageBox;
import org.silentsoft.actlist.rest.RESTfulAPI;
import org.silentsoft.actlist.util.ConfigUtil;
import org.silentsoft.actlist.view.about.About;
import org.silentsoft.actlist.view.configuration.Configuration;
import org.silentsoft.actlist.view.explore.Explore;
import org.silentsoft.core.util.DateUtil;
import org.silentsoft.core.util.FileUtil;
import org.silentsoft.core.util.SystemUtil;
import org.silentsoft.io.event.EventHandler;
import org.silentsoft.io.event.EventListener;
import org.silentsoft.io.memory.SharedMemory;
import org.silentsoft.ui.model.Delta;
import org.silentsoft.ui.model.MaximizeProperty;
import org.silentsoft.ui.util.StageDragResizer;

public class AppController
implements EventListener {
    @FXML
    private AnchorPane root;
    @FXML
    private BorderPane head;
    @FXML
    private Label headMinimizeButton;
    @FXML
    private Label headMaximizeButton;
    @FXML
    private Label headCloseButton;
    @FXML
    private BorderPane body;
    @FXML
    private VBox sideArea;
    @FXML
    private HBox sideControls;
    @FXML
    private Label sideMinimizeButton;
    @FXML
    private Label sideMaximizeButton;
    @FXML
    private Label sideCloseButton;
    @FXML
    private VBox sideNav;
    @FXML
    private Region navPlugins;
    @FXML
    private Region navExplore;
    @FXML
    private Region navConsole;
    @FXML
    private Region navAbout;
    @FXML
    private Region navConfiguration;
    @FXML
    private Label appUpdateAlarmLabel;
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private BorderPane contentPane;
    @FXML
    private VBox componentBox;
    private TextArea consoleTextArea;
    private PopOver updatePopOver;
    private MaximizeProperty maximizeProperty;
    private HashMap<String, URLClassLoader> pluginMap;

    protected void initialize() {
        EventHandler.addListener((EventListener)this);
        this.initConsole();
        this.root.setPrefWidth(ConfigUtil.getRootWidth());
        this.root.setPrefHeight(ConfigUtil.getRootHeight());
        this.maximizeProperty = new MaximizeProperty(App.getStage());
        this.pluginMap = new HashMap();
        this.makeDraggable(App.getStage(), (Node)this.head);
        this.makeNormalizable(App.getStage(), (Node)this.head);
        this.makeMinimizable(App.getStage(), (Node)this.headMinimizeButton);
        this.makeMaximizable(App.getStage(), (Node)this.headMaximizeButton);
        this.makeClosable(App.getStage(), (Node)this.headCloseButton);
        this.makeDraggable(App.getStage(), (Node)this.sideNav);
        this.makeNormalizable(App.getStage(), (Node)this.sideNav);
        this.makeMinimizable(App.getStage(), (Node)this.sideMinimizeButton);
        this.makeMaximizable(App.getStage(), (Node)this.sideMaximizeButton);
        this.makeClosable(App.getStage(), (Node)this.sideCloseButton);
        this.applyTheme();
        this.makeResizable(App.getStage(), (Region)this.root);
        this.initUpdatePopOver();
        this.checkUpdate();
        SharedMemory.getDataMap().put((Object)"KEY_PLUGIN_MAP", this.pluginMap);
        SharedMemory.getDataMap().put((Object)"KEY_COMPONENT_BOX", (Object)this.componentBox);
        this.loadPlugins();
        this.enableContextMenu();
        this.enableDragAndDrop();
    }

    public void notifyFocusState(boolean bl) {
        if (ConfigUtil.isMacTheme()) {
            if (bl) {
                this.sideCloseButton.setStyle("-fx-background-color: red; -fx-background-radius: 5em;");
                this.sideMinimizeButton.setStyle("-fx-background-color: orange; -fx-background-radius: 5em;");
                this.sideMaximizeButton.setStyle("-fx-background-color: #59bf53; -fx-background-radius: 5em;");
            } else {
                this.sideCloseButton.setStyle("-fx-background-color: #808080; -fx-background-radius: 5em;");
                this.sideMinimizeButton.setStyle("-fx-background-color: #808080; -fx-background-radius: 5em;");
                this.sideMaximizeButton.setStyle("-fx-background-color: #808080; -fx-background-radius: 5em;");
            }
        }
    }

    private void initConsole() {
        this.consoleTextArea = new TextArea();
        this.consoleTextArea.setContextMenu(new ContextMenu());
        this.consoleTextArea.setEditable(false);
        this.consoleTextArea.setFont(Font.font((String)"Consolas", (double)13.0));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-fx-control-inner-background: rgb(30, 30, 30); ");
        stringBuffer.append("-fx-background-color: -fx-control-inner-background; ");
        stringBuffer.append("-fx-background-radius: 0; ");
        stringBuffer.append("-fx-faint-focus-color: transparent;");
        this.consoleTextArea.setStyle(stringBuffer.toString());
        SharedMemory.getDataMap().put((Object)"KEY_CONSOLE_TEXT_AREA", (Object)this.consoleTextArea);
    }

    private void makeDraggable(Stage stage, Node node) {
        Delta delta = new Delta();
        node.setOnMousePressed(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                delta.setX(stage.getX() - mouseEvent.getScreenX());
                delta.setY(stage.getY() - mouseEvent.getScreenY());
                node.setOpacity(0.98);
            }
        });
        node.setOnMouseDragged(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                if (this.maximizeProperty.isMaximized()) {
                    double d = mouseEvent.getScreenX() - stage.getX();
                    double d2 = mouseEvent.getScreenY() - stage.getY();
                    this.changeMaximizeProperty(stage);
                    delta.setX(-1.0 * (stage.getWidth() / 2.0));
                    delta.setY(-1.0 * mouseEvent.getSceneY());
                } else {
                    stage.setX(mouseEvent.getScreenX() + delta.getX());
                    stage.setY(mouseEvent.getScreenY() + delta.getY());
                }
            }
        });
        node.setOnMouseReleased(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                node.setOpacity(1.0);
            }
        });
    }

    private void makeNormalizable(Stage stage, Node node) {
        node.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getClickCount() >= 2) {
                this.changeMaximizeProperty(stage);
            }
        });
    }

    private void makeMinimizable(Stage stage, Node node) {
        node.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                stage.setIconified(true);
            }
        });
    }

    private void makeMaximizable(Stage stage, Node node) {
        node.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                this.changeMaximizeProperty(stage);
            }
        });
    }

    private void makeClosable(Stage stage, Node node) {
        node.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                if (SystemUtil.isMac()) {
                    AdapterContext.getContext().getApplicationAdapter().hide();
                } else {
                    stage.hide();
                }
            }
        });
    }

    private void makeResizable(Stage stage, Region region) {
        StageDragResizer.makeResizable((Stage)stage, (Region)region, (int)7, (int)10, () -> {
            try {
                ConfigUtil.setRootWidth(region.getWidth());
                ConfigUtil.setRootHeight(region.getHeight());
                ConfigUtil.setStageWidth(App.getStage().getWidth());
                ConfigUtil.setStageHeight(App.getStage().getHeight());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void changeMaximizeProperty(Stage stage) {
        this.maximizeProperty.setMaximized(stage, !this.maximizeProperty.isMaximized());
        if (this.maximizeProperty.isMaximized()) {
            AnchorPane.setLeftAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setTopAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)this.root, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)this.body, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.body, (Double)0.0);
            AnchorPane.setTopAnchor((Node)this.body, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)this.body, (Double)0.0);
        } else {
            AnchorPane.setLeftAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setRightAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setTopAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setBottomAnchor((Node)this.root, (Double)5.0);
            AnchorPane.setLeftAnchor((Node)this.body, (Double)2.0);
            AnchorPane.setRightAnchor((Node)this.body, (Double)2.0);
            AnchorPane.setTopAnchor((Node)this.body, (Double)2.0);
            AnchorPane.setBottomAnchor((Node)this.body, (Double)2.0);
        }
    }

    private void applyTheme() {
        String string;
        switch (string = ConfigUtil.getTheme()) {
            case "WIN": {
                if (this.body.getTop() == null) {
                    this.body.setTop((Node)this.head);
                }
                if (this.sideArea.getChildren().indexOf((Object)this.sideControls) == -1) break;
                this.sideArea.getChildren().remove((Object)this.sideControls);
                break;
            }
            case "MAC": {
                if (this.body.getTop() != null) {
                    this.body.setTop(null);
                }
                if (this.sideArea.getChildren().indexOf((Object)this.sideControls) != -1) break;
                this.sideArea.getChildren().add(0, (Object)this.sideControls);
            }
        }
    }

    @FXML
    private void showPluginsView() {
        this.adjustHead(this.navPlugins);
        this.toggleNav(this.navPlugins);
        this.contentPane.setCenter((Node)this.componentBox);
    }

    @FXML
    private void showExploreView() {
        this.adjustHead(this.navExplore);
        this.toggleNav(this.navExplore);
        this.contentPane.setCenter((Node)new Explore().getViewer());
    }

    @FXML
    private void showConsoleView() {
        this.adjustHead(this.navConsole);
        this.toggleNav(this.navConsole);
        this.contentPane.setCenter((Node)this.consoleTextArea);
    }

    @FXML
    private void showAboutView() {
        this.adjustHead(this.navAbout);
        this.toggleNav(this.navAbout);
        this.contentPane.setCenter((Node)new About().getViewer());
    }

    @FXML
    private void showConfigurationView() {
        this.adjustHead(this.navConfiguration);
        this.toggleNav(this.navConfiguration);
        this.contentPane.setCenter((Node)new Configuration().getViewer());
    }

    @FXML
    private void eventNavMouseEntered(MouseEvent mouseEvent) {
        Region region;
        if (mouseEvent.getSource() instanceof Region && (region = (Region)mouseEvent.getSource()).getOpacity() != 1.0) {
            region.setOpacity(0.9);
        }
    }

    @FXML
    private void eventNavMouseExited(MouseEvent mouseEvent) {
        Region region;
        if (mouseEvent.getSource() instanceof Region && (region = (Region)mouseEvent.getSource()).getOpacity() != 1.0) {
            region.setOpacity(0.75);
        }
    }

    private void adjustHead(Region region) {
        if (region == this.navConsole) {
            this.head.setStyle("-fx-background-color: rgb(30, 30, 30);");
            this.headMinimizeButton.setStyle("-fx-background-color: #ffffff; -fx-background-radius: 5em;");
            this.headMaximizeButton.setStyle("-fx-background-color: #ffffff; -fx-background-radius: 5em;");
            this.headCloseButton.setStyle("-fx-background-color: #ffffff; -fx-background-radius: 5em;");
            ((SVGPath)this.headMinimizeButton.getGraphic()).setFill(Paint.valueOf((String)"#1e1e1e"));
            ((SVGPath)this.headMaximizeButton.getGraphic()).setFill(Paint.valueOf((String)"#1e1e1e"));
            ((SVGPath)this.headCloseButton.getGraphic()).setFill(Paint.valueOf((String)"#1e1e1e"));
        } else {
            this.head.setStyle("-fx-background-color: #cfcfcf, #ffffff; -fx-background-insets: 0 0 0 0, 0 0 1 0;");
            this.headMinimizeButton.setStyle("-fx-background-color: #3e3e3e; -fx-background-radius: 5em;");
            this.headMaximizeButton.setStyle("-fx-background-color: #3e3e3e; -fx-background-radius: 5em;");
            this.headCloseButton.setStyle("-fx-background-color: #3e3e3e; -fx-background-radius: 5em;");
            ((SVGPath)this.headMinimizeButton.getGraphic()).setFill(Paint.valueOf((String)"#ffffff"));
            ((SVGPath)this.headMaximizeButton.getGraphic()).setFill(Paint.valueOf((String)"#ffffff"));
            ((SVGPath)this.headCloseButton.getGraphic()).setFill(Paint.valueOf((String)"#ffffff"));
        }
    }

    private void toggleNav(Region region) {
        Arrays.asList(this.navPlugins, this.navExplore, this.navConsole, this.navAbout, this.navConfiguration).forEach(region2 -> {
            if (region2 == region) {
                region2.setOpacity(1.0);
            } else {
                region2.setOpacity(0.75);
            }
        });
    }

    private void initUpdatePopOver() {
        this.updatePopOver = new PopOver();
        Label label = new Label("Actlist Update Alarm");
        label.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)12.0));
        label.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        Label label2 = new Label("New Actlist is available. Would you like to browse now ?");
        label2.setWrapText(true);
        label2.setFont(Font.font((String)"Verdana", (double)12.0));
        label2.setTextAlignment(TextAlignment.CENTER);
        label2.setPrefWidth(194.0);
        label2.setPrefHeight(40.0);
        JFXButton jFXButton = new JFXButton("Not Now");
        jFXButton.setCursor(Cursor.HAND);
        jFXButton.setPrefWidth(97.0);
        jFXButton.setButtonType(JFXButton.ButtonType.RAISED);
        jFXButton.setRipplerFill(Paint.valueOf((String)"#eeeeee"));
        jFXButton.setFont(Font.font((String)"Verdana", (double)12.0));
        jFXButton.setTextFill(Paint.valueOf((String)"#0b7aea"));
        jFXButton.setOnMouseClicked(mouseEvent -> this.hideUpdatePopOver());
        JFXButton jFXButton2 = new JFXButton("Browse");
        jFXButton2.setCursor(Cursor.HAND);
        jFXButton2.setPrefWidth(97.0);
        jFXButton2.setButtonType(JFXButton.ButtonType.RAISED);
        jFXButton2.setRipplerFill(Paint.valueOf((String)"#eeeeee"));
        jFXButton2.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)12.0));
        jFXButton2.setTextFill(Paint.valueOf((String)"#1c81f9"));
        jFXButton2.setOnMouseClicked(mouseEvent -> {
            try {
                Desktop.getDesktop().browse(new URI("http://actlist.silentsoft.org/archives/"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hideUpdatePopOver();
        });
        HBox hBox = new HBox(new Node[]{jFXButton, jFXButton2});
        hBox.setAlignment(Pos.CENTER);
        hBox.setStyle("-fx-border-color: lightgray; -fx-border-width: 1 0 0 0;");
        VBox vBox = new VBox(new Node[]{label, label2, hBox});
        vBox.setAlignment(Pos.CENTER);
        vBox.setStyle("-fx-background-color: white;");
        vBox.setSpacing(5.0);
        vBox.setPrefWidth(214.0);
        vBox.setPrefHeight(103.0);
        this.updatePopOver.setContentNode((Node)vBox);
        this.updatePopOver.setArrowLocation(PopOver.ArrowLocation.BOTTOM_LEFT);
    }

    private void checkUpdate() {
        new Thread(() -> {
            Runnable runnable = () -> {
                try {
                    boolean bl = false;
                    ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
                    arrayList.add(new BasicNameValuePair("version", "1.4.1"));
                    arrayList.add(new BasicNameValuePair("os", SystemUtil.getOSName()));
                    arrayList.add(new BasicNameValuePair("architecture", SystemUtil.getPlatformArchitecture()));
                    Map map = RESTfulAPI.doGet("http://actlist.silentsoft.org/api/update/check", arrayList, Map.class);
                    if (map == null) {
                        return;
                    }
                    if (map.containsKey("available")) {
                        bl = Boolean.parseBoolean(String.valueOf(map.get("available")));
                    }
                    SharedMemory.getDataMap().put((Object)"KEY_IS_AVAILABLE_NEW_ACTLIST", (Object)bl);
                    if (bl) {
                        Platform.runLater(() -> {
                            this.appUpdateAlarmLabel.setVisible(true);
                            FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)400.0), (Node)this.appUpdateAlarmLabel);
                            fadeTransition.setFromValue(1.0);
                            fadeTransition.setToValue(0.3);
                            fadeTransition.setCycleCount(6);
                            fadeTransition.setAutoReverse(true);
                            fadeTransition.play();
                        });
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            };
            boolean bl = true;
            Date date = null;
            while (true) {
                if (bl) {
                    runnable.run();
                    date = Calendar.getInstance().getTime();
                }
                try {
                    Thread.sleep((long)Duration.minutes((double)10.0).toMillis());
                }
                catch (InterruptedException interruptedException) {
                    bl = DateUtil.getDifferenceHoursFromNow((Date)date) >= 24;
                    continue;
                    catch (Throwable throwable) {
                        bl = DateUtil.getDifferenceHoursFromNow((Date)date) >= 24;
                        throw throwable;
                    }
                }
                bl = DateUtil.getDifferenceHoursFromNow((Date)date) >= 24;
                continue;
                break;
            }
        }).start();
    }

    @FXML
    private void showControls() {
        ((SVGPath)this.sideCloseButton.getGraphic()).setFill(Paint.valueOf((String)"rgb(35, 35, 35)"));
        ((SVGPath)this.sideMinimizeButton.getGraphic()).setFill(Paint.valueOf((String)"rgb(35, 35, 35)"));
        ((SVGPath)this.sideMaximizeButton.getGraphic()).setFill(Paint.valueOf((String)"rgb(35, 35, 35)"));
    }

    @FXML
    private void hideControls() {
        ((SVGPath)this.sideCloseButton.getGraphic()).setFill(Paint.valueOf((String)"transparent"));
        ((SVGPath)this.sideMinimizeButton.getGraphic()).setFill(Paint.valueOf((String)"transparent"));
        ((SVGPath)this.sideMaximizeButton.getGraphic()).setFill(Paint.valueOf((String)"transparent"));
    }

    @FXML
    private void showUpdatePopOver() {
        if (!this.updatePopOver.isShowing()) {
            this.updatePopOver.show((Node)this.appUpdateAlarmLabel);
        }
    }

    private void hideUpdatePopOver() {
        this.updatePopOver.hide();
        this.appUpdateAlarmLabel.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPlugins() {
        String string2;
        HBox hBox;
        Label label;
        Hyperlink hyperlink;
        File file;
        this.componentBox.getChildren().clear();
        try {
            file = Paths.get(System.getProperty("user.dir"), "plugins").toFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            hyperlink = this.readDeactivatedPlugins();
            SharedMemory.getDataMap().put((Object)"KEY_DEACTIVATED_PLUGINS", hyperlink);
            label = this.readPriorityOfPlugins();
            SharedMemory.getDataMap().put((Object)"KEY_PRIORITY_OF_PLUGINS", label);
            hBox = new ArrayList();
            Files.walk(Paths.get(System.getProperty("user.dir"), "plugins"), 1, new FileVisitOption[0]).forEach(path -> {
                if (this.isAssignableFromJarFile((Path)path)) {
                    hBox.add(path.getFileName().toString());
                }
            });
            for (int i = label.size() - 1; i >= 0; --i) {
                string2 = label.get(i);
                if (hBox.contains(string2)) {
                    hBox.remove(string2);
                    hBox.add(0, string2);
                    continue;
                }
                label.remove(i);
            }
            label.clear();
            label.addAll(hBox);
            this.savePriorityOfPlugins();
            SharedMemory.getDataMap().put((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS", (Object)hBox.size());
            EventHandler.callEvent(this.getClass(), (String)"EVENT_NOTIFY_PRELOADER_PREPARING_PLUGINS");
            for (String string2 : hBox) {
                try {
                    Path path2 = Paths.get(System.getProperty("user.dir"), "plugins", string2);
                    if (!this.isAssignableFromJarFile(path2)) continue;
                    this.loadPlugin(path2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    EventHandler.callEvent(this.getClass(), (String)"EVENT_NOTIFY_PRELOADER_COUNT_DOWN_PLUGIN");
                }
            }
        }
        catch (Exception exception) {
            if (SharedMemory.getDataMap().get((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS") == null) {
                SharedMemory.getDataMap().put((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS", (Object)0);
                EventHandler.callEvent(this.getClass(), (String)"EVENT_NOTIFY_PRELOADER_PREPARING_PLUGINS");
            }
            if (this.componentBox.getChildren().isEmpty()) {
                Label label2 = new Label();
                label2.setText("No plugins available.");
                Hyperlink hyperlink2 = new Hyperlink();
                hyperlink2.setText("Explore");
                hyperlink2.setOnMouseReleased(mouseEvent -> {
                    hyperlink2.setVisited(false);
                    this.showExploreView();
                });
                Label label3 = new Label();
                label3.setText("or drag and drop.");
                HBox hBox2 = new HBox(new Node[]{hyperlink2, label3});
                hBox2.setAlignment(Pos.CENTER);
                VBox vBox = new VBox(new Node[]{label2, hBox2});
                vBox.setAlignment(Pos.CENTER);
                vBox.setSpacing(15.0);
                AnchorPane.setTopAnchor((Node)vBox, (Double)0.0);
                AnchorPane.setRightAnchor((Node)vBox, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)vBox, (Double)0.0);
                AnchorPane.setLeftAnchor((Node)vBox, (Double)0.0);
                AnchorPane anchorPane = new AnchorPane(new Node[]{vBox});
                anchorPane.setStyle("-fx-background-color: #ffffff;");
                anchorPane.setPrefWidth(310.0);
                anchorPane.setPrefHeight(310.0);
                this.componentBox.getChildren().add((Object)anchorPane);
            }
        }
        catch (Throwable throwable) {
            if (SharedMemory.getDataMap().get((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS") == null) {
                SharedMemory.getDataMap().put((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS", (Object)0);
                EventHandler.callEvent(this.getClass(), (String)"EVENT_NOTIFY_PRELOADER_PREPARING_PLUGINS");
            }
            if (this.componentBox.getChildren().isEmpty()) {
                Label label4 = new Label();
                label4.setText("No plugins available.");
                Hyperlink hyperlink3 = new Hyperlink();
                hyperlink3.setText("Explore");
                hyperlink3.setOnMouseReleased(mouseEvent -> {
                    hyperlink2.setVisited(false);
                    this.showExploreView();
                });
                Label label5 = new Label();
                label5.setText("or drag and drop.");
                HBox hBox3 = new HBox(new Node[]{hyperlink3, label5});
                hBox3.setAlignment(Pos.CENTER);
                VBox vBox = new VBox(new Node[]{label4, hBox3});
                vBox.setAlignment(Pos.CENTER);
                vBox.setSpacing(15.0);
                AnchorPane.setTopAnchor((Node)vBox, (Double)0.0);
                AnchorPane.setRightAnchor((Node)vBox, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)vBox, (Double)0.0);
                AnchorPane.setLeftAnchor((Node)vBox, (Double)0.0);
                AnchorPane anchorPane = new AnchorPane(new Node[]{vBox});
                anchorPane.setStyle("-fx-background-color: #ffffff;");
                anchorPane.setPrefWidth(310.0);
                anchorPane.setPrefHeight(310.0);
                this.componentBox.getChildren().add((Object)anchorPane);
            }
            throw throwable;
        }
        if (SharedMemory.getDataMap().get((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS") == null) {
            SharedMemory.getDataMap().put((Object)"KEY_NOTIFY_PRELOADER_NUMBER_OF_PLUGINS", (Object)0);
            EventHandler.callEvent(this.getClass(), (String)"EVENT_NOTIFY_PRELOADER_PREPARING_PLUGINS");
        }
        if (this.componentBox.getChildren().isEmpty()) {
            file = new Label();
            file.setText("No plugins available.");
            hyperlink = new Hyperlink();
            hyperlink.setText("Explore");
            hyperlink.setOnMouseReleased(mouseEvent -> {
                hyperlink2.setVisited(false);
                this.showExploreView();
            });
            label = new Label();
            label.setText("or drag and drop.");
            hBox = new HBox(new Node[]{hyperlink, label});
            hBox.setAlignment(Pos.CENTER);
            VBox vBox = new VBox(new Node[]{file, hBox});
            vBox.setAlignment(Pos.CENTER);
            vBox.setSpacing(15.0);
            AnchorPane.setTopAnchor((Node)vBox, (Double)0.0);
            AnchorPane.setRightAnchor((Node)vBox, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)vBox, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)vBox, (Double)0.0);
            string2 = new AnchorPane(new Node[]{vBox});
            string2.setStyle("-fx-background-color: #ffffff;");
            string2.setPrefWidth(310.0);
            string2.setPrefHeight(310.0);
            this.componentBox.getChildren().add((Object)string2);
        }
        App.getStage().showingProperty().addListener((observableValue, bl, bl2) -> {
            if (!bl.booleanValue() && bl2.booleanValue()) {
                EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_ACTIVATED");
            } else if (bl.booleanValue() && !bl2.booleanValue()) {
                EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_DEACTIVATED");
            }
        });
        App.getStage().iconifiedProperty().addListener((observableValue, bl, bl2) -> {
            if (!bl.booleanValue() && bl2.booleanValue()) {
                EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_DEACTIVATED");
            } else if (bl.booleanValue() && !bl2.booleanValue()) {
                EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_ACTIVATED");
            }
        });
        App.getStage().setOnCloseRequest(windowEvent -> EventHandler.callEvent(this.getClass(), (String)"EVENT_APPLICATION_EXIT"));
    }

    private void enableContextMenu() {
        MenuItem menuItem = new MenuItem("Add a new plugin");
        menuItem.setOnAction(actionEvent -> {
            FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter("Actlist Plugin File", new String[]{"*.jar"});
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Select a new Actlist plugin file");
            fileChooser.setInitialDirectory(Paths.get(System.getProperty("user.dir"), "plugins").toFile());
            fileChooser.getExtensionFilters().add((Object)extensionFilter);
            fileChooser.setSelectedExtensionFilter(extensionFilter);
            File file = fileChooser.showOpenDialog((Window)App.getStage());
            if (file == null) {
                return;
            }
            if (this.possibleToInstallThePlugin(file)) {
                this.installAndLoadThePlugin(file);
            }
        });
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{menuItem});
        this.scrollPane.setOnMouseReleased(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                contextMenu.show((Window)App.getStage(), mouseEvent.getScreenX(), mouseEvent.getScreenY());
            }
        });
    }

    private void enableDragAndDrop() {
        Predicate<Dragboard> predicate = dragboard -> {
            File file;
            List list;
            return dragboard.hasFiles() && (list = dragboard.getFiles()).size() == 1 && (file = (File)list.get(0)).isFile() && file.getName().toLowerCase().endsWith(".jar");
        };
        this.scrollPane.setOnDragOver(dragEvent -> {
            if (predicate.test(dragEvent.getDragboard())) {
                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            } else {
                dragEvent.consume();
            }
        });
        this.scrollPane.setOnDragDropped(dragEvent -> {
            File file;
            dragEvent.setDropCompleted(false);
            if (predicate.test(dragEvent.getDragboard()) && this.possibleToInstallThePlugin(file = (File)dragEvent.getDragboard().getFiles().get(0))) {
                this.installAndLoadThePlugin(file);
                dragEvent.setDropCompleted(true);
            }
            dragEvent.consume();
        });
    }

    private boolean possibleToInstallThePlugin(File file) {
        HashMap hashMap;
        boolean bl = true;
        if (Paths.get(System.getProperty("user.dir"), "plugins", file.getName()).toFile().exists() && (hashMap = (HashMap)SharedMemory.getDataMap().get((Object)"KEY_PLUGIN_MAP")).containsKey(file.getName())) {
            bl = false;
            MessageBox.showError((Object)App.getStage(), (String)"The selected file name is already in use by another plugin !");
        }
        return bl;
    }

    private void installAndLoadThePlugin(File file) {
        try {
            boolean bl = PluginManager.install(file);
            if (bl) {
                PluginManager.load(file.getName(), true);
                this.savePriorityOfPlugins();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MessageBox.showError((Object)App.getStage(), (String)"Oops... something is weird !");
        }
    }

    private boolean isAssignableFromJarFile(Path path) {
        String string;
        String string2;
        File file = path.toFile();
        return file.isFile() && (string2 = file.getName()).contains(".") && ".jar".equalsIgnoreCase(string = string2.substring(string2.lastIndexOf("."), string2.length()));
    }

    private List<String> readDeactivatedPlugins() {
        return FileUtil.readFileByLine((Path)Paths.get(System.getProperty("user.dir"), "plugins", "deactivated.ini"), (boolean)true);
    }

    private void saveDeactivatedPlugins() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            List list = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
            for (String string : list) {
                stringBuffer.append(string);
                stringBuffer.append("\r\n");
            }
            FileUtil.saveFile((Path)Paths.get(System.getProperty("user.dir"), "plugins", "deactivated.ini"), (String)stringBuffer.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<String> readPriorityOfPlugins() {
        return FileUtil.readFileByLine((Path)Paths.get(System.getProperty("user.dir"), "plugins", "priority.ini"), (boolean)true);
    }

    private void savePriorityOfPlugins() {
        try {
            List<String> list;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.componentBox.getChildren().isEmpty()) {
                list = (List)SharedMemory.getDataMap().get((Object)"KEY_PRIORITY_OF_PLUGINS");
            } else {
                list = new ArrayList();
                for (String string : this.componentBox.getChildrenUnmodifiable()) {
                    list.add(((PluginComponent)string.getUserData()).getPluginFileName());
                }
            }
            for (String string : list) {
                stringBuffer.append(string);
                stringBuffer.append("\r\n");
            }
            FileUtil.saveFile((Path)Paths.get(System.getProperty("user.dir"), "plugins", "priority.ini"), (String)stringBuffer.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadPlugin(Path path) throws Exception {
        String string = path.getFileName().toString();
        List list = (List)SharedMemory.getDataMap().get((Object)"KEY_DEACTIVATED_PLUGINS");
        PluginManager.load(string, !list.contains(string));
    }

    public void onEvent(String string) {
        switch (string) {
            case "EVENT_APPLY_THEME": {
                this.applyTheme();
                break;
            }
            case "EVENT_SHOW_EXPLORE_VIEW": {
                this.showExploreView();
                break;
            }
            case "EVENT_SHOW_ABOUT_VIEW": {
                this.showAboutView();
                break;
            }
            case "EVENT_SHOW_CONFIGURATION_VIEW": {
                this.showConfigurationView();
                break;
            }
            case "EVENT_SAVE_DEACTIVATED_PLUGINS": {
                this.saveDeactivatedPlugins();
                break;
            }
            case "EVENT_SAVE_PRIORITY_OF_PLUGINS": {
                this.savePriorityOfPlugins();
            }
        }
    }
}

