/*
 * Decompiled with CFR 0.152.
 */
package org.silentsoft.actlist.plugin;

import com.jfoenix.controls.JFXHamburger;
import com.jfoenix.controls.JFXToggleButton;
import java.io.File;
import java.nio.file.Paths;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import org.silentsoft.actlist.plugin.ActlistPlugin;
import org.silentsoft.actlist.plugin.PluginConfig;
import org.silentsoft.actlist.plugin.messagebox.MessageBox;
import org.silentsoft.core.util.FileUtil;
import org.silentsoft.core.util.JSONUtil;
import org.silentsoft.core.util.SystemUtil;

public final class DebugApp
extends Application {
    static boolean isDebugMode = false;
    Stage stage;

    public static void debug() {
        isDebugMode = true;
        DebugApp.launch((String[])new String[]{""});
    }

    public void start(final Stage stage) throws Exception {
        this.stage = stage;
        Class<?> clazz = Class.forName("Plugin");
        if (ActlistPlugin.class.isAssignableFrom(clazz)) {
            String configContent;
            PluginConfig pluginConfig;
            final ActlistPlugin plugin = (ActlistPlugin)ActlistPlugin.class.cast(clazz.newInstance());
            ActlistPlugin.SupportedPlatform currentPlatform = null;
            if (SystemUtil.isWindows()) {
                currentPlatform = ActlistPlugin.SupportedPlatform.WINDOWS;
            } else if (SystemUtil.isMac()) {
                currentPlatform = ActlistPlugin.SupportedPlatform.MACOSX;
            }
            plugin.currentPlatformObject().set((Object)currentPlatform);
            plugin.classLoaderObject().set((Object)((Object)((Object)this)).getClass().getClassLoader());
            plugin.setPluginConfig(new PluginConfig("debug"));
            File configFile = Paths.get(System.getProperty("user.dir"), "plugins", "config", "debug.config").toFile();
            if (configFile.exists() && (pluginConfig = (PluginConfig)JSONUtil.JSONToObject((String)(configContent = FileUtil.readFile((File)configFile)), PluginConfig.class)) != null) {
                plugin.setPluginConfig(pluginConfig);
            }
            Object changeListener = new ChangeListener<Object>(){

                public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                    if (oldValue == newValue) {
                        return;
                    }
                    Platform.runLater(() -> MessageBox.showError("Not supported feature on debug mode."));
                }
            };
            plugin.shouldShowLoadingBar().addListener((ChangeListener)changeListener);
            plugin.exceptionObject().addListener((ChangeListener)changeListener);
            plugin.showTrayNotificationObject().addListener((ChangeListener)changeListener);
            plugin.dismissTrayNotificationObject().addListener((ChangeListener)changeListener);
            plugin.shouldDismissTrayNotifications().addListener((ChangeListener)changeListener);
            plugin.shouldBrowseActlistArchives().addListener((ChangeListener)changeListener);
            plugin.shouldRequestShowActlist().addListener((ChangeListener)changeListener);
            changeListener = new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        JFXToggleButton toggle = (JFXToggleButton)stage.getScene().lookup("#toggle");
                        boolean isActivated = toggle.selectedProperty().get();
                        if (isActivated) {
                            toggle.setSelected(false);
                            toggle.getOnAction().handle(null);
                        }
                        plugin.shouldRequestDeactivate().set(false);
                    }
                }
            };
            plugin.shouldRequestDeactivate().addListener((ChangeListener)changeListener);
            AnchorPane root = new AnchorPane();
            root.setPrefWidth(435.0);
            root.setStyle("-fx-background-color: #ffffff;");
            root.getChildren().add((Object)this.createHamburger());
            root.getChildren().add((Object)this.createHead(plugin));
            root.getChildren().add((Object)this.createToggle(plugin));
            root.getChildren().add((Object)this.createSeparator());
            root.getChildren().add((Object)this.createBody(plugin));
            stage.setScene(new Scene((Parent)root));
            stage.setTitle("Actlist Debug App");
            stage.show();
            if (plugin.existsGraphic()) {
                plugin.getGraphic();
            }
            plugin.initialize();
            if (!plugin.isOneTimePlugin()) {
                ((JFXToggleButton)stage.getScene().lookup("#toggle")).getOnAction().handle(null);
            }
        } else {
            throw new Exception("The Plugin class must be extends ActlistPlugin !");
        }
    }

    private JFXHamburger createHamburger() {
        JFXHamburger hamburger = new JFXHamburger();
        hamburger.setLayoutX(13.0);
        hamburger.setLayoutY(19.0);
        hamburger.setOpacity(0.2);
        hamburger.setPrefHeight(14.0);
        hamburger.setPrefWidth(11.0);
        hamburger.setCursor(Cursor.MOVE);
        return hamburger;
    }

    private HBox createHead(ActlistPlugin plugin) {
        Label lblPluginName = new Label();
        lblPluginName.setText(plugin.getPluginName() == null || plugin.getPluginName().trim().isEmpty() ? "(empty name)" : plugin.getPluginName());
        lblPluginName.setPrefHeight(16.0);
        lblPluginName.setPrefWidth(302.0);
        HBox.setHgrow((Node)lblPluginName, (Priority)Priority.SOMETIMES);
        lblPluginName.setFont(Font.font((String)"Arial", (double)14.0));
        HBox head = new HBox(new Node[]{lblPluginName});
        head.setAlignment(Pos.CENTER_LEFT);
        head.setPrefHeight(45.0);
        AnchorPane.setLeftAnchor((Node)head, (Double)35.0);
        AnchorPane.setRightAnchor((Node)head, (Double)60.0);
        AnchorPane.setTopAnchor((Node)head, (Double)0.0);
        head.setOpaqueInsets(Insets.EMPTY);
        head.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        return head;
    }

    private JFXToggleButton createToggle(ActlistPlugin plugin) {
        JFXToggleButton toggle = new JFXToggleButton();
        toggle.setId("toggle");
        toggle.setLayoutX(199.0);
        toggle.setLayoutY(-2.0);
        toggle.setText(" ");
        toggle.setSelected(!plugin.isOneTimePlugin());
        toggle.setToggleColor(Paint.valueOf((String)"#fafafa"));
        toggle.setToggleLineColor(Paint.valueOf((String)"#59bf53"));
        toggle.setUnToggleLineColor(Paint.valueOf((String)"#e0e0e0"));
        AnchorPane.setRightAnchor((Node)toggle, (Double)-0.203125);
        toggle.setOnAction(actionEvent -> Platform.runLater(() -> {
            try {
                VBox body = (VBox)this.stage.getScene().lookup("#body");
                if (toggle.selectedProperty().get()) {
                    Node pluginContent;
                    if (plugin.existsGraphic() && (pluginContent = plugin.getGraphic()) != null) {
                        body.getChildren().add((Object)new BorderPane(pluginContent));
                        Separator contentLine = new Separator();
                        contentLine.setPrefWidth(215.0);
                        contentLine.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
                        body.getChildren().add((Object)contentLine);
                    }
                    plugin.pluginActivated();
                } else {
                    body.getChildren().clear();
                    plugin.pluginDeactivated();
                }
                this.stage.getScene().getWindow().sizeToScene();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        return toggle;
    }

    private Separator createSeparator() {
        Separator separator = new Separator();
        separator.setLayoutX(35.0);
        separator.setLayoutY(50.0);
        separator.setPrefWidth(215.0);
        AnchorPane.setLeftAnchor((Node)separator, (Double)35.0);
        AnchorPane.setRightAnchor((Node)separator, (Double)20.0);
        return separator;
    }

    private VBox createBody(ActlistPlugin plugin) {
        VBox body = new VBox();
        body.setId("body");
        body.setLayoutX(35.0);
        body.setLayoutY(51.0);
        body.setPrefWidth(380.0);
        AnchorPane.setRightAnchor((Node)body, (Double)20.0);
        AnchorPane.setLeftAnchor((Node)body, (Double)35.0);
        return body;
    }
}

